/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.OB.CodeSetReader;
import org.apache.yoko.orb.OB.MinorCodes;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;

final class UTF8Reader
extends CodeSetReader {
    UTF8Reader() {
    }

    @Override
    public char read_char(InputStream in) throws DATA_CONVERSION {
        return this.utf8ToUnicode(in);
    }

    @Override
    public char read_wchar(InputStream in, int len) throws DATA_CONVERSION {
        return this.utf8ToUnicode(in);
    }

    @Override
    public int count_wchar(char first) {
        if ((first & 0x80) == 0) {
            return 1;
        }
        if ((first & 0xF8) == 192) {
            return 2;
        }
        if ((first & 0xF8) == 224) {
            return 3;
        }
        throw new DATA_CONVERSION(MinorCodes.describeDataConversion(1095974914), 1095974914, CompletionStatus.COMPLETED_NO);
    }

    private char utf8ToUnicode(InputStream in) throws DATA_CONVERSION {
        char value;
        byte first;
        if (((first = in.buf_.data_[in.buf_.pos_++]) & 0x80) == 0) {
            return (char)first;
        }
        if ((first & 0xF8) == 192) {
            value = (char)(first & 0x1F);
        } else if ((first & 0xF8) == 224) {
            value = (char)(first & 0xF);
            if ((in.buf_.data_[in.buf_.pos_] & 0xC0) != 128) {
                throw new DATA_CONVERSION(MinorCodes.describeDataConversion(1095974915), 1095974915, CompletionStatus.COMPLETED_NO);
            }
            value = (char)(value << 6);
            value = (char)(value | in.buf_.data_[in.buf_.pos_++] & 0x3F);
        } else {
            throw new DATA_CONVERSION(MinorCodes.describeDataConversion(1095974914), 1095974914, CompletionStatus.COMPLETED_NO);
        }
        if ((in.buf_.data_[in.buf_.pos_] & 0xC0) != 128) {
            throw new DATA_CONVERSION(MinorCodes.describeDataConversion(1095974915), 1095974915, CompletionStatus.COMPLETED_NO);
        }
        value = (char)(value << 6);
        value = (char)(value | in.buf_.data_[in.buf_.pos_++] & 0x3F);
        return value;
    }

    @Override
    public void set_flags(int flags) {
    }
}

