/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.Vector;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.Downcall;
import org.apache.yoko.orb.OB.GIOPOutgoingMessage;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.UnsentMessage;
import org.apache.yoko.orb.OB.Util;
import org.apache.yoko.orb.OCI.Buffer;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.GIOP.MsgType_1_1;

public class MessageQueue {
    protected Vector unsent_ = new Vector();
    protected Vector pending_ = new Vector();

    MessageQueue() {
    }

    public void add(ORBInstance orbInstance, Buffer buf) {
        this.unsent_.addElement(new UnsentMessage(buf));
    }

    public void add(ORBInstance orbInstance, Downcall down) {
        try {
            OutputStream out = down.output();
            int pos = out._OB_pos();
            out._OB_pos(0);
            ProfileInfo profileInfo = down.profileInfo();
            GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(orbInstance, out, profileInfo);
            String op = down.operation();
            if (op.charAt(0) == '_' && op.equals("_locate")) {
                outgoing.writeMessageHeader(MsgType_1_1.LocateRequest, false, pos - 12);
            } else {
                outgoing.writeMessageHeader(MsgType_1_1.Request, false, pos - 12);
            }
            out._OB_pos(pos);
        }
        catch (SystemException ex) {
            Assert._OB_assert(ex.completed == CompletionStatus.COMPLETED_NO);
            down.setFailureException(ex);
            return;
        }
        this.unsent_.addElement(new UnsentMessage(down));
    }

    public Buffer getFirstUnsentBuffer() {
        if (this.unsent_.isEmpty()) {
            return null;
        }
        return ((UnsentMessage)this.unsent_.firstElement()).buf;
    }

    public Downcall moveFirstUnsentToPending() {
        if (this.unsent_.isEmpty()) {
            return null;
        }
        UnsentMessage m = (UnsentMessage)this.unsent_.firstElement();
        Downcall down = m.down;
        this.unsent_.removeElementAt(0);
        if (down != null) {
            if (down.responseExpected()) {
                down.setPending();
                this.pending_.addElement(down);
            } else {
                down.setNoException(null);
            }
        }
        return down;
    }

    public Downcall findAndRemovePending(int reqId) {
        for (int i = 0; i < this.pending_.size(); ++i) {
            Downcall d = (Downcall)this.pending_.elementAt(i);
            if (d.requestId() != reqId) continue;
            this.pending_.removeElementAt(i);
            return d;
        }
        return null;
    }

    public void setException(int state, SystemException ex, boolean notCompleted) {
        while (!this.unsent_.isEmpty()) {
            UnsentMessage m = (UnsentMessage)this.unsent_.firstElement();
            if (m.down != null) {
                m.down.setFailureException(ex);
            }
            this.unsent_.removeElementAt(0);
        }
        SystemException except = Util.copySystemException(ex);
        if (!notCompleted) {
            except.completed = CompletionStatus.COMPLETED_MAYBE;
        }
        while (!this.pending_.isEmpty()) {
            Downcall down = (Downcall)this.pending_.firstElement();
            down.setFailureException(except);
            this.pending_.removeElementAt(0);
        }
    }

    public boolean hasUnsent() {
        return !this.unsent_.isEmpty();
    }
}

