/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.ObjectFactory;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SetOverrideType;

public final class InitialServiceManager {
    static final Logger logger = Logger.getLogger(InitialServiceManager.class.getName());
    private Hashtable services_ = new Hashtable(37);
    private String defaultInitRef_;
    private boolean destroy_ = false;
    private ORBInstance orbInstance_;

    protected void finalize() throws Throwable {
        Assert._OB_assert(this.destroy_);
        super.finalize();
    }

    synchronized void destroy() {
        Assert._OB_assert(!this.destroy_);
        this.destroy_ = true;
        this.services_ = null;
        this.orbInstance_ = null;
    }

    public void setORBInstance(ORBInstance instance) {
        this.orbInstance_ = instance;
        Properties properties = this.orbInstance_.getProperties();
        String value = properties.getProperty("yoko.orb.default_init_ref");
        this.defaultInitRef_ = value == null ? "" : value;
        String propRoot = "yoko.orb.service.";
        Enumeration<java.lang.Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(propRoot)) continue;
            value = properties.getProperty(key);
            Assert._OB_assert(value != null);
            key = key.substring(propRoot.length());
            try {
                this.addInitialReference(key, value, true);
            }
            catch (InvalidName ex) {
                Assert._OB_assert(ex);
            }
        }
    }

    public synchronized String[] listInitialServices() {
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        String[] list = new String[this.services_.size()];
        int i = 0;
        Enumeration e = this.services_.keys();
        while (e.hasMoreElements()) {
            list[i++] = (String)e.nextElement();
        }
        return list;
    }

    public synchronized Object resolveInitialReferences(String identifier) throws InvalidName {
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        Assert._OB_assert(identifier != null);
        logger.fine("Resolving initial ORB reference for " + identifier);
        ObjectFactory objectFactory = this.orbInstance_.getObjectFactory();
        Object obj = null;
        Service svc = (Service)this.services_.get(identifier);
        if (svc != null) {
            if (svc.obj != null) {
                obj = svc.obj;
            } else if (svc.ref.length() > 0) {
                svc.obj = obj = objectFactory.stringToObject(svc.ref);
                this.services_.put(identifier, svc);
            }
        }
        logger.fine("No match found for ORB intial reference " + identifier);
        if (obj == null && this.defaultInitRef_.length() > 0 && !this.services_.containsKey(identifier)) {
            String url = this.defaultInitRef_ + '/' + identifier;
            obj = objectFactory.stringToObject(url);
        }
        if (obj == null) {
            logger.fine("No default initializer found for ORB intial reference " + identifier);
            throw new InvalidName();
        }
        if (obj instanceof LocalObject) {
            return obj;
        }
        Policy[] orbPolicies = objectFactory.policies();
        Vector<Policy> vec = new Vector<Policy>();
        for (int i = 0; i < orbPolicies.length; ++i) {
            Policy policy = null;
            try {
                policy = obj._get_policy(orbPolicies[i].policy_type());
            }
            catch (INV_POLICY iNV_POLICY) {
                // empty catch block
            }
            if (policy == null) {
                policy = orbPolicies[i];
            }
            vec.addElement(policy);
        }
        java.lang.Object[] p = new Policy[vec.size()];
        vec.copyInto(p);
        return obj._set_policy_override((Policy[])p, SetOverrideType.SET_OVERRIDE);
    }

    public void addInitialReference(String name, Object obj) throws InvalidName {
        this.addInitialReference(name, obj, false);
    }

    public synchronized void addInitialReference(String name, String iorString, boolean override) throws InvalidName {
        logger.fine("Adding initial reference name=" + name + ", ior=" + iorString);
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        Assert._OB_assert(name != null && iorString != null);
        if (this.services_.containsKey(name) && !override) {
            logger.fine("Initial reference name=" + name + "already exists");
            throw new InvalidName();
        }
        Service svc = new Service();
        svc.ref = iorString;
        this.services_.put(name, svc);
    }

    public synchronized void addInitialReference(String name, Object p, boolean override) throws InvalidName {
        if (p != null) {
            logger.fine("Adding initial reference name=" + name + " of type " + p.getClass().getName());
        } else {
            logger.fine("Adding initial reference name=" + name + " with null implementation");
        }
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        Assert._OB_assert(name != null);
        if (this.services_.containsKey(name) && !override) {
            throw new InvalidName();
        }
        Service svc = new Service();
        svc.ref = "";
        svc.obj = p;
        this.services_.put(name, svc);
    }

    private class Service {
        String ref;
        Object obj;

        private Service() {
        }
    }
}

