/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.internal.classloader;

import com.ibm.ws.kernel.internal.classloader.JarFileClassLoader;
import com.ibm.ws.kernel.internal.classloader.JarResourceHandler;
import com.ibm.ws.kernel.internal.classloader.ResourceEntry;
import com.ibm.ws.kernel.internal.classloader.ResourceHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarResourceEntry
implements ResourceEntry {
    private final JarResourceHandler handler;
    private final JarEntry jarEntry;

    public JarResourceEntry(JarResourceHandler handler, JarEntry jarEntry) {
        this.handler = handler;
        this.jarEntry = jarEntry;
    }

    @Override
    public ResourceHandler getResourceHandler() {
        return this.handler;
    }

    @Override
    public Manifest getManifest() throws IOException {
        return this.handler.getManifest();
    }

    @Override
    public Certificate[] getCertificates() {
        return this.jarEntry.getCertificates();
    }

    @Override
    public byte[] getBytes() throws IOException {
        byte[] byArray;
        InputStream in = null;
        try {
            in = this.handler.getJarFile().getInputStream(this.jarEntry);
            byArray = JarFileClassLoader.getBytes(in, this.jarEntry.getSize());
        }
        catch (Throwable throwable) {
            JarFileClassLoader.close(in);
            throw throwable;
        }
        JarFileClassLoader.close(in);
        return byArray;
    }

    @Override
    public URL toURL() {
        JarFile jarFile = this.handler.getJarFile();
        String name = jarFile.getName() + "!/" + this.jarEntry.getName();
        try {
            final JarEntryURLStreamHandler handler = new JarEntryURLStreamHandler(jarFile, this.jarEntry);
            final URL url = new URL("jarentry", "", -1, name, handler);
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    handler.setExpectedURL(url);
                    return null;
                }
            });
            return url;
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
        catch (PrivilegedActionException e) {
            throw new Error(e.getCause());
        }
    }

    private static class JarEntryURLConnection
    extends URLConnection {
        private final JarFile jarFile;
        private final JarEntry jarEntry;

        public JarEntryURLConnection(URL url, JarFile jarFile, JarEntry jarEntry) {
            super(url);
            this.jarFile = jarFile;
            this.jarEntry = jarEntry;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.jarFile.getInputStream(this.jarEntry);
        }

        @Override
        public long getLastModified() {
            return this.jarEntry.getTime();
        }

        @Override
        public int getContentLength() {
            long size = this.jarEntry.getSize();
            return size > Integer.MAX_VALUE ? -1 : (int)size;
        }
    }

    private static class JarEntryURLStreamHandler
    extends URLStreamHandler {
        private final JarFile jarFile;
        private final JarEntry jarEntry;
        private URL expectedURL;

        public JarEntryURLStreamHandler(JarFile jarFile, JarEntry jarEntry) {
            this.jarFile = jarFile;
            this.jarEntry = jarEntry;
        }

        private void setExpectedURL(URL expectedURL) {
            this.expectedURL = expectedURL;
        }

        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            if (url == null || url != this.expectedURL) {
                throw new IllegalStateException();
            }
            return new JarEntryURLConnection(url, this.jarFile, this.jarEntry);
        }
    }
}

