/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal.commands;

import com.ibm.ws.kernel.boot.BootstrapConfig;
import com.ibm.ws.kernel.boot.Debug;
import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.boot.internal.ServerCommand;
import com.ibm.ws.kernel.boot.internal.ServerLock;
import com.ibm.ws.kernel.boot.internal.commands.JavaDumpAction;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Set;

public class ServerCommandClient
extends ServerCommand {
    final String serverName;
    private static final char DELIM = '#';

    public ServerCommandClient(BootstrapConfig bootProps) {
        super(bootProps);
        this.serverName = bootProps.getProcessName();
        this.serverUUID = "CLIENT";
    }

    public boolean isValid() {
        return this.commandFile.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerCommand.ServerCommandID createServerCommand(String command) throws IOException {
        FileInputStream fis = null;
        BufferedReader reader = null;
        try {
            fis = new FileInputStream(this.commandFile);
            reader = new BufferedReader(new InputStreamReader(fis));
            String line = reader.readLine();
            if (line == null) {
                line = "";
            }
            ServerCommand.ServerCommandID serverCommandID = (ServerCommand)this.new ServerCommand.ServerCommandID(line, command);
            return serverCommandID;
        }
        finally {
            if (!Utils.tryToClose(reader)) {
                Utils.tryToClose(fis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ReturnCode write(String command, ReturnCode notStartedRC, ReturnCode errorRC) {
        ReturnCode returnCode;
        SocketChannel channel = null;
        try {
            ServerCommand.ServerCommandID commandID = this.createServerCommand(command);
            if (commandID.getPort() > 0) {
                channel = SelectorProvider.provider().openSocketChannel();
                channel.connect(new InetSocketAddress(InetAddress.getByName(null), commandID.getPort()));
                this.write(channel, commandID.getCommandString());
                String authID = this.read(channel);
                File authFile = new File(this.commandAuthDir, authID);
                authFile.delete();
                this.write(channel, authID);
                String cmdResponse = this.read(channel);
                String targetServerUUID = null;
                String responseCode = null;
                if (cmdResponse.isEmpty()) {
                    throw new IOException("connection closed by server without a reply");
                }
                if (cmdResponse.indexOf(35) != -1) {
                    targetServerUUID = cmdResponse.substring(0, cmdResponse.indexOf(35));
                    responseCode = cmdResponse.substring(cmdResponse.indexOf(35) + 1);
                } else {
                    targetServerUUID = cmdResponse;
                }
                if (!commandID.validateTarget(targetServerUUID)) {
                    throw new IOException("command file mismatch");
                }
                ReturnCode result = ReturnCode.OK;
                if (responseCode != null) {
                    try {
                        int returnCode2 = Integer.parseInt(responseCode.trim());
                        result = ReturnCode.getEnum(returnCode2);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IOException("invalid return code");
                    }
                }
                if (result == ReturnCode.INVALID) {
                    throw new IOException("invalid return code");
                }
                ReturnCode returnCode3 = result;
                Utils.tryToClose(channel);
                return returnCode3;
            }
            if (commandID.getPort() == -1) {
                ReturnCode returnCode4 = ReturnCode.SERVER_COMMAND_PORT_DISABLED_STATUS;
                Utils.tryToClose(channel);
                return returnCode4;
            }
            returnCode = notStartedRC;
            Utils.tryToClose(channel);
        }
        catch (ConnectException e) {
            Debug.printStackTrace(e);
            ReturnCode returnCode5 = notStartedRC;
            return returnCode5;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (IOException e2) {
                Debug.printStackTrace(e2);
                ReturnCode returnCode6 = errorRC;
                return returnCode6;
            }
        }
        finally {
            Utils.tryToClose(channel);
        }
        return returnCode;
    }

    public ReturnCode startStatus(ServerLock lock) {
        while (!this.isValid()) {
            ReturnCode rc = this.startStatusWait(lock);
            if (rc == ReturnCode.START_STATUS_ACTION) continue;
            return rc;
        }
        for (int i = 0; i < 60 && this.isValid(); ++i) {
            ReturnCode rc = this.write("status:start", ReturnCode.START_STATUS_ACTION, ReturnCode.ERROR_SERVER_START);
            if (rc != ReturnCode.START_STATUS_ACTION) {
                return rc;
            }
            rc = this.startStatusWait(lock);
            if (rc == ReturnCode.START_STATUS_ACTION) continue;
            return rc;
        }
        return this.write("status:start", ReturnCode.ERROR_SERVER_START, ReturnCode.ERROR_SERVER_START);
    }

    private ReturnCode startStatusWait(ServerLock lock) {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            Debug.printStackTrace(ex);
            return ReturnCode.ERROR_SERVER_START;
        }
        if (!lock.testServerRunning()) {
            return ReturnCode.ERROR_SERVER_START;
        }
        return ReturnCode.START_STATUS_ACTION;
    }

    public ReturnCode stopServer(boolean force) {
        return this.write(force ? "forceStop" : "stop", ReturnCode.REDUNDANT_ACTION_STATUS, ReturnCode.ERROR_SERVER_STOP);
    }

    public ReturnCode introspectServer(String dumpTimestamp, Set<JavaDumpAction> javaDumpActions) {
        String command;
        if (javaDumpActions.isEmpty()) {
            command = "introspect#" + dumpTimestamp;
        } else {
            StringBuilder commandBuilder = new StringBuilder().append("introspectJavadump").append('#').append(dumpTimestamp);
            for (JavaDumpAction javaDumpAction : javaDumpActions) {
                commandBuilder.append(',').append(javaDumpAction.name());
            }
            command = commandBuilder.toString();
        }
        return this.write(command, ReturnCode.DUMP_ACTION, ReturnCode.ERROR_SERVER_DUMP);
    }

    public ReturnCode javaDump(Set<JavaDumpAction> javaDumpActions) {
        StringBuilder commandBuilder = new StringBuilder("javadump");
        int sep = 35;
        for (JavaDumpAction javaDumpAction : javaDumpActions) {
            commandBuilder.append((char)sep).append(javaDumpAction.toString());
            sep = 44;
        }
        return this.write(commandBuilder.toString(), ReturnCode.SERVER_INACTIVE_STATUS, ReturnCode.ERROR_SERVER_DUMP);
    }

    public ReturnCode pause(String targetArg) {
        StringBuilder commandBuilder = new StringBuilder("pause");
        char sep = '#';
        if (targetArg != null) {
            commandBuilder.append(sep).append(targetArg);
        }
        return this.write(commandBuilder.toString(), ReturnCode.SERVER_INACTIVE_STATUS, ReturnCode.ERROR_SERVER_PAUSE);
    }

    public ReturnCode resume(String targetArg) {
        StringBuilder commandBuilder = new StringBuilder("resume");
        char sep = '#';
        if (targetArg != null) {
            commandBuilder.append(sep).append(targetArg);
        }
        return this.write(commandBuilder.toString(), ReturnCode.SERVER_INACTIVE_STATUS, ReturnCode.ERROR_SERVER_RESUME);
    }
}

