/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal;

import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.kernel.boot.BootstrapConfig;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.boot.logging.TextFileOutputStreamFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUtils {
    protected static final int DEFAULT_BUFFER_SIZE = 8192;
    static final Pattern ABSOLUTE_URI = Pattern.compile("^[^/#\\?]+?:/.*");

    public static File[] listFiles(File target, final List<Pattern> patterns, final boolean include) {
        if (patterns == null || patterns.isEmpty()) {
            return target.listFiles();
        }
        return target.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                for (Pattern pattern : patterns) {
                    Matcher matcher = pattern.matcher(name);
                    if (!matcher.matches()) continue;
                    return include;
                }
                return !include;
            }
        });
    }

    public static void copyFile(File dest, File source) throws IOException {
        FileInputStream input = null;
        try {
            input = new FileInputStream(source);
            FileUtils.createFile(dest, input);
        }
        catch (Throwable throwable) {
            Utils.tryToClose(input);
            throw throwable;
        }
        Utils.tryToClose(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(File dest, InputStream sourceInput) throws IOException {
        if (sourceInput == null || dest == null) {
            return;
        }
        FileOutputStream fos = null;
        try {
            if (!dest.getParentFile().exists() && !dest.getParentFile().mkdirs()) {
                throw new FileNotFoundException();
            }
            fos = TextFileOutputStreamFactory.createOutputStream(dest);
            byte[] buffer = new byte[8192];
            int count = -1;
            while ((count = sourceInput.read(buffer)) > 0) {
                fos.write(buffer, 0, count);
            }
            fos.flush();
        }
        catch (Throwable throwable) {
            Utils.tryToClose(fos);
            Utils.tryToClose(sourceInput);
            throw throwable;
        }
        Utils.tryToClose(fos);
        Utils.tryToClose(sourceInput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendFile(File dest, InputStream sourceInput) throws IOException {
        if (sourceInput == null || dest == null) {
            return;
        }
        FileOutputStream fos = null;
        try {
            if (!dest.getParentFile().exists()) {
                throw new FileNotFoundException();
            }
            fos = TextFileOutputStreamFactory.createOutputStream(dest, true);
            byte[] buffer = new byte[8192];
            int count = -1;
            while ((count = sourceInput.read(buffer)) > 0) {
                fos.write(buffer, 0, count);
            }
            fos.flush();
        }
        catch (Throwable throwable) {
            Utils.tryToClose(fos);
            Utils.tryToClose(sourceInput);
            throw throwable;
        }
        Utils.tryToClose(fos);
        Utils.tryToClose(sourceInput);
    }

    public static void copyDir(File from, File to) throws FileNotFoundException, IOException {
        File[] files = from.listFiles();
        if (files != null) {
            for (File ff : files) {
                File tf = new File(to, ff.getName());
                if (ff.isDirectory()) {
                    if (!tf.mkdir()) continue;
                    FileUtils.copyDir(ff, tf);
                    continue;
                }
                if (!ff.isFile()) continue;
                FileUtils.copyFile(tf, ff);
            }
        }
    }

    public static File createTempFile(String prefix, String suffix, String parentDir) throws IOException {
        File tempFile = null;
        if (parentDir != null) {
            String systemTemp;
            File parent = new File(parentDir);
            if (!(parent.isAbsolute() || (parent = new File(systemTemp = System.getProperty("java.io.tmpdir"), parentDir)).exists() || parent.mkdirs())) {
                return null;
            }
            tempFile = File.createTempFile(prefix, suffix, parent);
        } else {
            tempFile = File.createTempFile(prefix, suffix);
        }
        return tempFile;
    }

    public static boolean isUnderDirectory(File child, File parent) {
        if (child == null || parent == null) {
            return false;
        }
        URI childUri = child.toURI();
        URI relativeUri = parent.toURI().relativize(childUri);
        return !relativeUri.equals(childUri);
    }

    public static boolean createDir(File dir) {
        return !dir.exists() && dir.mkdir();
    }

    public static File convertPathToFile(String filePath, BootstrapConfig bootProps) {
        if (filePath == null) {
            throw new NullPointerException();
        }
        File resolvedFile = null;
        String resolvedPath = FileUtils.normalizeFilePath(bootProps.replaceSymbols(filePath));
        resolvedFile = new File(resolvedPath);
        if (!resolvedFile.isAbsolute()) {
            resolvedFile = bootProps.getConfigFile(resolvedPath);
        }
        return resolvedFile;
    }

    private static String normalizeFilePath(String filePath) {
        if (filePath.contains("\\/")) {
            filePath = filePath.replace("\\/", File.separator);
        } else if (filePath.contains("/\\")) {
            filePath = filePath.replace("/\\", File.separator);
        }
        if (File.separatorChar == '/') {
            filePath = filePath.replace("\\", File.separator);
        }
        return filePath;
    }

    public static String normalizeEntryPath(String entryPath) {
        if (entryPath == null || entryPath.isEmpty()) {
            return "";
        }
        if ((entryPath = entryPath.replace("\\", "/")).startsWith("/")) {
            entryPath = entryPath.length() == 1 ? "" : entryPath.substring(1, entryPath.length());
        }
        return entryPath;
    }

    public static String normalizeDirPath(String dirPath) {
        if (dirPath == null || dirPath.isEmpty()) {
            return "";
        }
        if (!(dirPath = dirPath.replace("\\", "/")).endsWith("/")) {
            dirPath = dirPath + "/";
        }
        return dirPath;
    }

    public static String normalizePathDrive(String path) {
        if (File.separatorChar == '\\' && path.length() > 1 && path.charAt(1) == ':' && path.charAt(0) >= 'a' && path.charAt(0) <= 'z') {
            path = Character.toUpperCase(path.charAt(0)) + path.substring(1);
        }
        return path;
    }

    public static String normalize(String path) {
        int ns;
        int i;
        if (path.startsWith("http:") || path.startsWith("https:") || path.startsWith("ftp:")) {
            return path;
        }
        boolean slash_change = false;
        String prefix = "";
        if (path.length() >= 9 && path.startsWith("file:////")) {
            prefix = "file://";
            path = path.substring(7);
            slash_change = true;
        }
        if (path.length() >= 9 && path.startsWith("file:///")) {
            prefix = "file:///";
            path = path.substring(8);
        } else if (path.length() >= 6 && path.startsWith("file:/") && path.charAt(7) != '/') {
            prefix = "file:/";
            path = path.substring(6);
        }
        int origLength = path.length();
        int j = 0;
        int num_segments = 0;
        int lastSlash = 0;
        boolean dotSegment = false;
        boolean backslash = false;
        for (i = 0; i < origLength; ++i) {
            if (i == 0 && path.charAt(i) == '.') {
                dotSegment = true;
            }
            if (path.charAt(i) != '/' && path.charAt(i) != '\\') continue;
            if (path.charAt(i) == '\\') {
                backslash = true;
            }
            if (i == 0) {
                ++num_segments;
                while (i + 1 < path.length() && (path.charAt(i + 1) == '/' || path.charAt(i + 1) == '\\')) {
                    ++i;
                }
                if (i > 0) {
                    slash_change = true;
                }
            } else if (i == lastSlash) {
                slash_change = true;
            } else if (i != lastSlash) {
                ++num_segments;
            }
            if (!dotSegment && i + 1 < path.length() && path.charAt(i + 1) == '.') {
                dotSegment = true;
            }
            lastSlash = i + 1;
        }
        if (i > lastSlash) {
            ++num_segments;
        }
        if (backslash) {
            path = FileUtils.slashify(path);
        }
        if (path.length() > 3 && path.charAt(0) == '/' && path.charAt(2) == ':') {
            path = path.substring(1);
        }
        if (!slash_change && !dotSegment) {
            return prefix + path;
        }
        boolean pathChanged = false;
        origLength = path.length();
        ArrayList<String> segments = new ArrayList<String>(num_segments);
        lastSlash = 0;
        for (i = 0; i < origLength; ++i) {
            if (path.charAt(i) != '/') continue;
            if (i == 0) {
                while (path.charAt(i + 1) == '/') {
                    ++i;
                }
                segments.add(path.substring(0, i + 1));
            } else if (i == lastSlash) {
                pathChanged = true;
            } else if (i != lastSlash) {
                segments.add(path.substring(lastSlash, i + 1));
            }
            lastSlash = i + 1;
        }
        if (i > lastSlash) {
            segments.add(path.substring(lastSlash));
        }
        for (i = ns = segments.size() - 1; i >= 0; --i) {
            String s = (String)segments.get(i);
            String t = FileUtils.trimSlash(s);
            if (i >= 1 && t.equals("..")) {
                j = i - 1;
                String p = (String)segments.get(j);
                String q = FileUtils.trimSlash(p);
                if (q.equals(".")) {
                    pathChanged = true;
                    segments.remove(j);
                } else if (!q.equals("..") && !FileUtils.isSymbol(q)) {
                    pathChanged = true;
                    segments.remove(i);
                    segments.remove(j);
                }
                if (segments.size() != j) continue;
                i = j;
                continue;
            }
            if (!t.equals(".")) continue;
            pathChanged = true;
            segments.remove(i);
        }
        if (pathChanged) {
            StringBuilder sb = new StringBuilder(path.length());
            for (String s : segments) {
                sb.append(s);
            }
            return prefix + sb.toString();
        }
        return prefix + path;
    }

    @Trivial
    public static boolean isSymbol(String s) {
        return s.length() > 3 && s.charAt(0) == '$' && s.charAt(1) == '{';
    }

    @Trivial
    public static boolean pathIsAbsolute(String normalizedPath) {
        if (normalizedPath.length() > 0 && normalizedPath.charAt(0) == '/') {
            return true;
        }
        if (FileUtils.isSymbol(normalizedPath)) {
            return true;
        }
        if (normalizedPath.contains(":")) {
            if (normalizedPath.length() > 3 && normalizedPath.charAt(1) == ':' && normalizedPath.charAt(2) == '/') {
                return true;
            }
            Matcher m = ABSOLUTE_URI.matcher(normalizedPath);
            if (m.matches()) {
                return true;
            }
        }
        return false;
    }

    @Trivial
    private static String trimSlash(String segment) {
        int len = segment.length();
        if (len >= 1 && segment.charAt(len - 1) == '/') {
            return segment.substring(0, len - 1);
        }
        return segment;
    }

    @Trivial
    public static String slashify(String filePath) {
        return filePath.replace('\\', '/');
    }

    public static boolean recursiveClean(File fileToRemove) {
        if (fileToRemove == null) {
            return true;
        }
        Boolean fileExists = Boolean.FALSE;
        final File f_fileToRemove = fileToRemove;
        try {
            fileExists = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    if (f_fileToRemove.exists()) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fileExists != null && !fileExists.booleanValue()) {
            return true;
        }
        boolean success = true;
        Boolean fileIsDirectory = null;
        try {
            fileIsDirectory = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    if (f_fileToRemove.isDirectory()) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fileIsDirectory != null && fileIsDirectory.booleanValue()) {
            File[] files = fileToRemove.listFiles();
            if (files == null) {
                return false;
            }
            for (File file : files) {
                if (file.isDirectory()) {
                    success |= FileUtils.recursiveClean(file);
                    continue;
                }
                if (file.getName().equals(".sLock") && fileToRemove.getName().equals("workarea") || fileToRemove.getName().equals("workarea") && file.getName().equals(".sRunning")) continue;
                success |= file.delete();
            }
            files = fileToRemove.listFiles();
            if (files.length == 0) {
                success |= fileToRemove.delete();
            }
        } else {
            Boolean successful_delete = Boolean.TRUE;
            final File ftr = fileToRemove;
            try {
                successful_delete = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                    @Override
                    public Boolean run() throws Exception {
                        Boolean s = ftr.delete();
                        return s;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            success |= successful_delete.booleanValue();
        }
        return success;
    }

    public static File getFile(URL url) {
        String path;
        try {
            if (url.getAuthority() != null) {
                url = new URL("file://" + url.toString().substring("file:".length()));
            }
            path = new File(url.toURI()).getPath();
        }
        catch (MalformedURLException e) {
            path = null;
        }
        catch (URISyntaxException e) {
            path = null;
        }
        catch (IllegalArgumentException e) {
            path = null;
        }
        if (path == null) {
            path = url.getPath();
        }
        return new File(FileUtils.normalizePathDrive(path));
    }

    @Trivial
    public static boolean containsSymbol(String s) {
        int pos;
        if (s != null && s.length() > 3 && (pos = s.indexOf(36)) >= 0) {
            int pos2 = pos + 1;
            if (s.length() > pos2 && s.charAt(pos2) == '{' && (pos2 = s.indexOf(125, pos2)) >= 0) {
                return true;
            }
        }
        return false;
    }
}

