/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.logging.source;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.logging.data.GenericData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collector.manager.BufferManager;
import com.ibm.wsspi.collector.manager.Source;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.logging.AccessLogForwarder;
import com.ibm.wsspi.http.logging.AccessLogRecordData;
import com.ibm.wsspi.http.logging.LogForwarderManager;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AccessLogSource
implements Source {
    private static final TraceComponent tc = Tr.register(AccessLogSource.class);
    private final String sourceName = "com.ibm.ws.http.logging.source.accesslog";
    private final String location = "memory";
    private BufferManager bufferMgr = null;
    private AccessLogHandler accessLogHandler;
    static final long serialVersionUID = 5936856138788654285L;

    protected synchronized void activate(Map<String, Object> configuration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Activating " + this), (Object[])new Object[0]);
        }
    }

    protected void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(" Deactivating " + this), (Object[])new Object[]{" reason = " + reason});
        }
    }

    public String getSourceName() {
        return "com.ibm.ws.http.logging.source.accesslog";
    }

    public String getLocation() {
        return "memory";
    }

    public void setBufferManager(BufferManager bufferMgr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Setting buffer manager " + this), (Object[])new Object[0]);
        }
        this.bufferMgr = bufferMgr;
        this.startSource();
    }

    public void unsetBufferManager(BufferManager bufferMgr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Un-setting buffer manager " + this), (Object[])new Object[0]);
        }
        this.stopSource();
        this.bufferMgr = null;
    }

    private void startSource() {
        this.accessLogHandler = new AccessLogHandler();
        LogForwarderManager.registerAccessLogForwarder(this.accessLogHandler);
    }

    private void stopSource() {
        LogForwarderManager.deregisterAccessLogForwarder(this.accessLogHandler);
        this.accessLogHandler = null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class AccessLogHandler
    implements AccessLogForwarder {
        private final AtomicLong seq = new AtomicLong();
        static final long serialVersionUID = 6715811758680259629L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private AccessLogHandler() {
        }

        @Override
        public void process(AccessLogRecordData recordData) {
            HttpRequestMessage request = recordData.getRequest();
            HttpResponseMessage response = recordData.getResponse();
            if (request != null) {
                GenericData genData = new GenericData();
                long requestStartTimeVal = recordData.getStartTime();
                genData.addPair("ibm_requestStartTime", (Number)requestStartTimeVal);
                genData.addPair("ibm_uriPath", request.getRequestURI());
                genData.addPair("ibm_requestMethod", request.getMethod());
                genData.addPair("ibm_queryString", request.getQueryString());
                genData.addPair("ibm_requestHost", recordData.getLocalIP());
                genData.addPair("ibm_requestPort", recordData.getLocalPort());
                genData.addPair("ibm_remoteHost", recordData.getRemoteAddress());
                genData.addPair("ibm_userAgent", request.getHeader("User-Agent").asString());
                genData.addPair("ibm_requestProtocol", request.getVersion());
                genData.addPair("ibm_bytesReceived", (Number)recordData.getBytesWritten());
                genData.addPair("ibm_responseCode", (Number)response.getStatusCodeAsInt());
                genData.addPair("ibm_elapsedTime", (Number)recordData.getElapsedTime());
                genData.addPair("ibm_datetime", (Number)recordData.getTimestamp());
                String sequenceVal = requestStartTimeVal + "_" + String.format("%013X", this.seq.incrementAndGet());
                genData.addPair("ibm_sequence", sequenceVal);
                genData.setSourceType("com.ibm.ws.http.logging.source.accesslog");
                AccessLogSource.this.bufferMgr.add((Object)genData);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Added a event to buffer " + genData), (Object[])new Object[0]);
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(AccessLogHandler.class);
        }
    }
}

