/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.container.Container;
import com.ibm.ws.container.DeployedModule;
import com.ibm.ws.webcontainer.VirtualHostConfiguration;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.core.BaseContainer;
import com.ibm.ws.webcontainer.exception.WebAppNotLoadedException;
import com.ibm.ws.webcontainer.exception.WebGroupVHostNotFoundException;
import com.ibm.ws.webcontainer.session.IHttpSessionContext;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer.webapp.WebGroup;
import com.ibm.ws.webcontainer.webapp.WebGroupConfiguration;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.util.URIMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public abstract class VirtualHost
extends BaseContainer {
    protected static final Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.VirtualHost";
    protected final VirtualHostConfiguration vHostConfig;

    public VirtualHost(VirtualHostConfiguration vHostConfig, Container parent) {
        super(vHostConfig.getName(), parent);
        this.vHostConfig = vHostConfig;
        this.requestMapper = new URIMapper(true);
    }

    public List<String> getAliases() {
        return this.vHostConfig.getAliases();
    }

    public void addWebApplication(DeployedModule deployedModule, List extensionFactories) throws WebAppNotLoadedException {
        WebGroupConfiguration wgConfig = deployedModule.getWebGroupConfig();
        WebGroup wg = deployedModule.getWebGroup();
        String contextRoot = deployedModule.getContextRoot();
        String ct = VirtualHost.makeProperContextRoot(contextRoot);
        String mapRoot = VirtualHost.makeMappingContextRoot(ct);
        String displayName = deployedModule.getDisplayName();
        WebGroup webGroup = (WebGroup)this.requestMapper.map(mapRoot);
        if (webGroup != null && ct.equalsIgnoreCase(webGroup.getConfiguration().getContextRoot())) {
            ArrayList list = webGroup.getWebApps();
            String originalName = "";
            if (list != null && list.size() > 0) {
                WebApp originalWebApp = (WebApp)list.get(0);
                originalName = originalWebApp.getWebAppName();
            }
            logger.logp(Level.SEVERE, CLASS_NAME, "addWebApplication", "context.root.already.in.use", new Object[]{displayName, contextRoot, originalName, displayName});
            throw new WebAppNotLoadedException("Context root " + contextRoot + " is already bound. Cannot start application " + displayName);
        }
        webGroup = wg;
        deployedModule.getWebAppConfig().setVirtualHostName(this.getName());
        wgConfig.setWebAppHost(this);
        webGroup.initialize(wgConfig);
        try {
            webGroup.addWebApplication(deployedModule, extensionFactories);
            Object[] args = new Object[]{displayName, this.vHostConfig.toString()};
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.INFO, CLASS_NAME, "addWebApplication", "module.[{0}].successfully.bound.to.virtualhost.[{1}]", args);
            }
        }
        catch (Throwable t) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addWebApplication", "error adding web app [" + displayName + "]");
            }
            webGroup.destroy();
            webGroup = null;
            throw new WebAppNotLoadedException(t.getMessage(), t);
        }
        try {
            this.addMapping(contextRoot, webGroup);
            webGroup.notifyStart();
        }
        catch (Exception exc) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addWebApplication", "error adding mapping ", exc);
            }
            webGroup.destroy();
            throw new WebAppNotLoadedException("Context root " + contextRoot + " mapping unable to be bound. Application " + displayName + " unavailable.", exc);
        }
    }

    public static String makeMappingContextRoot(String contextRoot) {
        String cRoot = contextRoot;
        if (cRoot.endsWith("/") && !cRoot.equals("/")) {
            cRoot = contextRoot.substring(0, cRoot.length() - 1);
        }
        cRoot = cRoot.equals("/") ? cRoot + "*" : cRoot + "/*";
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "makeMapingContextRoot", "original-> " + contextRoot + ", matcher->" + cRoot);
        }
        return cRoot;
    }

    public static String makeProperContextRoot(String contextRoot) {
        String cRoot = contextRoot;
        if (cRoot.endsWith("/") && !cRoot.equals("/")) {
            cRoot = contextRoot.substring(0, cRoot.length() - 1);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "makeProperContextRoot", "original-> " + contextRoot + ", matcher->" + cRoot);
        }
        return cRoot;
    }

    public String getMimeType(String withDot, String withoutDot) {
        String type = this.vHostConfig.getMimeType(withoutDot);
        if (type == null) {
            type = this.vHostConfig.getMimeType(withDot);
        }
        return type;
    }

    public IHttpSessionContext getSessionContext(DeployedModule moduleConfig, WebApp webApp, ArrayList[] listeners) throws Throwable {
        return ((WebContainer)this.parent).getSessionContext(moduleConfig, webApp, this.vHostConfig.getName(), listeners);
    }

    public ServletContext findContext(String path) {
        WebGroup g = (WebGroup)this.requestMapper.map(path);
        if (g != null) {
            return g.getContext();
        }
        return null;
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        this.requestMapper = null;
    }

    @Override
    public void handleRequest(ServletRequest req, ServletResponse res) throws Exception {
        WebAppDispatcherContext dispatchContext = (WebAppDispatcherContext)((IExtendedRequest)req).getWebAppDispatcherContext();
        String reqURI = dispatchContext.getDecodedReqUri();
        RequestProcessor g = this.requestMapper.map(reqURI);
        if (g == null) {
            throw new WebGroupVHostNotFoundException(reqURI);
        }
        g.handleRequest(req, res);
    }

    public void removeWebApplication(DeployedModule deployedModule) {
        String contextRoot = deployedModule.getContextRoot();
        this.removeWebApplication(deployedModule, contextRoot);
    }

    public void removeWebApplication(DeployedModule deployedModule, String contextRoot) {
        String ct;
        String mapRoot;
        WebGroup webGroup;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "removeWebApplication", "ContextRoot : " + contextRoot);
        }
        if ((webGroup = (WebGroup)this.removeMappedObject(mapRoot = VirtualHost.makeMappingContextRoot(ct = VirtualHost.makeProperContextRoot(deployedModule.getContextRoot())))) != null) {
            webGroup.removeWebApplication(deployedModule);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "removeWebApplication", "name: " + webGroup.getName());
            }
            this.removeSubContainer(webGroup.getName());
        }
    }

    protected synchronized void addMapping(String contextRoot, WebGroup group) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addMapping", " contextRoot -->" + contextRoot + " group -->" + group.getName() + " : " + this.hashCode());
        }
        this.requestMapper.addMapping(contextRoot, group);
    }

    protected synchronized void removeMapping(String contextRoot) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "removeMapping", " contextRoot -->" + contextRoot + " : " + this.hashCode());
        }
        this.requestMapper.removeMapping(contextRoot);
    }

    protected synchronized Object removeMappedObject(String contextRoot) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "removeMappedObject", " contextRoot -->" + contextRoot + " : " + this.hashCode());
        }
        RequestProcessor o = this.requestMapper.map(contextRoot);
        this.removeMapping(contextRoot);
        return o;
    }

    protected void addSecureRedirect(ServletRequest req, String hostAlias) {
    }
}

