/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.library.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.classloading.LibraryAccess;
import com.ibm.ws.classloading.internal.LibertyLoader;
import com.ibm.ws.dynamic.bundle.BundleFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.ApiRegion;
import com.ibm.ws.library.internal.SharedLibraryImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.equinox.module.ModuleDelegateClassLoaderFactory;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.library.Library;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.FrameworkWiring;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LibraryPackageExporter
implements ModuleDelegateClassLoaderFactory,
LibraryAccess {
    private static final String EXPORTER_POSTFIX = "_library_exporter";
    private static final String REGION_EXPORT_TO_LIBERTY = "liberty.library.export.to.liberty";
    private static final String REGION_EXPORT_TO_OSGI_APPS = "liberty.library.export.to.osgi.app";
    private final String REGION_KERNEL;
    private final AtomicLong counter = new AtomicLong();
    private final BundleContext context;
    private final RegionDigraph digraph;
    private final ConcurrentMap<Bundle, Library> bundleToLibrary = new ConcurrentHashMap<Bundle, Library>();
    private final ConcurrentMap<Library, LibraryVisibility> libraryToVisibility = new ConcurrentHashMap<Library, LibraryVisibility>();
    static final long serialVersionUID = 8074378969667956573L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public LibraryPackageExporter(BundleContext context, RegionDigraph digraph) {
        this.context = context;
        this.digraph = digraph;
        Region thisRegion = digraph.getRegion(context.getBundle());
        this.REGION_KERNEL = thisRegion.getName();
    }

    private void refresh(Collection<Bundle> bundles) {
        if (FrameworkState.isStopping()) {
            return;
        }
        Bundle system = this.context.getBundle("System Bundle");
        FrameworkWiring fwkWiring = (FrameworkWiring)system.adapt(FrameworkWiring.class);
        final CountDownLatch refreshed = new CountDownLatch(1);
        fwkWiring.refreshBundles(bundles, new FrameworkListener[]{new FrameworkListener(){
            static final long serialVersionUID = -655910410396593157L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public void frameworkEvent(FrameworkEvent event) {
                refreshed.countDown();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        }});
        try {
            refreshed.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.library.internal.LibraryPackageExporter", (String)"179", (Object)this, (Object[])new Object[]{bundles});
            Thread.interrupted();
        }
    }

    private Region getLibraryExporterRegion(final RegionDigraph digraph, final LibraryAccess.PackageVisibility visibility) throws BundleException {
        final String libertyExporterRegionName = this.getExportFromRegion(visibility);
        Region existingLibraryExporter = digraph.getRegion(libertyExporterRegionName);
        if (existingLibraryExporter == null) {
            ApiRegion.update((RegionDigraph)digraph, (Callable)new Callable<RegionDigraph>(){
                static final long serialVersionUID = -5889624978910718476L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public RegionDigraph call() throws Exception {
                    RegionDigraph copy = digraph.copy();
                    Region libraryExporter = copy.getRegion(libertyExporterRegionName);
                    if (libraryExporter != null) {
                        return null;
                    }
                    libraryExporter = copy.createRegion(libertyExporterRegionName);
                    Region exportTo = copy.getRegion(LibraryPackageExporter.this.getExportToRegion(visibility));
                    RegionFilterBuilder builder = copy.createRegionFilterBuilder();
                    builder.allowAll("osgi.wiring.package");
                    exportTo.connectRegion(libraryExporter, builder.build());
                    return copy;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            });
            return digraph.getRegion(libertyExporterRegionName);
        }
        return existingLibraryExporter;
    }

    private String getExportFromRegion(LibraryAccess.PackageVisibility visibility) {
        switch (visibility) {
            case LIBERTY_FEATURES: {
                return REGION_EXPORT_TO_LIBERTY;
            }
            case OSGI_APPS: {
                return REGION_EXPORT_TO_OSGI_APPS;
            }
        }
        throw new IllegalArgumentException("Illegal visibility type: " + (Object)((Object)visibility));
    }

    private String getExportToRegion(LibraryAccess.PackageVisibility visibility) {
        switch (visibility) {
            case LIBERTY_FEATURES: {
                return this.REGION_KERNEL;
            }
            case OSGI_APPS: {
                return ApiRegion.ALL.getRegionName();
            }
        }
        throw new IllegalArgumentException("Illegal visibility type: " + (Object)((Object)visibility));
    }

    public ClassLoader getDelegateClassLoader(Bundle bundle) {
        Library library = (Library)this.bundleToLibrary.get(bundle);
        return library == null ? null : library.getClassLoader();
    }

    @Override
    public void setPackages(Library library, Collection<String> packageNames, LibraryAccess.PackageVisibility visibility) {
        LibraryVisibility libraryVisibility = new LibraryVisibility();
        LibraryVisibility current = this.libraryToVisibility.putIfAbsent(library, libraryVisibility);
        if (current != null) {
            libraryVisibility = current;
        }
        libraryVisibility.update(library, packageNames, visibility);
    }

    void delete(SharedLibraryImpl library) {
        LibraryVisibility libraryVisibility = (LibraryVisibility)this.libraryToVisibility.remove(library);
        if (libraryVisibility != null) {
            libraryVisibility.delete();
        }
    }

    void refreshExporters(SharedLibraryImpl library) {
        LibraryVisibility libraryVisibility = (LibraryVisibility)this.libraryToVisibility.get(library);
        if (libraryVisibility != null) {
            libraryVisibility.refreshExporters();
        }
    }

    static /* synthetic */ AtomicLong access$000(LibraryPackageExporter x0) {
        return x0.counter;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(LibraryPackageExporter.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class LibraryVisibility {
        private final EnumMap<LibraryAccess.PackageVisibility, Bundle> packageExporters = new EnumMap(LibraryAccess.PackageVisibility.class);
        private final long id = LibraryPackageExporter.access$000(LibraryPackageExporter.this).incrementAndGet();
        static final long serialVersionUID = 9055099644522500557L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private LibraryVisibility() {
        }

        void update(Library library, Collection<String> packageNames, LibraryAccess.PackageVisibility visibility) {
            if (packageNames == null || packageNames.isEmpty()) {
                this.uninstallExporter(visibility);
            } else {
                this.updateExporter(library, packageNames, visibility);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void uninstallExporter(LibraryAccess.PackageVisibility visibility) {
            Bundle existing;
            LibraryVisibility libraryVisibility = this;
            synchronized (libraryVisibility) {
                existing = this.packageExporters.remove((Object)visibility);
                if (existing != null) {
                    LibraryPackageExporter.this.bundleToLibrary.remove(existing);
                }
            }
            if (existing != null) {
                try {
                    existing.uninstall();
                }
                catch (BundleException bundleException) {
                    FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.library.internal.LibraryPackageExporter$LibraryVisibility", (String)"86", (Object)this, (Object[])new Object[]{visibility});
                }
                LibraryPackageExporter.this.refresh(Collections.singletonList(existing));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateExporter(Library library, Collection<String> packageNames, LibraryAccess.PackageVisibility visibility) {
            LibertyLoader loader = (LibertyLoader)library.getClassLoader();
            Bundle gatewayBundle = loader.getBundle();
            try {
                Region region = LibraryPackageExporter.this.getLibraryExporterRegion(LibraryPackageExporter.this.digraph, visibility);
                String exporterPostfix = "_library_exporter_" + this.id;
                Bundle result = new BundleFactory().setBundleContext(LibraryPackageExporter.this.context).setBundleLocationPrefix("").setBundleLocation(gatewayBundle.getLocation() + exporterPostfix).setBundleSymbolicName(gatewayBundle.getSymbolicName() + exporterPostfix).setBundleVersion(gatewayBundle.getVersion()).setBundleName((String)gatewayBundle.getHeaders("").get("Bundle-Name") + exporterPostfix).addAttributeValues("Export-Package", packageNames.toArray()).setRegion(region).createBundle();
                ((BundleStartLevel)result.adapt(BundleStartLevel.class)).setStartLevel(1);
                LibraryVisibility libraryVisibility = this;
                synchronized (libraryVisibility) {
                    LibraryPackageExporter.this.bundleToLibrary.put(result, library);
                    this.packageExporters.put(visibility, result);
                }
                LibraryPackageExporter.this.refresh(Collections.singletonList(result));
            }
            catch (BundleException bundleException) {
                FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.library.internal.LibraryPackageExporter$LibraryVisibility", (String)"121", (Object)this, (Object[])new Object[]{library, packageNames, visibility});
            }
        }

        void delete() {
            for (LibraryAccess.PackageVisibility visibility : LibraryAccess.PackageVisibility.values()) {
                this.uninstallExporter(visibility);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void refreshExporters() {
            ArrayList<Bundle> toRefresh;
            LibraryVisibility libraryVisibility = this;
            synchronized (libraryVisibility) {
                toRefresh = new ArrayList<Bundle>(this.packageExporters.values());
            }
            LibraryPackageExporter.this.refresh(toRefresh);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(LibraryVisibility.class);
        }
    }
}

