/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.classloading.internal.AppClassLoader;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.wsspi.classloading.ClassLoaderIdentity;
import com.ibm.wsspi.classloading.ClassLoadingConfigurationException;
import com.ibm.wsspi.kernel.service.utils.CompositeEnumeration;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;

@Trivial
final class Util {
    static final TraceComponent tc = Tr.register(Util.class);

    private Util() {
        throw null;
    }

    static <T> T ensureNotNull(String msg, T t) throws ClassLoadingConfigurationException {
        Util.ensure(msg, t != null);
        return t;
    }

    static void ensure(String msg, boolean condition) throws ClassLoadingConfigurationException {
        if (!condition) {
            throw new ClassLoadingConfigurationException(msg);
        }
    }

    static <T> List<T> list(T ... elems) {
        return Arrays.asList(elems);
    }

    static <T> Collection<T> freeze(Collection<T> coll) {
        return coll == null ? null : Collections.unmodifiableCollection(coll);
    }

    static <T> List<T> freeze(List<T> list) {
        return list == null ? null : Collections.unmodifiableList(list);
    }

    static <T> Set<T> freeze(Set<T> set) {
        return set == null ? null : Collections.unmodifiableSet(set);
    }

    static <T> String join(Iterable<T> elems, String delim) {
        if (elems == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (T elem : elems) {
            result.append(elem).append(delim);
        }
        if (result.length() > 0) {
            result.setLength(result.length() - delim.length());
        }
        return result.toString();
    }

    static String normalizeResourceName(String resourceName) {
        if (resourceName.startsWith("/")) {
            return resourceName.substring(1);
        }
        return resourceName;
    }

    static String convertClassNameToResourceName(String className) {
        return className.replace('.', '/') + ".class";
    }

    @Trivial
    @FFDCIgnore(value={IOException.class})
    public static void tryToClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static <T> Enumeration<T> compose(Enumeration<T> e1, Enumeration<T> e2) {
        return Util.isEmpty(e1) ? e2 : (Util.isEmpty(e2) ? e1 : new CompositeEnumeration(e1).add(e2));
    }

    private static boolean isEmpty(Enumeration<?> e) {
        return !e.hasMoreElements();
    }

    static boolean isGlobalSharedLibraryLoader(AppClassLoader loader) {
        ClassLoaderIdentity id = loader.getKey();
        return "Shared Library".equals(id.getDomain()) && "global".equals(id.getId());
    }
}

