/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.providers.jsonp;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jaxrs20.component.LibertyJaxRsThreadPoolAdapter;
import com.ibm.ws.jaxrs20.utils.ReflectUtil;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.classloading.ClassLoadingService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;

@Produces(value={"application/json", "application/*+json"})
@Consumes(value={"application/json", "application/*+json"})
@Provider
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JsonPProvider
implements MessageBodyReader,
MessageBodyWriter {
    private static final String[] jsonpClasses;
    private static final Map<String, Class<?>> jsonpClsMaps;
    private static final Map<String, Method> jsonpMethodMaps;
    static final long serialVersionUID = -6152669688849102640L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private static void loadClass(ClassLoader cl) {
        for (String clsName : jsonpClasses) {
            Class<?> c = ReflectUtil.loadClass(cl, clsName);
            if (c == null) continue;
            jsonpClsMaps.put(clsName, c);
        }
    }

    public long getSize(Object arg0, Class arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
        return -1L;
    }

    public boolean isWriteable(Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isAssignableFrom(type, "javax.json.JsonStructure") || this.isAssignableFrom(type, "javax.json.JsonArray") || this.isAssignableFrom(type, "javax.json.JsonObject");
    }

    private boolean isAssignableFrom(Class type, String parentClass) {
        if (jsonpClsMaps.containsKey(parentClass)) {
            return jsonpClsMaps.get(parentClass).isAssignableFrom(type);
        }
        return false;
    }

    private Method getMethod(String className, String methodName, Class[] paramTypes) {
        if (!jsonpClsMaps.containsKey(className)) {
            return null;
        }
        Class<?> c = jsonpClsMaps.get(className);
        Method m = null;
        String cachekey = className + "." + methodName;
        if (jsonpMethodMaps.containsKey(cachekey)) {
            m = jsonpMethodMaps.get(cachekey);
        } else {
            m = ReflectUtil.getMethod(c, methodName, paramTypes);
            jsonpMethodMaps.put(cachekey, m);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeTo(Object t, Class type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        if (entityStream == null) {
            throw new IOException("Initialized OutputStream should be provided");
        }
        if (!jsonpClsMaps.containsKey("javax.json.JsonWriter") || !jsonpClsMaps.containsKey("javax.json.Json") || !jsonpClsMaps.containsKey("javax.json.JsonStructure")) return;
        Class<?> jsonStructureClass = jsonpClsMaps.get("javax.json.JsonStructure");
        Method m = this.getMethod("javax.json.Json", "createWriter", new Class[]{OutputStream.class});
        Method m2 = this.getMethod("javax.json.JsonWriter", "write", new Class[]{jsonStructureClass});
        Method m3 = this.getMethod("javax.json.JsonWriter", "close", null);
        if (m == null) return;
        Object writer = null;
        writer = ReflectUtil.invoke(m, null, new Object[]{entityStream});
        if (writer != null) {
            ReflectUtil.invoke(m2, writer, new Object[]{t});
        }
        if (writer == null) return;
        try {
            ReflectUtil.invoke(m3, writer, null);
            return;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.jaxrs20.providers.jsonp.JsonPProvider", (String)"168", (Object)this, (Object[])new Object[]{t, type, genericType, annotations, mediaType, httpHeaders, entityStream});
        }
        return;
        catch (Throwable throwable) {
            try {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.jaxrs20.providers.jsonp.JsonPProvider", (String)"162", (Object)this, (Object[])new Object[]{t, type, genericType, annotations, mediaType, httpHeaders, entityStream});
                if (writer == null) return;
            }
            catch (Throwable throwable2) {
                if (writer == null) throw throwable2;
                try {
                    ReflectUtil.invoke(m3, writer, null);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    FFDCFilter.processException((Throwable)throwable3, (String)"com.ibm.ws.jaxrs20.providers.jsonp.JsonPProvider", (String)"168", (Object)this, (Object[])new Object[]{t, type, genericType, annotations, mediaType, httpHeaders, entityStream});
                }
                throw throwable2;
            }
            try {
                ReflectUtil.invoke(m3, writer, null);
                return;
            }
            catch (Throwable throwable4) {
                FFDCFilter.processException((Throwable)throwable4, (String)"com.ibm.ws.jaxrs20.providers.jsonp.JsonPProvider", (String)"168", (Object)this, (Object[])new Object[]{t, type, genericType, annotations, mediaType, httpHeaders, entityStream});
            }
            return;
        }
    }

    public boolean isReadable(Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isAssignableFrom(type, "javax.json.JsonStructure") || this.isAssignableFrom(type, "javax.json.JsonArray") || this.isAssignableFrom(type, "javax.json.JsonObject");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @FFDCIgnore(value={Throwable.class})
    public Object readFrom(Class arg0, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        Object reader;
        Method m3;
        Class<?> jsonException;
        block14: {
            if (entityStream == null) {
                throw new IOException("Initialized InputStream should be provided");
            }
            if (!jsonpClsMaps.containsKey("javax.json.JsonReader") || !jsonpClsMaps.containsKey("javax.json.Json") || !jsonpClsMaps.containsKey("javax.json.JsonException")) return null;
            jsonException = jsonpClsMaps.get("javax.json.JsonException");
            Method m = this.getMethod("javax.json.Json", "createReader", new Class[]{InputStream.class});
            Method m2 = this.getMethod("javax.json.JsonReader", "read", null);
            m3 = this.getMethod("javax.json.JsonReader", "close", null);
            if (m == null) return null;
            reader = null;
            reader = ReflectUtil.invoke(m, null, new Object[]{entityStream});
            if (reader == null) break block14;
            Object object = ReflectUtil.invoke(m2, reader, null);
            if (reader == null) return object;
            try {
                ReflectUtil.invoke(m3, reader, null);
                return object;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return object;
        }
        if (reader == null) return null;
        try {
            ReflectUtil.invoke(m3, reader, null);
            return null;
        }
        catch (Throwable throwable) {}
        return null;
        catch (Throwable e) {
            try {
                if (jsonException.isAssignableFrom(e.getClass())) {
                    throw ExceptionUtils.toBadRequestException(e, null);
                }
                if (reader == null) return null;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    ReflectUtil.invoke(m3, reader, null);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                ReflectUtil.invoke(m3, reader, null);
                return null;
            }
            catch (Throwable throwable) {}
            return null;
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JsonPProvider.class);
        jsonpClasses = new String[]{"javax.json.Json", "javax.json.JsonArray", "javax.json.JsonException", "javax.json.JsonObject", "javax.json.JsonReader", "javax.json.JsonStructure", "javax.json.JsonWriter"};
        jsonpClsMaps = new HashMap();
        jsonpMethodMaps = new HashMap<String, Method>();
        try {
            final ClassLoadingService clSvc = (ClassLoadingService)LibertyJaxRsThreadPoolAdapter.getClassLoadingServiceref().getService();
            final ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
                static final long serialVersionUID = 5864126176063464797L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ClassLoader run() {
                    return clSvc == null ? Thread.currentThread().getContextClassLoader() : clSvc.createThreadContextClassLoader(JsonPProvider.class.getClassLoader());
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
            JsonPProvider.loadClass(cl);
            if (clSvc != null) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){
                    static final long serialVersionUID = -7916058554031248591L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Void run() {
                        clSvc.destroyThreadContextClassLoader(cl);
                        return null;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(2.class);
                    }
                });
            }
        }
        catch (NoClassDefFoundError clSvc) {
            FFDCFilter.processException((Throwable)clSvc, (String)"com.ibm.ws.jaxrs20.providers.jsonp.JsonPProvider", (String)"76", null, (Object[])new Object[0]);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            JsonPProvider.loadClass(cl);
        }
    }
}

