/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jndi.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jndi.WSNameUtil;
import com.ibm.ws.jndi.internal.ContextNode;
import com.ibm.ws.jndi.internal.JNDIServiceBinderManager;
import com.ibm.ws.jndi.internal.WSContext;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ObjectFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={InitialContextFactory.class, ObjectFactory.class, WSContextFactory.class}, servicefactory=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class WSContextFactory
implements InitialContextFactory,
ObjectFactory {
    private BundleContext userContext;
    static final long serialVersionUID = 6353146459386485015L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void activate(ComponentContext cc) {
        Bundle usingBundle = cc.getUsingBundle();
        this.userContext = usingBundle.getBundleContext();
    }

    public WSContext getInitialContext(Hashtable env) throws NamingException {
        return new WSContext(this.userContext, JNDIServiceBinderManager.JNDIServiceBinderHolder.HELPER.root, env);
    }

    @Override
    public Object getObjectInstance(Object o, Name n, Context c, Hashtable<?, ?> envmt) throws Exception {
        Hashtable<String, Object> env = envmt;
        return o instanceof Reference ? this.resolve((Reference)o, env) : null;
    }

    private WSContext resolve(Reference ref, Hashtable<String, Object> env) throws NamingException {
        RefAddr addr;
        Object content;
        if (ref.getClassName().equals(WSContext.class.getName()) && (content = (addr = ref.get("jndi")).getContent()) instanceof String) {
            String name = (String)content;
            Object o = JNDIServiceBinderManager.JNDIServiceBinderHolder.HELPER.root.lookup(WSNameUtil.normalize(name));
            try {
                ContextNode node = (ContextNode)o;
                return new WSContext(this.userContext, node, env);
            }
            catch (ClassCastException node) {
                FFDCFilter.processException((Throwable)node, (String)"com.ibm.ws.jndi.internal.WSContextFactory", (String)"87", (Object)this, (Object[])new Object[]{ref, env});
                throw new NotContextException(name);
            }
        }
        return null;
    }

    static Reference makeReference(WSContext ctx) throws NamingException {
        StringRefAddr addr = new StringRefAddr("jndi", "" + ctx.myNode.fullName);
        return new Reference(WSContext.class.getName(), addr, WSContextFactory.class.getName(), null);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(WSContextFactory.class);
    }
}

