/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.time;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.text.SimpleDateFormat;
import java.util.Date;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TimeUtils {
    private static final TraceComponent tc = Tr.register(TimeUtils.class, (String)"SecurityCommon", (String)"com.ibm.ws.security.common.internal.resources.SSOCommonMessages");
    public static final String YearMonthDateHourMinSecZone = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String YearMonthDateHourMinSecMillisZone = "yyyy-MM-dd'T'HH:mm:ss:SSSZ";
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
    static final long serialVersionUID = 7695778627365105325L;

    public TimeUtils() {
    }

    public TimeUtils(String dateFormat) {
        this.setSimpleDateFormat(dateFormat);
    }

    @FFDCIgnore(value={Exception.class})
    public void setSimpleDateFormat(String formatString) {
        block4: {
            if (formatString == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Null format string provided; date format will not be changed", (Object[])new Object[0]);
                }
                return;
            }
            try {
                this.simpleDateFormat = new SimpleDateFormat(formatString);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Exception caught setting date format: " + e.getMessage()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)"Date format will not be changed", (Object[])new Object[0]);
            }
        }
    }

    public String createDateString(long timeMilliseconds) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Creating date string based on long value: " + timeMilliseconds), (Object[])new Object[0]);
        }
        return this.createDateString(new Date(timeMilliseconds));
    }

    public String createDateString(Date date) {
        if (date == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Null Date object provided; returning null", (Object[])new Object[0]);
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Creating date string based on date: " + date), (Object[])new Object[0]);
        }
        String formatted = this.simpleDateFormat.format(date);
        return formatted;
    }
}

