/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.ear.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.adaptable.module.structure.StructureHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
final class EARStructureHelper
implements StructureHelper {
    private static final EARStructureHelper unknownRootInstance;
    private final Map<String, Object> rootPathTree;
    static final long serialVersionUID = 3683467489970445625L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static StructureHelper getUnknownRootInstance() {
        return unknownRootInstance;
    }

    public static EARStructureHelper create(Collection<String> rootPaths) {
        HashMap<String, Object> rootPathTree = new HashMap<String, Object>();
        for (String path : rootPaths) {
            EARStructureHelper.addRootPath(rootPathTree, path);
        }
        return new EARStructureHelper(rootPathTree);
    }

    private static void addRootPath(Map<String, Object> rootPathTree, String path) {
        HashMap<String, Object> node = rootPathTree;
        String[] parts = path.split("/+");
        if (parts.length > 0) {
            int begin;
            int n = begin = parts[0].isEmpty() ? 1 : 0;
            if (begin < parts.length) {
                for (int i = begin; i < parts.length - 1; ++i) {
                    Object nextNode = node.get(parts[i]);
                    if (nextNode == RootStatus.Root) {
                        return;
                    }
                    if (nextNode != null) {
                        HashMap<String, Object> uncheckedNode;
                        node = uncheckedNode = (HashMap<String, Object>)nextNode;
                        continue;
                    }
                    HashMap<String, Object> newNode = new HashMap<String, Object>();
                    node.put(parts[i], newNode);
                    node = newNode;
                }
                node.put(parts[parts.length - 1], (Object)RootStatus.Root);
            }
        }
    }

    private static boolean isContainerWithinTopPathSpace(ArtifactContainer artifactContainer) {
        return artifactContainer.getRoot().getEnclosingContainer() == null;
    }

    private EARStructureHelper(Map<String, Object> rootPathTree) {
        this.rootPathTree = rootPathTree;
    }

    private static boolean isRootName(String name) {
        return name.endsWith(".war") || name.endsWith(".jar") || name.endsWith(".rar");
    }

    private RootStatus pathContainsRoot(String path) {
        String[] parts = path.split("/");
        Map node = this.rootPathTree;
        for (int i = 0; i < parts.length; ++i) {
            Map uncheckedNode;
            if (parts[i].isEmpty()) continue;
            if (this.rootPathTree == null) {
                if (!EARStructureHelper.isRootName(parts[i])) continue;
                return i == parts.length - 1 ? RootStatus.Root : RootStatus.ParentRoot;
            }
            Object nextNode = node.get(parts[i]);
            if (nextNode == null) {
                return RootStatus.None;
            }
            if (nextNode == RootStatus.Root) {
                return i == parts.length - 1 ? RootStatus.Root : RootStatus.ParentRoot;
            }
            node = uncheckedNode = (Map)nextNode;
        }
        return RootStatus.None;
    }

    public boolean isRoot(ArtifactContainer artifactContainer) {
        if (!EARStructureHelper.isContainerWithinTopPathSpace(artifactContainer)) {
            return false;
        }
        String path = artifactContainer.getPath();
        return this.pathContainsRoot(path) == RootStatus.Root;
    }

    public boolean isValid(ArtifactContainer artifactContainer, String path) {
        String acPath;
        if (!EARStructureHelper.isContainerWithinTopPathSpace(artifactContainer)) {
            return true;
        }
        if (!path.startsWith("/") && this.pathContainsRoot(acPath = artifactContainer.getPath()) != RootStatus.None) {
            return true;
        }
        return this.pathContainsRoot(path) != RootStatus.ParentRoot;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(EARStructureHelper.class);
        unknownRootInstance = new EARStructureHelper(null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static final class RootStatus
    extends Enum<RootStatus> {
        public static final /* enum */ RootStatus None;
        public static final /* enum */ RootStatus Root;
        public static final /* enum */ RootStatus ParentRoot;
        private static final /* synthetic */ RootStatus[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static RootStatus[] values() {
            return (RootStatus[])$VALUES.clone();
        }

        public static RootStatus valueOf(String name) {
            return Enum.valueOf(RootStatus.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(RootStatus.class);
            None = new RootStatus();
            Root = new RootStatus();
            ParentRoot = new RootStatus();
            $VALUES = new RootStatus[]{None, Root, ParentRoot};
        }
    }
}

