/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.service.util.CpuInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.internal.ExecutorServiceImpl;
import com.ibm.ws.threading.internal.IntervalTask;
import com.ibm.ws.threading.internal.ThroughputDistribution;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ThreadPoolExecutor;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public final class ThreadPoolController {
    private static final TraceComponent tc = Tr.register(ThreadPoolController.class);
    private static final long interval;
    private static final int compareRange;
    private static final int NUMBER_CPUS;
    private int controllerCycle = 0;
    private boolean distributionReset = false;
    private int poolIncrement;
    private int poolDecrement = this.poolIncrement = 1;
    private static final int poolIncrementBoundLow;
    private static final int poolIncrementBoundMedium;
    private static final int poolIncrementMax;
    private static final int poolIncrementMin;
    private static final int POOL_INCREMENT_MIN_DEFAULT = 1;
    private static final int POOL_INCREMENT_MAX_DEFAULT;
    private static final int MINIMUM_DESIRED_POOLSIZE_ADJUSTMENTS;
    private int targetPoolSize = -1;
    private int consecutiveTargetPoolSizeWrong = 0;
    private static final int MAX_CONSECUTIVE_TARGET_POOLSIZE_WRONG = 3;
    private static final int highCpu;
    private static final double dataAgePruneLevel;
    private static final int compareSpanPruneMultiplier;
    private static final double tputRatioPruneLevel;
    private static final double poolTputRatioHigh;
    private static final double poolTputRatioLow;
    private static final int compareSpanRatioMultiplier;
    private static final double growScoreFilterLevel;
    private static final double shrinkScoreFilterLevel;
    private static final double resetDistroStdDevEwmaRatio;
    private static final double resetDistroNewTputEwmaRatio;
    private static final double resetDistroConsecutiveOutliers;
    private double processCpuUtil = -1.0;
    private double systemCpuUtil = -1.0;
    private double cpuUtil = -1.0;
    private static final int MAX_INTERVALS_WITHOUT_CHANGE = 5;
    static final double EMPTY_QUEUE_SHRINK_MAGIC_PER_INTERVAL = 0.04;
    private static final int IDLE_INTERVALS_BEFORE_PAUSE = 3;
    private static final int MAX_OUTLIER_AFTER_CHANGE_BEFORE_RESET;
    private static final int MAX_THREADS_TO_BREAK_HANG;
    private final ExecutorServiceImpl executorService;
    private LastAction lastAction = LastAction.NONE;
    private final Timer timer = new Timer("Executor Service Control Timer", true);
    private IntervalTask activeTask = null;
    private boolean paused = false;
    private long lastTimerPop = 0L;
    private long previousCompleted = 0L;
    private double previousThroughput = 0.0;
    private int consecutiveQueueEmptyCount = 0;
    private int consecutiveNoAdjustment = 0;
    private int consecutiveOutlierAfterAdjustment = 0;
    private int consecutiveIdleCount = 0;
    private final int maxThreads;
    private final int coreThreads;
    private final int threadRange;
    ThreadPoolExecutor threadPool;
    private TreeMap<Integer, ThroughputDistribution> threadStats = new TreeMap();
    private int poolSizeWhenHangDetected = -1;
    private int hangIntervalCounter = 0;
    static final long serialVersionUID = 8569198517927074314L;

    ThreadPoolController(ExecutorServiceImpl executorService, ThreadPoolExecutor pool) {
        this.executorService = executorService;
        this.threadPool = pool;
        this.coreThreads = pool.getCorePoolSize();
        this.maxThreads = pool.getMaximumPoolSize();
        this.threadRange = this.maxThreads - this.coreThreads;
        this.setPoolSize(this.coreThreads);
        this.targetPoolSize = this.coreThreads;
        this.resetStatistics(true);
        if (this.coreThreads < this.maxThreads) {
            this.activeTask = new IntervalTask(this);
            this.timer.schedule((TimerTask)this.activeTask, interval, interval);
        }
    }

    void resetStatistics(boolean clearHistory) {
        this.lastTimerPop = System.currentTimeMillis();
        this.previousCompleted = this.threadPool == null ? 0L : this.threadPool.getCompletedTaskCount();
        this.previousThroughput = 0.0;
        this.consecutiveQueueEmptyCount = 0;
        this.consecutiveNoAdjustment = 0;
        this.consecutiveOutlierAfterAdjustment = 0;
        this.consecutiveIdleCount = 0;
        if (clearHistory) {
            this.threadStats = new TreeMap();
        }
        this.lastAction = LastAction.NONE;
    }

    void resetThreadPool() {
        if (this.threadPool == null) {
            return;
        }
        int availableProcessors = NUMBER_CPUS;
        int factor = 2500 * availableProcessors / Math.max(1, (int)this.previousThroughput);
        factor = Math.min(factor, 4);
        factor = Math.max(factor, 2);
        int newThreads = Math.min(factor * availableProcessors, this.maxThreads);
        this.targetPoolSize = newThreads = Math.max(newThreads, this.coreThreads);
        this.setPoolSize(newThreads);
        this.resetStatistics(true);
    }

    synchronized void deactivate() {
        this.paused = false;
        if (this.activeTask != null) {
            this.activeTask.cancel();
            this.activeTask = null;
        }
        this.threadPool = null;
    }

    synchronized void pause() {
        this.paused = true;
        if (this.activeTask != null) {
            this.activeTask.cancel();
            this.activeTask = null;
        }
    }

    @Trivial
    void resumeIfPaused() {
        if (this.paused) {
            this.resume();
        }
    }

    synchronized void resume() {
        this.paused = false;
        if (this.activeTask == null) {
            this.activeTask = new IntervalTask(this);
            this.timer.schedule((TimerTask)this.activeTask, interval, interval);
        }
    }

    ThroughputDistribution getThroughputDistribution(int activeThreads, boolean create) {
        Integer threads;
        ThroughputDistribution throughput;
        if (activeThreads < this.coreThreads) {
            activeThreads = this.coreThreads;
        }
        if ((throughput = this.threadStats.get(threads = Integer.valueOf(activeThreads))) == null && create) {
            throughput = new ThroughputDistribution();
            throughput.setLastUpdate(this.controllerCycle);
            this.threadStats.put(threads, throughput);
        }
        return throughput;
    }

    boolean manageIdlePool(ThreadPoolExecutor threadPool, long intervalCompleted) {
        this.consecutiveIdleCount = intervalCompleted == 0L && threadPool.getActiveCount() == 0 ? ++this.consecutiveIdleCount : 0;
        if (this.consecutiveIdleCount >= 3) {
            this.pause();
            this.lastAction = LastAction.PAUSE;
            return true;
        }
        return false;
    }

    boolean handleOutliers(ThroughputDistribution distribution, double throughput) {
        boolean currentIsOutlier;
        if (throughput < 0.0) {
            this.resetStatistics(false);
            return true;
        }
        if (throughput == 0.0) {
            return false;
        }
        double zScore = distribution.getZScore(throughput);
        boolean bl = currentIsOutlier = zScore <= -3.0 || zScore >= 3.0;
        if (currentIsOutlier) {
            double ewma = distribution.getMovingAverage();
            double stddev = distribution.getStddev();
            if (stddev / ewma > resetDistroStdDevEwmaRatio || Math.abs(throughput - ewma) / ewma > resetDistroNewTputEwmaRatio || (double)distribution.incrementAndGetConsecutiveOutliers() >= resetDistroConsecutiveOutliers) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"reset distribution", (Object[])new Object[]{" distribution: " + distribution + ", new throughput: " + throughput});
                }
                distribution.reset(throughput, this.controllerCycle);
                this.distributionReset = true;
            } else if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"outlier detected", (Object[])new Object[]{" distribution: " + distribution + ", new throughput: " + throughput});
            }
        } else {
            distribution.resetConsecutiveOutliers();
        }
        if (this.lastAction != LastAction.NONE) {
            this.consecutiveOutlierAfterAdjustment = this.distributionReset ? ++this.consecutiveOutlierAfterAdjustment : 0;
        }
        if (this.consecutiveOutlierAfterAdjustment >= MAX_OUTLIER_AFTER_CHANGE_BEFORE_RESET) {
            this.resetThreadPool();
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    double getShrinkScore(int poolSize, double forecast, double throughput, int queueDepth, boolean cpuHigh) {
        double shrinkScore = 0.0;
        double shrinkMagic = 0.0;
        boolean flippedCoin = false;
        int downwardCompareSpan = 0;
        if (queueDepth > 0) {
            this.consecutiveQueueEmptyCount = 0;
        } else if (this.lastAction != LastAction.SHRINK) {
            ++this.consecutiveQueueEmptyCount;
        }
        if (poolSize >= this.coreThreads + this.poolDecrement) {
            downwardCompareSpan = Math.min(compareRange * this.poolDecrement, poolSize - this.coreThreads);
            Integer shrinkKey = this.threadStats.lowerKey(poolSize);
            Integer priorKey = poolSize;
            int smallerPools = 0;
            while (true) {
                int distance = 0;
                if (shrinkKey == null) break;
                priorKey = shrinkKey;
                shrinkKey = this.threadStats.lowerKey(shrinkKey);
                ThroughputDistribution priorStats = this.threadStats.get(priorKey);
                if (this.pruneData(priorStats, forecast, distance = poolSize - priorKey, downwardCompareSpan)) {
                    this.threadStats.remove(priorKey);
                    continue;
                }
                ++smallerPools;
                shrinkScore += priorStats.getProbabilityGreaterThan(forecast);
                if (distance >= downwardCompareSpan) break;
            }
            if (smallerPools < compareRange) {
                shrinkScore += this.flipCoin() ? 0.7 : 0.0;
                ++smallerPools;
                flippedCoin = true;
            }
            shrinkScore /= (double)smallerPools;
            if (!(this.consecutiveQueueEmptyCount <= 0 || this.lastAction == LastAction.SHRINK && throughput < this.previousThroughput)) {
                shrinkMagic = Math.min((double)this.consecutiveQueueEmptyCount * 0.04, 0.5);
                shrinkScore += shrinkMagic;
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"shrinkMagic info", (Object[])new Object[]{" shrinkMagic added: " + shrinkMagic});
                }
            }
            if (shrinkScore < 0.5) {
                if (cpuHigh) {
                    shrinkScore = this.flipCoin() ? 0.7 : shrinkScore;
                } else if (flippedCoin) {
                    try {
                        int upwardCompareSpan = Math.min(compareRange * this.poolIncrement, this.maxThreads - poolSize);
                        Integer largestPoolSize = this.getLargestValidPoolSize(poolSize, forecast, upwardCompareSpan);
                        if (largestPoolSize - poolSize > upwardCompareSpan * compareSpanRatioMultiplier && this.leanTowardShrinking(poolSize, largestPoolSize, forecast, this.threadStats.get(largestPoolSize).getMovingAverage())) {
                            shrinkScore = 0.7;
                        }
                    }
                    catch (Exception upwardCompareSpan) {
                        void e;
                        FFDCFilter.processException((Throwable)upwardCompareSpan, (String)"com.ibm.ws.threading.internal.ThreadPoolController", (String)"893", (Object)this, (Object[])new Object[]{poolSize, forecast, throughput, queueDepth, cpuHigh});
                        FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getShrinkScore - largestPoolSize", (Object)this);
                    }
                } else {
                    try {
                        Integer smallestPoolSize = this.getSmallestValidPoolSize(poolSize, forecast, downwardCompareSpan);
                        if (poolSize - smallestPoolSize > downwardCompareSpan * compareSpanRatioMultiplier && this.leanTowardShrinking(smallestPoolSize, poolSize, this.threadStats.get(smallestPoolSize).getMovingAverage(), forecast)) {
                            shrinkScore = 0.7;
                        }
                    }
                    catch (Exception smallestPoolSize) {
                        void e;
                        FFDCFilter.processException((Throwable)smallestPoolSize, (String)"com.ibm.ws.threading.internal.ThreadPoolController", (String)"905", (Object)this, (Object[])new Object[]{poolSize, forecast, throughput, queueDepth, cpuHigh});
                        FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getShrinkScore - smallestPoolSize", (Object)this);
                    }
                }
            } else if (flippedCoin && queueDepth > poolSize * 4) {
                double d = shrinkScore = this.flipCoin() ? 0.0 : shrinkScore;
            }
            if (shrinkScore < shrinkScoreFilterLevel) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"shrinkScore pruning", (Object[])new Object[]{" shrinkScore " + shrinkScore + " pruned"});
                }
                shrinkScore = 0.0;
            }
        }
        return shrinkScore;
    }

    /*
     * WARNING - void declaration
     */
    double getGrowScore(int poolSize, double forecast, double throughput, int queueDepth, boolean cpuHigh) {
        double growScore = 0.0;
        boolean flippedCoin = false;
        int upwardCompareSpan = 0;
        if (poolSize + this.poolIncrement <= this.maxThreads) {
            upwardCompareSpan = Math.min(compareRange * this.poolIncrement, this.maxThreads - poolSize);
            Integer growKey = this.threadStats.higherKey(poolSize);
            Integer priorKey = poolSize;
            int largerPools = 0;
            while (true) {
                int distance = 0;
                if (growKey == null) break;
                priorKey = growKey;
                growKey = this.threadStats.higherKey(growKey);
                ThroughputDistribution priorStats = this.threadStats.get(priorKey);
                if (this.pruneData(priorStats, forecast, distance = priorKey - poolSize, upwardCompareSpan)) {
                    this.threadStats.remove(priorKey);
                    continue;
                }
                ++largerPools;
                growScore += priorStats.getProbabilityGreaterThan(forecast);
                if (distance >= upwardCompareSpan) break;
            }
            if (largerPools < compareRange) {
                growScore += this.flipCoin() ? 0.7 : 0.0;
                ++largerPools;
                flippedCoin = true;
            }
            growScore /= (double)largerPools;
            ThroughputDistribution currentStats = this.getThroughputDistribution(poolSize, false);
            ThroughputDistribution growStats = this.getThroughputDistribution(poolSize + this.poolIncrement, false);
            if (currentStats != null && growStats != null && growScore < 0.5 && currentStats.getProbabilityGreaterThan(growStats.getMovingAverage()) >= 0.5) {
                growScore = 0.0;
            }
            if (cpuHigh && growScore > 0.0 && flippedCoin) {
                growScore = this.flipCoin() ? growScore : 0.0;
            } else if (growScore == 0.0 && flippedCoin && queueDepth > poolSize * 4) {
                growScore = this.flipCoin() ? 0.5 : 0.0;
            } else if (growScore > 0.0) {
                if (flippedCoin) {
                    try {
                        int downwardCompareSpan = Math.min(compareRange * this.poolDecrement, poolSize - this.coreThreads);
                        Integer smallestPoolSize = this.getSmallestValidPoolSize(poolSize, forecast, downwardCompareSpan);
                        if (poolSize - smallestPoolSize > downwardCompareSpan * compareSpanRatioMultiplier && this.leanTowardShrinking(smallestPoolSize, poolSize, this.threadStats.get(smallestPoolSize).getMovingAverage(), forecast)) {
                            growScore = 0.0;
                        }
                    }
                    catch (Exception downwardCompareSpan) {
                        void e;
                        FFDCFilter.processException((Throwable)downwardCompareSpan, (String)"com.ibm.ws.threading.internal.ThreadPoolController", (String)"1017", (Object)this, (Object[])new Object[]{poolSize, forecast, throughput, queueDepth, cpuHigh});
                        FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getGrowScore - smallestPoolSize", (Object)this);
                    }
                } else if (growScore < 0.5) {
                    try {
                        Integer largestPoolSize = this.getLargestValidPoolSize(poolSize, forecast, upwardCompareSpan);
                        if (largestPoolSize - poolSize > upwardCompareSpan * compareSpanRatioMultiplier && this.leanTowardShrinking(poolSize, largestPoolSize, forecast, this.threadStats.get(largestPoolSize).getMovingAverage())) {
                            growScore = 0.0;
                        }
                    }
                    catch (Exception largestPoolSize) {
                        void e;
                        FFDCFilter.processException((Throwable)largestPoolSize, (String)"com.ibm.ws.threading.internal.ThreadPoolController", (String)"1032", (Object)this, (Object[])new Object[]{poolSize, forecast, throughput, queueDepth, cpuHigh});
                        FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getGrowScore - largestPoolSize", (Object)this);
                    }
                }
            }
            if (growScore < growScoreFilterLevel) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"growScore pruning", (Object[])new Object[]{" growScore " + growScore + " pruned"});
                }
                growScore = 0.0;
            }
        }
        return growScore;
    }

    int forceVariation(int poolSize, int calculatedAdjustment, long intervalCompleted) {
        this.consecutiveNoAdjustment = calculatedAdjustment == 0 && intervalCompleted != 0L ? ++this.consecutiveNoAdjustment : 0;
        int forcedAdjustment = calculatedAdjustment;
        if (this.consecutiveNoAdjustment >= 5) {
            this.consecutiveNoAdjustment = 0;
            if (this.flipCoin() && poolSize + this.poolIncrement <= this.maxThreads) {
                forcedAdjustment = this.poolIncrement;
            } else if (poolSize - this.poolDecrement >= this.coreThreads) {
                forcedAdjustment = -this.poolDecrement;
            }
        }
        return forcedAdjustment;
    }

    boolean flipCoin() {
        return Math.random() >= 0.5;
    }

    int adjustPoolSize(int poolSize, int poolAdjustment) {
        if (this.threadPool == null) {
            return poolSize;
        }
        int newPoolSize = poolSize + poolAdjustment;
        this.lastAction = LastAction.NONE;
        if (poolAdjustment != 0) {
            if (poolAdjustment < 0 && newPoolSize >= this.coreThreads) {
                this.lastAction = LastAction.SHRINK;
                this.setPoolSize(newPoolSize);
            } else if (poolAdjustment > 0 && newPoolSize <= this.maxThreads) {
                this.lastAction = LastAction.GROW;
                this.setPoolSize(newPoolSize);
            } else {
                newPoolSize = poolSize;
            }
        }
        return newPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized String evaluateInterval() {
        if (this.threadPool == null) {
            return "threadPool == null";
        }
        int poolSize = this.threadPool.getPoolSize();
        if (poolSize <= 0) {
            return "poolSize <= 0";
        }
        if (poolSize < this.coreThreads) {
            return "poolSize < coreThreads";
        }
        ++this.controllerCycle;
        long currentTime = System.currentTimeMillis();
        long completedWork = this.threadPool.getCompletedTaskCount();
        long deltaTime = Math.max(currentTime - this.lastTimerPop, interval);
        long deltaCompleted = completedWork - this.previousCompleted;
        double throughput = 1000.0 * (double)deltaCompleted / (double)deltaTime;
        try {
            boolean queueEmpty;
            int queueDepth = this.threadPool.getQueue().size();
            boolean bl = queueEmpty = queueDepth == 0;
            if (this.manageIdlePool(this.threadPool, deltaCompleted)) {
                String string = "monitoring paused";
                return string;
            }
            if (this.resolveHang(deltaCompleted, queueEmpty)) {
                String string = "action take to resolve hang";
                return string;
            }
            if (this.checkTargetPoolSize(poolSize)) {
                String string = "poolSize != targetPoolSize";
                return string;
            }
            ThroughputDistribution currentStats = this.getThroughputDistribution(poolSize, true);
            this.distributionReset = false;
            if (this.handleOutliers(currentStats, throughput)) {
                String string = "aberrant workload";
                return string;
            }
            if (!this.distributionReset && throughput > 0.0) {
                currentStats.addDataPoint(throughput, this.controllerCycle);
            }
            boolean cpuHigh = false;
            this.processCpuUtil = CpuInfo.getJavaCpuUsage();
            this.systemCpuUtil = CpuInfo.getSystemCpuUsage();
            this.cpuUtil = Math.max(this.systemCpuUtil, this.processCpuUtil);
            if (this.cpuUtil > (double)highCpu) {
                cpuHigh = true;
            }
            this.setPoolIncrementDecrement(poolSize);
            double forecast = currentStats.getMovingAverage();
            double shrinkScore = this.getShrinkScore(poolSize, forecast, throughput, queueDepth, cpuHigh);
            double growScore = this.getGrowScore(poolSize, forecast, throughput, queueDepth, cpuHigh);
            int poolAdjustment = 0;
            if (growScore > shrinkScore) {
                poolAdjustment = this.poolIncrement;
            } else if (shrinkScore > growScore) {
                poolAdjustment = -this.poolDecrement;
            }
            poolAdjustment = this.forceVariation(poolSize, poolAdjustment, deltaCompleted);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Interval data", (Object[])new Object[]{this.toIntervalData(throughput, forecast, shrinkScore, growScore, queueDepth, poolSize, poolAdjustment)});
            }
            this.targetPoolSize = this.adjustPoolSize(poolSize, poolAdjustment);
        }
        finally {
            this.lastTimerPop = currentTime;
            this.previousCompleted = completedWork;
            this.previousThroughput = throughput;
        }
        return "";
    }

    @Trivial
    private String toIntervalData(double throughput, double forecast, double shrinkScore, double growScore, int queueDepth, int poolSize, int poolAdjustment) {
        int i;
        int RANGE = 25;
        StringBuilder sb = new StringBuilder();
        sb.append("\nThroughput:");
        sb.append(String.format(" previous = %.6f", this.previousThroughput));
        sb.append(String.format(" current = %.6f", throughput));
        sb.append(String.format(" forecast = %.6f", forecast));
        sb.append("\nHeuristics:");
        sb.append(String.format(" queueDepth = %8d", queueDepth));
        sb.append(String.format(" consecutiveQueueEmptyCount = %2d", this.consecutiveQueueEmptyCount));
        sb.append(String.format(" consecutiveNoAdjustment = %2d", this.consecutiveNoAdjustment));
        sb.append("\nOutliers:  ");
        sb.append(String.format(" consecutiveOutlierAfterAdjustment = %2d", this.consecutiveOutlierAfterAdjustment));
        sb.append("\nAttraction:");
        sb.append(String.format(" shrinkScore = %.6f", shrinkScore));
        sb.append(String.format(" growScore = %.6f", growScore));
        sb.append(String.format(" lastAction = %s", new Object[]{this.lastAction}));
        sb.append("\nCPU:");
        sb.append(String.format(" cpuUtil = %.2f", this.cpuUtil));
        sb.append(String.format(" processCpuUtil = %.2f", this.processCpuUtil));
        sb.append(String.format(" systemCpuUtil = %.2f", this.systemCpuUtil));
        sb.append("\nIncrement:");
        sb.append(String.format(" poolSize = %2d", poolSize));
        sb.append(String.format(" poolIncrement = %2d", this.poolIncrement));
        sb.append(String.format(" poolDecrement = %2d", this.poolDecrement));
        sb.append(String.format(" compareRange = %2d", compareRange));
        sb.append("\nStatistics:\n");
        Integer[] poolSizes = new Integer[51];
        ThroughputDistribution[] tputDistros = new ThroughputDistribution[51];
        Integer poolSizeInteger = poolSize;
        int start = 25;
        int end = 25;
        poolSizes[25] = poolSizeInteger;
        tputDistros[25] = this.getThroughputDistribution(poolSize, false);
        Integer prior = this.threadStats.lowerKey(poolSizeInteger);
        Integer next = this.threadStats.higherKey(poolSizeInteger);
        for (i = 1; i <= 25; ++i) {
            if (prior != null) {
                poolSizes[--start] = prior;
                tputDistros[start] = this.getThroughputDistribution(prior, false);
                prior = this.threadStats.lowerKey(prior);
            }
            if (next == null) continue;
            poolSizes[++end] = next;
            tputDistros[end] = this.getThroughputDistribution(next, false);
            next = this.threadStats.higherKey(next);
        }
        for (i = start; i <= end; ++i) {
            sb.append(String.format("%s%3d threads: %s%n", poolSizes[i] == poolSizeInteger ? "-->" : "   ", poolSizes[i], String.valueOf(tputDistros[i])));
        }
        if (poolAdjustment == 0) {
            sb.append("### No pool adjustment ###");
        } else if (poolAdjustment < 0) {
            sb.append("--- Shrinking to " + (poolSize + poolAdjustment) + " ---");
        } else {
            sb.append("+++ Growing to " + (poolSize + poolAdjustment) + " +++");
        }
        return sb.toString();
    }

    private String poolTputRatioData(double poolTputRatio, double poolRatio, double tputRatio, double smallerPoolTput, double largerPoolTput, int smallerPoolSize, int largerPoolSize) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n ");
        sb.append(String.format(" poolTputRatio: %.3f", poolTputRatio));
        sb.append(String.format(" poolRatio: %.3f", poolRatio));
        sb.append(String.format(" tputRatio: %.3f", tputRatio));
        sb.append("\n ");
        sb.append(String.format(" smallerPoolSize: %d", smallerPoolSize));
        sb.append(String.format(" largerPoolSize: %d", largerPoolSize));
        sb.append(String.format(" smallerPoolTput: %.3f", smallerPoolTput));
        sb.append(String.format(" largerPoolTput: %.3f", largerPoolTput));
        return sb.toString();
    }

    private boolean resolveHang(long tasksCompleted, boolean queueEmpty) {
        boolean actionTaken = false;
        if (tasksCompleted == 0L && !queueEmpty) {
            int poolSize = this.threadPool.getPoolSize();
            if (this.poolSizeWhenHangDetected < 0) {
                this.poolSizeWhenHangDetected = poolSize;
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Executor hang detected at poolSize=" + this.poolSizeWhenHangDetected), (Object[])new Object[]{this.threadPool});
                }
            }
            this.setPoolIncrementDecrement(poolSize);
            if (poolSize + this.poolIncrement <= this.maxThreads && poolSize < MAX_THREADS_TO_BREAK_HANG) {
                this.setPoolSize(poolSize += this.poolIncrement);
                this.targetPoolSize = poolSize;
                actionTaken = true;
            } else if (this.hangIntervalCounter == 1 && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"unbreakableExecutorHang", (Object[])new Object[]{this.poolSizeWhenHangDetected, poolSize});
            }
            ++this.hangIntervalCounter;
        } else {
            this.poolSizeWhenHangDetected = -1;
            this.hangIntervalCounter = 0;
        }
        return actionTaken;
    }

    private void setPoolSize(int newPoolSize) {
        if (newPoolSize < this.threadPool.getCorePoolSize()) {
            this.threadPool.setCorePoolSize(newPoolSize);
            this.threadPool.setMaximumPoolSize(newPoolSize);
        } else {
            this.threadPool.setMaximumPoolSize(newPoolSize);
            this.threadPool.setCorePoolSize(newPoolSize);
        }
    }

    private boolean pruneData(ThroughputDistribution priorStats, double forecast, int distance, int compareSpan) {
        boolean prune = false;
        double tputRatio = forecast / priorStats.getMovingAverage();
        if (tputRatio > tputRatioPruneLevel || tputRatio < 1.0 / tputRatioPruneLevel) {
            prune = true;
        } else {
            double variability;
            int age = this.controllerCycle - priorStats.getLastUpdate();
            if ((double)age * (variability = priorStats.getStddev() / priorStats.getMovingAverage()) > dataAgePruneLevel) {
                prune = true;
            }
        }
        return prune;
    }

    private Integer getSmallestValidPoolSize(Integer poolSize, Double forecast, int compareSpan) {
        Integer smallestPoolSize = -1;
        boolean validSmallData = false;
        int distance = 0;
        while (!validSmallData) {
            smallestPoolSize = this.threadStats.firstKey();
            ThroughputDistribution smallestPoolSizeStats = this.getThroughputDistribution(smallestPoolSize, false);
            distance = poolSize - smallestPoolSize;
            if (this.pruneData(smallestPoolSizeStats, forecast, distance, compareSpan)) {
                this.threadStats.remove(smallestPoolSize);
                continue;
            }
            validSmallData = true;
        }
        return smallestPoolSize;
    }

    private Integer getLargestValidPoolSize(Integer poolSize, Double forecast, int compareSpan) {
        Integer largestPoolSize = -1;
        boolean validLargeData = false;
        int distance = 0;
        while (!validLargeData) {
            largestPoolSize = this.threadStats.lastKey();
            ThroughputDistribution largestPoolSizeStats = this.getThroughputDistribution(largestPoolSize, false);
            distance = largestPoolSize - poolSize;
            if (this.pruneData(largestPoolSizeStats, forecast, distance, compareSpan)) {
                this.threadStats.remove(largestPoolSize);
                continue;
            }
            validLargeData = true;
        }
        return largestPoolSize;
    }

    private boolean leanTowardShrinking(Integer smallerPoolSize, int largerPoolSize, double smallerPoolTput, double largerPoolTput) {
        boolean shouldShrink = false;
        double poolRatio = largerPoolSize / smallerPoolSize;
        double tputRatio = largerPoolTput / smallerPoolTput;
        double poolTputRatio = poolRatio / tputRatio;
        if (tputRatio < 1.0) {
            shouldShrink = !this.flipCoin() || !this.flipCoin();
        } else if (poolTputRatio > poolTputRatioHigh) {
            shouldShrink = !this.flipCoin() || !this.flipCoin();
        } else if (poolTputRatio > poolTputRatioLow) {
            boolean bl = shouldShrink = !this.flipCoin();
        }
        if (tc.isEventEnabled() && shouldShrink) {
            Tr.event((TraceComponent)tc, (String)"Tput ratio shrinkScore adjustment, larger poolSizes", (Object[])new Object[]{this.poolTputRatioData(poolTputRatio, poolRatio, tputRatio, smallerPoolTput, largerPoolTput, smallerPoolSize, largerPoolSize)});
        }
        return shouldShrink;
    }

    private void setPoolIncrementDecrement(int poolSize) {
        if (this.threadRange < NUMBER_CPUS * MINIMUM_DESIRED_POOLSIZE_ADJUSTMENTS) {
            if (this.threadRange < MINIMUM_DESIRED_POOLSIZE_ADJUSTMENTS) {
                this.poolIncrement = 1;
                this.poolDecrement = 1;
            } else {
                this.poolDecrement = this.poolIncrement = this.threadRange / MINIMUM_DESIRED_POOLSIZE_ADJUSTMENTS;
            }
        } else if (poolSize <= poolIncrementBoundLow) {
            this.poolDecrement = this.poolIncrement = NUMBER_CPUS;
        } else if (poolSize <= poolIncrementBoundMedium) {
            this.poolDecrement = this.poolIncrement = NUMBER_CPUS * 2;
            if (poolSize == poolIncrementBoundLow + NUMBER_CPUS) {
                this.poolDecrement = NUMBER_CPUS;
            }
        } else {
            this.poolDecrement = this.poolIncrement = NUMBER_CPUS * 4;
            if (poolSize == poolIncrementBoundMedium + NUMBER_CPUS * 2) {
                this.poolDecrement = NUMBER_CPUS * 2;
            }
        }
        if ((poolIncrementMin != 1 || poolIncrementMax != POOL_INCREMENT_MAX_DEFAULT) && poolIncrementMin <= poolIncrementMax) {
            this.poolIncrement = Math.max(this.poolIncrement, poolIncrementMin);
            this.poolDecrement = this.poolIncrement = Math.min(this.poolIncrement, poolIncrementMax);
        }
        if (poolSize + this.poolIncrement > this.maxThreads) {
            if (poolSize == this.maxThreads) {
                this.poolDecrement = poolSize - this.threadStats.lowerKey(poolSize);
            } else {
                this.poolIncrement = this.maxThreads - poolSize;
            }
        }
        if (poolSize - this.poolDecrement < this.coreThreads && poolSize > this.coreThreads) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"poolDecrement vs coreThreads check", (Object[])new Object[]{" poolSize " + poolSize + " , poolDecrement: " + this.poolDecrement + ", coreThreads: " + this.coreThreads});
            }
            this.poolDecrement = poolSize - this.coreThreads;
        }
    }

    private boolean checkTargetPoolSize(int poolSize) {
        boolean poolSizeCheckFailed = false;
        if (poolSize != this.targetPoolSize) {
            poolSizeCheckFailed = true;
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"targetPoolSize check", (Object[])new Object[]{" poolSize " + poolSize + " != targetPoolSize " + this.targetPoolSize});
            }
            ++this.consecutiveTargetPoolSizeWrong;
            if (this.consecutiveTargetPoolSizeWrong >= 3) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"consecutiveTargetPoolSize check", (Object[])new Object[]{" consecutiveTargetPoolSizeWrong " + this.consecutiveTargetPoolSizeWrong + " exceeds threshold " + 3 + ", calling setPoolSize(targetPoolSize)"});
                }
                this.setPoolSize(this.targetPoolSize);
                this.consecutiveTargetPoolSizeWrong = 0;
            }
        } else {
            this.consecutiveTargetPoolSizeWrong = 0;
        }
        return poolSizeCheckFailed;
    }

    private static final String getSystemProperty(final String propName) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = 741276333193848807L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty(propName);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
    }

    synchronized void introspect(PrintWriter out) {
        String INDENT = "  ";
        out.println(this.getClass().getName());
        out.println("  coreThreads = " + this.coreThreads);
        out.println("  maxThreads = " + this.maxThreads);
        out.println("  interval = " + interval);
        out.println("  compareRange = " + compareRange);
        out.println("  NUMBER_CPUS = " + NUMBER_CPUS);
        out.println("  controllerCycle = " + this.controllerCycle);
        out.println("  poolIncrement = " + this.poolIncrement);
        out.println("  poolDecrement = " + this.poolDecrement);
        out.println("  poolIncrementMax = " + poolIncrementMax);
        out.println("  poolIncrementMin = " + poolIncrementMin);
        out.println("  targetPoolSize = " + this.targetPoolSize);
        out.println("  consecutiveTargetPoolSizeWrong = " + this.consecutiveTargetPoolSizeWrong);
        out.println("  highCpu = " + highCpu);
        out.println("  dataAgePruneLevel = " + dataAgePruneLevel);
        out.println("  growScoreFilterLevel = " + growScoreFilterLevel);
        out.println("  shrinkScoreFilterLevel = " + shrinkScoreFilterLevel);
        out.println("  resetDistroStdDevEwmaRatio = " + resetDistroStdDevEwmaRatio);
        out.println("  resetDistroNewTputEwmaRatio = " + resetDistroNewTputEwmaRatio);
        out.println("  resetDistroConsecutiveOutliers = " + resetDistroConsecutiveOutliers);
        out.println("  paused = " + this.paused);
        out.println("  hangIntervalCounter = " + this.hangIntervalCounter);
        out.println("  poolSizeWhenHangDetected = " + this.poolSizeWhenHangDetected);
        out.println("  lastAction = " + (Object)((Object)this.lastAction));
        out.println("  lastTimerPop = " + this.lastTimerPop);
        out.println("  previousCompleted = " + this.previousCompleted);
        out.println("  consecutiveIdleCount = " + this.consecutiveIdleCount);
        out.println("  consecutiveNoAdjustment = " + this.consecutiveNoAdjustment);
        out.println("  consecutiveOutlierAfterAdjustment = " + this.consecutiveOutlierAfterAdjustment);
        out.println("  consecutiveQueueEmptyCount = " + this.consecutiveQueueEmptyCount);
        out.println("  threadPool");
        out.println("    poolSize = " + this.threadPool.getPoolSize());
        out.println("    activeCount = " + this.threadPool.getActiveCount());
        out.println("    corePoolSize = " + this.threadPool.getCorePoolSize());
        out.println("    maxPoolSize = " + this.threadPool.getMaximumPoolSize());
        out.println("    largestPoolSize = " + this.threadPool.getLargestPoolSize());
        out.println("    completedTaskCount = " + this.threadPool.getCompletedTaskCount());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        NUMBER_CPUS = CpuInfo.getAvailableProcessors();
        POOL_INCREMENT_MAX_DEFAULT = NUMBER_CPUS * 4;
        String tpcResetDistroStdDevEwmaRatio = ThreadPoolController.getSystemProperty("tpcResetDistroStdDevEwmaRatio");
        resetDistroStdDevEwmaRatio = tpcResetDistroStdDevEwmaRatio == null ? 0.1 : Double.parseDouble(tpcResetDistroStdDevEwmaRatio);
        String tpcResetDistroNewTputEwmaRatio = ThreadPoolController.getSystemProperty("tpcResetDistroNewTputEwmaRatio");
        resetDistroNewTputEwmaRatio = tpcResetDistroNewTputEwmaRatio == null ? 0.5 : Double.parseDouble(tpcResetDistroNewTputEwmaRatio);
        String tpcResetDistroConsecutiveOutliers = ThreadPoolController.getSystemProperty("tpcResetDistroConsecutiveOutliers");
        resetDistroConsecutiveOutliers = tpcResetDistroConsecutiveOutliers == null ? 5.0 : (double)Integer.parseInt(tpcResetDistroConsecutiveOutliers);
        String tpcMinimumDesiredPoolSizeAdjustments = ThreadPoolController.getSystemProperty("tpcMinimumDesiredPoolSizeAdjustments");
        MINIMUM_DESIRED_POOLSIZE_ADJUSTMENTS = tpcMinimumDesiredPoolSizeAdjustments == null ? 10 : Integer.parseInt(tpcMinimumDesiredPoolSizeAdjustments);
        String tpcTputRatioPruneLevel = ThreadPoolController.getSystemProperty("tpcTputRatioPruneLevel");
        tputRatioPruneLevel = tpcTputRatioPruneLevel == null ? 5.0 : Double.parseDouble(tpcTputRatioPruneLevel);
        String tpcPoolTputRatioHigh = ThreadPoolController.getSystemProperty("tpcPoolTputRatioHigh");
        poolTputRatioHigh = tpcPoolTputRatioHigh == null ? 5.0 : Double.parseDouble(tpcPoolTputRatioHigh);
        String tpcPoolTputRatioLow = ThreadPoolController.getSystemProperty("tpcPoolTputRatioLow");
        poolTputRatioLow = tpcPoolTputRatioLow == null ? 3.0 : Double.parseDouble(tpcPoolTputRatioLow);
        String tpcCompareSpanRatioMultiplier = ThreadPoolController.getSystemProperty("tpcCompareSpanRatioMultiplier");
        compareSpanRatioMultiplier = tpcCompareSpanRatioMultiplier == null ? 2 : Integer.parseInt(tpcCompareSpanRatioMultiplier);
        String tpcGrowScorePruneLevel = ThreadPoolController.getSystemProperty("tpcGrowScorePruneLevel");
        growScoreFilterLevel = tpcGrowScorePruneLevel == null ? 0.5 : Double.parseDouble(tpcGrowScorePruneLevel);
        String tpcShrinkScorePruneLevel = ThreadPoolController.getSystemProperty("tpcShrinkScorePruneLevel");
        shrinkScoreFilterLevel = tpcShrinkScorePruneLevel == null ? 0.5 : Double.parseDouble(tpcShrinkScorePruneLevel);
        String tpcPoolIncrementMin = ThreadPoolController.getSystemProperty("tpcPoolIncrementMin");
        poolIncrementMin = tpcPoolIncrementMin == null ? 1 : Integer.parseInt(tpcPoolIncrementMin);
        String tpcPoolIncrementMax = ThreadPoolController.getSystemProperty("tpcPoolIncrementMax");
        poolIncrementMax = tpcPoolIncrementMax == null ? POOL_INCREMENT_MAX_DEFAULT : Integer.parseInt(tpcPoolIncrementMax);
        String tpcPoolIncrementBoundLow = ThreadPoolController.getSystemProperty("tpcPoolIncrementBoundLow");
        poolIncrementBoundLow = tpcPoolIncrementBoundLow == null ? NUMBER_CPUS * 16 : Integer.parseInt(tpcPoolIncrementBoundLow);
        String tpcPoolIncrementBoundMedium = ThreadPoolController.getSystemProperty("tpcPoolIncrementBoundMedium");
        poolIncrementBoundMedium = tpcPoolIncrementBoundMedium == null ? NUMBER_CPUS * 64 : Integer.parseInt(tpcPoolIncrementBoundMedium);
        String tpcHighCpu = ThreadPoolController.getSystemProperty("tpcHighCpu");
        highCpu = tpcHighCpu == null ? 90 : Integer.parseInt(tpcHighCpu);
        String tpcDataAgePruneLevel = ThreadPoolController.getSystemProperty("tpcDataAgePruneLevel");
        dataAgePruneLevel = tpcDataAgePruneLevel == null ? 5.0 : Double.parseDouble(tpcDataAgePruneLevel);
        String tpcCompareSpanPruneMultiplier = ThreadPoolController.getSystemProperty("tpcCompareSpanPruneMultiplier");
        compareSpanPruneMultiplier = tpcCompareSpanPruneMultiplier == null ? 2 : Integer.parseInt(tpcCompareSpanPruneMultiplier);
        String tpcInterval = ThreadPoolController.getSystemProperty("tpcInterval");
        interval = tpcInterval == null ? 1500L : (long)Integer.parseInt(tpcInterval);
        String tpcCompareRange = ThreadPoolController.getSystemProperty("tpcCompareRange");
        int n = compareRange = tpcCompareRange == null ? 4 : Integer.parseInt(tpcCompareRange);
        if (tc.isEventEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n Interval: ").append(String.format("%6d", interval));
            sb.append(" compareRange: ").append(String.format("%6d", compareRange));
            sb.append(" highCpu: ").append(String.format("%4d", highCpu));
            sb.append("\n tputRatioPruneLevel: ").append(String.format("%2.2f", tputRatioPruneLevel));
            sb.append(" poolTputRatioHigh: ").append(String.format("%2.2f", poolTputRatioHigh));
            sb.append(" poolTputRatioLow: ").append(String.format("%2.2f", poolTputRatioLow));
            sb.append(" compareSpanRatioMultiplier: ").append(String.format("%3d", compareSpanRatioMultiplier));
            sb.append("\n growScorePruneLevel: ").append(String.format("%2.2f", growScoreFilterLevel));
            sb.append(" shrinkScorePruneLevel: ").append(String.format("%2.2f", shrinkScoreFilterLevel));
            sb.append(" dataAgePruneLevel: ").append(String.format("%2.2f", dataAgePruneLevel));
            sb.append(" compareSpanPruneMultiplier: ").append(String.format("%3d", compareSpanPruneMultiplier));
            sb.append("\n poolIncrementMin: ").append(String.format("%3d", poolIncrementMin));
            sb.append(" poolIncrementMax: ").append(String.format("%4d", poolIncrementMax));
            sb.append(" poolIncrementBoundLow: ").append(String.format("%3d", poolIncrementBoundLow));
            sb.append(" poolIncrementBoundMedium: ").append(String.format("%3d", poolIncrementBoundMedium));
            sb.append("\n resetDistroStdDevEwmaRatio: ").append(String.format("%2.2f", resetDistroStdDevEwmaRatio));
            sb.append(" resetDistroNewTputEwmaRatio: ").append(String.format("%2.2f", resetDistroNewTputEwmaRatio));
            sb.append(" resetDistroConsecutiveOutliers: ").append(String.format("%2.2f", resetDistroConsecutiveOutliers));
            Tr.event((TraceComponent)tc, (String)"Initial config settings:", (Object[])new Object[]{sb});
        }
        MAX_OUTLIER_AFTER_CHANGE_BEFORE_RESET = compareRange * 2 + 2;
        MAX_THREADS_TO_BREAK_HANG = Math.max(1000, 512 * NUMBER_CPUS);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static final class LastAction
    extends Enum<LastAction> {
        public static final /* enum */ LastAction NONE;
        public static final /* enum */ LastAction GROW;
        public static final /* enum */ LastAction SHRINK;
        public static final /* enum */ LastAction PAUSE;
        private static final /* synthetic */ LastAction[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static LastAction[] values() {
            return (LastAction[])$VALUES.clone();
        }

        public static LastAction valueOf(String name) {
            return Enum.valueOf(LastAction.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(LastAction.class);
            NONE = new LastAction();
            GROW = new LastAction();
            SHRINK = new LastAction();
            PAUSE = new LastAction();
            $VALUES = new LastAction[]{NONE, GROW, SHRINK, PAUSE};
        }
    }
}

