/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.utils;

import com.ibm.ws.collector.manager.buffer.BufferManagerImpl;
import com.ibm.ws.logging.internal.impl.ConsoleLogHandler;
import com.ibm.ws.logging.internal.impl.MessageLogHandler;
import com.ibm.ws.logging.source.LogSource;
import com.ibm.ws.logging.source.TraceSource;
import com.ibm.ws.logging.utils.CollectorManagerPipelineBootstrap;
import com.ibm.wsspi.collector.manager.Handler;

public class CollectorManagerPipelineUtils
implements CollectorManagerPipelineBootstrap {
    public static CollectorManagerPipelineUtils collectorMgrPipelineUtils;
    private MessageLogHandler messageLogHandler;
    private ConsoleLogHandler consoleLogHandler;
    private LogSource logSource = null;
    private TraceSource traceSource = null;
    private BufferManagerImpl logConduit = null;
    private BufferManagerImpl traceConduit = null;
    private boolean isJsonTrService = false;

    public CollectorManagerPipelineUtils() {
        if (this.logSource == null) {
            this.logSource = new LogSource();
        }
        if (this.traceSource == null) {
            this.traceSource = new TraceSource();
        }
        if (this.logConduit == null) {
            this.logConduit = new BufferManagerImpl(10000, "com.ibm.ws.logging.source.message");
        }
        if (this.traceConduit == null) {
            this.traceConduit = new BufferManagerImpl(10000, "com.ibm.ws.logging.source.trace");
        }
        this.logSource.setBufferManager(this.logConduit);
        this.traceSource.setBufferManager(this.traceConduit);
    }

    public static synchronized CollectorManagerPipelineUtils getInstance() {
        if (collectorMgrPipelineUtils == null) {
            collectorMgrPipelineUtils = new CollectorManagerPipelineUtils();
        }
        return collectorMgrPipelineUtils;
    }

    @Override
    public LogSource getLogSource() {
        return this.logSource;
    }

    @Override
    public TraceSource getTraceSource() {
        return this.traceSource;
    }

    @Override
    public BufferManagerImpl getLogConduit() {
        return this.logConduit;
    }

    @Override
    public BufferManagerImpl getTraceConduit() {
        return this.traceConduit;
    }

    @Override
    public Handler getMessageLogHandler() {
        if (this.messageLogHandler != null) {
            return this.messageLogHandler;
        }
        return null;
    }

    @Override
    public void setMessageHandler(Handler handler) {
        this.messageLogHandler = (MessageLogHandler)handler;
    }

    public boolean getJsonTrService() {
        return this.isJsonTrService;
    }

    public void setJsonTrService(boolean value) {
        this.isJsonTrService = value;
    }

    @Override
    public Handler getConsoleLogHandler() {
        if (this.consoleLogHandler != null) {
            return this.consoleLogHandler;
        }
        return null;
    }

    @Override
    public void setConsoleHandler(Handler handler) {
        this.consoleLogHandler = (ConsoleLogHandler)handler;
    }
}

