/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.impl;

import com.ibm.websphere.logging.WsLevel;
import com.ibm.ws.logging.collector.Formatter;
import com.ibm.ws.logging.data.GenericData;
import com.ibm.ws.logging.internal.impl.BaseTraceService;
import com.ibm.ws.logging.internal.impl.JsonLogHandler;
import com.ibm.wsspi.collector.manager.SynchronousHandler;
import java.util.List;
import java.util.logging.Level;

public class ConsoleLogHandler
extends JsonLogHandler
implements SynchronousHandler,
Formatter {
    public static final String COMPONENT_NAME = "com.ibm.ws.logging.internal.impl.ConsoleLogHandler";
    private BaseTraceService.SystemLogHolder sysLogHolderOriginal;
    private Level consoleLogLevel;
    private boolean copySystemStreams;

    public ConsoleLogHandler(String serverName, String wlpUserDir, List<String> sourcesList) {
        super(serverName, wlpUserDir, sourcesList);
    }

    @Override
    public String getHandlerName() {
        return COMPONENT_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronousWrite(Object event) {
        BaseTraceService.SystemLogHolder sysLogHolder = this.sysLogHolderOriginal;
        if (sysLogHolder == null) {
            return;
        }
        String evensourcetType = this.getSourceTypeFromDataObject(event);
        int logLevelValue = Integer.MIN_VALUE;
        String loggerName = null;
        String sourceType = null;
        if (event instanceof GenericData) {
            GenericData genData = (GenericData)event;
            loggerName = genData.getLoggerName();
            sourceType = genData.getSourceType();
            Level logRecordLevel = genData.getLogRecordLevel();
            if (logRecordLevel != null) {
                logLevelValue = logRecordLevel.intValue();
            }
        }
        String messageOutput = (String)this.formatEvent(evensourcetType, "memory", event, null, -1);
        ConsoleLogHandler consoleLogHandler = this;
        synchronized (consoleLogHandler) {
            if (sourceType.equals("com.ibm.ws.http.logging.source.accesslog") || sourceType.equals("com.ibm.ws.logging.source.trace") || sourceType.equals("com.ibm.ws.logging.ffdc.source.ffdcsource")) {
                sysLogHolder.getOriginalStream().println(messageOutput);
                return;
            }
            if (this.copySystemStreams && logLevelValue == WsLevel.CONFIG.intValue() && (loggerName.equalsIgnoreCase("SystemOut") || loggerName.equalsIgnoreCase("SystemErr"))) {
                sysLogHolder.getOriginalStream().println(messageOutput);
                return;
            }
            if (logLevelValue >= this.consoleLogLevel.intValue()) {
                sysLogHolder.getOriginalStream().println(messageOutput);
                return;
            }
        }
    }

    @Override
    public void setWriter(Object writer) {
        this.sysLogHolderOriginal = (BaseTraceService.SystemLogHolder)writer;
    }

    public Level getConsoleLogLevel() {
        return this.consoleLogLevel;
    }

    public void setConsoleLogLevel(Level consoleLogLevel) {
        this.consoleLogLevel = consoleLogLevel;
    }

    public boolean getCopySystemStreams() {
        return this.copySystemStreams;
    }

    public void setCopySystemStreams(boolean copySystemStreams) {
        this.copySystemStreams = copySystemStreams;
    }
}

