/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.impl;

import com.ibm.ejs.ras.Untraceable;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.websphere.ras.DataFormatHelper;
import com.ibm.websphere.ras.Traceable;
import com.ibm.websphere.ras.TruncatableThrowable;
import com.ibm.ws.logging.collector.DateFormatHelper;
import com.ibm.ws.logging.internal.WsLogRecord;
import com.ibm.ws.logging.internal.impl.LoggingConstants;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class BaseTraceFormatter
extends Formatter {
    public static final String banner = "********************************************************************************";
    public static final Object NULL_ID = null;
    public static final String NULL_FORMATTED_MSG = null;
    static final int basicNameLength = 13;
    static final int enhancedNameLength = 60;
    static final String pad8 = "        ";
    static final String basicPadding = "                                 ";
    static final String advancedPadding = "          ";
    static final String enhancedPadding = "                                                                                                               ";
    static final String nlBasicPadding = LoggingConstants.nl + "                                 ";
    static final String nlAdvancedPadding = LoggingConstants.nl + "          ";
    static final String nlEnhancedPadding = LoggingConstants.nl + "                                                                                                               ";
    static final String nullParamString = "null";
    static final String badParamString = "<malformed parameter>";
    static final String emptyString = "";
    static final String emptyStringReplacement = "\"\"";
    static final String ENTRY = "Entry ";
    static final String EXIT = "Exit ";
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String NAME_FORMAT = "[%-8s] ";
    private static final String N_INFO = String.format("[%-8s] ", Level.INFO.getLocalizedName());
    private static final String N_AUDIT = String.format("[%-8s] ", WsLevel.AUDIT.getLocalizedName());
    private static final String N_EVENT = String.format("[%-8s] ", WsLevel.EVENT.getLocalizedName());
    private static final String N_WARN = String.format("[%-8s] ", Level.WARNING.getLocalizedName());
    private static final String N_ERROR = String.format("[%-8s] ", WsLevel.ERROR.getLocalizedName());
    private static final String N_FATAL = String.format("[%-8s] ", WsLevel.FATAL.getLocalizedName());
    final LoggingConstants.TraceFormat traceFormat;
    static boolean useIsoDateFormat = false;

    public static final String levelToString(Level level) {
        if (level != null) {
            int l = level.intValue();
            if (l == WsLevel.FATAL.intValue()) {
                return N_FATAL;
            }
            if (l == WsLevel.ERROR.intValue()) {
                return N_ERROR;
            }
            if (l == Level.WARNING.intValue()) {
                return N_WARN;
            }
            if (l == WsLevel.AUDIT.intValue()) {
                return N_AUDIT;
            }
            if (l == Level.INFO.intValue()) {
                return N_INFO;
            }
            if (level == WsLevel.EVENT) {
                return N_EVENT;
            }
        }
        return emptyString;
    }

    public BaseTraceFormatter(LoggingConstants.TraceFormat traceFormat) {
        this.traceFormat = traceFormat;
    }

    public LoggingConstants.TraceFormat getTraceFormat() {
        return this.traceFormat;
    }

    @Override
    public String format(LogRecord r) {
        String text = this.formatMessage(r);
        return this.createFormattedString(r, NULL_ID, text);
    }

    public String traceLogFormat(LogRecord logRecord, Object id, String formattedMsg, String formattedVerboseMsg) {
        String txt = formattedVerboseMsg == null ? this.formatVerboseMessage(logRecord, formattedMsg, false) : formattedVerboseMsg;
        return this.createFormattedString(logRecord, id, txt);
    }

    @Override
    public String formatMessage(LogRecord logRecord) {
        if (System.getSecurityManager() == null) {
            return this.formatMessage(logRecord, logRecord.getParameters(), true);
        }
        final LogRecord f_logRecord = logRecord;
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return BaseTraceFormatter.this.formatMessage(f_logRecord, f_logRecord.getParameters(), true);
            }
        });
    }

    private String formatMessage(LogRecord logRecord, Object[] logParams, boolean useResourceBundle) {
        String txt;
        ResourceBundle rb;
        boolean hasParams = logParams != null && logParams.length > 0;
        String msg = logRecord.getMessage();
        if (useResourceBundle && (rb = logRecord.getResourceBundle()) != null) {
            try {
                msg = rb.getString(msg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (msg != null && hasParams && msg.contains("{0")) {
            Object[] formattedParams = new Object[logParams.length];
            for (int i = 0; i < logParams.length; ++i) {
                formattedParams[i] = logParams[i] instanceof TruncatableThrowable ? DataFormatHelper.throwableToString((TruncatableThrowable)logParams[i]) : (logParams[i] instanceof Throwable ? DataFormatHelper.throwableToString(new TruncatableThrowable((Throwable)logParams[i])) : (logParams[i] instanceof Untraceable ? logParams[i].getClass().getName() : (logParams[i] instanceof Traceable ? this.formatTraceable((Traceable)logParams[i]) : logParams[i])));
            }
            txt = MessageFormat.format(msg, formattedParams);
        } else {
            txt = msg + (hasParams ? " " + this.formatObj(logParams) : emptyString);
        }
        return txt;
    }

    public String formatVerboseMessage(LogRecord logRecord, String msg) {
        return this.formatVerboseMessage(logRecord, msg, true);
    }

    public String formatVerboseMessage(LogRecord logRecord, String formattedMsg, boolean useResourceBundle) {
        Object[] logParams = logRecord.getParameters();
        if (logParams != null) {
            for (int i = 0; i < logParams.length; ++i) {
                Object newLogParam;
                Object logParam = logParams[i];
                if (logParam == null || (newLogParam = this.formatVerboseObj(logParam)) == null) continue;
                Object[] newLogParams = new Object[logParams.length];
                System.arraycopy(logParams, 0, newLogParams, 0, i);
                newLogParams[i] = newLogParam;
                ++i;
                while (i < logParams.length) {
                    logParam = logParams[i];
                    if (logParam != null) {
                        newLogParam = this.formatVerboseObj(logParam);
                        newLogParams[i] = newLogParam != null ? newLogParam : logParam;
                    }
                    ++i;
                }
                return this.formatMessage(logRecord, newLogParams, useResourceBundle);
            }
        }
        if (formattedMsg == null) {
            formattedMsg = this.formatMessage(logRecord, logParams, useResourceBundle);
        }
        return formattedMsg;
    }

    private Object formatVerboseObj(Object obj) {
        if (obj instanceof TruncatableThrowable) {
            TruncatableThrowable truncatable = (TruncatableThrowable)obj;
            Throwable wrappedException = truncatable.getWrappedException();
            return DataFormatHelper.throwableToString(wrappedException);
        }
        if (obj instanceof Throwable) {
            return DataFormatHelper.throwableToString((Throwable)obj);
        }
        return null;
    }

    public String consoleLogFormat(LogRecord logRecord, String txt) {
        StringBuilder sb = new StringBuilder(256);
        sb.append(BaseTraceFormatter.levelToString(logRecord.getLevel()));
        sb.append(txt);
        Throwable t = logRecord.getThrown();
        if (t != null) {
            String s = t.getLocalizedMessage();
            if (s == null) {
                s = t.toString();
            }
            sb.append(LoggingConstants.nl).append(s);
        }
        return sb.toString();
    }

    public String messageLogFormat(LogRecord logRecord, String formattedVerboseMsg) {
        String stackTrace;
        StringBuilder sb = new StringBuilder(256);
        String sym = this.getMarker(logRecord);
        String name = BaseTraceFormatter.nonNullString(logRecord.getLoggerName(), logRecord.getSourceClassName());
        sb.append('[').append(DateFormatHelper.formatTime(logRecord.getMillis(), useIsoDateFormat)).append("] ");
        sb.append(DataFormatHelper.getThreadId()).append(' ');
        this.formatFixedString(sb, name, 60);
        sb.append(sym);
        sb.append(formattedVerboseMsg);
        if (logRecord.getThrown() != null && (stackTrace = this.getStackTrace(logRecord)) != null) {
            sb.append(LoggingConstants.nl).append(stackTrace);
        }
        return sb.toString();
    }

    private String createFormattedString(LogRecord logRecord, Object id, String txt) {
        WsLogRecord wsLogRecord = this.getWsLogRecord(logRecord);
        String method = logRecord.getSourceMethodName();
        String className = logRecord.getSourceClassName();
        String stackTrace = this.getStackTrace(logRecord);
        String sym = this.getMarker(logRecord);
        StringBuilder sb = new StringBuilder(256);
        sb.append('[').append(DateFormatHelper.formatTime(logRecord.getMillis(), useIsoDateFormat)).append("] ");
        sb.append(DataFormatHelper.getThreadId());
        switch (this.traceFormat) {
            default: {
                String objId = this.generateObjectId(id, true);
                String name = BaseTraceFormatter.nonNullString(logRecord.getSourceClassName(), logRecord.getLoggerName());
                sb.append(" id=").append(objId).append(' ');
                this.formatFixedString(sb, name, 60);
                sb.append(sym);
                if (method != null) {
                    sb.append(method).append(' ');
                }
                sb.append(txt);
                if (stackTrace == null) break;
                sb.append(LoggingConstants.nl).append(stackTrace);
                break;
            }
            case BASIC: {
                String name = BaseTraceFormatter.nonNullString(logRecord.getLoggerName(), logRecord.getSourceClassName());
                sb.append(' ');
                this.fixedClassString(sb, name, 13);
                sb.append(sym);
                if (className != null) {
                    sb.append(className);
                }
                sb.append(' ');
                if (method != null) {
                    sb.append(method);
                }
                sb.append(' ');
                sb.append(txt);
                if (stackTrace == null) break;
                sb.append(nlBasicPadding).append(stackTrace);
                break;
            }
            case ADVANCED: {
                String x;
                String objId = this.generateObjectId(id, false);
                String name = BaseTraceFormatter.nonNullString(logRecord.getLoggerName(), null);
                sb.append(' ');
                sb.append(sym);
                sb.append("UOW=");
                if (wsLogRecord != null) {
                    sb.append(wsLogRecord.getCorrelationId());
                }
                sb.append(" source=").append(name);
                if (className != null) {
                    sb.append(" class=").append(className);
                }
                if (method != null) {
                    sb.append(" method=").append(method);
                }
                if (id != null) {
                    sb.append(" id=").append(objId);
                }
                if (wsLogRecord != null) {
                    sb.append(" org=");
                    sb.append(wsLogRecord.getOrganization());
                    sb.append(" prod=");
                    sb.append(wsLogRecord.getProduct());
                    sb.append(" component=");
                    sb.append(wsLogRecord.getComponent());
                    x = wsLogRecord.getReporterOrSourceThreadName();
                } else {
                    x = Thread.currentThread().getName();
                }
                if (x != null) {
                    sb.append(" thread=[").append(x).append("]");
                }
                sb.append(nlAdvancedPadding).append(txt);
                if (stackTrace == null) break;
                sb.append(nlAdvancedPadding).append(stackTrace);
            }
        }
        return sb.toString();
    }

    private String getStackTrace(LogRecord logRecord) {
        Throwable t = logRecord.getThrown();
        if (t != null) {
            return DataFormatHelper.throwableToString(t);
        }
        return null;
    }

    private final String generateObjectId(Object id, boolean fixedWidth) {
        String objId;
        if (id != null) {
            objId = Integer.toHexString(System.identityHashCode(id));
            if (objId.length() < 8) {
                StringBuilder builder = new StringBuilder();
                builder.append("00000000");
                builder.append(objId);
                objId = builder.substring(builder.length() - 8);
            }
        } else {
            objId = fixedWidth ? pad8 : emptyString;
        }
        return objId;
    }

    private void formatFixedString(StringBuilder output, String s, int len) {
        if (s == null) {
            s = nullParamString;
        }
        if (s.length() > len) {
            output.append(s.substring(s.length() - len, s.length()));
        } else {
            output.append(s);
            if (len > s.length()) {
                output.append(enhancedPadding.substring(0, len - s.length()));
            }
        }
    }

    private void fixedClassString(StringBuilder output, String s, int len) {
        int i;
        if (s == null) {
            s = nullParamString;
        }
        if ((i = s.lastIndexOf(46)) >= 0) {
            s = s.substring(i + 1);
        }
        if (s.length() > len) {
            output.append(s.substring(0, len));
        } else {
            output.append(s);
            if (len > s.length()) {
                output.append(enhancedPadding.substring(0, len - s.length()));
            }
        }
    }

    private String formatTraceable(Traceable t) {
        String formatted;
        try {
            formatted = t.toTraceString();
        }
        catch (Exception e) {
            formatted = "<Exception " + e + " caught while calling toTraceString() on object " + t.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(t)) + ">";
        }
        return formatted;
    }

    public String formatObj(Object objs) {
        String ans;
        block22: {
            String nlPad;
            block18: {
                block19: {
                    StringBuilder sb;
                    block21: {
                        int len;
                        block20: {
                            ans = emptyString;
                            nlPad = LoggingConstants.TraceFormat.ADVANCED.equals((Object)this.traceFormat) ? nlAdvancedPadding : (LoggingConstants.TraceFormat.BASIC.equals((Object)this.traceFormat) ? nlBasicPadding : nlEnhancedPadding);
                            String nlPadA = nlPad + " ";
                            if (objs == null) break block18;
                            if (!objs.getClass().isArray()) break block19;
                            sb = new StringBuilder();
                            len = Array.getLength(objs);
                            if (!objs.getClass().getName().equals("[B")) break block20;
                            int COLUMNS = 32;
                            byte[] b = (byte[])objs;
                            int printLen = len > 16384 ? 16384 : len;
                            sb.append(nlPad).append(objs.toString()).append(",len=").append(len);
                            for (int i = 0; i < printLen; ++i) {
                                if (i % 32 == 0) {
                                    sb.append(nlPadA + '|' + DataFormatHelper.padHexString(i, 4) + '|');
                                }
                                if (i % 4 == 0) {
                                    sb.append(" ");
                                }
                                sb.append(hexChars[b[i] >> 4 & 0xF]);
                                sb.append(hexChars[b[i] & 0xF]);
                            }
                            if (printLen == len) break block21;
                            sb.append(nlPadA).append(" ...");
                            break block21;
                        }
                        if (objs.getClass().getName().equals("[C")) {
                            sb.append((char[])objs);
                        } else {
                            for (int i = 0; i < len; ++i) {
                                String s = this.formatObj(Array.get(objs, i));
                                if (s.startsWith(LoggingConstants.nl)) {
                                    sb.append(s);
                                } else {
                                    sb.append(nlPad + s);
                                }
                                if (sb.length() <= 16384) continue;
                                sb.append(nlPad + "...");
                                break;
                            }
                        }
                    }
                    ans = sb.toString();
                    break block22;
                }
                if (objs instanceof Untraceable) {
                    ans = nlPad + objs.getClass().getName();
                } else if (objs instanceof Traceable) {
                    ans = nlPad + this.formatTraceable((Traceable)objs);
                } else if (objs instanceof TruncatableThrowable) {
                    ans = nlPad + DataFormatHelper.throwableToString((TruncatableThrowable)objs);
                } else if (objs instanceof Throwable) {
                    ans = nlPad + DataFormatHelper.throwableToString(new TruncatableThrowable((Throwable)objs));
                } else {
                    try {
                        ans = nlPad + objs.toString();
                    }
                    catch (Exception e) {
                        ans = "<Exception " + e + " caught while calling toString() on object " + objs.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(objs)) + ">";
                    }
                }
                break block22;
            }
            ans = nlPad + nullParamString;
        }
        return ans;
    }

    private static String nonNullString(String parameter, String alternate) {
        if (parameter != null) {
            return parameter;
        }
        if (alternate != null) {
            return alternate;
        }
        return emptyString;
    }

    private String getMarker(LogRecord logRecord) {
        String message;
        Level level = logRecord.getLevel();
        if (level == null) {
            return " Z ";
        }
        if (level.getName() == "SystemErr") {
            return " R ";
        }
        if (level.getName() == "SystemOut") {
            return " O ";
        }
        LevelFormat f = LevelFormat.findFormat(level);
        if (f == null) {
            return " Z ";
        }
        if (f.level == Level.FINER && (message = logRecord.getMessage()) != null) {
            if (message.equals(ENTRY) || message.startsWith("ENTRY")) {
                return " > ";
            }
            if (message.equals(EXIT) || message.startsWith("RETURN")) {
                return " < ";
            }
        }
        return f.marker;
    }

    private WsLogRecord getWsLogRecord(LogRecord logRecord) {
        try {
            return (WsLogRecord)logRecord;
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    static enum LevelFormat {
        FATAL(WsLevel.FATAL, " F "),
        ERROR(WsLevel.ERROR, " E "),
        WARNING(Level.WARNING, " W "),
        AUDIT(WsLevel.AUDIT, " A "),
        INFO(Level.INFO, " I "),
        CONFIG(Level.CONFIG, " C "),
        DETAIL(WsLevel.DETAIL, " D "),
        EVENT(WsLevel.FINE, " 1 "),
        FINE(Level.FINE, " 1 "),
        FINER(Level.FINER, " 2 "),
        FINEST(Level.FINEST, " 3 ");

        final Level level;
        final int id;
        final String marker;

        private LevelFormat(Level l, String s) {
            this.level = l;
            this.id = l.intValue();
            this.marker = s;
        }

        public static LevelFormat findFormat(Level level) {
            int levelId = level.intValue();
            for (LevelFormat f : LevelFormat.values()) {
                if (level == f.level) {
                    return f;
                }
                if (levelId != f.id) continue;
                return f;
            }
            return null;
        }
    }
}

