/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.collector;

import com.ibm.websphere.ras.DataFormatHelper;
import com.ibm.ws.health.center.data.HCGCData;
import com.ibm.ws.logging.collector.CollectorJsonHelpers;
import com.ibm.ws.logging.data.GenericData;
import com.ibm.ws.logging.data.KeyValuePair;
import com.ibm.ws.logging.data.Pair;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;

public class CollectorJsonUtils1_1 {
    public static final int MAX_USER_AGENT_LENGTH = 2048;

    public static String getEventType(String source, String location) {
        return CollectorJsonHelpers.getEventType(source, location);
    }

    public static String jsonifyEvent(Object event, String eventType, String serverName, String wlpUserDir, String serverHostName, String[] tags, int maxFieldLength) {
        if (eventType.equals("liberty_gc")) {
            if (event instanceof GenericData) {
                return CollectorJsonUtils1_1.jsonifyGCEvent(-1, wlpUserDir, serverName, serverHostName, "liberty_gc", event, tags);
            }
            return CollectorJsonUtils1_1.jsonifyGCEvent(serverHostName, wlpUserDir, serverName, (HCGCData)event, tags);
        }
        if (eventType.equals("liberty_message")) {
            return CollectorJsonUtils1_1.jsonifyTraceAndMessage(maxFieldLength, wlpUserDir, serverName, serverHostName, "liberty_message", event, tags);
        }
        if (eventType.equals("liberty_trace")) {
            return CollectorJsonUtils1_1.jsonifyTraceAndMessage(maxFieldLength, wlpUserDir, serverName, serverHostName, "liberty_trace", event, tags);
        }
        if (eventType.equals("liberty_ffdc")) {
            return CollectorJsonUtils1_1.jsonifyFFDC(maxFieldLength, wlpUserDir, serverName, serverHostName, "liberty_ffdc", event, tags);
        }
        if (eventType.equals("liberty_accesslog")) {
            return CollectorJsonUtils1_1.jsonifyAccess(-1, wlpUserDir, serverName, serverHostName, "liberty_accesslog", event, tags);
        }
        return "";
    }

    private static String jsonifyGCEvent(String hostName, String wlpUserDir, String serverName, HCGCData hcGCData, String[] tags) {
        String sequenceNum = hcGCData.getSequence();
        StringBuilder sb = new StringBuilder();
        boolean isFirstField = true;
        sb.append("{");
        isFirstField = CollectorJsonHelpers.addCommonFieldsGC1_1(sb, hostName, wlpUserDir, serverName, hcGCData.getTime(), sequenceNum, isFirstField, "liberty_gc");
        isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "ibm_reason", hcGCData.getReason(), false, false, false, isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "ibm_gcType", hcGCData.getType(), false, false, false, isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "ibm_duration", String.valueOf((long)hcGCData.getDuration() * 1000L), false, false, false, isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "ibm_maxHeap", String.valueOf(hcGCData.getMaxHeap()), false, false, false, isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "ibm_usedHeap", String.valueOf((long)hcGCData.getUsage()), false, false, false, isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "ibm_heap", String.valueOf((long)hcGCData.getHeap()), false, false, false, isFirstField))))));
        if (tags != null) {
            CollectorJsonUtils1_1.addTagNameForVersion(sb).append(CollectorJsonHelpers.jsonifyTags(tags));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String jsonifyGCEvent(int maxFieldLength, String wlpUserDir, String serverName, String hostName, String eventType, Object event, String[] tags) {
        GenericData genData = (GenericData)event;
        StringBuilder sb = new StringBuilder();
        boolean isFirstField = true;
        ArrayList<Pair> pairs = genData.getPairs();
        KeyValuePair kvp = null;
        String key = null;
        String value = null;
        sb.append("{");
        isFirstField = CollectorJsonHelpers.addCommonFields1_1(sb, hostName, wlpUserDir, serverName, isFirstField, eventType);
        for (Pair p : pairs) {
            if (p instanceof KeyValuePair) {
                String datetime;
                long duration;
                kvp = (KeyValuePair)p;
                key = kvp.getKey();
                value = kvp.getValue();
                isFirstField = key.equals("ibm_duration") ? (isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, Long.toString(duration = Long.parseLong(value) * 1000L), false, true, false, isFirstField, kvp.isNumber())) : (key.equals("ibm_datetime") ? (isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, datetime = CollectorJsonHelpers.dateFormatTL.get().format(Long.parseLong(value)), false, true, false, isFirstField, false)) : (isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, value, false, true, false, isFirstField, kvp.isNumber())));
            }
            if (tags == null) continue;
            CollectorJsonUtils1_1.addTagNameForVersion(sb).append(CollectorJsonHelpers.jsonifyTags(tags));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String jsonifyFFDC(int maxFieldLength, String wlpUserDir, String serverName, String hostName, String eventType, Object event, String[] tags) {
        GenericData genData = (GenericData)event;
        StringBuilder sb = new StringBuilder();
        boolean isFirstField = true;
        ArrayList<Pair> pairs = genData.getPairs();
        KeyValuePair kvp = null;
        String key = null;
        String value = null;
        sb.append("{");
        isFirstField = CollectorJsonHelpers.addCommonFields1_1(sb, hostName, wlpUserDir, serverName, isFirstField, eventType);
        for (Pair p : pairs) {
            if (!(p instanceof KeyValuePair)) continue;
            kvp = (KeyValuePair)p;
            key = kvp.getKey();
            value = kvp.getValue();
            if (key.equals("label") || key.equals("sourceID") || key.equals("dateOfFirstOccurence") || key.equals("count")) continue;
            if (key.equals("ibm_stackTrace")) {
                String formattedValue = CollectorJsonHelpers.formatMessage(value, maxFieldLength);
                isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, formattedValue, false, true, false, isFirstField, kvp.isNumber());
                continue;
            }
            if (key.equals("ibm_threadId")) {
                isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, DataFormatHelper.padHexString(Integer.parseInt(value), 8), false, true, false, isFirstField, false);
                continue;
            }
            if (key.equals("ibm_datetime")) {
                String datetime = CollectorJsonHelpers.dateFormatTL.get().format(Long.parseLong(value));
                isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, datetime, false, true, false, isFirstField, false);
                continue;
            }
            isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, value, false, true, false, isFirstField, kvp.isNumber());
        }
        if (tags != null) {
            CollectorJsonUtils1_1.addTagNameForVersion(sb).append(CollectorJsonHelpers.jsonifyTags(tags));
        }
        sb.append("}");
        return sb.toString();
    }

    public static String jsonifyAccess(int maxFieldLength, String wlpUserDir, String serverName, String hostName, String eventType, Object event, String[] tags) {
        GenericData genData = (GenericData)event;
        StringBuilder sb = new StringBuilder();
        boolean isFirstField = true;
        ArrayList<Pair> pairs = genData.getPairs();
        KeyValuePair kvp = null;
        String key = null;
        String value = null;
        sb.append("{");
        isFirstField = CollectorJsonHelpers.addCommonFields1_1(sb, hostName, wlpUserDir, serverName, isFirstField, eventType);
        for (Pair p : pairs) {
            if (!(p instanceof KeyValuePair)) continue;
            kvp = (KeyValuePair)p;
            key = kvp.getKey();
            value = kvp.getValue();
            if (key.equals("ibm_requestStartTime")) continue;
            if (key.equals("ibm_queryString")) {
                String jsonQueryString = value;
                if (jsonQueryString != null) {
                    try {
                        jsonQueryString = URLDecoder.decode(jsonQueryString, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, jsonQueryString, false, true, false, isFirstField, kvp.isNumber());
                continue;
            }
            if (key.equals("ibm_userAgent")) {
                String userAgent = value;
                if (userAgent != null && userAgent.length() > 2048) {
                    userAgent = userAgent.substring(0, 2048);
                }
                isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, userAgent, false, false, false, isFirstField, kvp.isNumber());
                continue;
            }
            if (key.equals("ibm_datetime")) {
                String datetime = CollectorJsonHelpers.dateFormatTL.get().format(Long.parseLong(value));
                isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, datetime, false, true, false, isFirstField, false);
                continue;
            }
            isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, value, false, true, false, isFirstField, kvp.isNumber());
        }
        if (tags != null) {
            CollectorJsonUtils1_1.addTagNameForVersion(sb).append(CollectorJsonHelpers.jsonifyTags(tags));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String jsonifyTraceAndMessage(int maxFieldLength, String wlpUserDir, String serverName, String hostName, String eventType, Object event, String[] tags) {
        GenericData genData = (GenericData)event;
        StringBuilder sb = new StringBuilder();
        boolean isFirstField = true;
        ArrayList<Pair> pairs = genData.getPairs();
        KeyValuePair kvp = null;
        String key = null;
        String value = null;
        sb.append("{");
        isFirstField = CollectorJsonHelpers.addCommonFields1_1(sb, hostName, wlpUserDir, serverName, isFirstField, eventType);
        for (Pair p : pairs) {
            if (!(p instanceof KeyValuePair)) continue;
            kvp = (KeyValuePair)p;
            key = kvp.getKey();
            value = kvp.getValue();
            if (key.equals("severity")) continue;
            if (key.equals("message")) {
                String formattedValue = CollectorJsonHelpers.formatMessage(value, maxFieldLength);
                isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, formattedValue, false, true, false, isFirstField, kvp.isNumber());
                continue;
            }
            if (key.equals("ibm_threadId")) {
                isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, DataFormatHelper.padHexString(Integer.parseInt(value), 8), false, true, false, isFirstField, false);
                continue;
            }
            if (key.equals("ibm_datetime")) {
                String datetime = CollectorJsonHelpers.dateFormatTL.get().format(Long.parseLong(value));
                isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, datetime, false, true, false, isFirstField, false);
                continue;
            }
            isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, value, false, true, false, isFirstField, kvp.isNumber());
        }
        if (tags != null) {
            CollectorJsonUtils1_1.addTagNameForVersion(sb).append(CollectorJsonHelpers.jsonifyTags(tags));
        }
        sb.append("}");
        return sb.toString();
    }

    private static StringBuilder addTagNameForVersion(StringBuilder sb) {
        sb.append(",\"ibm_tags\":");
        return sb;
    }
}

