/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.collector;

import com.ibm.websphere.ras.DataFormatHelper;
import com.ibm.ws.health.center.data.HCGCData;
import com.ibm.ws.logging.collector.CollectorJsonHelpers;
import com.ibm.ws.logging.collector.CollectorJsonUtils1_1;
import com.ibm.ws.logging.data.GenericData;
import com.ibm.ws.logging.data.KeyValuePair;
import com.ibm.ws.logging.data.Pair;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;

public class CollectorJsonUtils {
    public static final int MAX_USER_AGENT_LENGTH = 2048;

    public static String getEventType(String source, String location) {
        return CollectorJsonHelpers.getEventType(source, location);
    }

    public static String jsonifyEvent(Object event, String eventType, String serverName, String wlpUserDir, String serverHostName, String collectorVersion, String[] tags, int maxFieldLength) {
        if (!collectorVersion.startsWith("1.0")) {
            return CollectorJsonUtils1_1.jsonifyEvent(event, eventType, serverName, wlpUserDir, serverHostName, tags, maxFieldLength);
        }
        if (eventType.equals("liberty_gc")) {
            if (event instanceof GenericData) {
                return CollectorJsonUtils.jsonifyGCEvent(-1, wlpUserDir, serverName, serverHostName, "liberty_gc", event, tags);
            }
            return CollectorJsonUtils.jsonifyGCEvent(serverHostName, wlpUserDir, serverName, (HCGCData)event, tags);
        }
        if (eventType.equals("liberty_message")) {
            return CollectorJsonUtils.jsonifyTraceAndMessage(maxFieldLength, wlpUserDir, serverName, serverHostName, "liberty_message", event, tags);
        }
        if (eventType.equals("liberty_trace")) {
            return CollectorJsonUtils.jsonifyTraceAndMessage(maxFieldLength, wlpUserDir, serverName, serverHostName, "liberty_trace", event, tags);
        }
        if (eventType.equals("liberty_ffdc")) {
            return CollectorJsonUtils.jsonifyFFDC(maxFieldLength, wlpUserDir, serverName, serverHostName, "liberty_ffdc", event, tags);
        }
        if (eventType.equals("liberty_accesslog")) {
            return CollectorJsonUtils.jsonifyAccess(-1, wlpUserDir, serverName, serverHostName, "liberty_accesslog", event, tags);
        }
        return "";
    }

    private static String jsonifyGCEvent(String hostName, String wlpUserDir, String serverName, HCGCData hcGCData, String[] tags) {
        String sequenceNum = hcGCData.getSequence();
        StringBuilder sb = new StringBuilder();
        boolean isFirstField = true;
        sb.append("{");
        isFirstField = CollectorJsonHelpers.addCommonFieldsGC(sb, hostName, wlpUserDir, serverName, hcGCData.getTime(), sequenceNum, isFirstField, "liberty_gc");
        isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "reason", hcGCData.getReason(), false, false, false, isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "gcType", hcGCData.getType(), false, false, false, isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "duration", String.valueOf((long)hcGCData.getDuration() * 1000L), false, false, false, isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "maxHeap", String.valueOf(hcGCData.getMaxHeap()), false, false, false, isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "usedHeap", String.valueOf((long)hcGCData.getUsage()), false, false, false, isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "heap", String.valueOf((long)hcGCData.getHeap()), false, false, false, isFirstField))))));
        if (tags != null) {
            CollectorJsonUtils.addTagNameForVersion(sb).append(CollectorJsonHelpers.jsonifyTags(tags));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String jsonifyGCEvent(int maxFieldLength, String wlpUserDir, String serverName, String hostName, String eventType, Object event, String[] tags) {
        GenericData genData = (GenericData)event;
        StringBuilder sb = new StringBuilder();
        boolean isFirstField = true;
        ArrayList<Pair> pairs = genData.getPairs();
        KeyValuePair kvp = null;
        String key = null;
        String value = null;
        sb.append("{");
        isFirstField = CollectorJsonHelpers.addCommonFields(sb, hostName, wlpUserDir, serverName, isFirstField, eventType);
        for (Pair p : pairs) {
            if (p instanceof KeyValuePair) {
                kvp = (KeyValuePair)p;
                key = kvp.getKey();
                value = kvp.getValue();
                if (key.equals("ibm_duration")) {
                    key = "duration";
                    long duration = Long.parseLong(value) * 1000L;
                    isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, Long.toString(duration), false, true, false, isFirstField, kvp.isNumber());
                } else if (key.equals("ibm_datetime")) {
                    key = "datetime";
                    String datetime = CollectorJsonHelpers.dateFormatTL.get().format(Long.parseLong(value));
                    isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, datetime, false, true, false, isFirstField, false);
                } else {
                    if (key.contains("ibm_")) {
                        key = CollectorJsonHelpers.removeIBMTag(key);
                    }
                    isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, value, false, true, false, isFirstField, kvp.isNumber());
                }
            }
            if (tags == null) continue;
            CollectorJsonUtils.addTagNameForVersion(sb).append(CollectorJsonHelpers.jsonifyTags(tags));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String jsonifyTraceAndMessage(int maxFieldLength, String wlpUserDir, String serverName, String hostName, String eventType, Object event, String[] tags) {
        GenericData genData = (GenericData)event;
        StringBuilder sb = new StringBuilder();
        boolean isFirstField = true;
        ArrayList<Pair> pairs = genData.getPairs();
        KeyValuePair kvp = null;
        String key = null;
        String value = null;
        sb.append("{");
        isFirstField = CollectorJsonHelpers.addCommonFields(sb, hostName, wlpUserDir, serverName, isFirstField, eventType);
        for (Pair p : pairs) {
            if (!(p instanceof KeyValuePair)) continue;
            kvp = (KeyValuePair)p;
            key = kvp.getKey();
            value = kvp.getValue();
            if (key.equals("loglevel")) continue;
            if (key.equals("message")) {
                String formattedValue = CollectorJsonHelpers.formatMessage(value, maxFieldLength);
                isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, formattedValue, false, true, false, isFirstField, kvp.isNumber());
                continue;
            }
            if (key.equals("ibm_threadId")) {
                key = "threadId";
                isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, DataFormatHelper.padHexString(Integer.parseInt(value), 8), false, true, false, isFirstField, false);
                continue;
            }
            if (key.equals("ibm_datetime")) {
                key = "datetime";
                String datetime = CollectorJsonHelpers.dateFormatTL.get().format(Long.parseLong(value));
                isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, datetime, false, true, false, isFirstField, false);
                continue;
            }
            if (key.equals("module")) {
                key = "loggerName";
                isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, value, false, true, false, isFirstField, kvp.isNumber());
                continue;
            }
            if (key.contains("ibm_")) {
                key = CollectorJsonHelpers.removeIBMTag(key);
            }
            isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, value, false, true, false, isFirstField, kvp.isNumber());
        }
        if (tags != null) {
            CollectorJsonUtils.addTagNameForVersion(sb).append(CollectorJsonHelpers.jsonifyTags(tags));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String jsonifyFFDC(int maxFieldLength, String wlpUserDir, String serverName, String hostName, String eventType, Object event, String[] tags) {
        GenericData genData = (GenericData)event;
        StringBuilder sb = new StringBuilder();
        boolean isFirstField = true;
        ArrayList<Pair> pairs = genData.getPairs();
        KeyValuePair kvp = null;
        String key = null;
        String value = null;
        sb.append("{");
        isFirstField = CollectorJsonHelpers.addCommonFields(sb, hostName, wlpUserDir, serverName, isFirstField, eventType);
        for (Pair p : pairs) {
            if (!(p instanceof KeyValuePair)) continue;
            kvp = (KeyValuePair)p;
            key = kvp.getKey();
            value = kvp.getValue();
            if (key.equals("label") || key.equals("sourceID") || key.equals("dateOfFirstOccurence") || key.equals("count")) continue;
            if (key.equals("ibm_stackTrace")) {
                key = "stackTrace";
                String formattedValue = CollectorJsonHelpers.formatMessage(value, maxFieldLength);
                isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, formattedValue, false, true, false, isFirstField, kvp.isNumber());
                continue;
            }
            if (key.equals("ibm_threadId")) {
                key = "threadId";
                isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, DataFormatHelper.padHexString(Integer.parseInt(value), 8), false, true, false, isFirstField, false);
                continue;
            }
            if (key.equals("ibm_datetime")) {
                key = "datetime";
                String datetime = CollectorJsonHelpers.dateFormatTL.get().format(Long.parseLong(value));
                isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, datetime, false, true, false, isFirstField, false);
                continue;
            }
            if (key.contains("ibm_")) {
                key = CollectorJsonHelpers.removeIBMTag(key);
            }
            isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, value, false, true, false, isFirstField, kvp.isNumber());
        }
        if (tags != null) {
            CollectorJsonUtils.addTagNameForVersion(sb).append(CollectorJsonHelpers.jsonifyTags(tags));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String jsonifyAccess(int maxFieldLength, String wlpUserDir, String serverName, String hostName, String eventType, Object event, String[] tags) {
        GenericData genData = (GenericData)event;
        StringBuilder sb = new StringBuilder();
        boolean isFirstField = true;
        ArrayList<Pair> pairs = genData.getPairs();
        KeyValuePair kvp = null;
        String key = null;
        String value = null;
        sb.append("{");
        isFirstField = CollectorJsonHelpers.addCommonFields(sb, hostName, wlpUserDir, serverName, isFirstField, eventType);
        for (Pair p : pairs) {
            if (!(p instanceof KeyValuePair)) continue;
            kvp = (KeyValuePair)p;
            key = kvp.getKey();
            value = kvp.getValue();
            if (key.equals("ibm_requestStartTime")) continue;
            if (key.equals("ibm_queryString")) {
                key = "queryString";
                String jsonQueryString = value;
                if (jsonQueryString != null) {
                    try {
                        jsonQueryString = URLDecoder.decode(jsonQueryString, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, jsonQueryString, false, true, false, isFirstField, kvp.isNumber());
                continue;
            }
            if (key.equals("ibm_userAgent")) {
                key = "userAgent";
                String userAgent = value;
                if (userAgent != null && userAgent.length() > 2048) {
                    userAgent = userAgent.substring(0, 2048);
                }
                isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, userAgent, false, false, false, isFirstField, kvp.isNumber());
                continue;
            }
            if (key.equals("ibm_datetime")) {
                key = "datetime";
                String datetime = CollectorJsonHelpers.dateFormatTL.get().format(Long.parseLong(value));
                isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key, datetime, false, true, false, isFirstField, false);
                continue;
            }
            isFirstField &= !CollectorJsonHelpers.addToJSON(sb, key = CollectorJsonHelpers.removeIBMTag(key), value, false, true, false, isFirstField, kvp.isNumber());
        }
        if (tags != null) {
            CollectorJsonUtils.addTagNameForVersion(sb).append(CollectorJsonHelpers.jsonifyTags(tags));
        }
        sb.append("}");
        return sb.toString();
    }

    private static StringBuilder addTagNameForVersion(StringBuilder sb) {
        sb.append(",\"tags\":");
        return sb;
    }
}

