/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.collector;

import com.ibm.ws.logging.collector.BurstDateFormat;
import java.text.SimpleDateFormat;

public class CollectorJsonHelpers {
    protected static ThreadLocal<BurstDateFormat> dateFormatTL = new ThreadLocal<BurstDateFormat>(){

        @Override
        protected BurstDateFormat initialValue() {
            return new BurstDateFormat(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
        }
    };

    protected static String getEventType(String source, String location) {
        if (source.equals("com.ibm.ws.health.center.source.gcsource") && location.equals("memory")) {
            return "liberty_gc";
        }
        if (source.equals("com.ibm.ws.logging.source.message") && location.equals("memory")) {
            return "liberty_message";
        }
        if (source.endsWith("com.ibm.ws.logging.source.trace") && location.equals("memory")) {
            return "liberty_trace";
        }
        if (source.endsWith("com.ibm.ws.logging.ffdc.source.ffdcsource") && location.equals("memory")) {
            return "liberty_ffdc";
        }
        if (source.endsWith("com.ibm.ws.http.logging.source.accesslog") && location.equals("memory")) {
            return "liberty_accesslog";
        }
        return "";
    }

    protected static boolean addToJSON(StringBuilder sb, String name, String value, boolean jsonEscapeName, boolean jsonEscapeValue, boolean trim, boolean isFirstField) {
        boolean b = CollectorJsonHelpers.addToJSON(sb, name, value, jsonEscapeName, jsonEscapeValue, trim, isFirstField, false);
        return b;
    }

    protected static boolean addToJSON(StringBuilder sb, String name, String value, boolean jsonEscapeName, boolean jsonEscapeValue, boolean trim, boolean isFirstField, boolean isNumber) {
        if (name == null || value == null) {
            return false;
        }
        if (!isFirstField) {
            sb.append(",");
        }
        if (trim) {
            value = value.trim();
        }
        sb.append("\"");
        if (jsonEscapeName) {
            CollectorJsonHelpers.jsonEscape3(sb, name);
        } else {
            sb.append(name);
        }
        if (isNumber) {
            sb.append("\":");
            if (jsonEscapeValue) {
                CollectorJsonHelpers.jsonEscape3(sb, value);
            } else {
                sb.append(value);
            }
        } else {
            sb.append("\":\"");
            if (jsonEscapeValue) {
                CollectorJsonHelpers.jsonEscape3(sb, value);
            } else {
                sb.append(value);
            }
            sb.append("\"");
        }
        return true;
    }

    protected static void jsonEscape3(StringBuilder sb, String s) {
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\"': 
                case '/': 
                case '\\': {
                    sb.append("\\");
                    sb.append(c);
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
    }

    protected static boolean addCommonFields(StringBuilder sb, String hostName, String wlpUserDir, String serverName, boolean isFirstField, String eventType) {
        return isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "serverName", serverName, false, false, false, isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "wlpUserDir", wlpUserDir, false, true, false, isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "hostName", hostName, false, false, false, isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "type", eventType, false, false, false, isFirstField))));
    }

    protected static boolean addCommonFields1_1(StringBuilder sb, String hostName, String wlpUserDir, String serverName, boolean isFirstField, String eventType) {
        return isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "ibm_serverName", serverName, false, false, false, isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "ibm_userDir", wlpUserDir, false, true, false, isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "host", hostName, false, false, false, isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "type", eventType, false, false, false, isFirstField))));
    }

    protected static boolean addCommonFieldsGC1_1(StringBuilder sb, String hostName, String wlpUserDir, String serverName, long timestamp, String sequenceNum, boolean isFirstField, String eventType) {
        String datetime = dateFormatTL.get().format(timestamp);
        return isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "ibm_sequence", sequenceNum, false, false, false, isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "ibm_serverName", serverName, false, false, false, isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "ibm_userDir", wlpUserDir, false, true, false, isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "host", hostName, false, false, false, isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "type", eventType, false, false, false, isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "ibm_datetime", datetime, false, false, false, isFirstField))))));
    }

    protected static boolean addCommonFieldsGC(StringBuilder sb, String hostName, String wlpUserDir, String serverName, long timestamp, String sequenceNum, boolean isFirstField, String eventType) {
        String datetime = dateFormatTL.get().format(timestamp);
        return isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "sequence", sequenceNum, false, false, false, isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "serverName", serverName, false, false, false, isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "wlpUserDir", wlpUserDir, false, true, false, isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "hostName", hostName, false, false, false, isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "type", eventType, false, false, false, isFirstField &= !CollectorJsonHelpers.addToJSON(sb, "datetime", datetime, false, false, false, isFirstField))))));
    }

    protected static String formatMessage(String message, int maxLength) {
        return message.length() > maxLength && maxLength > 0 ? message.substring(0, maxLength) + "..." : message;
    }

    protected static String removeIBMTag(String s) {
        s = s.replace("ibm_", "");
        return s;
    }

    protected static StringBuilder addTagNameForVersion(StringBuilder sb) {
        sb.append(",\"tags\":");
        return sb;
    }

    protected static String jsonifyTags(String[] tags) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < tags.length; ++i) {
            tags[i] = tags[i].trim();
            if (tags[i].contains(" ") || tags[i].contains("-")) continue;
            sb.append("\"");
            CollectorJsonHelpers.jsonEscape3(sb, tags[i]);
            sb.append("\"");
            if (i == tags.length - 1) continue;
            sb.append(",");
        }
        if (sb.toString().lastIndexOf(",") == sb.toString().length() - 1) {
            sb.delete(sb.toString().lastIndexOf(","), sb.toString().lastIndexOf(",") + 1);
        }
        sb.append("]");
        return sb.toString();
    }
}

