/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.collector;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;

public class BurstDateFormat {
    private final SimpleDateFormat formatter;
    private long refTimestamp = 0L;
    private String refBeginning;
    private String refEnding;
    private long refMilli = 0L;
    private long pdiff = 0L;
    private long ndiff = 0L;
    private final FieldPosition position = new FieldPosition(DateFormat.Field.MILLISECOND);
    private boolean reset = false;

    public BurstDateFormat(SimpleDateFormat formatter) {
        this.formatter = formatter;
    }

    public void applyPattern(String pattern) {
        if (!this.formatter.toPattern().equals(pattern)) {
            this.formatter.applyPattern(pattern);
            this.reset = true;
        }
    }

    public String format(long timestamp) {
        long delta = timestamp - this.refTimestamp;
        if (delta >= this.pdiff || delta < this.ndiff || this.reset) {
            this.reset = false;
            StringBuffer refTime = new StringBuffer();
            this.refTimestamp = timestamp;
            this.formatter.format(timestamp, refTime, this.position);
            this.refMilli = Long.parseLong(refTime.substring(this.position.getBeginIndex(), this.position.getEndIndex()));
            this.refBeginning = refTime.substring(0, this.position.getBeginIndex());
            this.refEnding = refTime.substring(this.position.getEndIndex());
            this.pdiff = 1000L - this.refMilli;
            this.ndiff = -this.refMilli;
            return refTime.toString();
        }
        StringBuffer sb = new StringBuffer();
        long newMilli = delta + this.refMilli;
        if (newMilli >= 100L) {
            sb.append(this.refBeginning).append(newMilli).append(this.refEnding);
        } else if (newMilli >= 10L) {
            sb.append(this.refBeginning).append('0').append(newMilli).append(this.refEnding);
        } else {
            sb.append(this.refBeginning).append("00").append(newMilli).append(this.refEnding);
        }
        return sb.toString();
    }
}

