/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jmx.internal.DelayedMBeanHolder;
import com.ibm.ws.jmx.internal.DelayedMBeanRegistrationState;
import com.ibm.ws.jmx.internal.MBeanUtil;
import com.ibm.ws.kernel.boot.jmx.service.DelayedMBeanHelper;
import com.ibm.ws.kernel.boot.jmx.service.MBeanServerForwarderDelegate;
import com.ibm.ws.kernel.boot.jmx.service.MBeanServerNotificationSupport;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
final class DelayedMBeanActivator
extends MBeanServerForwarderDelegate
implements DelayedMBeanHelper {
    public static final String MBEAN_CLASSES = "com.ibm.ws.jmx.delayed.MBeanClasses";
    private volatile MBeanServerNotificationSupport notificationSupport;
    private final ConcurrentHashMap<ObjectName, DelayedMBeanHolder> delayedMBeanMap = new ConcurrentHashMap();
    private final BundleContext bundleContext;
    static final long serialVersionUID = 9013352522093520959L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    DelayedMBeanActivator(BundleContext ctx) {
        this.bundleContext = ctx;
    }

    public int getPriority() {
        return 0;
    }

    public boolean isDelayedMBean(ObjectName name) {
        return this.delayedMBeanMap.containsKey(name);
    }

    public void setMBeanServerNotificationSupport(MBeanServerNotificationSupport support) {
        this.notificationSupport = support;
    }

    boolean registerDelayedMBean(ServiceReference<?> ref, ObjectName objectName) {
        if (this.delayedMBeanMap.putIfAbsent(objectName, new DelayedMBeanHolder(ref)) == null) {
            MBeanServerNotificationSupport _notificationSupport = this.notificationSupport;
            if (_notificationSupport != null) {
                _notificationSupport.sendRegisterNotification(objectName);
            }
            return true;
        }
        return false;
    }

    private void registerDelayedMBeans() {
        for (ObjectName name : this.delayedMBeanMap.keySet()) {
            try {
                this.registerMBeanIfDelayed(name);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"104", (Object)((Object)this), (Object[])new Object[0]);
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                FFDCFilter.processException((Throwable)notCompliantMBeanException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"106", (Object)((Object)this), (Object[])new Object[0]);
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                FFDCFilter.processException((Throwable)instanceAlreadyExistsException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"108", (Object)((Object)this), (Object[])new Object[0]);
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
                FFDCFilter.processException((Throwable)mBeanRegistrationException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"110", (Object)((Object)this), (Object[])new Object[0]);
            }
        }
    }

    private void registerMBeanIfDelayed(ObjectName name) throws InstanceNotFoundException, NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanRegistrationException {
        DelayedMBeanHolder mBeanHolder;
        if (name != null && (mBeanHolder = this.delayedMBeanMap.get(name)) != null) {
            this.registerMBeanIfDelayed(mBeanHolder, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerMBeanIfDelayed(DelayedMBeanHolder mBeanHolder, ObjectName name) throws InstanceNotFoundException, NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanRegistrationException {
        Object mBean = this.bundleContext.getService(mBeanHolder.getRef());
        if (mBean == null) throw new InstanceNotFoundException();
        DelayedMBeanRegistrationState state = mBeanHolder.registrationState.get();
        if (state == DelayedMBeanRegistrationState.DELAYED && mBeanHolder.registrationState.compareAndSet(state, DelayedMBeanRegistrationState.PROCESSING)) {
            MBeanServerNotificationSupport _notificationSupport;
            boolean registered = false;
            try {
                mBean = MBeanUtil.getRegisterableMBean(mBeanHolder.getRef(), mBean);
                if (mBean != null) {
                    ObjectInstance oi = super.registerMBean(mBean, name);
                    registered = true;
                }
                if (this.delayedMBeanMap.remove(name) == null) {
                    // empty if block
                }
                mBeanHolder.registrationState.set(registered ? DelayedMBeanRegistrationState.REGISTERED : DelayedMBeanRegistrationState.UNREGISTERED);
                mBeanHolder.processingCompleteSignal.countDown();
                if (registered || (_notificationSupport = this.notificationSupport) == null) return;
            }
            catch (Throwable throwable) {
                MBeanServerNotificationSupport _notificationSupport2;
                if (this.delayedMBeanMap.remove(name) == null) {
                    // empty if block
                }
                mBeanHolder.registrationState.set(registered ? DelayedMBeanRegistrationState.REGISTERED : DelayedMBeanRegistrationState.UNREGISTERED);
                mBeanHolder.processingCompleteSignal.countDown();
                if (registered || (_notificationSupport2 = this.notificationSupport) == null) throw throwable;
                _notificationSupport2.sendUnregisterNotification(name);
                throw throwable;
            }
            _notificationSupport.sendUnregisterNotification(name);
            return;
        }
        this.bundleContext.ungetService(mBeanHolder.getRef());
        state = mBeanHolder.registrationState.get();
        if (state != DelayedMBeanRegistrationState.PROCESSING) return;
        this.waitForProcessingToComplete(mBeanHolder);
    }

    private boolean unregisterMBeanIfDelayed(ObjectName name) {
        DelayedMBeanHolder mBeanHolder;
        if (name != null && (mBeanHolder = this.delayedMBeanMap.get(name)) != null) {
            return this.unregisterMBeanIfDelayed(mBeanHolder, name);
        }
        return false;
    }

    private boolean unregisterMBeanIfDelayed(DelayedMBeanHolder mBeanHolder, ObjectName name) {
        DelayedMBeanRegistrationState state = mBeanHolder.registrationState.get();
        if (state == DelayedMBeanRegistrationState.DELAYED && mBeanHolder.registrationState.compareAndSet(state, DelayedMBeanRegistrationState.PROCESSING)) {
            if (this.delayedMBeanMap.remove(name) == null) {
                // empty if block
            }
            mBeanHolder.registrationState.set(DelayedMBeanRegistrationState.UNREGISTERED);
            mBeanHolder.processingCompleteSignal.countDown();
            MBeanServerNotificationSupport _notificationSupport = this.notificationSupport;
            if (_notificationSupport != null) {
                _notificationSupport.sendUnregisterNotification(name);
            }
            return true;
        }
        state = mBeanHolder.registrationState.get();
        if (state == DelayedMBeanRegistrationState.PROCESSING) {
            this.waitForProcessingToComplete(mBeanHolder);
        }
        return false;
    }

    @FFDCIgnore(value={InterruptedException.class})
    private void waitForProcessingToComplete(DelayedMBeanHolder mBeanHolder) {
        boolean done = false;
        do {
            try {
                mBeanHolder.processingCompleteSignal.await();
                done = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!done);
    }

    /*
     * WARNING - void declaration
     */
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        try {
            this.registerMBeanIfDelayed(name);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            void e;
            FFDCFilter.processException((Throwable)notCompliantMBeanException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"236", (Object)((Object)this), (Object[])new Object[]{name, listener, filter, handback});
            this.newInstanceNotFoundException((Exception)e);
        }
        catch (InstanceAlreadyExistsException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"238", (Object)((Object)this), (Object[])new Object[]{name, listener, filter, handback});
            this.newInstanceNotFoundException(e);
        }
        catch (MBeanRegistrationException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"240", (Object)((Object)this), (Object[])new Object[]{name, listener, filter, handback});
            this.newInstanceNotFoundException(e);
        }
        super.addNotificationListener(name, listener, filter, handback);
    }

    /*
     * WARNING - void declaration
     */
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        try {
            this.registerMBeanIfDelayed(name);
            this.registerMBeanIfDelayed(listener);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            void e;
            FFDCFilter.processException((Throwable)notCompliantMBeanException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"254", (Object)((Object)this), (Object[])new Object[]{name, listener, filter, handback});
            this.newInstanceNotFoundException((Exception)e);
        }
        catch (InstanceAlreadyExistsException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"256", (Object)((Object)this), (Object[])new Object[]{name, listener, filter, handback});
            this.newInstanceNotFoundException(e);
        }
        catch (MBeanRegistrationException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"258", (Object)((Object)this), (Object[])new Object[]{name, listener, filter, handback});
            this.newInstanceNotFoundException(e);
        }
        super.addNotificationListener(name, listener, filter, handback);
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            this.registerMBeanIfDelayed(name);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"271", (Object)((Object)this), (Object[])new Object[]{className, name});
            throw new InstanceAlreadyExistsException();
        }
        return super.createMBean(className, name);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        this.registerMBeanIfDelayed(name);
        this.registerMBeanIfDelayed(loaderName);
        return super.createMBean(className, name, loaderName);
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            this.registerMBeanIfDelayed(name);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"296", (Object)((Object)this), (Object[])new Object[]{className, name, params, signature});
            throw new InstanceAlreadyExistsException();
        }
        return super.createMBean(className, name, params, signature);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        this.registerMBeanIfDelayed(name);
        this.registerMBeanIfDelayed(loaderName);
        return super.createMBean(className, name, loaderName, params, signature);
    }

    /*
     * WARNING - void declaration
     */
    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        try {
            this.registerMBeanIfDelayed(name);
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            void e;
            FFDCFilter.processException((Throwable)mBeanRegistrationException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"319", (Object)((Object)this), (Object[])new Object[]{name, data});
            this.newInstanceNotFoundException((Exception)e);
        }
        return super.deserialize(name, data);
    }

    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        this.registerDelayedMBeans();
        return super.deserialize(className, data);
    }

    /*
     * WARNING - void declaration
     */
    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        try {
            this.registerMBeanIfDelayed(loaderName);
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            void e;
            FFDCFilter.processException((Throwable)mBeanRegistrationException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"339", (Object)((Object)this), (Object[])new Object[]{className, loaderName, data});
            this.newInstanceNotFoundException((Exception)e);
        }
        return super.deserialize(className, loaderName, data);
    }

    /*
     * WARNING - void declaration
     */
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        try {
            this.registerMBeanIfDelayed(name);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            void e;
            FFDCFilter.processException((Throwable)notCompliantMBeanException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"351", (Object)((Object)this), (Object[])new Object[]{name, attribute});
            this.newInstanceNotFoundException((Exception)e);
        }
        catch (InstanceAlreadyExistsException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"353", (Object)((Object)this), (Object[])new Object[]{name, attribute});
            this.newInstanceNotFoundException(e);
        }
        return super.getAttribute(name, attribute);
    }

    /*
     * WARNING - void declaration
     */
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        try {
            this.registerMBeanIfDelayed(name);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            void e;
            FFDCFilter.processException((Throwable)notCompliantMBeanException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"364", (Object)((Object)this), (Object[])new Object[]{name, attributes});
            this.newInstanceNotFoundException((Exception)e);
        }
        catch (InstanceAlreadyExistsException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"366", (Object)((Object)this), (Object[])new Object[]{name, attributes});
            this.newInstanceNotFoundException(e);
        }
        catch (MBeanRegistrationException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"368", (Object)((Object)this), (Object[])new Object[]{name, attributes});
            this.newInstanceNotFoundException(e);
        }
        return super.getAttributes(name, attributes);
    }

    /*
     * WARNING - void declaration
     */
    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        try {
            this.registerMBeanIfDelayed(loaderName);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            void e;
            FFDCFilter.processException((Throwable)notCompliantMBeanException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"379", (Object)((Object)this), (Object[])new Object[]{loaderName});
            this.newInstanceNotFoundException((Exception)e);
        }
        catch (InstanceAlreadyExistsException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"381", (Object)((Object)this), (Object[])new Object[]{loaderName});
            this.newInstanceNotFoundException(e);
        }
        catch (MBeanRegistrationException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"383", (Object)((Object)this), (Object[])new Object[]{loaderName});
            this.newInstanceNotFoundException(e);
        }
        return super.getClassLoader(loaderName);
    }

    /*
     * WARNING - void declaration
     */
    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        try {
            this.registerMBeanIfDelayed(mbeanName);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            void e;
            FFDCFilter.processException((Throwable)notCompliantMBeanException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"394", (Object)((Object)this), (Object[])new Object[]{mbeanName});
            this.newInstanceNotFoundException((Exception)e);
        }
        catch (InstanceAlreadyExistsException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"396", (Object)((Object)this), (Object[])new Object[]{mbeanName});
            this.newInstanceNotFoundException(e);
        }
        catch (MBeanRegistrationException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"398", (Object)((Object)this), (Object[])new Object[]{mbeanName});
            this.newInstanceNotFoundException(e);
        }
        return super.getClassLoaderFor(mbeanName);
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        return super.getClassLoaderRepository();
    }

    public String getDefaultDomain() {
        return super.getDefaultDomain();
    }

    public String[] getDomains() {
        String[] domains = super.getDomains();
        Iterator<Map.Entry<ObjectName, DelayedMBeanHolder>> entries = this.delayedMBeanMap.entrySet().iterator();
        if (!entries.hasNext()) {
            return domains;
        }
        HashSet<String> _domains = domains != null ? new HashSet<String>(Arrays.asList(domains)) : new HashSet();
        do {
            Map.Entry<ObjectName, DelayedMBeanHolder> entry = entries.next();
            if (entry.getValue().registrationState.get() == DelayedMBeanRegistrationState.UNREGISTERED) continue;
            _domains.add(entry.getKey().getDomain());
        } while (entries.hasNext());
        return _domains.toArray(new String[_domains.size()]);
    }

    public Integer getMBeanCount() {
        int _mBeanCount;
        Integer mBeanCount = super.getMBeanCount();
        Iterator<DelayedMBeanHolder> mBeanHolders = this.delayedMBeanMap.values().iterator();
        if (!mBeanHolders.hasNext()) {
            return mBeanCount;
        }
        int n = _mBeanCount = mBeanCount != null ? mBeanCount : 0;
        do {
            if (mBeanHolders.next().registrationState.get() == DelayedMBeanRegistrationState.UNREGISTERED) continue;
            ++_mBeanCount;
        } while (mBeanHolders.hasNext());
        return _mBeanCount;
    }

    /*
     * WARNING - void declaration
     */
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        try {
            this.registerMBeanIfDelayed(name);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            void e;
            FFDCFilter.processException((Throwable)notCompliantMBeanException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"466", (Object)((Object)this), (Object[])new Object[]{name});
            this.newInstanceNotFoundException((Exception)e);
        }
        catch (InstanceAlreadyExistsException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"468", (Object)((Object)this), (Object[])new Object[]{name});
            this.newInstanceNotFoundException(e);
        }
        catch (MBeanRegistrationException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"470", (Object)((Object)this), (Object[])new Object[]{name});
            this.newInstanceNotFoundException(e);
        }
        return super.getMBeanInfo(name);
    }

    /*
     * WARNING - void declaration
     */
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        try {
            this.registerMBeanIfDelayed(name);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            void e;
            FFDCFilter.processException((Throwable)notCompliantMBeanException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"481", (Object)((Object)this), (Object[])new Object[]{name});
            this.newInstanceNotFoundException((Exception)e);
        }
        catch (InstanceAlreadyExistsException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"483", (Object)((Object)this), (Object[])new Object[]{name});
            this.newInstanceNotFoundException(e);
        }
        catch (MBeanRegistrationException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"485", (Object)((Object)this), (Object[])new Object[]{name});
            this.newInstanceNotFoundException(e);
        }
        return super.getObjectInstance(name);
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException {
        this.registerDelayedMBeans();
        return super.instantiate(className);
    }

    /*
     * WARNING - void declaration
     */
    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        try {
            this.registerMBeanIfDelayed(loaderName);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            void e;
            FFDCFilter.processException((Throwable)notCompliantMBeanException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"504", (Object)((Object)this), (Object[])new Object[]{className, loaderName});
            this.newInstanceNotFoundException((Exception)e);
        }
        catch (InstanceAlreadyExistsException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"506", (Object)((Object)this), (Object[])new Object[]{className, loaderName});
            this.newInstanceNotFoundException(e);
        }
        return super.instantiate(className, loaderName);
    }

    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        this.registerDelayedMBeans();
        return super.instantiate(className, params, signature);
    }

    /*
     * WARNING - void declaration
     */
    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        try {
            this.registerMBeanIfDelayed(loaderName);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            void e;
            FFDCFilter.processException((Throwable)notCompliantMBeanException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"527", (Object)((Object)this), (Object[])new Object[]{className, loaderName, params, signature});
            this.newInstanceNotFoundException((Exception)e);
        }
        catch (InstanceAlreadyExistsException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"529", (Object)((Object)this), (Object[])new Object[]{className, loaderName, params, signature});
            this.newInstanceNotFoundException(e);
        }
        return super.instantiate(className, loaderName, params, signature);
    }

    /*
     * WARNING - void declaration
     */
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        try {
            this.registerMBeanIfDelayed(name);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            void e;
            FFDCFilter.processException((Throwable)notCompliantMBeanException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"542", (Object)((Object)this), (Object[])new Object[]{name, operationName, params, signature});
            this.newInstanceNotFoundException((Exception)e);
        }
        catch (InstanceAlreadyExistsException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"544", (Object)((Object)this), (Object[])new Object[]{name, operationName, params, signature});
            this.newInstanceNotFoundException(e);
        }
        return super.invoke(name, operationName, params, signature);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        DelayedMBeanHolder mBeanHolder = this.delayedMBeanMap.get(name);
        if (mBeanHolder != null) {
            Object mbeanClassesObj = mBeanHolder.getRef().getProperty(MBEAN_CLASSES);
            if (mbeanClassesObj != null) {
                String[] mbeanClasses;
                String[] stringArray;
                if (mbeanClassesObj instanceof String) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = (String)mbeanClassesObj;
                } else {
                    stringArray = mbeanClasses = (String[])mbeanClassesObj;
                }
                if (this.checkTypeMatch(className, (String[])mBeanHolder.getRef().getProperty("objectClass")) || this.checkTypeMatch(className, mbeanClasses)) {
                    return true;
                }
                for (String implClassName : mbeanClasses) {
                    if (!this.checkInheritance(className, implClassName, mBeanHolder.getRef().getBundle())) continue;
                    return true;
                }
                return false;
            }
            try {
                this.registerMBeanIfDelayed(name);
            }
            catch (NotCompliantMBeanException mbeanClasses) {
                void e;
                FFDCFilter.processException((Throwable)mbeanClasses, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"574", (Object)((Object)this), (Object[])new Object[]{name, className});
                throw this.newInstanceNotFoundException((Exception)e);
            }
            catch (InstanceAlreadyExistsException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"576", (Object)((Object)this), (Object[])new Object[]{name, className});
                throw this.newInstanceNotFoundException(e);
            }
            catch (MBeanRegistrationException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"578", (Object)((Object)this), (Object[])new Object[]{name, className});
                throw this.newInstanceNotFoundException(e);
            }
        }
        return super.isInstanceOf(name, className);
    }

    private boolean checkTypeMatch(String className, String[] classNames) {
        for (String test : classNames) {
            if (!test.equals(className)) continue;
            return true;
        }
        return false;
    }

    @FFDCIgnore(value={Exception.class})
    private boolean checkInheritance(String className, String test, Bundle b) {
        try {
            Class clazz = b.loadClass(className);
            Class testClazz = b.loadClass(test);
            return clazz.isAssignableFrom(testClazz);
        }
        catch (Exception e) {
            return false;
        }
    }

    private InstanceNotFoundException newInstanceNotFoundException(Exception e) {
        InstanceNotFoundException e2 = new InstanceNotFoundException();
        e2.initCause(e);
        return e2;
    }

    public boolean isRegistered(ObjectName name) {
        DelayedMBeanHolder mBeanHolder = this.delayedMBeanMap.get(name);
        if (mBeanHolder != null && mBeanHolder.registrationState.get() != DelayedMBeanRegistrationState.UNREGISTERED) {
            return true;
        }
        return super.isRegistered(name);
    }

    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        this.registerDelayedMBeans();
        return super.queryMBeans(name, query);
    }

    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        HashSet<ObjectName> names = super.queryNames(name, query);
        Iterator<Map.Entry<ObjectName, DelayedMBeanHolder>> entries = this.delayedMBeanMap.entrySet().iterator();
        if (!entries.hasNext()) {
            return names;
        }
        if (query != null) {
            query.setMBeanServer((MBeanServer)((Object)this));
        }
        if (!(names instanceof HashSet)) {
            names = names != null ? new HashSet<ObjectName>(names) : new HashSet();
        }
        do {
            ObjectName currentName;
            block8: {
                Map.Entry<ObjectName, DelayedMBeanHolder> entry = entries.next();
                if (entry.getValue().registrationState.get() == DelayedMBeanRegistrationState.UNREGISTERED || names.contains(currentName = entry.getKey()) || name != null && !name.apply(currentName)) continue;
                if (query != null) {
                    try {
                        if (!query.apply(currentName)) {
                        }
                        break block8;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"675", (Object)((Object)this), (Object[])new Object[]{name, query});
                    }
                    continue;
                }
            }
            names.add(currentName);
        } while (entries.hasNext());
        return names;
    }

    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        try {
            this.registerMBeanIfDelayed(name);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"695", (Object)((Object)this), (Object[])new Object[]{object, name});
            throw new InstanceAlreadyExistsException();
        }
        return super.registerMBean(object, name);
    }

    /*
     * WARNING - void declaration
     */
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        try {
            this.registerMBeanIfDelayed(name);
            this.registerMBeanIfDelayed(listener);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            void e;
            FFDCFilter.processException((Throwable)notCompliantMBeanException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"707", (Object)((Object)this), (Object[])new Object[]{name, listener});
            this.newInstanceNotFoundException((Exception)e);
        }
        catch (InstanceAlreadyExistsException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"709", (Object)((Object)this), (Object[])new Object[]{name, listener});
            this.newInstanceNotFoundException(e);
        }
        catch (MBeanRegistrationException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"711", (Object)((Object)this), (Object[])new Object[]{name, listener});
            this.newInstanceNotFoundException(e);
        }
        super.removeNotificationListener(name, listener);
    }

    /*
     * WARNING - void declaration
     */
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        try {
            this.registerMBeanIfDelayed(name);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            void e;
            FFDCFilter.processException((Throwable)notCompliantMBeanException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"723", (Object)((Object)this), (Object[])new Object[]{name, listener});
            this.newInstanceNotFoundException((Exception)e);
        }
        catch (InstanceAlreadyExistsException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"725", (Object)((Object)this), (Object[])new Object[]{name, listener});
            this.newInstanceNotFoundException(e);
        }
        catch (MBeanRegistrationException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"727", (Object)((Object)this), (Object[])new Object[]{name, listener});
            this.newInstanceNotFoundException(e);
        }
        super.removeNotificationListener(name, listener);
    }

    /*
     * WARNING - void declaration
     */
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        try {
            this.registerMBeanIfDelayed(name);
            this.registerMBeanIfDelayed(listener);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            void e;
            FFDCFilter.processException((Throwable)notCompliantMBeanException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"742", (Object)((Object)this), (Object[])new Object[]{name, listener, filter, handback});
            this.newInstanceNotFoundException((Exception)e);
        }
        catch (InstanceAlreadyExistsException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"744", (Object)((Object)this), (Object[])new Object[]{name, listener, filter, handback});
            this.newInstanceNotFoundException(e);
        }
        catch (MBeanRegistrationException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"746", (Object)((Object)this), (Object[])new Object[]{name, listener, filter, handback});
            this.newInstanceNotFoundException(e);
        }
        super.removeNotificationListener(name, listener, filter, handback);
    }

    /*
     * WARNING - void declaration
     */
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        try {
            this.registerMBeanIfDelayed(name);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            void e;
            FFDCFilter.processException((Throwable)notCompliantMBeanException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"760", (Object)((Object)this), (Object[])new Object[]{name, listener, filter, handback});
            this.newInstanceNotFoundException((Exception)e);
        }
        catch (InstanceAlreadyExistsException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"762", (Object)((Object)this), (Object[])new Object[]{name, listener, filter, handback});
            this.newInstanceNotFoundException(e);
        }
        catch (MBeanRegistrationException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"764", (Object)((Object)this), (Object[])new Object[]{name, listener, filter, handback});
            this.newInstanceNotFoundException(e);
        }
        super.removeNotificationListener(name, listener, filter, handback);
    }

    /*
     * WARNING - void declaration
     */
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            this.registerMBeanIfDelayed(name);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            void e;
            FFDCFilter.processException((Throwable)notCompliantMBeanException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"776", (Object)((Object)this), (Object[])new Object[]{name, attribute});
            this.newInstanceNotFoundException((Exception)e);
        }
        catch (InstanceAlreadyExistsException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"778", (Object)((Object)this), (Object[])new Object[]{name, attribute});
            this.newInstanceNotFoundException(e);
        }
        super.setAttribute(name, attribute);
    }

    /*
     * WARNING - void declaration
     */
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        try {
            this.registerMBeanIfDelayed(name);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            void e;
            FFDCFilter.processException((Throwable)notCompliantMBeanException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"789", (Object)((Object)this), (Object[])new Object[]{name, attributes});
            this.newInstanceNotFoundException((Exception)e);
        }
        catch (InstanceAlreadyExistsException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"791", (Object)((Object)this), (Object[])new Object[]{name, attributes});
            this.newInstanceNotFoundException(e);
        }
        catch (MBeanRegistrationException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivator", (String)"793", (Object)((Object)this), (Object[])new Object[]{name, attributes});
            this.newInstanceNotFoundException(e);
        }
        return super.setAttributes(name, attributes);
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        if (!this.unregisterMBeanIfDelayed(name)) {
            super.unregisterMBean(name);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(DelayedMBeanActivator.class);
    }
}

