/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.config.ConfigRetrieverException;
import com.ibm.websphere.config.ConfigUpdateException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.admin.ConfigID;
import com.ibm.ws.config.admin.ExtendedConfiguration;
import com.ibm.ws.config.admin.SystemConfigSupport;
import com.ibm.ws.config.xml.internal.BaseConfiguration;
import com.ibm.ws.config.xml.internal.ConfigComparator;
import com.ibm.ws.config.xml.internal.ConfigDelta;
import com.ibm.ws.config.xml.internal.ConfigElement;
import com.ibm.ws.config.xml.internal.ConfigMergeException;
import com.ibm.ws.config.xml.internal.ConfigNotFoundException;
import com.ibm.ws.config.xml.internal.ConfigRetriever;
import com.ibm.ws.config.xml.internal.ConfigUpdater;
import com.ibm.ws.config.xml.internal.ConfigValidator;
import com.ibm.ws.config.xml.internal.ConfigVariable;
import com.ibm.ws.config.xml.internal.ConfigVariableRegistry;
import com.ibm.ws.config.xml.internal.ConfigurationInfo;
import com.ibm.ws.config.xml.internal.ErrorHandler;
import com.ibm.ws.config.xml.internal.ExtendedMetatypeManager;
import com.ibm.ws.config.xml.internal.FactoryElement;
import com.ibm.ws.config.xml.internal.MetaTypeRegistry;
import com.ibm.ws.config.xml.internal.ServerConfiguration;
import com.ibm.ws.config.xml.internal.ServerXMLConfiguration;
import com.ibm.ws.config.xml.internal.SingletonElement;
import com.ibm.ws.config.xml.internal.metatype.ExtendedAttributeDefinition;
import com.ibm.ws.config.xml.internal.metatype.ExtendedObjectClassDefinition;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.OnErrorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ChangeHandler {
    static final TraceComponent tc = Tr.register(ChangeHandler.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private final SystemConfigSupport caSupport;
    private final ConfigVariableRegistry variableRegistry;
    private final ExtendedMetatypeManager extendedMetatypeManager;
    private final ConfigValidator validator;
    private final ConfigRetriever configRetriever;
    private final ConfigUpdater configUpdater;
    private final MetaTypeRegistry metatypeRegistry;
    static final long serialVersionUID = -8900604424361924886L;

    public ChangeHandler(SystemConfigSupport caSupport, ConfigVariableRegistry vr, ExtendedMetatypeManager emm, ConfigRetriever retriever, ConfigValidator validator, ConfigUpdater configUpdater, MetaTypeRegistry registry) {
        this.caSupport = caSupport;
        this.variableRegistry = vr;
        this.extendedMetatypeManager = emm;
        this.configRetriever = retriever;
        this.validator = validator;
        this.configUpdater = configUpdater;
        this.metatypeRegistry = registry;
    }

    public synchronized Collection<ConfigurationInfo> switchConfiguration(ServerXMLConfiguration serverXMLConfig, ConfigComparator.ComparatorResult result) throws ConfigUpdateException {
        serverXMLConfig.setNewConfiguration(result.getNewConfiguration());
        if (!result.getVariableDelta().isEmpty()) {
            this.configUpdater.updateSystemVariables(serverXMLConfig);
            if (result.getVariableDelta().containsKey("onError")) {
                ConfigVariable var = serverXMLConfig.getVariables().get("onError");
                if (var == null) {
                    ErrorHandler.INSTANCE.setOnError(OnErrorUtil.getDefaultOnError());
                } else {
                    OnErrorUtil.OnError onErrorVal = OnErrorUtil.OnError.valueOf((String)var.getValue().trim().toUpperCase());
                    ErrorHandler.INSTANCE.setOnError(onErrorVal);
                }
            }
        }
        List<ConfigDelta> deltas = result.getConfigDelta();
        HashMap<ConfigID, ConfigurationInfo> updatedConfigurations = new HashMap<ConfigID, ConfigurationInfo>();
        HashMap<ConfigID, ConfigurationInfo> deletedConfigurations = new HashMap<ConfigID, ConfigurationInfo>();
        this.processDelta(deltas, updatedConfigurations, deletedConfigurations, null);
        Collection<ConfigurationInfo> newConfigurations = this.configUpdater.update(false, updatedConfigurations.values());
        updatedConfigurations.clear();
        for (ConfigurationInfo info : newConfigurations) {
            updatedConfigurations.put(info.configElement.getConfigID(), info);
        }
        this.configUpdater.processUnresolvedReferences(ErrorHandler.INSTANCE.getOnError());
        ConfigProcessor processor = new ConfigProcessor(serverXMLConfig.getConfiguration());
        Collection<ConfigurationInfo> dependentConfigurations = processor.getDependentConfigurations(deltas, updatedConfigurations);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Dependent configurations: " + dependentConfigurations), (Object[])new Object[0]);
        }
        dependentConfigurations = this.configUpdater.update(true, dependentConfigurations);
        for (ConfigurationInfo info : dependentConfigurations) {
            updatedConfigurations.put(info.configElement.getConfigID(), info);
        }
        ArrayList<ConfigurationInfo> updates = new ArrayList<ConfigurationInfo>(deletedConfigurations.values());
        updates.addAll(updatedConfigurations.values());
        return updates;
    }

    /*
     * WARNING - void declaration
     */
    private void processDelta(List<ConfigDelta> deltas, Map<ConfigID, ConfigurationInfo> updatedConfigurations, Map<ConfigID, ConfigurationInfo> deletedConfigurations, ConfigElement parent) throws ConfigUpdateException {
        for (ConfigDelta delta : deltas) {
            ConfigurationInfo info;
            ExtendedObjectClassDefinition ocd;
            if (!delta.getNestedDelta().isEmpty()) {
                this.processDelta(delta.getNestedDelta(), updatedConfigurations, deletedConfigurations, delta.getConfigElement());
            }
            ConfigElement configElement = delta.getConfigElement();
            configElement.setParent(parent);
            ConfigComparator.DeltaType deltaType = delta.getDelta();
            MetaTypeRegistry.RegistryEntry registry = delta.getRegistryEntry();
            ExtendedObjectClassDefinition extendedObjectClassDefinition = ocd = registry != null ? registry.getObjectClassDefinition() : null;
            if (deltaType == ConfigComparator.DeltaType.REMOVED) {
                if (registry == null) {
                    info = this.removeConfigAndCreateInfo(configElement, false);
                    if (info != null) {
                        deletedConfigurations.put(configElement.getConfigID(), info);
                    }
                } else {
                    try {
                        ExtendedConfiguration configImpl = this.configRetriever.getConfiguration(configElement.getConfigID());
                        if (configImpl != null) {
                            this.removeUniqueVariables(configImpl, registry);
                            Dictionary<String, Object> properties = configImpl.getProperties();
                            String pid = null;
                            if (properties != null) {
                                pid = (String)properties.get("ibm.extends.source.pid");
                            }
                            if (pid == null) {
                                pid = configImpl.getPid();
                            }
                            this.extendedMetatypeManager.deleteSuperType(pid);
                        }
                    }
                    catch (ConfigNotFoundException configImpl) {
                        void ex;
                        FFDCFilter.processException((Throwable)configImpl, (String)"com.ibm.ws.config.xml.internal.ChangeHandler", (String)"178", (Object)this, (Object[])new Object[]{deltas, updatedConfigurations, deletedConfigurations, parent});
                        throw new ConfigUpdateException((Exception)ex);
                    }
                    if (registry.isSingleton() && ocd.hasAllRequiredDefaults() && configElement.isEnabled() && (parent == null || !parent.containsAttribute(registry.getAlias()) && !parent.containsAttribute(registry.getPid()))) {
                        SingletonElement oldElement = (SingletonElement)configElement;
                        SingletonElement newConfigElement = new SingletonElement(oldElement.getNodeName(), oldElement.pid);
                        try {
                            ConfigurationInfo info2 = this.createConfigurationInfo(newConfigElement, registry);
                            updatedConfigurations.put(newConfigElement.getConfigID(), info2);
                        }
                        catch (ConfigNotFoundException info2) {
                            void ex;
                            FFDCFilter.processException((Throwable)info2, (String)"com.ibm.ws.config.xml.internal.ChangeHandler", (String)"192", (Object)this, (Object[])new Object[]{deltas, updatedConfigurations, deletedConfigurations, parent});
                            throw new ConfigUpdateException((Exception)ex);
                        }
                    } else {
                        info = this.removeConfigAndCreateInfo(configElement, false);
                        if (info != null) {
                            deletedConfigurations.put(configElement.getConfigID(), info);
                        }
                    }
                }
            } else {
                if (registry != null) {
                    String pid = registry.getPid();
                    String alias = registry.getAlias();
                    if (registry.isFactory()) {
                        this.validator.validateFactoryInstance(pid, alias, configElement.getConfigID());
                    } else {
                        this.validator.validateSingleton(pid, alias);
                    }
                }
                try {
                    info = this.createConfigurationInfo(configElement, registry);
                    if (parent == null) {
                        updatedConfigurations.put(configElement.getConfigID(), info);
                    }
                }
                catch (ConfigNotFoundException info3) {
                    void ex;
                    FFDCFilter.processException((Throwable)info3, (String)"com.ibm.ws.config.xml.internal.ChangeHandler", (String)"221", (Object)this, (Object[])new Object[]{deltas, updatedConfigurations, deletedConfigurations, parent});
                    throw new ConfigUpdateException((Exception)ex);
                }
            }
            if (parent == null) continue;
            configElement.setParent(parent);
        }
    }

    private void removeUniqueVariables(ExtendedConfiguration config, MetaTypeRegistry.RegistryEntry registryEntry) {
        if (registryEntry != null) {
            for (Map.Entry<String, ExtendedAttributeDefinition> entry : registryEntry.getAttributeMap().entrySet()) {
                String attributeValue;
                ExtendedAttributeDefinition attrDef = entry.getValue();
                if (!attrDef.isUnique()) continue;
                Object value = attrDef.getID() == null ? null : config.getProperty(attrDef.getID());
                String string = attributeValue = value == null ? null : String.valueOf(value);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("removing value from config for unique attribute[" + attrDef.getID() + "]: " + attributeValue), (Object[])new Object[0]);
                }
                this.variableRegistry.removeUniqueVariable(attrDef, attributeValue);
            }
        }
    }

    protected synchronized void removeDefaultConfiguration(BaseConfiguration oldConfig, ServerXMLConfiguration serverConfig) throws ConfigUpdateException {
        ConfigComparator cc = new ConfigComparator(oldConfig, serverConfig.getConfiguration(), this.metatypeRegistry);
        ConfigComparator.ComparatorResult cr = cc.computeDelta();
        if (cr.hasDelta()) {
            cr.setNewConfiguration(serverConfig.getConfiguration());
            Collection<ConfigurationInfo> configurations = this.switchConfiguration(serverConfig, cr);
            if (configurations != null) {
                ArrayList futures = new ArrayList();
                for (ConfigurationInfo info : configurations) {
                    info.fireEvents(futures);
                }
            }
        }
    }

    public Set<String> removeMetatypeConvertedConfig(ServerConfiguration sc, Set<MetaTypeRegistry.RegistryEntry> updatedEntries) {
        HashSet<String> updates = new HashSet<String>();
        for (MetaTypeRegistry.RegistryEntry entry : updatedEntries) {
            this.removeMetatypeConvertedConfig((BaseConfiguration)sc, entry);
            updates.add(entry.getPid());
        }
        return updates;
    }

    /*
     * WARNING - void declaration
     */
    private void removeMetatypeConvertedConfig(BaseConfiguration config, MetaTypeRegistry.RegistryEntry entry) {
        try {
            if (entry.isFactory()) {
                Map<ConfigID, FactoryElement> map = config.getFactoryInstancesUsingDefaultId(entry.getPid(), entry.getAlias(), entry.getDefaultId());
                for (FactoryElement element : map.values()) {
                    ExtendedConfiguration ec = this.findConfigurationToRemove(element);
                    if (ec == null) continue;
                    this.removeUniqueVariables(ec, entry);
                    this.extendedMetatypeManager.deleteSuperType(ec.getPid());
                    ec.delete(true);
                }
            } else {
                SingletonElement element = config.getSingleton(entry.getPid(), entry.getAlias());
                ExtendedConfiguration ec = this.findConfigurationToRemove(element);
                this.removeUniqueVariables(ec, entry);
                this.extendedMetatypeManager.deleteSuperType(ec.getPid());
                ec.delete(true);
            }
        }
        catch (ConfigMergeException element) {
            void ex;
            FFDCFilter.processException((Throwable)element, (String)"com.ibm.ws.config.xml.internal.ChangeHandler", (String)"328", (Object)this, (Object[])new Object[]{config, entry});
            ex.getStackTrace();
        }
    }

    protected ConfigurationInfo removeConfigAndCreateInfo(ConfigElement configElement, boolean notify) {
        ExtendedConfiguration config = this.findConfigurationToRemove(configElement);
        if (config == null) {
            return null;
        }
        config.delete(notify);
        return new ConfigurationInfo(configElement, config, null, true);
    }

    /*
     * WARNING - void declaration
     */
    private ExtendedConfiguration findConfigurationToRemove(ConfigElement configElement) {
        block6: {
            try {
                ExtendedConfiguration[] configs = this.configRetriever.findConfigurations(configElement.getConfigID());
                if (configs != null) {
                    if (configs.length == 1) {
                        return configs[0];
                    }
                    if (configs.length > 1 && tc.isWarningEnabled()) {
                        Tr.warning((TraceComponent)tc, (String)"warn.config.delete.failed.multiple", (Object[])new Object[]{configElement.getDisplayId()});
                    }
                }
            }
            catch (ConfigRetrieverException configs) {
                void e;
                FFDCFilter.processException((Throwable)configs, (String)"com.ibm.ws.config.xml.internal.ChangeHandler", (String)"358", (Object)this, (Object[])new Object[]{configElement});
                e.getCause();
                if (!tc.isWarningEnabled()) break block6;
                Tr.warning((TraceComponent)tc, (String)"warn.config.delete.failed", (Object[])new Object[]{configElement.getDisplayId()});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Configuration not found for: " + configElement.getConfigID()), (Object[])new Object[0]);
        }
        return null;
    }

    protected ConfigurationInfo createConfigurationInfo(ConfigElement configElement, MetaTypeRegistry.RegistryEntry registryEntry) throws ConfigNotFoundException {
        ExtendedConfiguration config = this.configRetriever.getConfiguration(configElement.getConfigID());
        ConfigurationInfo info = new ConfigurationInfo(configElement, config, registryEntry, false);
        this.extendedMetatypeManager.createSuperTypes(info);
        return info;
    }

    public void updateAtStartup(ServerConfiguration serverConfiguration) throws ConfigUpdateException {
        List<ConfigurationInfo> infos = this.getConfigurationsToPopulate(serverConfiguration);
        this.configUpdater.update(true, infos);
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={ConfigNotFoundException.class})
    private List<ConfigurationInfo> getConfigurationsToPopulate(ServerConfiguration serverConfiguration) throws ConfigUpdateException {
        ExtendedConfiguration[] oldConfigs = null;
        try {
            oldConfigs = this.configRetriever.listAllConfigurations();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.config.xml.internal.ChangeHandler", (String)"390", (Object)this, (Object[])new Object[]{serverConfiguration});
            throw new ConfigUpdateException((Exception)e);
        }
        Map<String, ExtendedConfiguration> oldConfigurations = Collections.emptyMap();
        if (oldConfigs != null) {
            oldConfigurations = new HashMap(oldConfigs.length);
            for (ExtendedConfiguration config : oldConfigs) {
                oldConfigurations.put(config.getPid(), config);
                for (String oldVar : config.getUniqueVariables()) {
                    this.variableRegistry.removeVariable(oldVar);
                }
            }
        }
        ArrayList<ConfigurationInfo> infos = new ArrayList<ConfigurationInfo>();
        ArrayList<ExtendedConfiguration> newConfigurations = new ArrayList<ExtendedConfiguration>();
        for (String pid : serverConfiguration.getSingletonNames()) {
            SingletonElement configElement = serverConfiguration.getSingleton(pid, null);
            if (!configElement.isEnabled()) continue;
            try {
                ConfigurationInfo info = this.createConfigurationInfo(configElement, null);
                infos.add(info);
                newConfigurations.add(info.config);
                this.configRetriever.collectConfigurations(configElement, newConfigurations);
            }
            catch (ConfigNotFoundException e) {
                throw new ConfigUpdateException(e);
            }
        }
        for (String factoryPid : serverConfiguration.getFactoryNames()) {
            Map factoryInstances = serverConfiguration.getFactoryInstances(factoryPid, null);
            for (FactoryElement configElement : factoryInstances.values()) {
                if (!configElement.isEnabled()) continue;
                try {
                    ConfigurationInfo info = this.createConfigurationInfo(configElement, null);
                    infos.add(info);
                    newConfigurations.add(info.config);
                    ExtendedConfiguration superConfig = (ExtendedConfiguration)this.extendedMetatypeManager.getSuperTypeConfig(info.config.getPid());
                    if (superConfig != null) {
                        newConfigurations.add(superConfig);
                    }
                    this.configRetriever.collectConfigurations(configElement, newConfigurations);
                }
                catch (ConfigNotFoundException ex) {
                    throw new ConfigUpdateException(ex);
                }
            }
        }
        if (!oldConfigurations.isEmpty()) {
            for (ExtendedConfiguration config : newConfigurations) {
                oldConfigurations.remove(config.getPid());
            }
            for (ExtendedConfiguration config : oldConfigurations.values()) {
                if (!config.isInOverridesFile()) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Deleted configuration: " + ErrorHandler.INSTANCE.toTraceString(config, null)), (Object[])new Object[0]);
                }
                this.extendedMetatypeManager.removeSuperTypeForPid(config.getPid());
                config.delete(false);
            }
        }
        return infos;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class ConfigProcessor {
        private final ServerConfiguration configuration;
        static final long serialVersionUID = -2904369122036011356L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ConfigProcessor(ServerConfiguration configuration) {
            this.configuration = configuration;
        }

        private MetaTypeRegistry.RegistryEntry getRegistryEntry(String name) {
            return ChangeHandler.this.metatypeRegistry != null ? ChangeHandler.this.metatypeRegistry.getRegistryEntry(name) : null;
        }

        private ConfigID[] resolveConfigID(ConfigID configId, MetaTypeRegistry.RegistryEntry registryEntry) {
            if (registryEntry == null) {
                return new ConfigID[]{configId};
            }
            if (configId.getPid().equals(registryEntry.getPid())) {
                String alias;
                String string = alias = registryEntry.getChildAlias() == null ? registryEntry.getAlias() : registryEntry.getChildAlias();
                if (alias == null) {
                    return new ConfigID[]{configId};
                }
                ConfigID pid = configId;
                ConfigID aliasID = new ConfigID(registryEntry.getAlias(), configId.getId());
                return new ConfigID[]{pid, aliasID};
            }
            ConfigID pid = new ConfigID(registryEntry.getPid(), configId.getId());
            ConfigID alias = configId;
            return new ConfigID[]{pid, alias};
        }

        public Collection<ConfigurationInfo> getDependentConfigurations(List<ConfigDelta> deltas, Map<ConfigID, ConfigurationInfo> updatedConfigurations) throws ConfigUpdateException {
            HashSet<ConfigID> visited = new HashSet<ConfigID>();
            ArrayList<ConfigurationInfo> dependentConfigurations = new ArrayList<ConfigurationInfo>();
            for (ConfigDelta delta : deltas) {
                ConfigElement configElement = delta.getConfigElement();
                ConfigID configId = configElement.getConfigID();
                MetaTypeRegistry.RegistryEntry registry = delta.getRegistryEntry();
                ConfigID[] resolvedIds = this.resolveConfigID(configId, registry);
                this.processReferences(resolvedIds, dependentConfigurations, updatedConfigurations, visited);
            }
            return dependentConfigurations;
        }

        private void processReferences(ConfigID[] configIds, List<ConfigurationInfo> dependentConfigurations, Map<ConfigID, ConfigurationInfo> updatedConfigurations, Set<ConfigID> visited) throws ConfigUpdateException {
            for (ConfigID configId : configIds) {
                this.processReferences(configId, dependentConfigurations, updatedConfigurations, visited);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void processReferences(ConfigID configId, List<ConfigurationInfo> dependentConfigurations, Map<ConfigID, ConfigurationInfo> updatedConfigurations, Set<ConfigID> visited) throws ConfigUpdateException {
            if (visited.contains(configId)) {
                return;
            }
            visited.add(configId);
            Set<ConfigID> referenceIds = ChangeHandler.this.caSupport.getReferences(configId);
            for (ConfigID referenceId : referenceIds) {
                MetaTypeRegistry.RegistryEntry referenceRegistry = this.getRegistryEntry(referenceId.getPid());
                ConfigID[] resolvedIds = this.resolveConfigID(referenceId, referenceRegistry);
                this.processReferences(resolvedIds, dependentConfigurations, updatedConfigurations, visited);
                if (updatedConfigurations.containsKey(resolvedIds[0])) continue;
                ConfigElement configElement = null;
                configElement = referenceRegistry == null ? this.getConfigElement(resolvedIds[0].getPid(), resolvedIds[0].getId()) : this.getConfigElement(referenceRegistry, resolvedIds[0].getId());
                if (configElement == null) continue;
                try {
                    ConfigurationInfo info = ChangeHandler.this.createConfigurationInfo(configElement, referenceRegistry);
                    dependentConfigurations.add(info);
                }
                catch (ConfigNotFoundException info) {
                    void ex;
                    FFDCFilter.processException((Throwable)info, (String)"com.ibm.ws.config.xml.internal.ChangeHandler$ConfigProcessor", (String)"573", (Object)this, (Object[])new Object[]{configId, dependentConfigurations, updatedConfigurations, visited});
                    throw new ConfigUpdateException((Exception)ex);
                }
            }
        }

        private ConfigElement getConfigElement(String name, String id) throws ConfigMergeException {
            if (id != null) {
                return this.configuration.getFactoryInstance(name, null, id);
            }
            return this.configuration.getSingleton(name, null);
        }

        private ConfigElement getConfigElement(MetaTypeRegistry.RegistryEntry registry, String id) throws ConfigMergeException {
            if (registry.isFactory()) {
                return this.configuration.getFactoryInstance(registry.getPid(), registry.getAlias(), id);
            }
            return this.configuration.getSingleton(registry.getPid(), registry.getAlias());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ConfigProcessor.class);
        }
    }
}

