/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.server.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authentication.UnauthenticatedSubjectService;
import com.ibm.ws.security.csiv2.server.AuthenticatorImpl;
import com.ibm.ws.security.csiv2.server.config.css.ClientConfigHelper;
import com.ibm.ws.security.csiv2.server.config.tss.ServerConfigHelper;
import com.ibm.ws.security.csiv2.util.SecurityServices;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.UserRegistryService;
import com.ibm.ws.security.token.TokenManager;
import com.ibm.ws.transport.iiop.security.AbstractCsiv2SubsystemFactory;
import com.ibm.ws.transport.iiop.security.ClientPolicy;
import com.ibm.ws.transport.iiop.security.ServerPolicy;
import com.ibm.ws.transport.iiop.security.config.css.CSSConfig;
import com.ibm.ws.transport.iiop.security.config.ssl.yoko.SocketFactory;
import com.ibm.ws.transport.iiop.security.config.tss.TSSConfig;
import com.ibm.ws.transport.iiop.spi.IIOPEndpoint;
import com.ibm.ws.transport.iiop.spi.ReadyListener;
import com.ibm.ws.transport.iiop.spi.SubsystemFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Policy;
import org.omg.CSIIOP.TransportAddress;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceOptions(traceGroups={"CSIv2"}, traceGroup="", messageBundle="com.ibm.ws.security.csiv2.server.internal.resources.CSIv2ServerContainerMessages", traceExceptionThrow=false, traceExceptionHandling=false)
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={SubsystemFactory.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "service.ranking:Integer=3"})
public class CSIv2SubsystemFactory
extends AbstractCsiv2SubsystemFactory {
    private static final TraceComponent tc = Tr.register(CSIv2SubsystemFactory.class);
    private static final String ADDR_KEY = CSIv2SubsystemFactory.class.getName();
    private SecurityService securityService;
    private TokenManager tokenManager;
    private UnauthenticatedSubjectService unauthenticatedSubjectService;
    private List<String> userRegistries = Collections.emptyList();
    private static final String ENDPOINT_KEY = "yoko.orb.oa.endpoint";
    static final long serialVersionUID = 5219220007801702910L;

    @Reference
    protected void setSecurityService(SecurityService securityService, Map<String, Object> props) {
        this.securityService = securityService;
        String[] userRegistryIds = (String[])props.get("UserRegistry");
        if (userRegistryIds != null) {
            this.userRegistries = Arrays.asList(userRegistryIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatedSecurityService(SecurityService securityService, Map<String, Object> props) {
        String[] userRegistryIds = (String[])props.get("UserRegistry");
        CSIv2SubsystemFactory cSIv2SubsystemFactory = this;
        synchronized (cSIv2SubsystemFactory) {
            this.userRegistries = userRegistryIds != null ? Arrays.asList(userRegistryIds) : Collections.emptyList();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Known UserRegistry ids: {0}", (Object[])new Object[]{this.userRegistries});
        }
        this.updateRegistered();
    }

    protected void timeoutMessage(Set<String> requiredSslRefs, ReadyListener listener) {
        if (!super.check(requiredSslRefs)) {
            super.timeoutMessage(requiredSslRefs, listener);
        }
        if (this.userRegistries.isEmpty()) {
            Tr.error((TraceComponent)tc, (String)"NO_USER_REGISTRY", (Object[])new Object[]{listener.listenerId(), 10L});
        }
    }

    protected boolean check(Collection<String> requiredSslRefs) {
        return !this.userRegistries.isEmpty() && super.check(requiredSslRefs);
    }

    @Reference
    protected void setTokenManager(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    @Reference
    protected void setUnuathenticatedSubjectService(UnauthenticatedSubjectService unauthenticatedSubjectService) {
        this.unauthenticatedSubjectService = unauthenticatedSubjectService;
        SecurityServices.setUnauthenticatedSubjectService((UnauthenticatedSubjectService)unauthenticatedSubjectService);
    }

    public Policy getTargetPolicy(ORB orb, Map<String, Object> properties, Map<String, Object> extraConfig) throws Exception {
        if (extraConfig == null) {
            return null;
        }
        Map addrMap = (Map)extraConfig.get(ADDR_KEY);
        if (addrMap == null) {
            throw new IllegalStateException("Unexpected initialization order, corba bean config not parsed first: " + extraConfig);
        }
        AuthenticatorImpl authenticator = new AuthenticatorImpl(this.securityService.getAuthenticationService());
        String targetName = this.getRealm();
        TSSConfig tssConfig = new ServerConfigHelper(authenticator, this.tokenManager, this.unauthenticatedSubjectService, targetName, this.defaultAlias).getTSSConfig(properties, addrMap);
        Any any = orb.create_any();
        any.insert_Value((Serializable)new ServerPolicy.Config(tssConfig));
        Policy securityPolicy = orb.create_policy(1095976448, any);
        return securityPolicy;
    }

    public Policy getClientPolicy(ORB orb, Map<String, Object> properties) throws Exception {
        AuthenticatorImpl authenticator = new AuthenticatorImpl(this.securityService.getAuthenticationService());
        String domain = this.getRealm();
        CSSConfig cssConfig = new ClientConfigHelper(authenticator, domain, this.defaultAlias).getCSSConfig(properties);
        ClientPolicy clientPolicy = new ClientPolicy(cssConfig);
        return clientPolicy;
    }

    private String getRealm() throws RegistryException {
        String realm = "defaultRealm";
        UserRegistryService userRegistryService = this.securityService.getUserRegistryService();
        if (userRegistryService.isUserRegistryConfigured()) {
            realm = userRegistryService.getUserRegistry().getRealm();
        }
        return realm;
    }

    public void addTargetORBInitProperties(Properties initProperties, Map<String, Object> configProps, List<IIOPEndpoint> endpoints, Map<String, Object> extraProperties) {
        StringBuilder sb = new StringBuilder();
        Map<String, List<TransportAddress>> addrMap = this.extractTransportAddresses(configProps, endpoints, sb);
        extraProperties.put(ADDR_KEY, addrMap);
        sb.setLength(sb.length() - 1);
        initProperties.put(ENDPOINT_KEY, sb.toString());
    }

    private static void bindOptions(String host, int port, String sslAliasName, Boolean soReuseAddr, StringBuilder sb) {
        sb.append("iiop --bind ").append(host).append(" --host ").append(host);
        if (port > 0) {
            sb.append(" --port ").append(port);
        }
        if (sslAliasName != null && !sslAliasName.trim().isEmpty()) {
            sb.append(" --sslConfigName ").append(sslAliasName);
        }
        sb.append(" --soReuseAddr ").append(soReuseAddr);
        sb.append(",");
    }

    private Map<String, List<TransportAddress>> extractTransportAddresses(Map<String, Object> properties, List<IIOPEndpoint> endpoints, StringBuilder sb) {
        HashMap<String, List<TransportAddress>> mapOfAddr = new HashMap<String, List<TransportAddress>>();
        ArrayList<TransportAddress> unsecured = new ArrayList<TransportAddress>();
        mapOfAddr.put(null, unsecured);
        for (IIOPEndpoint ep : endpoints) {
            Boolean soReuseAddr = (Boolean)ep.getTcpOptions().get("soReuseAddr");
            if (soReuseAddr == null) {
                soReuseAddr = true;
            }
            String host = ep.getHost();
            if (ep.getIiopPort() > 0) {
                CSIv2SubsystemFactory.bindOptions(host, ep.getIiopPort(), null, soReuseAddr, sb);
                unsecured.add(new TransportAddress(host, (short)ep.getIiopPort()));
            }
            for (Map iiopsOptions : ep.getIiopsOptions()) {
                String sslAliasName = (String)iiopsOptions.get("sslRef");
                if (sslAliasName == null) {
                    sslAliasName = this.defaultAlias;
                }
                int iiopsPort = (Integer)iiopsOptions.get("iiopsPort");
                CSIv2SubsystemFactory.bindOptions(host, iiopsPort, sslAliasName, soReuseAddr, sb);
                ArrayList<TransportAddress> secured = (ArrayList<TransportAddress>)mapOfAddr.get(sslAliasName);
                if (secured == null) {
                    secured = new ArrayList<TransportAddress>();
                    mapOfAddr.put(sslAliasName, secured);
                }
                secured.add(new TransportAddress(host, (short)iiopsPort));
            }
        }
        return mapOfAddr;
    }

    public void addTargetORBInitArgs(Map<String, Object> targetProperties, List<String> args) {
        args.add("-IIOPconnectionHelper");
        args.add(SocketFactory.class.getName());
    }

    protected Set<String> extractSslRefs(Map<String, Object> properties, List<IIOPEndpoint> endpoints) {
        HashSet<String> result = new HashSet<String>();
        for (IIOPEndpoint endpoint : endpoints) {
            for (Map iiopsOptions : endpoint.getIiopsOptions()) {
                String sslAliasName = (String)iiopsOptions.get("sslRef");
                if (sslAliasName == null) {
                    sslAliasName = this.defaultAlias;
                }
                result.add(sslAliasName);
            }
        }
        result.addAll(new ClientConfigHelper(null, null, this.defaultAlias).extractSslRefs(properties));
        result.addAll(new ServerConfigHelper(null, null, null, null, this.defaultAlias).extractSslRefs(properties));
        return result;
    }
}

