/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt.tai;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.mp.jwt.MicroProfileJwtConfig;
import com.ibm.ws.security.mp.jwt.error.MpJwtProcessingException;
import com.ibm.ws.security.mp.jwt.impl.utils.MicroProfileJwtTaiRequest;
import com.ibm.ws.security.mp.jwt.tai.MicroProfileJwtTAI;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TAIRequestHelper {
    private static TraceComponent tc = Tr.register(TAIRequestHelper.class, (String)"MPJWT", (String)"com.ibm.ws.security.mp.jwt.resources.MicroProfileJwtMessages");
    public static final String ATTRIBUTE_TAI_REQUEST = "MPJwtTaiRequest";
    private static final String Authorization_Header = "Authorization";
    private static final String APPLICATION_AUTH_METHOD = "com.ibm.ws.security.tai.appAuthType";
    public static final String REQ_METHOD_POST = "POST";
    public static final String REQ_CONTENT_TYPE_NAME = "Content-Type";
    public static final String REQ_CONTENT_TYPE_APP_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String AUTHN_TYPE = "MP-JWT";
    static final long serialVersionUID = -6852357615871685267L;

    @ManualTrace
    public MicroProfileJwtTaiRequest createMicroProfileJwtTaiRequestAndSetRequestAttribute(HttpServletRequest request) {
        String methodName = "createMicroProfileJwtTaiRequestAndSetRequestAttribute";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{request});
        }
        MicroProfileJwtTaiRequest mpJwtTaiRequest = new MicroProfileJwtTaiRequest(request);
        request.setAttribute(ATTRIBUTE_TAI_REQUEST, (Object)mpJwtTaiRequest);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)mpJwtTaiRequest);
        }
        return mpJwtTaiRequest;
    }

    @ManualTrace
    public boolean requestShouldBeHandledByTAI(HttpServletRequest request, MicroProfileJwtTaiRequest mpJwtTaiRequest) {
        String methodName = "requestShouldBeHandledByTAI";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{request, mpJwtTaiRequest});
        }
        String loginHint = this.getLoginHint(request);
        mpJwtTaiRequest = this.setTaiRequestConfigInfo(request, loginHint, mpJwtTaiRequest);
        boolean result = false;
        boolean ignoreAppAuthMethod = true;
        MicroProfileJwtConfig mpJwtConfig = null;
        try {
            mpJwtConfig = mpJwtTaiRequest.getOnlyMatchingConfig();
        }
        catch (MpJwtProcessingException mpJwtProcessingException) {
            FFDCFilter.processException((Throwable)mpJwtProcessingException, (String)"com.ibm.ws.security.mp.jwt.tai.TAIRequestHelper", (String)"84", (Object)this, (Object[])new Object[]{request, mpJwtTaiRequest});
        }
        if (mpJwtConfig != null) {
            ignoreAppAuthMethod = mpJwtConfig.ignoreApplicationAuthMethod();
        }
        result = ignoreAppAuthMethod ? mpJwtTaiRequest.hasServices() : this.isMpJwtSpecifiedInLoginConfig(request);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)result);
        }
        return result;
    }

    private boolean isMpJwtSpecifiedInLoginConfig(HttpServletRequest request) {
        if (request.getAttribute(APPLICATION_AUTH_METHOD) != null) {
            String loginCfg = (String)request.getAttribute(APPLICATION_AUTH_METHOD);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Auth method = ", (Object[])new Object[]{loginCfg});
                Tr.debug((TraceComponent)tc, (String)"isMpJwtSpecifiedInLoginConfig ", (Object[])new Object[]{AUTHN_TYPE.equals(loginCfg)});
            }
            if (!AUTHN_TYPE.equals(loginCfg)) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"MPJWT_NOT_FOUND_IN_APPLICATION", (Object[])new Object[]{AUTHN_TYPE, loginCfg, "ignoreApplicationAuthMethod", "false"});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"isMpJwtSpecifiedInLoginConfig ", (Object[])new Object[]{msg});
                }
            }
            return AUTHN_TYPE.equals(loginCfg);
        }
        String msg = Tr.formatMessage((TraceComponent)tc, (String)"MPJWT_NOT_FOUND_IN_APPLICATION", (Object[])new Object[]{AUTHN_TYPE, "null", "ignoreApplicationAuthMethod", "false"});
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isMpJwtSpecifiedInLoginConfig ", (Object[])new Object[]{msg});
        }
        return false;
    }

    @ManualTrace
    String getLoginHint(HttpServletRequest request) {
        String specifiedServiceId;
        String methodName = "getLoginHint";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{request});
        }
        if ((specifiedServiceId = this.getLoginHintFromHeaderOrParameter(request)) == null || specifiedServiceId.isEmpty()) {
            specifiedServiceId = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)specifiedServiceId);
        }
        return specifiedServiceId;
    }

    @ManualTrace
    String getLoginHintFromHeaderOrParameter(HttpServletRequest request) {
        String methodName = "getLoginHintFromHeaderOrParameter";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{request});
        }
        String specifiedServiceId = request.getHeader("mpjwt_login_hint");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("specifiedService(h) id:" + specifiedServiceId), (Object[])new Object[0]);
        }
        if (specifiedServiceId == null || specifiedServiceId.isEmpty()) {
            specifiedServiceId = request.getParameter("mpjwt_login_hint");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("specifiedService(p) id:" + specifiedServiceId), (Object[])new Object[0]);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)specifiedServiceId);
        }
        return specifiedServiceId;
    }

    @ManualTrace
    public String getBearerToken(HttpServletRequest req, MicroProfileJwtConfig clientConfig) {
        String token;
        String methodName = "getBearerToken";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{req, clientConfig});
        }
        if ((token = this.getBearerTokenFromHeader(req)) == null) {
            token = this.getBearerTokenFromParameter(req);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)token);
        }
        return token;
    }

    @ManualTrace
    String getBearerTokenFromHeader(HttpServletRequest req) {
        String methodName = "getBearerTokenFromHeader";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{req});
        }
        String hdrValue = req.getHeader(Authorization_Header);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Authorization header=", (Object[])new Object[]{hdrValue});
        }
        String bearerAuthzMethod = "Bearer ";
        if (hdrValue != null && hdrValue.startsWith(bearerAuthzMethod)) {
            hdrValue = hdrValue.substring(bearerAuthzMethod.length());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)hdrValue);
        }
        return hdrValue;
    }

    @ManualTrace
    String getBearerTokenFromParameter(HttpServletRequest req) {
        String methodName = "getBearerTokenFromParameter";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{req});
        }
        String param = null;
        String reqMethod = req.getMethod();
        if (REQ_METHOD_POST.equalsIgnoreCase(reqMethod)) {
            String contentType = req.getHeader(REQ_CONTENT_TYPE_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Request content type: " + contentType), (Object[])new Object[0]);
            }
            if (REQ_CONTENT_TYPE_APP_FORM_URLENCODED.equals(contentType)) {
                param = req.getParameter(ACCESS_TOKEN);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, param);
        }
        return param;
    }

    @ManualTrace
    MicroProfileJwtTaiRequest setTaiRequestConfigInfo(HttpServletRequest request, String specifiedServiceId, MicroProfileJwtTaiRequest mpJwtTaiRequest) {
        String methodName = "setTaiRequestConfigInfo";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{request, specifiedServiceId, mpJwtTaiRequest});
        }
        if (specifiedServiceId == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Specific config ID not provided, so will set generic config information for MpJwtTaiRequest object", (Object[])new Object[0]);
            }
            MicroProfileJwtTaiRequest result = this.setGenericAndFilteredConfigTaiRequestInfo(request, mpJwtTaiRequest);
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, (Object)result);
            }
            return result;
        }
        MicroProfileJwtTaiRequest result = this.setSpecificConfigTaiRequestInfo(request, specifiedServiceId, mpJwtTaiRequest);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)result);
        }
        return result;
    }

    @ManualTrace
    MicroProfileJwtTaiRequest setGenericAndFilteredConfigTaiRequestInfo(HttpServletRequest request, MicroProfileJwtTaiRequest mpJwtTaiRequest) {
        String methodName = "setGenericAndFilteredConfigTaiRequestInfo";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{request, mpJwtTaiRequest});
        }
        if (mpJwtTaiRequest == null) {
            mpJwtTaiRequest = this.createMicroProfileJwtTaiRequestAndSetRequestAttribute(request);
        }
        Iterator<MicroProfileJwtConfig> services = this.getConfigServices();
        MicroProfileJwtTaiRequest result = this.setGenericAndFilteredConfigTaiRequestInfoFromConfigServices(request, mpJwtTaiRequest, services);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)result);
        }
        return result;
    }

    @ManualTrace
    MicroProfileJwtTaiRequest setGenericAndFilteredConfigTaiRequestInfoFromConfigServices(HttpServletRequest request, MicroProfileJwtTaiRequest mpJwtTaiRequest, Iterator<MicroProfileJwtConfig> services) {
        String methodName = "setGenericAndFilteredConfigTaiRequestInfoFromConfigServices";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{request, mpJwtTaiRequest, services});
        }
        if (services == null) {
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, (Object)mpJwtTaiRequest);
            }
            return mpJwtTaiRequest;
        }
        if (mpJwtTaiRequest == null) {
            mpJwtTaiRequest = this.createMicroProfileJwtTaiRequestAndSetRequestAttribute(request);
        }
        while (services.hasNext()) {
            MicroProfileJwtConfig mpJwtConfig = services.next();
            mpJwtTaiRequest.addGenericConfig(mpJwtConfig);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)mpJwtTaiRequest);
        }
        return mpJwtTaiRequest;
    }

    @ManualTrace
    MicroProfileJwtTaiRequest setSpecificConfigTaiRequestInfo(HttpServletRequest request, String configId, MicroProfileJwtTaiRequest mpJwtTaiRequest) {
        MicroProfileJwtConfig config;
        String methodName = "setSpecificConfigTaiRequestInfo";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{request, configId, mpJwtTaiRequest});
        }
        if (mpJwtTaiRequest == null) {
            mpJwtTaiRequest = this.createMicroProfileJwtTaiRequestAndSetRequestAttribute(request);
        }
        if ((config = this.getConfigAssociatedWithRequestAndId(request, configId)) == null) {
            mpJwtTaiRequest = this.handleNoMatchingConfiguration(configId, mpJwtTaiRequest);
        } else {
            mpJwtTaiRequest.setSpecifiedConfig(config);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)mpJwtTaiRequest);
        }
        return mpJwtTaiRequest;
    }

    MicroProfileJwtTaiRequest handleNoMatchingConfiguration(String configId, MicroProfileJwtTaiRequest mpJwtTaiRequest) {
        String msg = Tr.formatMessage((TraceComponent)tc, (String)"MPJWT_NO_SUCH_PROVIDER", (Object[])new Object[]{configId});
        Tr.error((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
        MpJwtProcessingException mpjwtException = new MpJwtProcessingException(msg);
        mpJwtTaiRequest.setTaiException(mpjwtException);
        return mpJwtTaiRequest;
    }

    @ManualTrace
    MicroProfileJwtConfig getConfigAssociatedWithRequestAndId(HttpServletRequest request, String configId) {
        String methodName = "getConfigAssociatedWithRequestAndId";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{request, configId});
        }
        MicroProfileJwtConfig mpJwtConfig = this.getConfig(configId);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)mpJwtConfig);
        }
        return mpJwtConfig;
    }

    Iterator<MicroProfileJwtConfig> getConfigServices() {
        return MicroProfileJwtTAI.getServices();
    }

    MicroProfileJwtConfig getConfig(String configId) {
        return MicroProfileJwtTAI.getMicroProfileJwtConfig(configId);
    }
}

