/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.ssl.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.channel.ssl.internal.SSLConnectionLink;
import com.ibm.ws.channel.ssl.internal.exception.SocketEstablishedSSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.tcpchannel.SSLConnectionContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class SSLConnectionContextImpl
implements SSLConnectionContext {
    protected static final TraceComponent tc = Tr.register(SSLConnectionContextImpl.class, (String)"SSLChannel", (String)"com.ibm.ws.channel.ssl.internal.resources.SSLChannelMessages");
    private SSLConnectionLink sslConnLink = null;
    private boolean isOutbound = false;
    private String alpnProtocol = null;

    public SSLConnectionContextImpl(SSLConnectionLink connLink, boolean connectionOutbound) {
        this.sslConnLink = connLink;
        this.isOutbound = connectionOutbound;
    }

    public String[] getEnabledCipherSuites() {
        return this.sslConnLink.getSSLEngine().getEnabledCipherSuites();
    }

    public String[] getEnabledProtocols() {
        return this.sslConnLink.getSSLEngine().getEnabledProtocols();
    }

    public void setEnabledProtocols(String[] args) {
        this.sslConnLink.getSSLEngine().setEnabledProtocols(args);
    }

    public boolean getEnableSessionCreation() {
        return this.sslConnLink.getSSLEngine().getEnableSessionCreation();
    }

    public boolean getNeedClientAuth() {
        return this.sslConnLink.getSSLEngine().getNeedClientAuth();
    }

    public SSLSession getSession() {
        return this.sslConnLink.getSSLEngine().getSession();
    }

    public boolean getUseClientMode() {
        return this.sslConnLink.getSSLEngine().getUseClientMode();
    }

    public boolean getWantClientAuth() {
        return this.sslConnLink.getSSLEngine().getWantClientAuth();
    }

    public void setEnabledCipherSuites(String[] suites) throws SSLException {
        if (!this.isOutbound) {
            throw new SocketEstablishedSSLException("Error, established setting cannot be modified.");
        }
        this.sslConnLink.getSSLEngine().setEnabledCipherSuites(suites);
    }

    public void setEnableSessionCreation(boolean flag) throws SSLException {
        if (!this.isOutbound) {
            throw new SocketEstablishedSSLException("Error, established setting cannot be modified.");
        }
        this.sslConnLink.getSSLEngine().setEnableSessionCreation(flag);
    }

    public void setNeedClientAuth(boolean flag) throws SSLException {
        if (!this.isOutbound) {
            throw new SocketEstablishedSSLException("Error, established setting cannot be modified.");
        }
        this.sslConnLink.getSSLEngine().setNeedClientAuth(flag);
    }

    public void setWantClientAuth(boolean flag) throws SSLException {
        if (!this.isOutbound) {
            throw new SocketEstablishedSSLException("Error, established setting cannot be modified.");
        }
        this.sslConnLink.getSSLEngine().setWantClientAuth(flag);
    }

    public void setUseClientMode(boolean flag) throws SSLException {
        if (!this.isOutbound) {
            throw new SocketEstablishedSSLException("Error, established setting cannot be modified.");
        }
        this.sslConnLink.getSSLEngine().setUseClientMode(flag);
    }

    public void renegotiate() {
        block2: {
            try {
                this.sslConnLink.getSSLEngine().beginHandshake();
            }
            catch (SSLException se) {
                FFDCFilter.processException((Throwable)se, (String)(this.getClass().getName() + ".renegotiate"), (String)"1");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Error while attempting handshake renegotiation; " + se), (Object[])new Object[0]);
            }
        }
    }

    public String getAlpnProtocol() {
        return this.alpnProtocol;
    }

    public void setAlpnProtocol(String protocol) {
        this.alpnProtocol = protocol;
    }
}

