/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.ssl.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.channel.ssl.internal.SSLConnectionLink;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;

public class SSLAlpnNegotiatorJdk8 {
    private static final TraceComponent tc = Tr.register(SSLAlpnNegotiatorJdk8.class, (String)"SSLChannel", (String)"com.ibm.ws.channel.ssl.internal.resources.SSLChannelMessages");
    private final String h1 = "http/1.1";
    private final String h2 = "h2";
    private final String unknown = "";
    private static boolean grizzlyAlpnPresent = false;
    private static boolean jettyAlpnPresent = false;
    private static Class<?> jettyAlpn;
    private static Class<?> jettyServerProviderInterface;
    private static Class<?> jettyProviderInterface;
    private static Class<?> grizzlyNegotiationSupport;
    private static Class<?> grizzlyAlpnClientNegotiator;
    private static Class<?> grizzlyAlpnServerNegotiator;
    private static Object grizzlyNegotiationSupportObject;

    protected boolean isGrizzlyAlpnActive() {
        return grizzlyAlpnPresent;
    }

    protected boolean isJettyAlpnActive() {
        return jettyAlpnPresent;
    }

    protected void tryToRegisterAlpnNegotiator(SSLEngine engine, SSLConnectionLink link) {
        if (this.isJettyAlpnActive()) {
            this.registerJettyAlpn(engine, link);
        } else if (this.isGrizzlyAlpnActive()) {
            this.registerGrizzlyAlpn(engine, link);
        }
    }

    protected void registerGrizzlyAlpn(SSLEngine engine, SSLConnectionLink link) {
        block8: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("registerGrizzlyAlpn entry " + engine), (Object[])new Object[0]);
            }
            if (grizzlyNegotiationSupport != null && grizzlyAlpnClientNegotiator != null && grizzlyAlpnServerNegotiator != null && grizzlyNegotiationSupportObject != null) {
                try {
                    GrizzlyAlpnNegotiator negotiator = new GrizzlyAlpnNegotiator(engine, link);
                    if (!engine.getUseClientMode()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("initializeAlpn invoke AlpnServerNegotiator " + engine), (Object[])new Object[0]);
                        }
                        Method m = grizzlyNegotiationSupport.getMethod("addNegotiator", SSLEngine.class, grizzlyAlpnServerNegotiator);
                        m.invoke(grizzlyNegotiationSupportObject, engine, Proxy.newProxyInstance(grizzlyAlpnServerNegotiator.getClassLoader(), new Class[]{grizzlyAlpnServerNegotiator}, (InvocationHandler)negotiator));
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("initializeAlpn invoke AlpnClientNegotiator " + engine), (Object[])new Object[0]);
                        }
                        Method m = grizzlyNegotiationSupport.getMethod("addNegotiator", SSLEngine.class, grizzlyAlpnClientNegotiator);
                        m.invoke(grizzlyNegotiationSupportObject, engine, Proxy.newProxyInstance(grizzlyAlpnClientNegotiator.getClassLoader(), new Class[]{grizzlyAlpnClientNegotiator}, (InvocationHandler)negotiator));
                    }
                }
                catch (Exception e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                    Tr.debug((TraceComponent)tc, (String)("registerGrizzlyAlpn grizzly-npn exception: " + e), (Object[])new Object[0]);
                }
            }
        }
    }

    protected void registerJettyAlpn(SSLEngine engine, SSLConnectionLink link) {
        block3: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("registerJettyAlpn entry " + engine), (Object[])new Object[0]);
            }
            try {
                JettyServerNegotiator negotiator = new JettyServerNegotiator(engine, link);
                Method m = jettyAlpn.getMethod("put", SSLEngine.class, jettyProviderInterface);
                m.invoke(null, engine, Proxy.newProxyInstance(jettyServerProviderInterface.getClassLoader(), new Class[]{jettyServerProviderInterface}, (InvocationHandler)negotiator));
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("registerJettyAlpn jetty-alpn exception: " + e), (Object[])new Object[0]);
            }
        }
    }

    static {
        try {
            jettyAlpn = ClassLoader.getSystemClassLoader().loadClass("org.eclipse.jetty.alpn.ALPN");
            jettyServerProviderInterface = ClassLoader.getSystemClassLoader().loadClass("org.eclipse.jetty.alpn.ALPN$ServerProvider");
            jettyProviderInterface = ClassLoader.getSystemClassLoader().loadClass("org.eclipse.jetty.alpn.ALPN$Provider");
            jettyAlpnPresent = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"jetty-alpn module was found on the classpath; ALPN is available", (Object[])new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!jettyAlpnPresent) {
                grizzlyNegotiationSupport = ClassLoader.getSystemClassLoader().loadClass("org.glassfish.grizzly.npn.NegotiationSupport");
                grizzlyAlpnServerNegotiator = ClassLoader.getSystemClassLoader().loadClass("org.glassfish.grizzly.npn.AlpnServerNegotiator");
                grizzlyAlpnClientNegotiator = ClassLoader.getSystemClassLoader().loadClass("org.glassfish.grizzly.npn.AlpnClientNegotiator");
                grizzlyNegotiationSupportObject = grizzlyNegotiationSupport.newInstance();
                grizzlyAlpnPresent = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"grizzly-npn module was found on the classpath; ALPN is available", (Object[])new Object[0]);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public class GrizzlyAlpnNegotiator
    implements InvocationHandler {
        private final SSLEngine engine;
        private final SSLConnectionLink link;

        public GrizzlyAlpnNegotiator(SSLEngine e, SSLConnectionLink l) {
            this.engine = e;
            this.link = l;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("invoke entry" + method), (Object[])new Object[0]);
            }
            if ((methodName = method.getName()).equals("selectProtocol")) {
                if (args != null && args.length == 2 && args[0] instanceof SSLEngine && args[1] instanceof String[]) {
                    return this.selectProtocol((SSLEngine)args[0], (String[])args[1]);
                }
                if (args != null && args.length == 2 && args[0] instanceof SSLEngine && args[1] instanceof String) {
                    this.selectProtocol((SSLEngine)args[0], (String)args[1]);
                }
            }
            return null;
        }

        protected String selectProtocol(SSLEngine engine, String[] protocolList) {
            this.removeServerNegotiatorEngine();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("selectProtocol entry engine: " + engine + " protocols: " + protocolList), (Object[])new Object[0]);
            }
            if (engine != null && protocolList != null && protocolList.length > 0) {
                if (Arrays.asList(protocolList).contains("h2")) {
                    if (this.link != null) {
                        this.link.setAlpnProtocol("h2");
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("selectProtocol protocol h2 selected" + engine), (Object[])new Object[0]);
                    }
                    return "h2";
                }
                if (Arrays.asList(protocolList).contains("http/1.1")) {
                    if (this.link != null) {
                        this.link.setAlpnProtocol("http/1.1");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("selectProtocol protocol http/1.1 selected" + engine), (Object[])new Object[0]);
                        }
                    }
                    return "http/1.1";
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("selectProtocol no protocol matched, returning http/1.1" + engine), (Object[])new Object[0]);
            }
            return "http/1.1";
        }

        protected void selectProtocol(SSLEngine engine, String protocol) {
            this.removeClientNegotiatorEngine();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("selectProtocol entry engine: " + engine + " protocol: " + protocol), (Object[])new Object[0]);
            }
            if (engine != null && protocol != null) {
                if (protocol.equals("h2")) {
                    if (this.link != null) {
                        this.link.setAlpnProtocol("h2");
                    }
                } else if (protocol.equals("http/1.1") && this.link != null) {
                    this.link.setAlpnProtocol("http/1.1");
                }
            }
        }

        public void removeServerNegotiatorEngine() {
            block2: {
                try {
                    Method m = grizzlyNegotiationSupport.getMethod("removeAlpnServerNegotiator", SSLEngine.class);
                    m.invoke(grizzlyNegotiationSupportObject, this.engine);
                }
                catch (Throwable t) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                    Tr.debug((TraceComponent)tc, (String)("removeEngine failed\n" + t), (Object[])new Object[0]);
                }
            }
        }

        public void removeClientNegotiatorEngine() {
            block2: {
                try {
                    Method m = grizzlyNegotiationSupport.getMethod("removeAlpnClientNegotiator", SSLEngine.class);
                    m.invoke(grizzlyNegotiationSupportObject, this.engine);
                }
                catch (Throwable t) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                    Tr.debug((TraceComponent)tc, (String)("removeEngine failed\n" + t), (Object[])new Object[0]);
                }
            }
        }
    }

    public class JettyServerNegotiator
    implements InvocationHandler {
        private final SSLEngine engine;
        private final SSLConnectionLink link;

        public JettyServerNegotiator(SSLEngine e, SSLConnectionLink l) {
            this.engine = e;
            this.link = l;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("invoke entry" + method), (Object[])new Object[0]);
            }
            if ((methodName = method.getName()).equals("select")) {
                if (args != null && args.length == 1 && args[0] instanceof List) {
                    return this.select((List)args[0]);
                }
            } else if (methodName.equals("unsupported") && args == null) {
                this.unsupported();
            }
            return null;
        }

        public String select(List<String> protocols) throws SSLException {
            this.removeEngine();
            if (protocols.contains("h2")) {
                if (this.link != null) {
                    this.link.setAlpnProtocol("h2");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("select protocol h2 selected" + this.engine), (Object[])new Object[0]);
                }
                return "h2";
            }
            if (protocols.contains("http/1.1")) {
                if (this.link != null) {
                    this.link.setAlpnProtocol("http/1.1");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("select protocol http/1.1 selected" + this.engine), (Object[])new Object[0]);
                    }
                }
                return "http/1.1";
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("select no protocol matched, returning http/1.1" + this.engine), (Object[])new Object[0]);
            }
            return "http/1.1";
        }

        public void unsupported() {
            this.removeEngine();
        }

        public void removeEngine() {
            block2: {
                try {
                    Method m = jettyAlpn.getMethod("remove", SSLEngine.class);
                    m.invoke(null, this.engine);
                }
                catch (Throwable t) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                    Tr.debug((TraceComponent)tc, (String)("removeEngine failed\n" + t), (Object[])new Object[0]);
                }
            }
        }
    }
}

