/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.utils;

import com.ibm.ws.session.utils.IIDGenerator;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.security.Security;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IDGeneratorImpl
implements IIDGenerator {
    private static boolean _loggedVersion = false;
    private int _sessionIDLength = 0;
    private static final char[] sBitChars = new char[]{'G', '9', 'U', 'i', 'b', 'w', '-', '8', '6', 'z', 'u', 'p', 'J', 'R', 'S', 'h', 'K', '5', 'n', 'c', '4', 'C', 't', 'I', 'W', '7', 'F', 'e', 'M', 'g', 'q', '2', '3', 'V', 'Z', 'k', 'O', 'D', 'a', 'v', 'y', 'Y', 'P', 'X', 'E', 'N', '1', 'f', 'l', 'B', '0', 'L', 's', 'o', 'A', 'T', 'd', 'x', 'm', 'r', 'Q', '_', 'j', 'H'};
    private static final int[] sSecondByteMasks = new int[]{0, 1, 3, 7, 15, 31, 63};
    private SecureRandom _random = null;
    private int _byteArraySize = 0;
    private static final String methodClassName = "IDGeneratorImpl";
    protected static Logger logger = Logger.getLogger("com.ibm.ws.util", "com.ibm.ws.session.resources.WASSessionCore");

    public IDGeneratorImpl() {
        this(23);
    }

    public IDGeneratorImpl(int sessionIDLength) {
        if (logger.isLoggable(Level.FINE) && !_loggedVersion) {
            logger.logp(Level.FINE, methodClassName, "", "CMVC Version 1.3 3/13/07 12:00:47");
            _loggedVersion = true;
        }
        this._sessionIDLength = sessionIDLength;
        this._byteArraySize = sessionIDLength * 6 / 8 + 1;
        String jceProvider = IDGeneratorImpl.getSystemProperty("DEFAULT_JCE_PROVIDER");
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, methodClassName, methodClassName, "JCE Provider is " + jceProvider);
        }
        try {
            this._random = SecureRandom.getInstance("IBMSecureRandom", jceProvider);
        }
        catch (Exception e) {
            logger.logp(Level.INFO, methodClassName, methodClassName, "SessionIdGeneratorImpl.UsingDefaultSecureRandom");
            this._random = new SecureRandom();
        }
        byte[] genBytes = new byte[this._byteArraySize];
        this._random.nextBytes(genBytes);
        this._random.setSeed(System.currentTimeMillis());
        this._random.setSeed(Thread.currentThread().getName().hashCode());
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(methodClassName, methodClassName, "length = " + sessionIDLength);
        }
    }

    public static String getSystemProperty(final String key) {
        String value = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Security.getProperty(key);
            }
        });
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getID() {
        byte[] genBytes = new byte[this._byteArraySize];
        SecureRandom secureRandom = this._random;
        synchronized (secureRandom) {
            this._random.nextBytes(genBytes);
        }
        String id = IDGeneratorImpl.convertSessionIdBytesToSessionId(genBytes, this._sessionIDLength);
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, methodClassName, "getSessionID", "sessionID=" + id);
        }
        return id;
    }

    public static String convertSessionIdBytesToSessionId(byte[] pBytes, int sessionIdLength) {
        char[] chars = new char[sessionIdLength];
        int byteNum = 0;
        int bitNum = 0;
        int pos = 0;
        while (byteNum < pBytes.length && pos < sessionIdLength) {
            int val = 0;
            if (bitNum < 3) {
                val = pBytes[byteNum] >> 2 - bitNum & 0x3F;
            } else {
                val = pBytes[byteNum] << 6 - (8 - bitNum);
                if (byteNum + 1 < pBytes.length) {
                    int secondVal = (pBytes[byteNum + 1] & 0xFF) >> 8 - (6 - (8 - bitNum));
                    val |= (secondVal &= sSecondByteMasks[6 - (8 - bitNum)]);
                }
                val &= 0x3F;
            }
            chars[pos++] = sBitChars[val];
            if ((bitNum += 6) < 8) continue;
            ++byteNum;
            bitNum -= 8;
        }
        return new String(chars);
    }
}

