/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.hpel;

import com.ibm.websphere.logging.WsLevel;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.kernel.boot.logging.LoggerHandlerManager;
import com.ibm.ws.logging.RoutedMessage;
import com.ibm.ws.logging.internal.hpel.HpelTraceServiceConfig;
import com.ibm.ws.logging.internal.hpel.HpelTraceServiceWriter;
import com.ibm.ws.logging.internal.impl.BaseTraceService;
import com.ibm.ws.logging.internal.impl.LogProviderConfigImpl;
import com.ibm.ws.logging.internal.impl.RoutedMessageImpl;
import com.ibm.wsspi.logging.MessageRouter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class HpelBaseTraceService
extends BaseTraceService {
    private final HpelTraceServiceWriter trWriter = new HpelTraceServiceWriter(this);

    public void echo(BaseTraceService.SystemLogHolder holder, LogRecord logRecord) {
        if (this.copySystemStreams) {
            this.writeFilteredStreamOutput(holder, logRecord);
        }
        this.trWriter.repositoryPublish(logRecord);
    }

    boolean notifyConsole(LogRecord logRecord) {
        int levelValue = logRecord.getLevel().intValue();
        if (levelValue >= Level.INFO.intValue()) {
            boolean logNormally;
            String txt = this.formatter.formatMessage(logRecord);
            MessageRouter router = (MessageRouter)this.externalMessageRouter.get();
            if (router != null && !(logNormally = router.route(txt, logRecord))) {
                return false;
            }
            if (levelValue >= this.consoleLogLevel.intValue()) {
                if (levelValue == WsLevel.ERROR.intValue() || levelValue == WsLevel.FATAL.intValue()) {
                    this.writeStreamOutput(this.systemErr, this.formatter.consoleLogFormat(logRecord, txt), false);
                } else {
                    this.writeStreamOutput(this.systemOut, this.formatter.consoleLogFormat(logRecord, txt), false);
                }
            }
        }
        return true;
    }

    public void publishLogRecord(LogRecord logRecord) {
        String formattedMsg = null;
        String formattedVerboseMsg = null;
        Level level = logRecord.getLevel();
        int levelValue = level.intValue();
        if (levelValue >= Level.INFO.intValue()) {
            String messageLogFormat;
            boolean logNormally;
            if (!(this.externalMessageRouter.get() == null && this.internalMessageRouter.get() == null || (logNormally = this.invokeMessageRouters((RoutedMessage)new RoutedMessageImpl(formattedMsg = this.formatter.formatMessage(logRecord), formattedVerboseMsg = this.formatter.formatVerboseMessage(logRecord, formattedMsg), messageLogFormat = this.formatter.messageLogFormat(logRecord, formattedVerboseMsg), logRecord))))) {
                return;
            }
            this.trWriter.repositoryPublish(logRecord);
        } else if (TraceComponent.isAnyTracingEnabled()) {
            BaseTraceService.TraceWriter detailLog = this.traceLog;
            this.publishTraceLogRecord(detailLog, logRecord, NULL_ID, formattedMsg, formattedVerboseMsg);
        }
    }

    protected void publishTraceLogRecord(BaseTraceService.TraceWriter detailLog, LogRecord logRecord, Object id, String formattedMsg, String formattedVerboseMsg) {
        if (formattedVerboseMsg == null) {
            formattedVerboseMsg = this.formatter.formatVerboseMessage(logRecord, formattedMsg, false);
        }
        this.invokeTraceRouters((RoutedMessage)new RoutedMessageImpl(formattedMsg, formattedVerboseMsg, null, logRecord));
        this.trWriter.repositoryPublish(logRecord);
    }

    protected void initializeWriters(LogProviderConfigImpl config) {
        this.trWriter.configure((HpelTraceServiceConfig)config);
    }

    protected void registerLoggerHandlerSingleton() {
        LoggerHandlerManager.setSingleton((Handler)new Handler(){

            @Override
            public void publish(LogRecord logRecord) {
                HpelBaseTraceService.this.publishLogRecord(logRecord);
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        });
    }

    protected void unregisterLoggerHandlerSingleton() {
        LoggerHandlerManager.unsetSingleton();
        this.trWriter.stop();
    }
}

