/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.main;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ras.instrument.internal.bci.LibertyTracingClassAdapter;
import com.ibm.ws.ras.instrument.internal.main.LibertyJava8WorkaroundRuntimeTransformer;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.ref.WeakReference;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.TraceClassVisitor;

public class LibertyRuntimeTransformer
implements ClassFileTransformer {
    private static final TraceComponent tc = Tr.register(LibertyRuntimeTransformer.class, (String)"logging", (String)"com.ibm.ws.logging.internal.resources.LoggingMessages");
    private static final boolean isIBMVirtualMachine = System.getProperty("java.vm.name", "unknown").contains("IBM J9") || System.getProperty("java.vm.name", "unknown").contains("OpenJ9");
    private static final boolean isSunVirtualMachine = System.getProperty("java.vm.name", "unknown").contains("HotSpot");
    private static final boolean detailedTransformTrace = Boolean.getBoolean("com.ibm.ws.logging.instrumentation.detail.enabled");
    private static Instrumentation instrumentation;
    private static LibertyRuntimeTransformer registeredTransformer;
    private static Map<Class<?>, WeakReference<TraceComponent>> traceComponentByClass;
    private static boolean injectAtTransform;
    private static boolean skipDebugData;
    private static final Boolean isJDK8WithHotReplaceBug;

    public static synchronized void setInstrumentation(Instrumentation inst) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setInstrumentation", (Object[])new Object[]{inst});
        }
        if ((instrumentation = inst) != null) {
            if (Boolean.getBoolean("com.ibm.websphere.ras.inject.at.transform")) {
                LibertyRuntimeTransformer.setInjectAtTransform(true);
            } else if (!instrumentation.isRetransformClassesSupported()) {
                Tr.info((TraceComponent)tc, (String)"INSTRUMENTATION_RETRANSFORM_NOT_SUPPORTED", (Object[])new Object[0]);
                LibertyRuntimeTransformer.setInjectAtTransform(true);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setInstrumentation");
        }
    }

    protected static void setInjectAtTransform(boolean injectAtTransform) {
        LibertyRuntimeTransformer.injectAtTransform = injectAtTransform;
        if (injectAtTransform) {
            LibertyRuntimeTransformer.addTransformer();
        }
    }

    protected static void setSkipDebugData(boolean skipDebugData) {
        LibertyRuntimeTransformer.skipDebugData = skipDebugData;
    }

    private static synchronized void addTransformer() {
        if (detailedTransformTrace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addTransformer", (Object[])new Object[0]);
        }
        if (registeredTransformer == null && instrumentation != null) {
            registeredTransformer = new LibertyRuntimeTransformer();
            instrumentation.addTransformer(registeredTransformer, true);
        }
        if (detailedTransformTrace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addTransformer");
        }
    }

    private static boolean isTransformPossible(byte[] bytes) {
        if (bytes.length < 8) {
            return false;
        }
        int classFileVersion = (bytes[6] & 0xFF) << 8 | bytes[7] & 0xFF;
        if (isJDK8WithHotReplaceBug.booleanValue()) {
            return classFileVersion <= 51;
        }
        return classFileVersion <= 55;
    }

    public static void traceStateChanged(TraceComponent traceComponent) {
        Class traceClass;
        if (instrumentation == null) {
            return;
        }
        if (!injectAtTransform && traceComponent.isEntryEnabled() && (traceClass = traceComponent.getTraceClass()) != null && traceClass != LibertyRuntimeTransformer.class) {
            LibertyRuntimeTransformer.addTransformer();
            traceComponentByClass.put(traceClass, new WeakReference<TraceComponent>(traceComponent));
            LibertyRuntimeTransformer.retransformClass(traceClass);
        }
    }

    private static final void retransformClass(Class<?> clazz) {
        if (detailedTransformTrace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"retransformClass", (Object[])new Object[]{clazz});
        }
        try {
            instrumentation.retransformClasses(clazz);
        }
        catch (Throwable t) {
            Tr.error((TraceComponent)tc, (String)"INSTRUMENTATION_TRANSFORM_FAILED_FOR_CLASS_2", (Object[])new Object[]{clazz.getName(), t});
        }
        if (detailedTransformTrace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"retransformClass");
        }
    }

    public static byte[] transform(byte[] bytes) throws IOException {
        return LibertyRuntimeTransformer.transform(bytes, true);
    }

    public static byte[] transform(byte[] bytes, boolean skipIfNotPreprocessed) throws IOException {
        byte[] result;
        if (detailedTransformTrace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"transform", (Object[])new Object[0]);
        }
        ClassReader reader = new ClassReader(bytes);
        ClassWriter writer = new ClassWriter(reader, 1);
        StringWriter sw = null;
        ClassWriter visitor = writer;
        if (tc.isDumpEnabled()) {
            sw = new StringWriter();
            visitor = new CheckClassAdapter((ClassVisitor)visitor, false);
            visitor = new TraceClassVisitor((ClassVisitor)visitor, new PrintWriter(sw));
        }
        LibertyTracingClassAdapter tracingClassAdapter = new LibertyTracingClassAdapter((ClassVisitor)visitor, skipIfNotPreprocessed);
        try {
            reader.accept((ClassVisitor)tracingClassAdapter, skipDebugData ? 2 : 0);
        }
        catch (Throwable t) {
            IOException ioe = new IOException("Unable to instrument class stream with trace: " + t.getMessage(), t);
            throw ioe;
        }
        if (detailedTransformTrace && tc.isDumpEnabled() && tracingClassAdapter.isClassModified()) {
            Tr.dump((TraceComponent)tc, (String)"Transformed class", (Object[])new Object[]{sw});
        }
        byte[] byArray = result = tracingClassAdapter.isClassModified() ? writer.toByteArray() : null;
        if (detailedTransformTrace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"transform", (Object)result);
        }
        return result;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (detailedTransformTrace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"transform", (Object[])new Object[]{loader, className, classBeingRedefined, protectionDomain});
        }
        byte[] newClassBytes = null;
        if (LibertyRuntimeTransformer.isTransformPossible(classfileBuffer)) {
            boolean traceEnabledForClass = injectAtTransform;
            if (!injectAtTransform && classBeingRedefined != null) {
                WeakReference<TraceComponent> tcReference = traceComponentByClass.get(classBeingRedefined);
                TraceComponent traceComponent = tcReference == null ? null : (TraceComponent)tcReference.get();
                traceEnabledForClass |= traceComponent != null && traceComponent.isEntryEnabled();
            }
            if (traceEnabledForClass) {
                try {
                    newClassBytes = LibertyRuntimeTransformer.transform(classfileBuffer);
                }
                catch (Throwable t) {
                    Tr.error((TraceComponent)tc, (String)"INSTRUMENTATION_TRANSFORM_FAILED_FOR_CLASS_2", (Object[])new Object[]{className, t});
                }
            }
        }
        if (detailedTransformTrace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"transform", (Object)newClassBytes);
        }
        return newClassBytes;
    }

    static {
        registeredTransformer = null;
        traceComponentByClass = Collections.synchronizedMap(new WeakHashMap());
        injectAtTransform = false;
        skipDebugData = false;
        isJDK8WithHotReplaceBug = LibertyJava8WorkaroundRuntimeTransformer.checkJDK8WithHotReplaceBug() != false ? Boolean.TRUE : Boolean.FALSE;
    }
}

