/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.strategies.writeable;

import org.osgi.framework.Version;

public class Version4Digit
implements Comparable<Version4Digit> {
    private int major = -1;
    private int minor = -1;
    private int micro = -1;
    private String qualifier = null;

    public Version4Digit(int major, int minor, int micro) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = "";
    }

    public Version4Digit(int major, int minor, int micro, String s) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = s;
    }

    public Version4Digit(Version version) {
        this.major = version.getMajor();
        this.minor = version.getMinor();
        this.micro = version.getMicro();
        this.qualifier = version.getQualifier();
    }

    public Version4Digit(String versionString) {
        try {
            Version v = new Version(versionString);
            this.major = v.getMajor();
            this.minor = v.getMinor();
            this.micro = v.getMicro();
            this.qualifier = v.getQualifier();
        }
        catch (IllegalArgumentException eae) {
            String[] bits = versionString.split("\\.");
            if (bits.length != 4) {
                throw eae;
            }
            try {
                this.major = Integer.parseInt(bits[0]);
                this.minor = Integer.parseInt(bits[1]);
                this.micro = Integer.parseInt(bits[2]);
            }
            catch (NumberFormatException e) {
                throw eae;
            }
            this.qualifier = bits[3];
        }
    }

    @Override
    public int compareTo(Version4Digit that) {
        if (this.equals(that)) {
            return 0;
        }
        if (this.getMajor() > that.getMajor()) {
            return 1;
        }
        if (that.getMajor() > this.getMajor()) {
            return -1;
        }
        if (this.getMinor() > that.getMinor()) {
            return 1;
        }
        if (that.getMinor() > this.getMinor()) {
            return -1;
        }
        if (this.getMicro() > that.getMicro()) {
            return 1;
        }
        if (that.getMicro() > this.getMicro()) {
            return -1;
        }
        try {
            if (this.getiQualifier() > that.getiQualifier()) {
                return 1;
            }
            if (that.getiQualifier() > this.getiQualifier()) {
                return -1;
            }
        }
        catch (NumberFormatException e) {
            return this.qualifier.compareTo(that.qualifier);
        }
        return 0;
    }

    public static Version4Digit getHigherVersion(Version4Digit v1, Version4Digit v2) {
        int i = v1.compareTo(v2);
        if (i > 0) {
            return v1;
        }
        if (i < 0) {
            return v2;
        }
        return null;
    }

    private int getiQualifier() {
        return Integer.parseInt(this.qualifier);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.micro;
        result = 31 * result + this.minor;
        result = 31 * result + (this.qualifier == null ? 0 : this.qualifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version4Digit other = (Version4Digit)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.micro != other.micro) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        return !(this.qualifier == null ? other.qualifier != null : !this.qualifier.equals(other.qualifier));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major);
        sb.append(".");
        sb.append(this.minor);
        sb.append(".");
        sb.append(this.micro);
        if (this.qualifier != null && !this.qualifier.equals("")) {
            sb.append(".");
            sb.append(this.qualifier);
        }
        return sb.toString();
    }
}

