/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.provisioning.packages;

import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;

public class PackageIndex<T>
implements FFDCSelfIntrospectable,
Iterable<T> {
    private static final String WILDCARD = "*";
    private static String nl = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("line.separator");
        }
    });
    protected final Node<T> root = new Node("");

    public synchronized boolean add(String key, T value) {
        if (key.length() > 3 && key.endsWith(WILDCARD) && key.charAt(key.length() - 2) != '.') {
            throw new IllegalArgumentException("Unsupported use of wildcard in key " + key);
        }
        Node<T> current = this.internalFind(key, false);
        if (current.getValue() != null) {
            return false;
        }
        current.setValue(value);
        return true;
    }

    public T find(String key) {
        Node<T> current = this.internalFind(key, true);
        return current == null ? null : (T)current.getValue();
    }

    private Node<T> internalFind(String key, boolean search) {
        int lastPos = 0;
        int nextDot = -1;
        Node<T> current = this.root;
        Node wildcard = null;
        boolean done = false;
        while (!done) {
            String segment;
            nextDot = key.indexOf(46, lastPos);
            if (nextDot > 0) {
                segment = key.substring(lastPos, nextDot);
            } else {
                segment = key.substring(lastPos);
                done = true;
            }
            if (search) {
                Node<T> next;
                if (current.wildcardKid != null) {
                    wildcard = current.wildcardKid;
                }
                if ((next = current.findChild(segment)) == null) {
                    if (wildcard == null) {
                        return null;
                    }
                    current = wildcard;
                } else {
                    current = next;
                }
            } else {
                current = current.findOrCreateChild(segment);
            }
            lastPos = nextDot + 1;
        }
        return current;
    }

    public void compact() {
        NodeIterator<T> i = this.getNodeIterator();
        while (i.hasNext()) {
            Object n = i.next();
            if (((NodeIndex)n).node.exactKids == null) continue;
            ((NodeIndex)n).node.exactKids.trimToSize();
        }
    }

    public String dump() {
        StringBuilder s = new StringBuilder();
        int c = 0;
        s.append(nl);
        NodeIterator<T> i = this.getNodeIterator(null);
        while (i.hasNext()) {
            Object n = i.next();
            ++c;
            s.append('\t').append(((NodeIndex)n).pkg).append(" = ").append(((NodeIndex)n).node.getValue()).append(nl);
        }
        s.append("\t---> ").append(c).append(" elements");
        return s.toString();
    }

    public String[] introspectSelf() {
        return new String[]{this.dump()};
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(null);
    }

    public Iterator<T> iterator(Filter<T> valueFilter) {
        final NodeIterator<T> nodeIterator = this.getNodeIterator(valueFilter);
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return nodeIterator.hasNext();
            }

            @Override
            public T next() {
                Object n = nodeIterator.next();
                return ((NodeIndex)n).getValue();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<String> packageIterator() {
        return this.packageIterator(null);
    }

    public Iterator<String> packageIterator(Filter<T> valueFilter) {
        final NodeIterator<T> nodeIterator = this.getNodeIterator(valueFilter);
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return nodeIterator.hasNext();
            }

            @Override
            public String next() {
                Object n = nodeIterator.next();
                return ((NodeIndex)n).pkg;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    NodeIterator<T> getNodeIterator(Filter<T> filter) {
        return new NodeIterator<T>(this.root, filter, true);
    }

    NodeIterator<T> getNodeIterator() {
        return new NodeIterator<T>(this.root, null, false);
    }

    static class NodeIndex<T> {
        final int kidSize;
        final Node<T> node;
        final boolean hasWildcard;
        final String pkg;
        int kidIndex = 0;
        boolean visitedWidcard = false;

        NodeIndex(String pkgRoot, Node<T> node) {
            String segment;
            this.node = node;
            this.kidSize = node.exactKids == null ? 0 : node.exactKids.size();
            boolean bl = this.hasWildcard = node.wildcardKid != null;
            this.pkg = pkgRoot == null ? null : ((segment = node.getSegment()).isEmpty() ? "" : (pkgRoot.isEmpty() ? segment : pkgRoot + "." + segment));
        }

        public T getValue() {
            return this.node.value;
        }

        boolean hasValue() {
            return this.node.value != null;
        }

        boolean hasMoreKids() {
            return this.kidIndex < this.kidSize || this.hasWildcard && !this.visitedWidcard;
        }

        Node<T> getNextKid() {
            if (this.kidIndex < this.kidSize) {
                return this.node.exactKids.get(this.kidIndex++);
            }
            if (this.hasWildcard && !this.visitedWidcard) {
                this.visitedWidcard = true;
                return this.node.wildcardKid;
            }
            return null;
        }

        public String toString() {
            return "(" + this.pkg + ", kids=" + this.kidIndex + "/" + this.kidSize + ", wildcard=" + this.hasWildcard + "/" + this.visitedWidcard + ", value=" + this.node.value + ")";
        }
    }

    static class NodeIterator<T>
    implements Iterator<NodeIndex<T>> {
        private final NodeIndex<T> rootIdx;
        private final Stack<NodeIndex<T>> nodeStack;
        private final Filter<T> valueFilter;
        private NodeIndex<T> currentNode = null;

        NodeIterator(Node<T> root, Filter<T> valueFilter, boolean buildPackageName) {
            this.rootIdx = new NodeIndex<T>(buildPackageName ? "" : null, root);
            this.nodeStack = new Stack();
            this.nodeStack.push(this.rootIdx);
            this.valueFilter = valueFilter != null ? valueFilter : new Filter<T>(){

                @Override
                public boolean includeValue(String packageName, T value) {
                    return true;
                }
            };
        }

        @Override
        public boolean hasNext() {
            while (this.currentNode == null && !this.nodeStack.isEmpty()) {
                this.currentNode = this.nodeStack.pop();
                while (this.currentNode.hasMoreKids()) {
                    this.nodeStack.push(this.currentNode);
                    this.currentNode = new NodeIndex<T>(this.currentNode.pkg, this.currentNode.getNextKid());
                }
                if (this.currentNode.hasValue() && this.valueFilter.includeValue(this.currentNode.pkg, this.currentNode.getValue())) continue;
                this.currentNode = null;
            }
            return this.currentNode != null;
        }

        @Override
        public NodeIndex<T> next() {
            NodeIndex<T> n = this.currentNode;
            this.currentNode = null;
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface Filter<T> {
        public boolean includeValue(String var1, T var2);
    }

    static class Node<T> {
        Node<T> wildcardKid = null;
        ArrayList<Node<T>> exactKids = null;
        final String seg;
        T value = null;

        public Node(String seg) {
            this.seg = seg;
        }

        public String getSegment() {
            return this.seg;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public Node<T> findOrCreateChild(String segment) {
            Node<T> result;
            if (segment.equals(PackageIndex.WILDCARD)) {
                if (this.wildcardKid == null) {
                    this.wildcardKid = new Node<T>(PackageIndex.WILDCARD);
                }
                result = this.wildcardKid;
            } else {
                if (this.exactKids == null) {
                    this.exactKids = new ArrayList(5);
                }
                result = this.insert(segment, this.exactKids);
            }
            return result;
        }

        public Node<T> findChild(String segment) {
            if (this.exactKids != null) {
                for (Node<T> n : this.exactKids) {
                    if (!segment.equals(n.getSegment())) continue;
                    return n;
                }
            }
            return null;
        }

        private Node<T> insert(String newSegment, List<Node<T>> list) {
            Node<T> result = null;
            if (list.isEmpty()) {
                result = new Node<T>(newSegment);
                list.add(result);
            } else {
                ListIterator<Node<T>> i = list.listIterator();
                while (i.hasNext()) {
                    Node<T> next = i.next();
                    String s = next.getSegment();
                    int c = newSegment.compareTo(s);
                    if (c == 0) {
                        result = next;
                        break;
                    }
                    if (c <= 0) continue;
                    i.previous();
                    break;
                }
                if (result == null) {
                    result = new Node<T>(newSegment);
                    i.add(result);
                }
            }
            return result;
        }

        public String toString() {
            return "Node[seg=" + this.seg + ", *=" + (this.wildcardKid != null ? 1 : 0) + ", exact=" + (this.exactKids != null ? this.exactKids.size() : 0) + "]";
        }
    }
}

