/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.launch.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.DataFormatHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.LibertyProcess;
import com.ibm.ws.kernel.boot.BootstrapConfig;
import com.ibm.ws.kernel.boot.ClientRunnerException;
import com.ibm.ws.kernel.boot.LaunchArguments;
import com.ibm.ws.kernel.boot.LaunchException;
import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.boot.internal.FileUtils;
import com.ibm.ws.kernel.boot.internal.KernelStartLevel;
import com.ibm.ws.kernel.boot.internal.commands.JavaDumpAction;
import com.ibm.ws.kernel.boot.internal.commands.JavaDumper;
import com.ibm.ws.kernel.boot.internal.commands.ServerDumpUtil;
import com.ibm.ws.kernel.boot.jmx.internal.PlatformMBeanServerBuilder;
import com.ibm.ws.kernel.boot.jmx.internal.PlatformMBeanServerBuilderListener;
import com.ibm.ws.kernel.boot.jmx.service.MBeanServerPipeline;
import com.ibm.ws.kernel.launch.internal.FrameworkConfigurator;
import com.ibm.ws.kernel.launch.internal.LibertyProcessImpl;
import com.ibm.ws.kernel.launch.internal.MissingDoPrivDetectionSecurityManager;
import com.ibm.ws.kernel.launch.internal.PauseableComponentControllerImpl;
import com.ibm.ws.kernel.launch.internal.Provisioner;
import com.ibm.ws.kernel.launch.internal.ProvisionerImpl;
import com.ibm.ws.kernel.launch.internal.ServerCommandListener;
import com.ibm.ws.kernel.launch.internal.ThreadIdentityManagerConfigurator;
import com.ibm.ws.kernel.launch.internal.TraceInstrumentation;
import com.ibm.ws.kernel.launch.service.ClientRunner;
import com.ibm.ws.kernel.launch.service.ForcedServerStop;
import com.ibm.ws.kernel.launch.service.FrameworkReady;
import com.ibm.ws.kernel.launch.service.PauseableComponentController;
import com.ibm.ws.kernel.launch.service.PauseableComponentControllerRequestFailedException;
import com.ibm.ws.kernel.launch.service.ServerContent;
import com.ibm.ws.kernel.launch.service.ServerFeatures;
import com.ibm.ws.kernel.productinfo.DuplicateProductInfoException;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.kernel.productinfo.ProductInfoParseException;
import com.ibm.ws.kernel.productinfo.ProductInfoReplaceException;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.logging.IntrospectableService;
import com.ibm.wsspi.logging.Introspector;
import com.ibm.wsspi.logprovider.LogProvider;
import io.openliberty.checkpoint.spi.CheckpointHook;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FrameworkManager {
    private static final TraceComponent tc = Tr.register(FrameworkManager.class, (String)"bootstrap", (String)"com.ibm.ws.kernel.boot.resources.LauncherMessages");
    private static final List<String> licLangs = Arrays.asList("cs", "de", "el", "es", "fr", "in", "it", "ja", "ko", "lt", "pl", "pt", "ru", "sl", "tr", "zh", "zh_TW");
    protected volatile ServerCommandListener sc;
    protected ShutdownHook shutdownHook;
    protected BootstrapConfig config;
    protected ClassLoader fwkClassloader;
    protected Framework framework;
    protected final CountDownLatch frameworkLatch;
    protected boolean frameworkLaunchSuccess;
    protected final CountDownLatch frameworkLaunched;
    protected final CountDownLatch frameworkShutdownLatch;
    protected BundleContext systemBundleCtx;
    protected long startTime;
    private ThreadIdentityManagerConfigurator threadIdentityManagerTracker;
    private ClientRunner clientRunner;
    private final CountDownLatch serverListenerLatch;
    private static final String MANAGER_DIR_NAME = ".manager";
    private static final String OSGI_DIR_NAME = "org.eclipse.osgi";
    static final long serialVersionUID = 909905336707081274L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    public FrameworkManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object[])new Object[0]);
        }
        this.sc = null;
        this.config = null;
        this.framework = null;
        this.frameworkLatch = new CountDownLatch(1);
        this.frameworkLaunched = new CountDownLatch(1);
        this.frameworkShutdownLatch = new CountDownLatch(1);
        this.serverListenerLatch = new CountDownLatch(1);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    public void launchFramework(BootstrapConfig config, LogProvider logProvider) {
        block168: {
            Framework fwk;
            boolean isClient;
            block164: {
                block165: {
                    if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                        Tr.entry((Object)this, (TraceComponent)tc, (String)"launchFramework", (Object[])new Object[]{config, logProvider});
                    }
                    if (config == null) {
                        throw new IllegalArgumentException("bootstrap config must not be null");
                    }
                    isClient = config.getProcessType().equals("client");
                    String nTime = config.get("kernel.launch.time");
                    long l = this.startTime = nTime == null ? System.nanoTime() : Long.parseLong(nTime);
                    if (isClient) {
                        Tr.audit((TraceComponent)tc, (String)"audit.launchTime.client", (Object[])new Object[]{config.getProcessName()});
                    } else {
                        Tr.audit((TraceComponent)tc, (String)"audit.launchTime", (Object[])new Object[]{config.getProcessName()});
                    }
                    this.outputLicenseRestrictionMessage();
                    this.outputEmbeddedProductExtensions();
                    this.outputEnvironmentVariableProductExtensions();
                    this.config = config;
                    boolean j2secManager = false;
                    if (config.get("websphere.java.security") != null) {
                        j2secManager = true;
                    }
                    String j2secNoRethrow = config.get("websphere.java.security.norethrow");
                    if (j2secManager) {
                        if (j2secNoRethrow == null || j2secNoRethrow.equals("false")) {
                            try {
                                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){
                                    static final long serialVersionUID = -3574127959770866429L;
                                    private static final /* synthetic */ TraceComponent $$$tc$$$;
                                    {
                                        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                                            Tr.entry((TraceComponent)$$$tc$$$, (String)"<init>", (Object[])new Object[]{FrameworkManager.this});
                                        }
                                        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                                            Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"<init>", (Object)this);
                                        }
                                    }

                                    @Override
                                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                                    public Void run() throws Exception {
                                        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                                            Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"run", (Object[])new Object[0]);
                                        }
                                        System.setSecurityManager(new SecurityManager());
                                        Void void_ = null;
                                        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                                            void_ = void_;
                                            Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"run", void_);
                                        }
                                        return void_;
                                    }

                                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                                    static {
                                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.launch.internal.FrameworkManager$1", 1.class, (String)"bootstrap", (String)"com.ibm.ws.kernel.boot.resources.LauncherMessages");
                                    }
                                });
                            }
                            catch (Exception exception) {
                                void ex;
                                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"245", (Object)this, (Object[])new Object[]{config, logProvider});
                                Tr.error((TraceComponent)tc, (String)"error.set.securitymanager", (Object[])new Object[]{ex.getMessage()});
                            }
                        } else {
                            if ("true".equals(config.get("websphere.java.security.unique"))) {
                                MissingDoPrivDetectionSecurityManager.setUniqueOnly(true);
                            }
                            try {
                                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){
                                    static final long serialVersionUID = -5771321187387388749L;
                                    private static final /* synthetic */ TraceComponent $$$tc$$$;
                                    {
                                        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                                            Tr.entry((TraceComponent)$$$tc$$$, (String)"<init>", (Object[])new Object[]{FrameworkManager.this});
                                        }
                                        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                                            Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"<init>", (Object)this);
                                        }
                                    }

                                    @Override
                                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                                    public Void run() throws Exception {
                                        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                                            Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"run", (Object[])new Object[0]);
                                        }
                                        System.setSecurityManager(new MissingDoPrivDetectionSecurityManager());
                                        Void void_ = null;
                                        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                                            void_ = void_;
                                            Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"run", void_);
                                        }
                                        return void_;
                                    }

                                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                                    static {
                                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.launch.internal.FrameworkManager$2", 2.class, (String)"bootstrap", (String)"com.ibm.ws.kernel.boot.resources.LauncherMessages");
                                    }
                                });
                            }
                            catch (Exception ex) {
                                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"260", (Object)this, (Object[])new Object[]{config, logProvider});
                                Tr.error((TraceComponent)tc, (String)"error.set.trace.securitymanager", (Object[])new Object[]{ex.getMessage()});
                            }
                        }
                        Tr.info((TraceComponent)tc, (String)"info.java2security.started", (Object[])new Object[]{config.getProcessName()});
                    }
                    if ((fwk = this.initFramework(config, logProvider)) != null) break block164;
                    Tr.error((TraceComponent)tc, (String)"error.unableToLaunch", (Object[])new Object[0]);
                    this.frameworkLatch.countDown();
                    try {
                        if (this.framework == null) break block165;
                        try {
                            this.addShutdownHook(isClient);
                            this.startServerCommandListener();
                            this.innerLaunchFramework(isClient);
                            Tr.info((TraceComponent)tc, (String)"audit.kernelStartTime", (Object[])new Object[]{this.getElapsedTime(false, new long[0])});
                            this.frameworkLaunchSuccess = true;
                            this.frameworkLaunched.countDown();
                        }
                        catch (Throwable throwable) {
                            this.frameworkLaunched.countDown();
                            try {
                                if (!this.frameworkLaunchSuccess) {
                                    this.stopFramework();
                                } else if (isClient) {
                                    try {
                                        if (this.waitForReady()) {
                                            this.launchClient();
                                        }
                                    }
                                    catch (InterruptedException interruptedException) {
                                        FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"309", (Object)this, (Object[])new Object[]{config, logProvider});
                                    }
                                    catch (Throwable throwable2) {
                                        void t;
                                        FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"311", (Object)this, (Object[])new Object[]{config, logProvider});
                                        throw new ClientRunnerException("Error while executing running the application", BootstrapConstants.messages.getString("error.client.runner"), (Throwable)t);
                                    }
                                    finally {
                                        this.stopFramework();
                                    }
                                }
                                this.waitForFrameworkStop();
                                this.removeShutdownHook();
                            }
                            catch (Throwable throwable3) {
                                this.waitForFrameworkStop();
                                this.removeShutdownHook();
                                try {
                                    this.serverListenerLatch.await(5L, TimeUnit.SECONDS);
                                }
                                catch (InterruptedException interruptedException) {
                                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"329", (Object)this, (Object[])new Object[]{config, logProvider});
                                    Thread.currentThread().interrupt();
                                }
                                if (this.sc != null) {
                                    this.sc.close();
                                }
                                if (!this.frameworkLaunchSuccess) throw throwable3;
                                if (isClient) {
                                    Tr.audit((TraceComponent)tc, (String)"audit.kernelUpTime.client", (Object[])new Object[]{config.getProcessName(), this.getElapsedTime(true, new long[0])});
                                    throw throwable3;
                                }
                                Tr.audit((TraceComponent)tc, (String)"audit.kernelUpTime", (Object[])new Object[]{config.getProcessName(), this.getElapsedTime(true, new long[0])});
                                throw throwable3;
                            }
                            try {
                                this.serverListenerLatch.await(5L, TimeUnit.SECONDS);
                            }
                            catch (InterruptedException t) {
                                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"329", (Object)this, (Object[])new Object[]{config, logProvider});
                                Thread.currentThread().interrupt();
                            }
                            if (this.sc != null) {
                                this.sc.close();
                            }
                            if (!this.frameworkLaunchSuccess) throw throwable;
                            if (isClient) {
                                Tr.audit((TraceComponent)tc, (String)"audit.kernelUpTime.client", (Object[])new Object[]{config.getProcessName(), this.getElapsedTime(true, new long[0])});
                                throw throwable;
                            }
                            Tr.audit((TraceComponent)tc, (String)"audit.kernelUpTime", (Object[])new Object[]{config.getProcessName(), this.getElapsedTime(true, new long[0])});
                            throw throwable;
                        }
                        try {
                            if (!this.frameworkLaunchSuccess) {
                                this.stopFramework();
                            } else if (isClient) {
                                try {
                                    if (this.waitForReady()) {
                                        this.launchClient();
                                    }
                                }
                                catch (InterruptedException interruptedException) {
                                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"309", (Object)this, (Object[])new Object[]{config, logProvider});
                                }
                                catch (Throwable throwable) {
                                    void t;
                                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"311", (Object)this, (Object[])new Object[]{config, logProvider});
                                    throw new ClientRunnerException("Error while executing running the application", BootstrapConstants.messages.getString("error.client.runner"), (Throwable)t);
                                }
                                finally {
                                    this.stopFramework();
                                }
                            }
                            this.waitForFrameworkStop();
                            this.removeShutdownHook();
                        }
                        catch (Throwable throwable) {
                            this.waitForFrameworkStop();
                            this.removeShutdownHook();
                            try {
                                this.serverListenerLatch.await(5L, TimeUnit.SECONDS);
                            }
                            catch (InterruptedException interruptedException) {
                                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"329", (Object)this, (Object[])new Object[]{config, logProvider});
                                Thread.currentThread().interrupt();
                            }
                            if (this.sc != null) {
                                this.sc.close();
                            }
                            if (!this.frameworkLaunchSuccess) throw throwable;
                            if (isClient) {
                                Tr.audit((TraceComponent)tc, (String)"audit.kernelUpTime.client", (Object[])new Object[]{config.getProcessName(), this.getElapsedTime(true, new long[0])});
                                throw throwable;
                            }
                            Tr.audit((TraceComponent)tc, (String)"audit.kernelUpTime", (Object[])new Object[]{config.getProcessName(), this.getElapsedTime(true, new long[0])});
                            throw throwable;
                        }
                        try {
                            this.serverListenerLatch.await(5L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException t) {
                            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"329", (Object)this, (Object[])new Object[]{config, logProvider});
                            Thread.currentThread().interrupt();
                        }
                        if (this.sc != null) {
                            this.sc.close();
                        }
                        if (!this.frameworkLaunchSuccess) break block165;
                        if (isClient) {
                            Tr.audit((TraceComponent)tc, (String)"audit.kernelUpTime.client", (Object[])new Object[]{config.getProcessName(), this.getElapsedTime(true, new long[0])});
                        } else {
                            Tr.audit((TraceComponent)tc, (String)"audit.kernelUpTime", (Object[])new Object[]{config.getProcessName(), this.getElapsedTime(true, new long[0])});
                        }
                    }
                    finally {
                        if (logProvider != null) {
                            logProvider.stop();
                        }
                        this.frameworkShutdownLatch.countDown();
                    }
                }
                if (!TraceComponent.isAnyTracingEnabled()) return;
                if (tc == null) return;
                if (!tc.isEntryEnabled()) return;
                Tr.exit((Object)this, (TraceComponent)tc, (String)"launchFramework");
                return;
            }
            this.systemBundleCtx = fwk.getBundleContext();
            this.framework = fwk;
            this.frameworkLatch.countDown();
            try {
                if (this.framework == null) break block168;
                try {
                    this.addShutdownHook(isClient);
                    this.startServerCommandListener();
                    this.innerLaunchFramework(isClient);
                    Tr.info((TraceComponent)tc, (String)"audit.kernelStartTime", (Object[])new Object[]{this.getElapsedTime(false, new long[0])});
                    this.frameworkLaunchSuccess = true;
                    this.frameworkLaunched.countDown();
                }
                catch (Throwable throwable) {
                    this.frameworkLaunched.countDown();
                    try {
                        if (!this.frameworkLaunchSuccess) {
                            this.stopFramework();
                        } else if (isClient) {
                            try {
                                if (this.waitForReady()) {
                                    this.launchClient();
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"309", (Object)this, (Object[])new Object[]{config, logProvider});
                            }
                            catch (Throwable throwable4) {
                                void t;
                                FFDCFilter.processException((Throwable)throwable4, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"311", (Object)this, (Object[])new Object[]{config, logProvider});
                                throw new ClientRunnerException("Error while executing running the application", BootstrapConstants.messages.getString("error.client.runner"), (Throwable)t);
                            }
                            finally {
                                this.stopFramework();
                            }
                        }
                        this.waitForFrameworkStop();
                        this.removeShutdownHook();
                    }
                    catch (Throwable throwable5) {
                        this.waitForFrameworkStop();
                        this.removeShutdownHook();
                        try {
                            this.serverListenerLatch.await(5L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException interruptedException) {
                            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"329", (Object)this, (Object[])new Object[]{config, logProvider});
                            Thread.currentThread().interrupt();
                        }
                        if (this.sc != null) {
                            this.sc.close();
                        }
                        if (!this.frameworkLaunchSuccess) throw throwable5;
                        if (isClient) {
                            Tr.audit((TraceComponent)tc, (String)"audit.kernelUpTime.client", (Object[])new Object[]{config.getProcessName(), this.getElapsedTime(true, new long[0])});
                            throw throwable5;
                        }
                        Tr.audit((TraceComponent)tc, (String)"audit.kernelUpTime", (Object[])new Object[]{config.getProcessName(), this.getElapsedTime(true, new long[0])});
                        throw throwable5;
                    }
                    try {
                        this.serverListenerLatch.await(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException t) {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"329", (Object)this, (Object[])new Object[]{config, logProvider});
                        Thread.currentThread().interrupt();
                    }
                    if (this.sc != null) {
                        this.sc.close();
                    }
                    if (!this.frameworkLaunchSuccess) throw throwable;
                    if (isClient) {
                        Tr.audit((TraceComponent)tc, (String)"audit.kernelUpTime.client", (Object[])new Object[]{config.getProcessName(), this.getElapsedTime(true, new long[0])});
                        throw throwable;
                    }
                    Tr.audit((TraceComponent)tc, (String)"audit.kernelUpTime", (Object[])new Object[]{config.getProcessName(), this.getElapsedTime(true, new long[0])});
                    throw throwable;
                }
                try {
                    if (!this.frameworkLaunchSuccess) {
                        this.stopFramework();
                    } else if (isClient) {
                        try {
                            if (this.waitForReady()) {
                                this.launchClient();
                            }
                        }
                        catch (InterruptedException nTime) {
                            FFDCFilter.processException((Throwable)nTime, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"309", (Object)this, (Object[])new Object[]{config, logProvider});
                        }
                        catch (Throwable nTime) {
                            void t;
                            FFDCFilter.processException((Throwable)nTime, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"311", (Object)this, (Object[])new Object[]{config, logProvider});
                            throw new ClientRunnerException("Error while executing running the application", BootstrapConstants.messages.getString("error.client.runner"), (Throwable)t);
                        }
                        finally {
                            this.stopFramework();
                        }
                    }
                    this.waitForFrameworkStop();
                    this.removeShutdownHook();
                }
                catch (Throwable throwable) {
                    this.waitForFrameworkStop();
                    this.removeShutdownHook();
                    try {
                        this.serverListenerLatch.await(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"329", (Object)this, (Object[])new Object[]{config, logProvider});
                        Thread.currentThread().interrupt();
                    }
                    if (this.sc != null) {
                        this.sc.close();
                    }
                    if (!this.frameworkLaunchSuccess) throw throwable;
                    if (isClient) {
                        Tr.audit((TraceComponent)tc, (String)"audit.kernelUpTime.client", (Object[])new Object[]{config.getProcessName(), this.getElapsedTime(true, new long[0])});
                        throw throwable;
                    }
                    Tr.audit((TraceComponent)tc, (String)"audit.kernelUpTime", (Object[])new Object[]{config.getProcessName(), this.getElapsedTime(true, new long[0])});
                    throw throwable;
                }
                try {
                    this.serverListenerLatch.await(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"329", (Object)this, (Object[])new Object[]{config, logProvider});
                    Thread.currentThread().interrupt();
                }
                if (this.sc != null) {
                    this.sc.close();
                }
                if (!this.frameworkLaunchSuccess) break block168;
                if (isClient) {
                    Tr.audit((TraceComponent)tc, (String)"audit.kernelUpTime.client", (Object[])new Object[]{config.getProcessName(), this.getElapsedTime(true, new long[0])});
                    break block168;
                } else {
                    Tr.audit((TraceComponent)tc, (String)"audit.kernelUpTime", (Object[])new Object[]{config.getProcessName(), this.getElapsedTime(true, new long[0])});
                }
                break block168;
            }
            finally {
                if (logProvider != null) {
                    logProvider.stop();
                }
                this.frameworkShutdownLatch.countDown();
            }
            catch (BundleException e) {
                try {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"280", (Object)this, (Object[])new Object[]{config, logProvider});
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    this.frameworkLatch.countDown();
                    try {
                        if (this.framework == null) throw throwable;
                        try {
                            this.addShutdownHook(isClient);
                            this.startServerCommandListener();
                            this.innerLaunchFramework(isClient);
                            Tr.info((TraceComponent)tc, (String)"audit.kernelStartTime", (Object[])new Object[]{this.getElapsedTime(false, new long[0])});
                            this.frameworkLaunchSuccess = true;
                            this.frameworkLaunched.countDown();
                        }
                        catch (Throwable throwable6) {
                            this.frameworkLaunched.countDown();
                            try {
                                if (!this.frameworkLaunchSuccess) {
                                    this.stopFramework();
                                } else if (isClient) {
                                    try {
                                        if (this.waitForReady()) {
                                            this.launchClient();
                                        }
                                    }
                                    catch (InterruptedException interruptedException) {
                                        FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"309", (Object)this, (Object[])new Object[]{config, logProvider});
                                    }
                                    catch (Throwable throwable7) {
                                        void t;
                                        FFDCFilter.processException((Throwable)throwable7, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"311", (Object)this, (Object[])new Object[]{config, logProvider});
                                        throw new ClientRunnerException("Error while executing running the application", BootstrapConstants.messages.getString("error.client.runner"), (Throwable)t);
                                    }
                                    finally {
                                        this.stopFramework();
                                    }
                                }
                                this.waitForFrameworkStop();
                                this.removeShutdownHook();
                            }
                            catch (Throwable throwable8) {
                                this.waitForFrameworkStop();
                                this.removeShutdownHook();
                                try {
                                    this.serverListenerLatch.await(5L, TimeUnit.SECONDS);
                                }
                                catch (InterruptedException interruptedException) {
                                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"329", (Object)this, (Object[])new Object[]{config, logProvider});
                                    Thread.currentThread().interrupt();
                                }
                                if (this.sc != null) {
                                    this.sc.close();
                                }
                                if (!this.frameworkLaunchSuccess) throw throwable8;
                                if (isClient) {
                                    Tr.audit((TraceComponent)tc, (String)"audit.kernelUpTime.client", (Object[])new Object[]{config.getProcessName(), this.getElapsedTime(true, new long[0])});
                                    throw throwable8;
                                }
                                Tr.audit((TraceComponent)tc, (String)"audit.kernelUpTime", (Object[])new Object[]{config.getProcessName(), this.getElapsedTime(true, new long[0])});
                                throw throwable8;
                            }
                            try {
                                this.serverListenerLatch.await(5L, TimeUnit.SECONDS);
                            }
                            catch (InterruptedException t) {
                                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"329", (Object)this, (Object[])new Object[]{config, logProvider});
                                Thread.currentThread().interrupt();
                            }
                            if (this.sc != null) {
                                this.sc.close();
                            }
                            if (!this.frameworkLaunchSuccess) throw throwable6;
                            if (isClient) {
                                Tr.audit((TraceComponent)tc, (String)"audit.kernelUpTime.client", (Object[])new Object[]{config.getProcessName(), this.getElapsedTime(true, new long[0])});
                                throw throwable6;
                            }
                            Tr.audit((TraceComponent)tc, (String)"audit.kernelUpTime", (Object[])new Object[]{config.getProcessName(), this.getElapsedTime(true, new long[0])});
                            throw throwable6;
                        }
                        try {
                            if (!this.frameworkLaunchSuccess) {
                                this.stopFramework();
                            } else if (isClient) {
                                try {
                                    if (this.waitForReady()) {
                                        this.launchClient();
                                    }
                                }
                                catch (InterruptedException interruptedException) {
                                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"309", (Object)this, (Object[])new Object[]{config, logProvider});
                                }
                                catch (Throwable throwable9) {
                                    void t;
                                    FFDCFilter.processException((Throwable)throwable9, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"311", (Object)this, (Object[])new Object[]{config, logProvider});
                                    throw new ClientRunnerException("Error while executing running the application", BootstrapConstants.messages.getString("error.client.runner"), (Throwable)t);
                                }
                                finally {
                                    this.stopFramework();
                                }
                            }
                            this.waitForFrameworkStop();
                            this.removeShutdownHook();
                        }
                        catch (Throwable throwable10) {
                            this.waitForFrameworkStop();
                            this.removeShutdownHook();
                            try {
                                this.serverListenerLatch.await(5L, TimeUnit.SECONDS);
                            }
                            catch (InterruptedException interruptedException) {
                                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"329", (Object)this, (Object[])new Object[]{config, logProvider});
                                Thread.currentThread().interrupt();
                            }
                            if (this.sc != null) {
                                this.sc.close();
                            }
                            if (!this.frameworkLaunchSuccess) throw throwable10;
                            if (isClient) {
                                Tr.audit((TraceComponent)tc, (String)"audit.kernelUpTime.client", (Object[])new Object[]{config.getProcessName(), this.getElapsedTime(true, new long[0])});
                                throw throwable10;
                            }
                            Tr.audit((TraceComponent)tc, (String)"audit.kernelUpTime", (Object[])new Object[]{config.getProcessName(), this.getElapsedTime(true, new long[0])});
                            throw throwable10;
                        }
                        try {
                            this.serverListenerLatch.await(5L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException t) {
                            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"329", (Object)this, (Object[])new Object[]{config, logProvider});
                            Thread.currentThread().interrupt();
                        }
                        if (this.sc != null) {
                            this.sc.close();
                        }
                        if (!this.frameworkLaunchSuccess) throw throwable;
                        if (isClient) {
                            Tr.audit((TraceComponent)tc, (String)"audit.kernelUpTime.client", (Object[])new Object[]{config.getProcessName(), this.getElapsedTime(true, new long[0])});
                            throw throwable;
                        }
                        Tr.audit((TraceComponent)tc, (String)"audit.kernelUpTime", (Object[])new Object[]{config.getProcessName(), this.getElapsedTime(true, new long[0])});
                        throw throwable;
                    }
                    finally {
                        if (logProvider != null) {
                            logProvider.stop();
                        }
                        this.frameworkShutdownLatch.countDown();
                    }
                }
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return;
        if (tc == null) return;
        if (!tc.isEntryEnabled()) return;
        Tr.exit((Object)this, (TraceComponent)tc, (String)"launchFramework");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    private void launchClient() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"launchClient", (Object[])new Object[0]);
        }
        ServiceReference reference = this.systemBundleCtx.getServiceReference(ClientRunner.class);
        ClientRunner clientRunner = this.clientRunner = reference == null ? null : (ClientRunner)this.systemBundleCtx.getService(reference);
        if (this.clientRunner == null) {
            Tr.error((TraceComponent)tc, (String)"error.client.runner.missing", (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"launchClient");
            }
            return;
        }
        this.clientRunner.run();
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"launchClient");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    private void outputLicenseRestrictionMessage() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"outputLicenseRestrictionMessage", (Object[])new Object[0]);
        }
        try {
            ProductInfo pi = ProductInfo.getAllProductInfo().get("com.ibm.websphere.appserver");
            if (pi != null && pi.getReplacedBy() == null) {
                String edition = String.valueOf(pi.getEdition()).toLowerCase();
                String licenseType = String.valueOf(pi.getProperty("com.ibm.websphere.productLicenseType")).toLowerCase();
                String key = "audit.licenseRestriction." + edition + '.' + licenseType;
                ResourceBundle rb = TraceNLS.getBaseResourceBundle(FrameworkManager.class, (String)tc.getResourceBundleName());
                if (rb.containsKey(key)) {
                    String file = FrameworkManager.getLang(Locale.getDefault()) + ".html";
                    Tr.audit((TraceComponent)tc, (String)key, (Object[])new Object[]{"https://public.dhe.ibm.com/ibmdl/export/pub/software/websphere/wasdev/license/" + edition + '/' + licenseType + '/' + pi.getVersion() + "/lafiles/" + file});
                }
            }
        }
        catch (ProductInfoParseException productInfoParseException) {
            FFDCFilter.processException((Throwable)productInfoParseException, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"389", (Object)this, (Object[])new Object[0]);
        }
        catch (DuplicateProductInfoException duplicateProductInfoException) {
            FFDCFilter.processException((Throwable)duplicateProductInfoException, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"390", (Object)this, (Object[])new Object[0]);
        }
        catch (ProductInfoReplaceException productInfoReplaceException) {
            FFDCFilter.processException((Throwable)productInfoReplaceException, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"391", (Object)this, (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"outputLicenseRestrictionMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    private void outputEmbeddedProductExtensions() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"outputEmbeddedProductExtensions", (Object[])new Object[0]);
        }
        String embededData = System.getProperty("PRODUCT_EXTENSIONS_ADDED_BY_EMBEDDER");
        if (embededData != null) {
            String[] extensions = embededData.split("\n");
            for (int i = 0; i < extensions.length && i + 3 <= extensions.length; i += 3) {
                Tr.info((TraceComponent)tc, (String)"info.addProductExtension", (Object[])new Object[]{extensions[i], extensions[i + 1], extensions[i + 2]});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"outputEmbeddedProductExtensions");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    private void outputEnvironmentVariableProductExtensions() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"outputEnvironmentVariableProductExtensions", (Object[])new Object[0]);
        }
        String envData = System.getProperty("PRODUCT_EXTENSIONS_ADDED_BY_ENV");
        if (envData != null) {
            String[] extensions = envData.split("\n");
            for (int i = 0; i < extensions.length && i + 3 <= extensions.length; i += 3) {
                Tr.info((TraceComponent)tc, (String)"info.envProductExtension", (Object[])new Object[]{extensions[i], extensions[i + 1], extensions[i + 2]});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"outputEnvironmentVariableProductExtensions");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    private static String getLang(Locale l) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLang", (Object[])new Object[]{l});
        }
        String lang = "en";
        String option = l.getLanguage() + '_' + l.getCountry();
        if (licLangs.contains(option)) {
            lang = option;
        } else if (licLangs.contains(l.getLanguage())) {
            lang = l.getLanguage();
        }
        String string = lang;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            string = string;
            Tr.exit((TraceComponent)tc, (String)"getLang", (Object)string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    @FFDCIgnore(value={Provisioner.InvalidBundleContextException.class, LaunchException.class})
    protected void innerLaunchFramework(boolean isClient) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"innerLaunchFramework", (Object[])new Object[]{isClient});
        }
        try {
            this.registerInstrumentationService(this.systemBundleCtx);
            this.registerLibertyProcessService(this.systemBundleCtx, this.config);
            this.preRegisterMBeanServerPipelineService(this.systemBundleCtx);
            this.openThreadIdentityTracker(this.systemBundleCtx);
            this.registerPauseableComponentController(this.systemBundleCtx);
            BundleRepositoryRegistry.initializeDefaults(this.config.getProcessName(), true, isClient);
            ProvisionerImpl provisioner = new ProvisionerImpl();
            provisioner.initialProvisioning(this.systemBundleCtx, this.config);
            this.config.getKernelResolver().dispose();
        }
        catch (LaunchException le) {
            throw le;
        }
        catch (Provisioner.InvalidBundleContextException invalidBundleContextException) {
            // empty catch block
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"innerLaunchFramework");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    private void registerLibertyProcessService(BundleContext systemBundleCtx, BootstrapConfig config) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"registerLibertyProcessService", (Object[])new Object[]{systemBundleCtx, config});
        }
        List<String> cmds = config.getCmdArgs();
        if (cmds == null) {
            cmds = new ArrayList<String>();
        }
        LibertyProcessImpl processImpl = new LibertyProcessImpl(cmds, this);
        systemBundleCtx.registerService(LibertyProcess.class.getName(), (Object)processImpl, processImpl.getServiceProps());
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"registerLibertyProcessService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    protected void registerInstrumentationService(BundleContext systemContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"registerInstrumentationService", (Object[])new Object[]{systemContext});
        }
        Instrumentation inst = this.config.getInstrumentation();
        if (inst != null) {
            inst = (Instrumentation)Proxy.newProxyInstance(TraceInstrumentation.class.getClassLoader(), new Class[]{Instrumentation.class}, (InvocationHandler)new TraceInstrumentation(inst));
            Hashtable svcProps = new Hashtable();
            systemContext.registerService(Instrumentation.class.getName(), (Object)inst, svcProps);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"registerInstrumentationService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    protected void registerPauseableComponentController(BundleContext systemContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"registerPauseableComponentController", (Object[])new Object[]{systemContext});
        }
        PauseableComponentControllerImpl pauseableComponentController = new PauseableComponentControllerImpl(systemContext);
        if (pauseableComponentController != null) {
            Hashtable svcProps = new Hashtable();
            systemContext.registerService(PauseableComponentController.class.getName(), (Object)pauseableComponentController, svcProps);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"registerPauseableComponentController");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    private void preRegisterMBeanServerPipelineService(final BundleContext systemContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"preRegisterMBeanServerPipelineService", (Object[])new Object[]{systemContext});
        }
        PlatformMBeanServerBuilder.addPlatformMBeanServerBuilderListener(new PlatformMBeanServerBuilderListener(){
            static final long serialVersionUID = -4943351993778574101L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;
            {
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.entry((TraceComponent)$$$tc$$$, (String)"<init>", (Object[])new Object[]{FrameworkManager.this, bundleContext});
                }
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"<init>", (Object)this);
                }
            }

            @Override
            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            @FFDCIgnore(value={IllegalStateException.class})
            public void platformMBeanServerCreated(final MBeanServerPipeline pipeline) {
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"platformMBeanServerCreated", (Object[])new Object[]{pipeline});
                }
                if (pipeline != null) {
                    final Hashtable svcProps = new Hashtable();
                    try {
                        AccessController.doPrivileged(new PrivilegedAction<Void>(){
                            static final long serialVersionUID = 5475664542308805993L;
                            private static final /* synthetic */ TraceComponent $$$tc$$$;
                            {
                                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                                    Tr.entry((TraceComponent)$$$tc$$$, (String)"<init>", (Object[])new Object[]{this, mBeanServerPipeline, hashtable});
                                }
                                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                                    Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"<init>", (Object)this);
                                }
                            }

                            @Override
                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                            public Void run() {
                                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                                    Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"run", (Object[])new Object[0]);
                                }
                                systemContext.registerService(MBeanServerPipeline.class.getName(), (Object)pipeline, (Dictionary)svcProps);
                                Void void_ = null;
                                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                                    void_ = void_;
                                    Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"run", void_);
                                }
                                return void_;
                            }

                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                            static {
                                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.launch.internal.FrameworkManager$3$1", 1.class, (String)"bootstrap", (String)"com.ibm.ws.kernel.boot.resources.LauncherMessages");
                            }
                        });
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"platformMBeanServerCreated");
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.launch.internal.FrameworkManager$3", 3.class, (String)"bootstrap", (String)"com.ibm.ws.kernel.boot.resources.LauncherMessages");
            }
        });
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"preRegisterMBeanServerPipelineService");
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    protected Framework initFramework(BootstrapConfig config, final LogProvider logProvider) throws BundleException {
        Framework framework;
        Framework fwk2;
        block10: {
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"initFramework", (Object[])new Object[]{config, logProvider});
            }
            config.put("org.osgi.framework.startlevel.beginning", Integer.toString(KernelStartLevel.OSGI_INIT.getLevel()));
            this.fwkClassloader = config.getFrameworkClassloader();
            FrameworkFactory fwkFactory = FrameworkConfigurator.getFrameworkFactory(this.fwkClassloader);
            fwk2 = fwkFactory.newFramework(config.getFrameworkProperties());
            if (fwk2 != null) break block10;
            Framework framework2 = null;
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                framework2 = framework2;
                Tr.exit((Object)this, (TraceComponent)tc, (String)"initFramework", framework2);
            }
            return framework2;
        }
        try {
            String phaseProp;
            fwk2.init();
            if (LaunchArguments.isBetaEdition() && (phaseProp = config.get("io.openliberty.checkpoint")) != null) {
                CheckpointPhase phase = CheckpointPhase.getPhase(phaseProp);
                BundleContext fwkContext = fwk2.getBundleContext();
                fwkContext.registerService(CheckpointPhase.class, (Object)phase, FrameworkUtil.asDictionary(Collections.singletonMap("io.openliberty.checkpoint", phase)));
                fwkContext.registerService(CheckpointHook.class, (Object)new CheckpointHook(){
                    static final long serialVersionUID = 6758218565430280734L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;
                    {
                        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                            Tr.entry((TraceComponent)$$$tc$$$, (String)"<init>", (Object[])new Object[]{FrameworkManager.this, logProvider2});
                        }
                        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                            Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"<init>", (Object)this);
                        }
                    }

                    @Override
                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    public void prepare() {
                        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                            Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"prepare", (Object[])new Object[0]);
                        }
                        logProvider.stop();
                        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                            Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"prepare");
                        }
                    }

                    @Override
                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    public void restore() {
                        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                            Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"restore", (Object[])new Object[0]);
                        }
                        Map<String, String> configMap = Collections.singletonMap("RESTORE_ENABLED", "true");
                        TrConfigurator.update(configMap);
                        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                            Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"restore");
                        }
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.launch.internal.FrameworkManager$4", 4.class, (String)"bootstrap", (String)"com.ibm.ws.kernel.boot.resources.LauncherMessages");
                    }
                }, FrameworkUtil.asDictionary(Collections.singletonMap("service.ranking", Integer.MIN_VALUE)));
            }
            framework = fwk2;
        }
        catch (BundleException fwk2) {
            void ex;
            FFDCFilter.processException((Throwable)fwk2, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"598", (Object)this, (Object[])new Object[]{config, logProvider});
            throw ex;
        }
        catch (RuntimeException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"600", (Object)this, (Object[])new Object[]{config, logProvider});
            if (!this.handleEquinoxRuntimeException(ex)) {
                throw ex;
            }
            Framework framework3 = null;
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                framework3 = framework3;
                Tr.exit((Object)this, (TraceComponent)tc, (String)"initFramework", framework3);
            }
            return framework3;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            framework = framework;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"initFramework", (Object)framework);
        }
        return framework;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    private boolean handleEquinoxRuntimeException(RuntimeException ex) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"handleEquinoxRuntimeException", (Object[])new Object[]{ex});
        }
        Throwable cause = ex.getCause();
        if (cause != null && cause instanceof IOException) {
            File osgiDir = this.config.getWorkareaFile(OSGI_DIR_NAME);
            if (!(osgiDir.exists() && osgiDir.isDirectory() && osgiDir.canWrite())) {
                Tr.error((TraceComponent)tc, (String)"error.serverDirPermission", (Object[])new Object[]{osgiDir.getAbsolutePath()});
                boolean bl = true;
                if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                    bl = bl;
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"handleEquinoxRuntimeException", (Object)bl);
                }
                return bl;
            }
            File managerDir = new File(osgiDir, MANAGER_DIR_NAME);
            if (!(managerDir.exists() && managerDir.isDirectory() && managerDir.canWrite())) {
                Tr.error((TraceComponent)tc, (String)"error.serverDirPermission", (Object[])new Object[]{managerDir.getAbsolutePath()});
                boolean bl = true;
                if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                    bl = bl;
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"handleEquinoxRuntimeException", (Object)bl);
                }
                return bl;
            }
        }
        boolean bl = false;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            bl = bl;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"handleEquinoxRuntimeException", (Object)bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    private Framework waitForFramework() throws InterruptedException {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"waitForFramework", (Object[])new Object[0]);
        }
        this.frameworkLatch.await();
        Framework framework = this.framework;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            framework = framework;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"waitForFramework", (Object)framework);
        }
        return framework;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    public boolean waitForReady() throws InterruptedException {
        Collection readyServiceRefs;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"waitForReady", (Object[])new Object[0]);
        }
        if (this.waitForFramework() == null) {
            boolean bl = false;
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                bl = bl;
                Tr.exit((Object)this, (TraceComponent)tc, (String)"waitForReady", (Object)bl);
            }
            return bl;
        }
        this.frameworkLaunched.await();
        if (!this.frameworkLaunchSuccess) {
            boolean bl = false;
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                bl = bl;
                Tr.exit((Object)this, (TraceComponent)tc, (String)"waitForReady", (Object)bl);
            }
            return bl;
        }
        try {
            readyServiceRefs = this.systemBundleCtx.getServiceReferences(FrameworkReady.class, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            void e;
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"669", (Object)this, (Object[])new Object[0]);
            throw new IllegalStateException((Throwable)e);
        }
        catch (IllegalStateException e) {
            void ex;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"671", (Object)this, (Object[])new Object[0]);
            if (this.framework.getState() != 32) {
                this.waitForFrameworkStop();
                boolean bl = false;
                if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                    bl = bl;
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"waitForReady", (Object)bl);
                }
                return bl;
            }
            throw ex;
        }
        if (readyServiceRefs != null) {
            for (ServiceReference readyServiceRef : readyServiceRefs) {
                FrameworkReady ready = (FrameworkReady)this.systemBundleCtx.getService(readyServiceRef);
                if (ready == null) continue;
                ready.waitForFrameworkReady();
            }
        }
        if (this.framework.getState() != 32) {
            this.waitForFrameworkStop();
            boolean bl = false;
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                bl = bl;
                Tr.exit((Object)this, (TraceComponent)tc, (String)"waitForReady", (Object)bl);
            }
            return bl;
        }
        boolean bl = true;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            bl = bl;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"waitForReady", (Object)bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    void shutdownCommand(boolean force) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"shutdownCommand", (Object[])new Object[]{force});
        }
        if (force) {
            this.systemBundleCtx.registerService(ForcedServerStop.class, (Object)new ForcedServerStop(), null);
        }
        this.shutdownFramework();
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"shutdownCommand");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    public void shutdownFramework() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"shutdownFramework", (Object[])new Object[0]);
        }
        try {
            if (this.waitForFramework() != null) {
                this.stopFramework();
            }
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"724", (Object)this, (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"shutdownFramework");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    public void waitForShutdown() throws InterruptedException {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"waitForShutdown", (Object[])new Object[0]);
        }
        this.frameworkShutdownLatch.await();
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"waitForShutdown");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    @FFDCIgnore(value={Exception.class})
    protected void stopFramework() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"stopFramework", (Object[])new Object[0]);
        }
        try {
            this.framework.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"stopFramework");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    @FFDCIgnore(value={InterruptedException.class})
    protected void waitForFrameworkStop() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"waitForFrameworkStop", (Object[])new Object[0]);
        }
        try {
            FrameworkEvent rc;
            while ((rc = this.framework.waitForStop(0L)).getType() == 128) {
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"waitForFrameworkStop");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    private void addShutdownHook(boolean isClient) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"addShutdownHook", (Object[])new Object[]{isClient});
        }
        if (this.shutdownHook == null) {
            this.shutdownHook = new ShutdownHook(isClient);
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"addShutdownHook");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    @FFDCIgnore(value={IllegalStateException.class})
    private void removeShutdownHook() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"removeShutdownHook", (Object[])new Object[0]);
        }
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"removeShutdownHook");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    protected void startServerCommandListener() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"startServerCommandListener", (Object[])new Object[0]);
        }
        Thread listeningThread = new Thread("kernel-command-listener"){
            static final long serialVersionUID = 1085512137574898304L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;
            {
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.entry((TraceComponent)$$$tc$$$, (String)"<init>", (Object[])new Object[]{FrameworkManager.this, arg0});
                }
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"<init>", (Object)this);
                }
            }

            @Override
            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            public void run() {
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"run", (Object[])new Object[0]);
                }
                String uuid = FrameworkManager.this.systemBundleCtx.getProperty("org.osgi.framework.uuid");
                FrameworkManager.this.sc = new ServerCommandListener(FrameworkManager.this.config, uuid, FrameworkManager.this, this, FrameworkManager.this.systemBundleCtx);
                FrameworkManager.this.serverListenerLatch.countDown();
                FrameworkManager.this.sc.startListening();
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"run");
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.launch.internal.FrameworkManager$5", 5.class, (String)"bootstrap", (String)"com.ibm.ws.kernel.boot.resources.LauncherMessages");
            }
        };
        listeningThread.start();
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"startServerCommandListener");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    protected String getElapsedTime(boolean factor, long ... testMilliseconds) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getElapsedTime", (Object[])new Object[]{factor, testMilliseconds});
        }
        String info_seconds = BootstrapConstants.messages.getString("info.seconds");
        long elapsedTime = testMilliseconds.length == 0 ? TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startTime) : testMilliseconds[0];
        StringBuilder timeString = new StringBuilder(30);
        if (elapsedTime <= 0L) {
            long scndsN = 0L;
            timeString.append(MessageFormat.format(info_seconds, scndsN));
            String string = timeString.toString();
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                string = string;
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getElapsedTime", (Object)string);
            }
            return string;
        }
        double secMillis = 1000.0;
        long minuteMillis = 60000L;
        long hourMillis = 3600000L;
        long dayMillis = 86400000L;
        long mod = elapsedTime;
        if (factor) {
            long days = mod / 86400000L;
            mod %= 86400000L;
            if (days > 0L) {
                String info_days = BootstrapConstants.messages.getString("info.days");
                timeString.append(MessageFormat.format(info_days, days)).append(", ");
            }
            long hours = mod / 3600000L;
            mod %= 3600000L;
            if (hours > 0L) {
                String info_hours = BootstrapConstants.messages.getString("info.hours");
                timeString.append(MessageFormat.format(info_hours, hours)).append(", ");
            }
            long minutes = mod / 60000L;
            mod %= 60000L;
            if (minutes > 0L) {
                String info_minutes = BootstrapConstants.messages.getString("info.minutes");
                timeString.append(MessageFormat.format(info_minutes, minutes)).append(", ");
            }
            double seconds = (double)mod / 1000.0;
            if ((mod %= 1000L) == 0L) {
                timeString.append(MessageFormat.format(info_seconds, String.format("%,.0f", seconds)));
            } else if (Long.toString(mod).endsWith("00")) {
                timeString.append(MessageFormat.format(info_seconds, String.format("%,.1f", seconds)));
            } else if (Long.toString(mod).endsWith("0")) {
                timeString.append(MessageFormat.format(info_seconds, String.format("%,.2f", seconds)));
            } else {
                timeString.append(MessageFormat.format(info_seconds, String.format("%,.3f", seconds)));
            }
            String string = timeString.toString();
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                string = string;
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getElapsedTime", (Object)string);
            }
            return string;
        }
        double seconds = (double)elapsedTime / 1000.0;
        mod = elapsedTime % 1000L;
        if (seconds >= 4.294967295E9) {
            timeString.append(MessageFormat.format(info_seconds, String.format("%,.0f", seconds)));
        } else if (mod == 0L) {
            timeString.append(MessageFormat.format(info_seconds, String.format("%,.0f", seconds)));
        } else if (Long.toString(mod).endsWith("00")) {
            timeString.append(MessageFormat.format(info_seconds, String.format("%,.1f", seconds)));
        } else if (Long.toString(mod).endsWith("0")) {
            timeString.append(MessageFormat.format(info_seconds, String.format("%,.2f", seconds)));
        } else {
            timeString.append(MessageFormat.format(info_seconds, String.format("%,.3f", seconds)));
        }
        String string = timeString.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            string = string;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getElapsedTime", (Object)string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    public Set<String> queryFeatureInformation(String osRequest) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"queryFeatureInformation", (Object[])new Object[]{osRequest});
        }
        HashSet<String> result = null;
        try {
            ServiceReference[] refs = this.systemBundleCtx.getAllServiceReferences(ServerContent.class.getName(), null);
            if (refs != null && refs.length > 0) {
                result = new HashSet<String>();
                for (ServiceReference sr : refs) {
                    String[] infos;
                    ServerContent sc = (ServerContent)this.systemBundleCtx.getService(sr);
                    for (String info : infos = sc.getServerContentPaths(osRequest)) {
                        result.add(info);
                    }
                }
            }
        }
        catch (InvalidSyntaxException refs) {
            FFDCFilter.processException((Throwable)refs, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"1035", (Object)this, (Object[])new Object[]{osRequest});
        }
        ArrayList<String> sorted = new ArrayList<String>();
        if (result != null) {
            sorted.addAll(result);
        }
        Collections.sort(sorted);
        result = new LinkedHashSet();
        for (String s : sorted) {
            result.add(s);
        }
        HashSet<String> hashSet = result;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            hashSet = hashSet;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"queryFeatureInformation", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    public Set<String> queryFeatureNames() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"queryFeatureNames", (Object[])new Object[0]);
        }
        HashSet<String> result = null;
        try {
            ServiceReference[] refs = this.systemBundleCtx.getAllServiceReferences(ServerFeatures.class.getName(), null);
            if (refs != null && refs.length > 0) {
                result = new HashSet<String>();
                for (ServiceReference sr : refs) {
                    String[] infos;
                    ServerFeatures sf = (ServerFeatures)this.systemBundleCtx.getService(sr);
                    for (String info : infos = sf.getServerFeatureNames()) {
                        result.add(info);
                    }
                }
            }
        }
        catch (InvalidSyntaxException refs) {
            FFDCFilter.processException((Throwable)refs, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"1076", (Object)this, (Object[])new Object[0]);
        }
        ArrayList<String> sorted = new ArrayList<String>();
        if (result != null) {
            sorted.addAll(result);
        }
        Collections.sort(sorted);
        result = new LinkedHashSet();
        for (String s : sorted) {
            result.add(s);
        }
        HashSet<String> hashSet = result;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            hashSet = hashSet;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"queryFeatureNames", hashSet);
        }
        return hashSet;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    public void introspectFramework(String timestamp, Set<JavaDumpAction> javaDumpActions) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"introspectFramework", (Object[])new Object[]{timestamp, javaDumpActions});
        }
        Tr.audit((TraceComponent)tc, (String)"info.introspect.request.received", (Object[])new Object[0]);
        File dumpDir = this.config.getOutputFile("dump_" + timestamp + "/");
        if (!dumpDir.exists()) {
            throw new IllegalStateException("dump directory does not exist.");
        }
        if (javaDumpActions != null) {
            File javaDumpLocations = new File(dumpDir, ".dumpedjava");
            this.dumpJava(javaDumpActions, javaDumpLocations);
        }
        IntrospectionContext introspectionCtx = new IntrospectionContext(this.systemBundleCtx, dumpDir);
        introspectionCtx.introspectAll();
        File dumpedFlag = new File(dumpDir, ".dumped");
        try {
            dumpedFlag.createNewFile();
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"1125", (Object)this, (Object[])new Object[]{timestamp, javaDumpActions});
            Tr.warning((TraceComponent)tc, (String)"warn.unableWriteFile", (Object[])new Object[]{dumpedFlag, e.getMessage()});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"introspectFramework");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    public void dumpJava(Set<JavaDumpAction> javaDumpActions) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"dumpJava", (Object[])new Object[]{javaDumpActions});
        }
        Tr.audit((TraceComponent)tc, (String)"info.javadump.request.received", (Object[])new Object[0]);
        if (javaDumpActions == null) {
            javaDumpActions = new LinkedHashSet<JavaDumpAction>();
            javaDumpActions.add(JavaDumpAction.THREAD);
        }
        File serverOutputDir = this.config.getOutputFile(null);
        File dumpedFlag = new File(serverOutputDir, ".dumped");
        this.dumpJava(javaDumpActions, dumpedFlag);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"dumpJava");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    private void dumpJava(Set<JavaDumpAction> javaDumpActions, File statusFile) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"dumpJava", (Object[])new Object[]{javaDumpActions, statusFile});
        }
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(statusFile), "UTF-8");
            for (JavaDumpAction javaDumpAction : javaDumpActions) {
                String dumpFileName;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Start javadump action " + (Object)((Object)javaDumpAction)), (Object[])new Object[0]);
                }
                try {
                    File dumpFile = JavaDumper.getInstance().dump(javaDumpAction, this.config.getOutputFile(null));
                    if (dumpFile == null) {
                        if (ServerDumpUtil.isZos() && JavaDumpAction.SYSTEM == javaDumpAction) {
                            Tr.audit((TraceComponent)tc, (String)"info.javadump.zos.system.created", (Object[])new Object[0]);
                            dumpFileName = "";
                        } else {
                            Tr.warning((TraceComponent)tc, (String)"warn.javadump.unsupported", (Object[])new Object[]{javaDumpAction.displayName()});
                            dumpFileName = "";
                        }
                    } else {
                        Tr.audit((TraceComponent)tc, (String)"info.javadump.created", (Object[])new Object[]{dumpFile.getAbsolutePath()});
                        dumpFileName = dumpFile.getAbsolutePath();
                    }
                }
                catch (RuntimeException dumpFile) {
                    void e;
                    FFDCFilter.processException((Throwable)dumpFile, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"1280", (Object)this, (Object[])new Object[]{javaDumpActions, statusFile});
                    dumpFileName = "ERROR: " + e.toString();
                }
                writer.write(javaDumpAction.name());
                ((Writer)writer).write(61);
                writer.write(dumpFileName);
                ((Writer)writer).write(10);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("End javadump action " + (Object)((Object)javaDumpAction) + ", fileName = " + dumpFileName), (Object[])new Object[0]);
            }
        }
        catch (IOException iOException) {
            block15: {
                try {
                    void e;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager", (String)"1292", (Object)this, (Object[])new Object[]{javaDumpActions, statusFile});
                    Tr.warning((TraceComponent)tc, (String)"warn.unableWriteFile", (Object[])new Object[]{statusFile, e.getMessage()});
                    Utils.tryToClose(writer);
                    if (statusFile.delete()) break block15;
                }
                catch (Throwable throwable) {
                    Utils.tryToClose(writer);
                    throw throwable;
                }
                Utils.tryToClose(writer);
                if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"dumpJava");
                }
                return;
            }
            Utils.tryToClose(writer);
        }
        Utils.tryToClose(writer);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"dumpJava");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    private void openThreadIdentityTracker(BundleContext systemContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"openThreadIdentityTracker", (Object[])new Object[]{systemContext});
        }
        this.threadIdentityManagerTracker = new ThreadIdentityManagerConfigurator(systemContext);
        this.threadIdentityManagerTracker.open();
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"openThreadIdentityTracker");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    @FFDCIgnore(value={PauseableComponentControllerRequestFailedException.class})
    public ReturnCode pauseListeners(String args) {
        PauseableComponentController pauseableComponentController;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"pauseListeners", (Object[])new Object[]{args});
        }
        ServiceReference reference = this.systemBundleCtx.getServiceReference(PauseableComponentController.class);
        PauseableComponentController pauseableComponentController2 = pauseableComponentController = reference == null ? null : (PauseableComponentController)this.systemBundleCtx.getService(reference);
        if (pauseableComponentController == null) {
            Tr.error((TraceComponent)tc, (String)"error.pause.request.failed", (Object[])new Object[0]);
            ReturnCode returnCode = ReturnCode.ERROR_SERVER_PAUSE;
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                returnCode = returnCode;
                Tr.exit((Object)this, (TraceComponent)tc, (String)"pauseListeners", (Object)returnCode);
            }
            return returnCode;
        }
        try {
            if (args == null) {
                pauseableComponentController.pause();
            } else {
                String targetList = args.substring(args.indexOf("=") + 1);
                pauseableComponentController.pause(targetList);
            }
        }
        catch (PauseableComponentControllerRequestFailedException e) {
            ReturnCode returnCode = ReturnCode.ERROR_SERVER_PAUSE;
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                returnCode = returnCode;
                Tr.exit((Object)this, (TraceComponent)tc, (String)"pauseListeners", (Object)returnCode);
            }
            return returnCode;
        }
        ReturnCode returnCode = ReturnCode.OK;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            returnCode = returnCode;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"pauseListeners", (Object)returnCode);
        }
        return returnCode;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    @FFDCIgnore(value={PauseableComponentControllerRequestFailedException.class})
    public ReturnCode resumeListeners(String args) {
        PauseableComponentController pauseableComponentController;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"resumeListeners", (Object[])new Object[]{args});
        }
        ServiceReference reference = this.systemBundleCtx.getServiceReference(PauseableComponentController.class);
        PauseableComponentController pauseableComponentController2 = pauseableComponentController = reference == null ? null : (PauseableComponentController)this.systemBundleCtx.getService(reference);
        if (pauseableComponentController == null) {
            Tr.warning((TraceComponent)tc, (String)"error.resume.request.failed", (Object[])new Object[0]);
            ReturnCode returnCode = ReturnCode.ERROR_SERVER_RESUME;
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                returnCode = returnCode;
                Tr.exit((Object)this, (TraceComponent)tc, (String)"resumeListeners", (Object)returnCode);
            }
            return returnCode;
        }
        try {
            if (args == null) {
                pauseableComponentController.resume();
            } else {
                String targetList = args.substring(args.indexOf("=") + 1);
                pauseableComponentController.resume(targetList);
            }
        }
        catch (PauseableComponentControllerRequestFailedException e) {
            ReturnCode returnCode = ReturnCode.ERROR_SERVER_RESUME;
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                returnCode = returnCode;
                Tr.exit((Object)this, (TraceComponent)tc, (String)"resumeListeners", (Object)returnCode);
            }
            return returnCode;
        }
        ReturnCode returnCode = ReturnCode.OK;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            returnCode = returnCode;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"resumeListeners", (Object)returnCode);
        }
        return returnCode;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class IntrospectionContext {
        private final BundleContext systemBundleCtx;
        private final File dumpDir;
        private int unnamedCount;
        static final long serialVersionUID = -8904166937437377583L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        IntrospectionContext(BundleContext systemBundleCtx, File dumpDir) {
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.entry((TraceComponent)$$$tc$$$, (String)"<init>", (Object[])new Object[]{systemBundleCtx, dumpDir});
            }
            this.systemBundleCtx = systemBundleCtx;
            this.dumpDir = dumpDir;
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"<init>", (Object)this);
            }
        }

        /*
         * WARNING - void declaration
         */
        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        public void introspectAll() {
            block5: {
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"introspectAll", (Object[])new Object[0]);
                }
                File introspectionDir = new File(this.dumpDir, "introspections");
                if (!FileUtils.createDir(introspectionDir)) {
                    throw new IllegalStateException("introspections directory could not be created.");
                }
                try {
                    this.introspectIntrospectors(introspectionDir);
                    this.introspectIntrospectableServices(introspectionDir);
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    void e;
                    FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager$IntrospectionContext", (String)"1151", (Object)this, (Object[])new Object[0]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)"Exception occured when get IntrospectableService refs: {0}", (Object[])new Object[]{e});
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"introspectAll");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        private void introspectIntrospectors(File introspectionDir) throws InvalidSyntaxException {
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"introspectIntrospectors", (Object[])new Object[]{introspectionDir});
            }
            Collection refs = this.systemBundleCtx.getServiceReferences(Introspector.class, null);
            if (refs != null && !refs.isEmpty()) {
                for (ServiceReference ref : refs) {
                    Introspector introspector = (Introspector)this.systemBundleCtx.getService(ref);
                    if (introspector == null) continue;
                    try {
                        String name = introspector.getIntrospectorName();
                        String desc = introspector.getIntrospectorDescription();
                        this.introspect(introspectionDir, name, desc, introspector, null);
                    }
                    finally {
                        this.systemBundleCtx.ungetService(ref);
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"introspectIntrospectors");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        private void introspectIntrospectableServices(File introspectionDir) throws InvalidSyntaxException {
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"introspectIntrospectableServices", (Object[])new Object[]{introspectionDir});
            }
            Collection legacyRefs = this.systemBundleCtx.getServiceReferences(IntrospectableService.class, null);
            if (legacyRefs != null && !legacyRefs.isEmpty()) {
                for (ServiceReference ref : legacyRefs) {
                    IntrospectableService serv = (IntrospectableService)this.systemBundleCtx.getService(ref);
                    if (serv == null) continue;
                    try {
                        String name = serv.getName();
                        String desc = serv.getDescription();
                        this.introspect(introspectionDir, name, desc, null, serv);
                    }
                    finally {
                        this.systemBundleCtx.ungetService(ref);
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"introspectIntrospectableServices");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * WARNING - void declaration
         */
        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        private void introspect(File introspectionDir, String introspectionName, String introspectionDesc, Introspector introspector, IntrospectableService introspectable) {
            PrintWriter pw;
            FileOutputStream out;
            block11: {
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"introspect", (Object[])new Object[]{introspectionDir, introspectionName, introspectionDesc, introspector, introspectable});
                }
                if (introspectionName == null || introspectionName.isEmpty()) {
                    introspectionName = Introspector.class.getSimpleName() + '.' + this.unnamedCount++;
                }
                File introspectionFile = new File(introspectionDir, introspectionName + ".txt");
                out = null;
                pw = null;
                try {
                    out = new FileOutputStream(introspectionFile);
                    pw = new PrintWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
                    if (introspectionDesc != null && !introspectionDesc.isEmpty()) {
                        pw.println("The description of this introspector:");
                        pw.println(introspectionDesc);
                        pw.println();
                        pw.flush();
                    }
                    if (introspectable != null) {
                        introspectable.introspect((OutputStream)out);
                        break block11;
                    }
                    introspector.introspect(pw);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    void e2333332;
                    FFDCFilter.processException((Throwable)fileNotFoundException, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager$IntrospectionContext", (String)"1226", (Object)this, (Object[])new Object[]{introspectionDir, introspectionName, introspectionDesc, introspector, introspectable});
                    e2333332.getCause();
                    Tr.error((TraceComponent)tc, (String)"error.fileNotFound", (Object[])new Object[]{introspectionFile});
                    Utils.tryToClose(pw);
                    Utils.tryToClose(out);
                }
                catch (Throwable e2333332) {
                    block12: {
                        void t;
                        FFDCFilter.processException((Throwable)e2333332, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager$IntrospectionContext", (String)"1229", (Object)this, (Object[])new Object[]{introspectionDir, introspectionName, introspectionDesc, introspector, introspectable});
                        Tr.warning((TraceComponent)tc, (String)"warn.unableWriteFile", (Object[])new Object[]{introspectionFile, t.getMessage()});
                        if (out == null) break block12;
                        t.printStackTrace(pw);
                        {
                            catch (Throwable throwable) {
                                Utils.tryToClose(pw);
                                Utils.tryToClose(out);
                                throw throwable;
                            }
                        }
                    }
                    Utils.tryToClose(pw);
                    Utils.tryToClose(out);
                }
            }
            Utils.tryToClose(pw);
            Utils.tryToClose(out);
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"introspect");
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.launch.internal.FrameworkManager$IntrospectionContext", IntrospectionContext.class, (String)"bootstrap", (String)"com.ibm.ws.kernel.boot.resources.LauncherMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected class ShutdownHook
    extends Thread {
        private final boolean isClient;
        static final long serialVersionUID = 3707675224966209439L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        ShutdownHook(boolean isClient) {
            super("WS-ShutdownHook");
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.entry((TraceComponent)$$$tc$$$, (String)"<init>", (Object[])new Object[]{isClient});
            }
            this.setDaemon(false);
            this.isClient = isClient;
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"<init>", (Object)this);
            }
        }

        @Override
        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        public void run() {
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"run", (Object[])new Object[0]);
            }
            this.issueMessage();
            FrameworkManager.this.stopFramework();
            try {
                if (this.isClient) {
                    FrameworkManager.this.framework.waitForStop(0L);
                } else {
                    FrameworkManager.this.waitForShutdown();
                }
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.kernel.launch.internal.FrameworkManager$ShutdownHook", (String)"831", (Object)this, (Object[])new Object[0]);
            }
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"run");
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        private void issueMessage() {
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"issueMessage", (Object[])new Object[0]);
            }
            ThreadGroup systemGroup = this.getSystemThreadGroup();
            Thread[] threads = new Thread[systemGroup.activeCount() * 2];
            int numThreads = systemGroup.enumerate(threads);
            for (int i = 0; i < numThreads; ++i) {
                Thread thread = threads[i];
                StackTraceElement[] stack = thread.getStackTrace();
                if (!this.issueMessageForStackMethod(thread, stack, "java.lang.System", "exit") && !this.issueMessageForStackMethod(thread, stack, "java.lang.Runtime", "exit")) continue;
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"issueMessage");
                }
                return;
            }
            Tr.audit((TraceComponent)tc, (String)"audit.jvm.shutdown", (Object[])new Object[]{FrameworkManager.this.config.getProcessName()});
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"issueMessage");
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        private ThreadGroup getSystemThreadGroup() {
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"getSystemThreadGroup", (Object[])new Object[0]);
            }
            ThreadGroup group = Thread.currentThread().getThreadGroup();
            while (true) {
                ThreadGroup parent;
                if ((parent = group.getParent()) == null) {
                    ThreadGroup threadGroup = group;
                    if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                        threadGroup = threadGroup;
                        Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"getSystemThreadGroup", (Object)threadGroup);
                    }
                    return threadGroup;
                }
                group = parent;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        private boolean issueMessageForStackMethod(Thread thread, StackTraceElement[] stack, String className, String methodName) {
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"issueMessageForStackMethod", (Object[])new Object[]{thread, stack, className, methodName});
            }
            for (int i = 0; i < stack.length; ++i) {
                StackTraceElement element = stack[i];
                if (!element.getClassName().equals(className) || !element.getMethodName().equals(methodName)) continue;
                StackTraceElement[] callerStack = new StackTraceElement[stack.length - i];
                System.arraycopy(stack, i, callerStack, 0, stack.length - i);
                CallerStack callerStackFormattable = new CallerStack(callerStack);
                Tr.audit((TraceComponent)tc, (String)"audit.system.exit", (Object[])new Object[]{FrameworkManager.this.config.getProcessName(), thread.getName(), DataFormatHelper.getThreadId((Thread)thread), className + '.' + methodName, callerStackFormattable});
                boolean bl = true;
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    bl = bl;
                    Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"issueMessageForStackMethod", (Object)bl);
                }
                return bl;
            }
            boolean bl = false;
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                bl = bl;
                Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"issueMessageForStackMethod", (Object)bl);
            }
            return bl;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.launch.internal.FrameworkManager$ShutdownHook", ShutdownHook.class, (String)"bootstrap", (String)"com.ibm.ws.kernel.boot.resources.LauncherMessages");
        }

        @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
        @InjectedFFDC
        @TraceOptions
        private class CallerStack
        extends Throwable {
            static final long serialVersionUID = -3334213432553588349L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            CallerStack(StackTraceElement[] stack) {
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.entry((TraceComponent)$$$tc$$$, (String)"<init>", (Object[])new Object[]{stack});
                }
                this.setStackTrace(stack);
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"<init>", (Object)this);
                }
            }

            @Override
            public String toString() {
                return "";
            }

            @Override
            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            public Throwable fillInStackTrace() {
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"fillInStackTrace", (Object[])new Object[0]);
                }
                CallerStack callerStack = this;
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    callerStack = callerStack;
                    Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"fillInStackTrace", (Object)callerStack);
                }
                return callerStack;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.launch.internal.FrameworkManager$ShutdownHook$CallerStack", CallerStack.class, (String)"bootstrap", (String)"com.ibm.ws.kernel.boot.resources.LauncherMessages");
            }
        }
    }
}

