/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.security;

import com.ibm.ws.kernel.boot.security.PermissionsCombiner;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;

public class WLPDynamicPolicy
extends Policy {
    private Policy policy;
    private List<URL> urls;
    private PermissionCollection allPermissions;
    Permission allPermission = new AllPermission();
    private PermissionsCombiner permissionsCombiner;

    public WLPDynamicPolicy(Policy policy, List<URL> urls) {
        this.policy = policy;
        this.urls = urls;
        this.allPermissions = new PermissionCollection(){
            private static final long serialVersionUID = 3258131349494708277L;

            @Override
            public void add(Permission permission) {
            }

            @Override
            public boolean implies(Permission permission) {
                return true;
            }

            @Override
            public Enumeration<Permission> elements() {
                return new Enumeration<Permission>(){
                    int cur = 0;

                    @Override
                    public boolean hasMoreElements() {
                        return this.cur < 1;
                    }

                    @Override
                    public Permission nextElement() {
                        if (this.cur == 0) {
                            this.cur = 1;
                            return WLPDynamicPolicy.this.allPermission;
                        }
                        throw new NoSuchElementException();
                    }
                };
            }
        };
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        if (this.contains(codesource)) {
            return this.allPermissions;
        }
        return this.policy == null ? this.allPermissions : this.getMergedPermissions(codesource);
    }

    private PermissionCollection getMergedPermissions(CodeSource codesource) {
        if (this.permissionsCombiner != null && codesource != null && codesource.getLocation() != null) {
            return this.permissionsCombiner.getCombinedPermissions(this.policy.getPermissions(codesource), codesource);
        }
        return this.policy.getPermissions(codesource);
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        if (this.contains(domain.getCodeSource())) {
            return this.allPermissions;
        }
        return this.policy == null ? this.allPermissions : this.policy.getPermissions(domain);
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        if (this.contains(domain.getCodeSource())) {
            return true;
        }
        if (this.policy == null || this.policy.implies(domain, permission)) {
            return true;
        }
        String location = domain != null && domain.getCodeSource() != null && domain.getCodeSource().getLocation() != null ? domain.getCodeSource().getLocation().toExternalForm() : "";
        return location.startsWith("jrt:/jdk.attach");
    }

    @Override
    public void refresh() {
        if (this.policy != null) {
            this.policy.refresh();
        }
    }

    private boolean contains(CodeSource codeSource) {
        if (codeSource == null) {
            return false;
        }
        URL url = codeSource.getLocation();
        if (url == null) {
            return false;
        }
        for (URL u : this.urls) {
            if (!u.toString().equals(url.toString())) continue;
            return true;
        }
        return false;
    }

    public void setPermissionsCombiner(PermissionsCombiner permissionsCombiner) {
        this.permissionsCombiner = permissionsCombiner;
    }
}

