/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.impl;

import com.ibm.ws.logging.hpel.LogFileWriter;
import com.ibm.ws.logging.hpel.LogRepositoryManager;
import com.ibm.ws.logging.hpel.LogRepositoryWriter;
import com.ibm.ws.logging.hpel.impl.AccessHelper;
import com.ibm.ws.logging.hpel.impl.LogFileWriterImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogRepositoryWriterImpl
implements LogRepositoryWriter {
    private static final String BUNDLE_NAME = "com.ibm.ws.logging.hpel.resources.HpelMessages";
    private static final String className = LogRepositoryWriterImpl.class.getName();
    private static final Logger logger = Logger.getLogger(className, "com.ibm.ws.logging.hpel.resources.HpelMessages");
    private final LogRepositoryManager manager;
    private byte[] headerBytes = null;
    private int outOfSpaceAction = 0;
    protected boolean bufferingEnabled = true;
    private LogFileWriter writer = null;
    private int index = 0;
    private static final long SWITCH_PERIOD = 86400000L;
    private static final int MIN_SWITCH_HOUR = 0;
    private static final int MAX_SWITCH_HOUR = 23;
    private Timer fileSwitchTimer = null;
    private Date fileSwitchTime = new Date();
    private final TimerTask fileSwitchTask = new FileSwitchTask();
    private boolean isInitializing = false;
    private final ArrayList<RecordCache> cache = new ArrayList();

    public LogRepositoryWriterImpl(LogRepositoryManager manager) {
        this.manager = manager;
    }

    @Override
    public LogRepositoryManager getLogRepositoryManager() {
        return this.manager;
    }

    @Override
    public synchronized void setHeader(byte[] headerBytes) {
        this.headerBytes = new byte[headerBytes.length];
        System.arraycopy(headerBytes, 0, this.headerBytes, 0, headerBytes.length);
    }

    public synchronized void setOutOfSpaceAction(int type) {
        this.outOfSpaceAction = type;
    }

    public synchronized void setBufferingEnabled(boolean bufferingEnabled) {
        this.bufferingEnabled = bufferingEnabled;
    }

    private synchronized void switchFile() {
        if (this.writer != null) {
            try {
                this.writer.close(this.headerBytes);
                this.index = 0;
                this.writer = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void logRecord(long timestamp, byte[] bytes) {
        if (this.isInitializing) {
            this.cache.add(new RecordCache(timestamp, bytes));
            return;
        }
        while (this.headerBytes != null) {
            try {
                File next;
                this.isInitializing = true;
                this.writeHeader(timestamp);
                if (this.index > 0 && (next = this.manager.checkForNewFile(this.writer.checkTotal(bytes, this.headerBytes), timestamp)) != null) {
                    this.writer.close(this.headerBytes);
                    this.index = 0;
                    this.writer = this.createNewWriter(next);
                    this.writer.write(this.headerBytes);
                    this.manager.notifyOfFileAction("WLNEventRoll");
                }
                this.writer.write(bytes);
                this.writer.flush();
                ++this.index;
                break;
            }
            catch (IOException ex) {
                if (this.outOfSpaceAction == 2) {
                    this.stop();
                    break;
                }
                if (this.outOfSpaceAction == 1) {
                    if (!this.manager.purgeOldFiles()) break;
                    continue;
                }
                if (this.outOfSpaceAction != 0) break;
                this.disableFileSwitch();
                System.exit(-1);
                break;
            }
            catch (RuntimeException e) {
                if (this.outOfSpaceAction == 2) {
                    this.stop();
                    break;
                }
                if (this.outOfSpaceAction != 0) break;
                this.disableFileSwitch();
                System.exit(-1);
                break;
            }
            finally {
                this.isInitializing = false;
            }
        }
        if (!this.cache.isEmpty()) {
            ArrayList<RecordCache> copy = new ArrayList<RecordCache>();
            copy.addAll(this.cache);
            this.cache.clear();
            for (RecordCache record : copy) {
                this.logRecord(record.timestamp, record.bytes);
            }
        }
    }

    public synchronized void writeHeader(long timestamp) throws IOException {
        if (this.writer == null && this.headerBytes != null) {
            this.writer = this.createNewWriter(this.manager.startNewFile(timestamp));
            this.writer.write(this.headerBytes);
            this.manager.notifyOfFileAction("WLNEventRoll");
        }
    }

    @Override
    public synchronized void stop() {
        if (this.writer != null) {
            try {
                this.writer.close(this.headerBytes);
                this.writer = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.disableFileSwitch();
        this.headerBytes = null;
    }

    protected LogFileWriter createNewWriter(File file) throws IOException {
        return new LogFileWriterImpl(file, this.bufferingEnabled);
    }

    public void enableFileSwitch(int switchHour) {
        Calendar currentTime;
        if (this.fileSwitchTimer == null) {
            this.fileSwitchTimer = AccessHelper.createTimer();
        }
        if (switchHour < 0 || switchHour > 23) {
            logger.logp(Level.WARNING, className, "enableFileSwitch", "HPEL_IncorrectSwitchHour", new Object[]{switchHour, 0, 23, 0});
            switchHour = 0;
        }
        Calendar switchTime = currentTime = Calendar.getInstance();
        switchTime.set(11, switchHour);
        switchTime.set(12, 0);
        switchTime.set(13, 0);
        if (currentTime.after(switchTime)) {
            switchTime.add(5, 1);
        }
        this.fileSwitchTime.setTime(switchTime.getTimeInMillis());
        this.fileSwitchTimer.scheduleAtFixedRate(this.fileSwitchTask, this.fileSwitchTime, 86400000L);
    }

    public void disableFileSwitch() {
        if (this.fileSwitchTimer != null) {
            this.fileSwitchTimer.cancel();
        }
    }

    private static final class RecordCache {
        final long timestamp;
        final byte[] bytes;

        RecordCache(long timestamp, byte[] bytes) {
            this.timestamp = timestamp;
            this.bytes = bytes;
        }
    }

    private class FileSwitchTask
    extends TimerTask {
        private FileSwitchTask() {
        }

        @Override
        public void run() {
            LogRepositoryWriterImpl.this.switchFile();
        }
    }
}

