/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.impl;

import com.ibm.websphere.logging.hpel.writer.LogEventNotifier;
import com.ibm.ws.logging.hpel.LogRepositoryManager;
import com.ibm.ws.logging.hpel.impl.AccessHelper;
import com.ibm.ws.logging.hpel.impl.LogRepositoryBaseImpl;
import com.ibm.ws.logging.hpel.impl.LogRepositorySpaceAlert;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogRepositoryManagerImpl
extends LogRepositoryBaseImpl
implements LogRepositoryManager {
    private long maxLogFileSize = 0x500000L;
    private long maxRepositorySize = -1L;
    private final String svPid;
    private static String thisClass = LogRepositoryManagerImpl.class.getName();
    private static Logger debugLogger = LogRepositoryBaseImpl.getLogger();
    private TimerThread timer = null;
    private File ivSubDirectory = null;
    private final HashMap<String, FileDetails> activeFilesMap = new HashMap();
    private final HashMap<File, Integer> parentFilesMap = new HashMap();
    private String repositoryType = null;
    private boolean okToNotify = true;
    private static ArrayList<EventContents> notificationQueue = new ArrayList();
    private static final long MIN_LOG_FILE_SIZE = 0x100000L;
    private static final long MAX_LOG_FILE_SIZE = 0x500000L;
    private static final long MIN_REPOSITORY_SIZE = 0xA00000L;
    private static final int SPLIT_RATIO = 20;
    final LinkedList<FileDetails> fileList = new LinkedList();
    long totalSize = -1L;
    private static final long FAILED_WAIT_TIME = 1000L;
    private static final long FAILED_MAX_COUNT = 5L;

    public LogRepositoryManagerImpl(File directory, String pid, String label, boolean useDirTree) {
        super(directory);
        if (!AccessHelper.canMakeDirectories(directory)) {
            throw new IllegalArgumentException("Specified location can't be used as a log repository: " + directory);
        }
        int index = pid.indexOf("/");
        if (index > -1) {
            pid = pid.substring(0, index);
        }
        this.svPid = pid;
        if (useDirTree) {
            try {
                this.createLockFile(pid, label);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Specified location can't be used as a log repository: " + directory, ex);
            }
        } else {
            this.ivSubDirectory = directory;
        }
    }

    @Override
    public synchronized void stop() {
        if (this.timer != null) {
            this.timer.keepRunning = false;
            this.timer.interrupt();
            this.timer = null;
        }
        LogRepositorySpaceAlert.getInstance().removeRepositoryInfo(this);
    }

    public synchronized void configure(long maxRepositorySize, long retentionTime) {
        if (LogRepositoryBaseImpl.isDebugEnabled()) {
            debugLogger.logp(Level.FINE, thisClass, "configure", "Log Records for Manager managing type: " + this.managedType + " for pid: " + this.svPid + " maxRepSz: " + maxRepositorySize + " retentionTm: " + retentionTime);
        }
        boolean checkSpaceNow = maxRepositorySize > 0L && (this.maxRepositorySize <= 0L || maxRepositorySize < this.maxRepositorySize);
        this.maxLogFileSize = LogRepositoryManagerImpl.calculateFileSplit(maxRepositorySize);
        this.maxRepositorySize = maxRepositorySize;
        if (checkSpaceNow) {
            this.checkSpaceConstrain(this.maxLogFileSize);
        }
        if (this.timer == null) {
            if (retentionTime > 0L) {
                this.timer = new TimerThread(retentionTime);
                this.timer.start();
            }
        } else if (retentionTime <= 0L) {
            this.stop();
        } else if (retentionTime != this.timer.retentionTime) {
            this.timer.retentionTime = retentionTime;
            this.timer.interrupt();
        }
    }

    protected static long calculateFileSplit(long repositorySize) {
        if (repositorySize <= 0L) {
            return 0x500000L;
        }
        if (repositorySize < 0xA00000L) {
            throw new IllegalArgumentException("Specified repository size is too small");
        }
        long result = repositorySize / 20L;
        if (result < 0x100000L) {
            result = 0x100000L;
        } else if (result > 0x500000L) {
            result = 0x500000L;
        }
        return result;
    }

    private void initFileList(boolean force) {
        if (this.totalSize < 0L || force) {
            this.fileList.clear();
            this.parentFilesMap.clear();
            this.totalSize = 0L;
            File[] files = this.listRepositoryFiles();
            if (files.length > 0) {
                Arrays.sort(files, this.fileComparator);
                for (File file : files) {
                    long size = AccessHelper.getFileLength(file);
                    this.fileList.add(new FileDetails(file, this.getLogFileTimestamp(file), size, null));
                    this.totalSize += size;
                    if (LogRepositoryBaseImpl.isDebugEnabled()) {
                        debugLogger.logp(Level.FINE, thisClass, "initFileList", "add: " + file.getPath() + " sz: " + size + " listSz: " + this.fileList.size() + " new totalSz: " + this.totalSize);
                    }
                    this.incrementFileCount(file);
                }
                this.debugListLL("fileListPrePop");
            }
            this.deleteEmptyRepositoryDirs();
            if (LogRepositoryBaseImpl.isDebugEnabled()) {
                for (File parentNameKey : this.parentFilesMap.keySet()) {
                    Integer fileCount = this.parentFilesMap.get(parentNameKey);
                    debugLogger.logp(Level.FINE, thisClass, "initFileList", "  Directory: " + parentNameKey + " file count: " + fileCount);
                }
            }
        }
    }

    protected void deleteEmptyRepositoryDirs() {
        File[] directories = this.listRepositoryDirs();
        for (int i = 0; i < directories.length; ++i) {
            File[] childFiles;
            boolean currentDir;
            boolean bl = currentDir = this.ivSubDirectory != null && this.ivSubDirectory.compareTo(directories[i]) == 0;
            if (LogRepositoryManagerImpl.isDebugEnabled()) {
                debugLogger.logp(Level.FINE, thisClass, "deleteEmptyRepositoryDirs", "Instance directory name (controller): " + directories[i].getAbsolutePath());
            }
            for (File curFile : childFiles = AccessHelper.listFiles(directories[i], this.subprocFilter)) {
                if (LogRepositoryManagerImpl.isDebugEnabled()) {
                    debugLogger.logp(Level.FINE, thisClass, "deleteEmptyRepositoryDirs", "Servant directory name: " + curFile.getAbsolutePath());
                }
                if (!currentDir && !this.parentFilesMap.containsKey(curFile)) {
                    if (LogRepositoryManagerImpl.isDebugEnabled()) {
                        debugLogger.logp(Level.FINE, thisClass, "deleteEmptyRepositoryDirs", "Found an empty servant directory:  " + curFile);
                    }
                    this.deleteDirectory(curFile);
                    continue;
                }
                this.incrementFileCount(curFile);
            }
            if (currentDir || this.parentFilesMap.containsKey(directories[i])) continue;
            if (LogRepositoryManagerImpl.isDebugEnabled()) {
                debugLogger.logp(Level.FINE, thisClass, "listRepositoryFiles", "Found an empty directory:  " + directories[i]);
            }
            this.deleteDirectory(directories[i]);
        }
    }

    protected void deleteDirectory(File directoryName) {
        if (LogRepositoryManagerImpl.isDebugEnabled()) {
            debugLogger.logp(Level.FINE, thisClass, "deleteDirectory", "empty directory " + (directoryName == null ? "None" : directoryName.getPath()));
        }
        if (AccessHelper.deleteFile(directoryName)) {
            if (LogRepositoryManagerImpl.isDebugEnabled()) {
                debugLogger.logp(Level.FINE, thisClass, "deleteDirectory", "delete " + directoryName.getName());
            }
        } else if (LogRepositoryManagerImpl.isDebugEnabled()) {
            debugLogger.logp(Level.WARNING, thisClass, "deleteDirectory", "Failed to delete directory " + directoryName.getPath());
        }
    }

    private void incrementFileCount(File file) {
        File parentFile = file.getParentFile();
        Integer filecount = this.parentFilesMap.get(parentFile);
        if (filecount != null) {
            this.parentFilesMap.put(parentFile, filecount + 1);
        } else {
            this.parentFilesMap.put(parentFile, 1);
        }
    }

    private void decrementFileCount(File file) {
        File parentFile = file.getParentFile();
        Integer filecount = this.parentFilesMap.get(parentFile);
        if (filecount != null) {
            if (filecount == 1) {
                this.parentFilesMap.remove(parentFile);
                this.deleteDirectory(parentFile);
                this.decrementFileCount(parentFile);
            } else {
                this.parentFilesMap.put(parentFile, filecount - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSpaceConstrain(long logFileSize) {
        long spaceNeeded;
        if (this.maxRepositorySize > 0L) {
            LinkedList<FileDetails> linkedList = this.fileList;
            synchronized (linkedList) {
                this.initFileList(false);
                long purgeSize = this.totalSize + logFileSize - this.maxRepositorySize;
                if (LogRepositoryBaseImpl.isDebugEnabled()) {
                    debugLogger.logp(Level.FINE, thisClass, "checkSpaceConstrain", "total: " + this.totalSize + " maxLog: " + logFileSize + " maxRepos: " + this.maxRepositorySize);
                }
                if (purgeSize > 0L) {
                    this.purgeOldFiles(purgeSize);
                }
                spaceNeeded = this.maxRepositorySize - this.totalSize;
            }
        } else {
            spaceNeeded = 0x500000L;
        }
        LogRepositorySpaceAlert.getInstance().setRepositoryInfo(this, this.repositoryLocation, spaceNeeded);
    }

    private boolean purgeOldFiles(long total) {
        boolean result = false;
        if (LogRepositoryBaseImpl.isDebugEnabled()) {
            debugLogger.logp(Level.FINE, thisClass, "purgeOldFiles", "total: " + total + " listSz: " + this.fileList.size());
        }
        while (total > 0L && this.fileList.size() > 1) {
            FileDetails details = this.purgeOldestFile();
            if (details == null) continue;
            if (LogRepositoryBaseImpl.isDebugEnabled()) {
                debugLogger.logp(Level.FINE, thisClass, "purgeOldFiles", "Purged: " + details.file.getPath() + " sz: " + details.size);
            }
            total -= details.size;
            result = true;
        }
        return result;
    }

    private FileDetails purgeOldestFile() {
        this.debugListLL("prepurgeOldestFile");
        this.debugListHM("prepurgeOldestFile");
        FileDetails returnFD = this.getOldestInactive();
        if (LogRepositoryBaseImpl.isDebugEnabled()) {
            debugLogger.logp(Level.FINE, thisClass, "purgeOldestFile", "oldestInactive: " + (returnFD == null ? "None" : returnFD.file.getPath()));
        }
        if (returnFD == null) {
            return null;
        }
        if (LogRepositoryBaseImpl.isDebugEnabled()) {
            debugLogger.logp(Level.FINE, thisClass, "purgeOldestFile", "fileList size before remove: " + this.fileList.size());
        }
        if (LogRepositoryBaseImpl.isDebugEnabled()) {
            debugLogger.logp(Level.FINE, thisClass, "purgeOldestFile", "fileList size after remove: " + this.fileList.size());
        }
        if (AccessHelper.deleteFile(returnFD.file)) {
            this.fileList.remove(returnFD);
            this.totalSize -= returnFD.size;
            if (LogRepositoryBaseImpl.isDebugEnabled()) {
                debugLogger.logp(Level.FINE, thisClass, "purgeOldestFile", "delete: " + returnFD.file.getName());
            }
            this.decrementFileCount(returnFD.file);
            this.notifyOfFileAction("WLNEventDelete");
        } else {
            if (LogRepositoryBaseImpl.isDebugEnabled()) {
                debugLogger.logp(Level.FINE, thisClass, "purgeOldestFile", "Failed to delete file: " + returnFD.file.getPath());
            }
            this.initFileList(true);
            returnFD = null;
        }
        this.debugListLL("postpurgeOldestFile");
        return returnFD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debugListLL(String label) {
        if (LogRepositoryBaseImpl.isDebugEnabled()) {
            debugLogger.logp(Level.FINE, thisClass, "debugListLL", label + " w/fileList");
            LinkedList<FileDetails> linkedList = this.fileList;
            synchronized (linkedList) {
                for (FileDetails curFd : this.fileList) {
                    debugLogger.logp(Level.FINE, thisClass, "debugListLL", "  Sz: " + curFd.size + " Pid: " + curFd.pid + " Nm: " + curFd.file.getPath());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debugListHM(String label) {
        if (LogRepositoryBaseImpl.isDebugEnabled()) {
            debugLogger.logp(Level.FINE, thisClass, "debugListHM", label + " hash");
            LinkedList<FileDetails> linkedList = this.fileList;
            synchronized (linkedList) {
                HashMap<String, FileDetails> hashMap = this.activeFilesMap;
                synchronized (hashMap) {
                    for (String pidKey : this.activeFilesMap.keySet()) {
                        FileDetails thisFd = this.activeFilesMap.get(pidKey);
                        debugLogger.logp(Level.FINE, thisClass, "debugListHM", "  Pid: " + pidKey + " timestamp: " + thisFd.timestamp);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean purgeOldFiles() {
        LinkedList<FileDetails> linkedList = this.fileList;
        synchronized (linkedList) {
            this.initFileList(false);
            return this.purgeOldFiles(this.maxLogFileSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String addNewFileFromSubProcess(long spTimeStamp, String spPid, String spLabel) {
        this.checkSpaceConstrain(this.maxLogFileSize);
        if (LogRepositoryBaseImpl.isDebugEnabled()) {
            debugLogger.logp(Level.FINE, thisClass, "addNewFileFromSubProcess", "Tstamp: " + spTimeStamp + " pid: " + spPid + " lbl: " + spLabel + " Max: " + this.maxLogFileSize);
        }
        if (this.ivSubDirectory == null) {
            this.getControllingProcessDirectory(spTimeStamp, this.svPid);
        }
        if (LogRepositoryBaseImpl.isDebugEnabled()) {
            debugLogger.logp(Level.FINE, thisClass, "addNewFileFromSubProcess", "Got ivSubDir: " + this.ivSubDirectory.getPath());
        }
        File servantDirectory = new File(this.ivSubDirectory, this.getLogDirectoryName(-1L, spPid, spLabel));
        File servantFile = this.getLogFile(servantDirectory, spTimeStamp);
        FileDetails thisFile = new FileDetails(servantFile, spTimeStamp, this.maxLogFileSize, spPid);
        LinkedList<FileDetails> linkedList = this.fileList;
        synchronized (linkedList) {
            this.initFileList(false);
            this.fileList.add(thisFile);
            this.incrementFileCount(servantFile);
            HashMap<String, FileDetails> hashMap = this.activeFilesMap;
            synchronized (hashMap) {
                this.activeFilesMap.put(spPid, thisFile);
            }
        }
        this.totalSize += this.maxLogFileSize;
        if (LogRepositoryBaseImpl.isDebugEnabled()) {
            debugLogger.logp(Level.FINE, thisClass, "addNewFileFromSubProcess", "Added file: " + servantFile.getPath() + " sz:" + this.maxLogFileSize + " tstmp: " + spTimeStamp);
            this.debugListLL("postAddFromSP");
            this.debugListHM("postAddFromSP");
        }
        return servantFile.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inactivateSubProcess(String spPid) {
        LinkedList<FileDetails> linkedList = this.fileList;
        synchronized (linkedList) {
            HashMap<String, FileDetails> hashMap = this.activeFilesMap;
            synchronized (hashMap) {
                this.activeFilesMap.remove(spPid);
            }
        }
        if (LogRepositoryBaseImpl.isDebugEnabled()) {
            debugLogger.logp(Level.FINE, thisClass, "inactivateSubProcess", "Inactivated pid: " + spPid);
        }
    }

    private File calculateLogFile(long timestamp) {
        if (this.ivSubDirectory == null) {
            this.getControllingProcessDirectory(timestamp, this.svPid);
        }
        return this.getLogFile(this.ivSubDirectory, timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized File startNewFile(long timestamp) {
        this.okToNotify = false;
        this.checkSpaceConstrain(this.maxLogFileSize);
        File file = this.calculateLogFile(timestamp);
        File dir = file.getParentFile();
        if (!AccessHelper.isDirectory(dir)) {
            AccessHelper.makeDirectories(dir);
        }
        FileDetails thisFile = new FileDetails(file, timestamp, 0L, this.svPid);
        LinkedList<FileDetails> linkedList = this.fileList;
        synchronized (linkedList) {
            this.initFileList(false);
            this.fileList.add(thisFile);
            this.incrementFileCount(file);
            HashMap<String, FileDetails> hashMap = this.activeFilesMap;
            synchronized (hashMap) {
                this.activeFilesMap.put(this.svPid, thisFile);
            }
        }
        if (LogRepositoryBaseImpl.isDebugEnabled()) {
            debugLogger.logp(Level.FINE, thisClass, "startNewFile", "Added file: " + file.getPath() + " sz: 0  tstmp: " + timestamp);
            this.debugListLL("postAddLocal");
            this.debugListHM("postAddLocal");
        }
        if (LogRepositoryBaseImpl.isDebugEnabled()) {
            debugLogger.logp(Level.FINE, thisClass, "startNewFile", "roll");
        }
        this.okToNotify = true;
        if (this.timer != null) {
            this.timer.interrupt();
        }
        return file;
    }

    private void getControllingProcessDirectory(long timestamp, String pid) {
        int count = 0;
        while (this.ivSubDirectory == null) {
            this.ivSubDirectory = this.makeLogDirectory(timestamp, pid);
            if (this.ivSubDirectory != null) continue;
            if ((long)(++count) > 5L) {
                this.ivSubDirectory = this.makeLogDirectory(timestamp, pid, true);
                if (this.ivSubDirectory == null) {
                    if (LogRepositoryManagerImpl.isDebugEnabled()) {
                        debugLogger.logp(Level.FINE, thisClass, "UnableToMakeDirectory", "Unable to create instance directory forcefully , throwing Runtime Exception");
                    }
                    throw new RuntimeException("Failed to create instance log repository. See SystemOut.log for details.");
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized File checkForNewFile(long total, long timestamp) {
        HashMap<String, FileDetails> hashMap = this.activeFilesMap;
        synchronized (hashMap) {
            FileDetails pidCurrentFd = this.activeFilesMap.get(this.svPid);
            if (total <= this.maxLogFileSize || pidCurrentFd.file.equals(this.calculateLogFile(timestamp))) {
                pidCurrentFd.size = total;
                if (total > this.maxLogFileSize) {
                    this.checkSpaceConstrain(total);
                }
                return null;
            }
            this.totalSize += pidCurrentFd.size;
        }
        return this.startNewFile(timestamp);
    }

    @Override
    public void setLogEventNotifier(LogEventNotifier logEventNotifier) {
        if (logEventNotifier == null) {
            return;
        }
        if (LogRepositoryBaseImpl.isDebugEnabled()) {
            debugLogger.logp(Level.FINE, thisClass, "setLogEventNotifier", "managedTp: " + this.managedType);
        }
        super.setLogEventNotifier(logEventNotifier);
        if ("trace".equals(this.managedType) || "log".equals(this.managedType)) {
            this.repositoryType = "trace".equals(this.managedType) ? "WLNTrace" : "WLNLog";
            logEventNotifier.setOldestDate(this.getOldestDate(), this.repositoryType);
            if (LogRepositoryBaseImpl.isDebugEnabled()) {
                debugLogger.logp(Level.FINE, thisClass, "setLogEventNotifier", "repTp: " + this.repositoryType + " oldDt: " + this.getOldestDate());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOfFileAction(String eventType) {
        if (LogRepositoryBaseImpl.isDebugEnabled()) {
            debugLogger.logp(Level.FINE, thisClass, "notifyOfFileAction", "rTp: " + this.repositoryType + " EvtTp: " + eventType + " listener: " + this.logEventNotifier + " Dt: " + this.getOldestDate() + " Ok to notify: " + this.okToNotify);
        }
        if (this.logEventNotifier != null) {
            if (this.okToNotify) {
                if (LogRepositoryBaseImpl.isDebugEnabled()) {
                    debugLogger.logp(Level.FINE, thisClass, "notifyOfFileAction", "clearing queue");
                }
                ArrayList<EventContents> arrayList = notificationQueue;
                synchronized (arrayList) {
                    if (notificationQueue.size() > 0) {
                        for (EventContents eventContents : notificationQueue) {
                            this.logEventNotifier.recordFileAction(eventContents.eventType, eventContents.repositoryType, eventContents.dateOldestLogRecord);
                        }
                        notificationQueue.clear();
                    }
                }
                this.logEventNotifier.recordFileAction(eventType, this.repositoryType, this.getOldestDate());
            } else {
                if (LogRepositoryBaseImpl.isDebugEnabled()) {
                    debugLogger.logp(Level.FINE, thisClass, "notifyOfFileAction", "queueing event");
                }
                ArrayList<EventContents> arrayList = notificationQueue;
                synchronized (arrayList) {
                    notificationQueue.add(new EventContents(eventType, this.repositoryType, this.getOldestDate()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileDetails getOldestInactive() {
        for (FileDetails curFd : this.fileList) {
            if (curFd.pid == null) {
                return curFd;
            }
            HashMap<String, FileDetails> hashMap = this.activeFilesMap;
            synchronized (hashMap) {
                FileDetails cur4Pid = this.activeFilesMap.get(curFd.pid);
                if (cur4Pid == null || cur4Pid != curFd) {
                    return curFd;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date getOldestDate() {
        LinkedList<FileDetails> linkedList = this.fileList;
        synchronized (linkedList) {
            if (this.fileList.size() < 1) {
                return null;
            }
            FileDetails oldFd = this.fileList.element();
            return new Date(oldFd.timestamp);
        }
    }

    private class TimerThread
    extends Thread {
        private static final long IDLE_SLEEP = 3600000L;
        private long retentionTime;
        private boolean keepRunning = true;

        TimerThread(long retentionTime) {
            this.retentionTime = retentionTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileDetails target = null;
            long sleepTime = 3600000L;
            while (this.keepRunning) {
                LinkedList<FileDetails> linkedList = LogRepositoryManagerImpl.this.fileList;
                synchronized (linkedList) {
                    LogRepositoryManagerImpl.this.initFileList(false);
                    if (LogRepositoryManagerImpl.this.fileList.size() > 1 && target == LogRepositoryManagerImpl.this.getOldestInactive()) {
                        LogRepositoryManagerImpl.this.purgeOldestFile();
                    }
                    if (LogRepositoryManagerImpl.this.fileList.size() < 2) {
                        target = null;
                        sleepTime = 3600000L;
                    } else {
                        target = LogRepositoryManagerImpl.this.getOldestInactive();
                        long current = System.currentTimeMillis();
                        sleepTime = target.timestamp + this.retentionTime - current;
                    }
                }
                if (sleepTime <= 0L) continue;
                try {
                    TimerThread.sleep(sleepTime);
                }
                catch (InterruptedException ex) {
                    target = null;
                }
            }
        }
    }

    private static class FileDetails {
        final File file;
        final long timestamp;
        long size;
        String pid;

        FileDetails(File file, long timestamp, long size, String pid) {
            this.file = file;
            this.size = size;
            this.timestamp = timestamp;
            this.pid = pid;
        }
    }

    private static class EventContents {
        public String eventType;
        public String repositoryType;
        public Date dateOldestLogRecord;

        public EventContents(String eventType, String repositoryType, Date dateOldestRecord) {
            this.eventType = eventType;
            this.repositoryType = repositoryType;
            this.dateOldestLogRecord = dateOldestRecord;
        }
    }
}

