/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.handlers;

import com.ibm.ws.logging.hpel.handlers.LogRepositoryComponent;

public class LogRepositoryConfiguration {
    private static final LogRepositoryConfiguration ivLogRepositoryConfiguration = new LogRepositoryConfiguration();
    public static final int MILLIS_IN_HOURS = 3600000;
    public static final int ONE_MEG = 0x100000;
    private boolean ivControlRawTraceFilterEnabled;
    private final LogState ivLog = new LogState();
    public static final String DIRECTORY_TYPE = "DIRECTORY";
    public static final String MEMORYBUFFER_TYPE = "MEMORYBUFFER";
    private final TraceState ivTrace = new TraceState();
    private final TextState ivText = new TextState();

    private LogRepositoryConfiguration() {
    }

    public static LogRepositoryConfiguration getLogRepositoryConfiguration() {
        return ivLogRepositoryConfiguration;
    }

    private void updateLogConfiguration(LogState state) {
        LogRepositoryComponent.setLogDirectoryDestination(state.ivDataDirectory, state.ivPurgeBySizeEnabled, state.ivPurgeByTimeEnabled, state.ivFileSwitchEnabled, state.ivBufferingEnabled, state.ivPurgeMaxSize * 0x100000L, state.ivPurgeMinTime * 3600000L, state.ivFileSwitchTime, state.ivOutOfSpaceAction);
    }

    public boolean isRawTraceFilterEnabled() {
        return this.ivControlRawTraceFilterEnabled;
    }

    public void setRawTraceFilterEnabled(boolean rawTraceFilterEnabled) {
        this.ivControlRawTraceFilterEnabled = rawTraceFilterEnabled;
    }

    public void setLog(String dataDirectory, boolean enablePurgeBySize, boolean enablePurgeByTime, long maxSize, long minPurgeTime, String outOfSpaceAction, boolean enableBuffering, boolean fileSwitchEnabled, int fileSwitchTime) {
        LogState state = this.ivLog.clone();
        state.ivDataDirectory = dataDirectory;
        state.ivPurgeBySizeEnabled = enablePurgeBySize;
        state.ivPurgeByTimeEnabled = enablePurgeByTime;
        state.ivPurgeMaxSize = maxSize;
        state.ivPurgeMinTime = minPurgeTime;
        state.ivOutOfSpaceAction = outOfSpaceAction;
        state.ivBufferingEnabled = enableBuffering;
        state.ivFileSwitchEnabled = fileSwitchEnabled;
        state.ivFileSwitchTime = fileSwitchTime;
        this.updateLogConfiguration(state);
        state.copyTo(this.ivLog);
    }

    public String getLogDataDirectory() {
        return this.ivLog.ivDataDirectory;
    }

    public boolean isLogPurgeBySizeEnabled() {
        return this.ivLog.ivPurgeBySizeEnabled;
    }

    public long getLogPurgeMaxSize() {
        return this.ivLog.ivPurgeMaxSize;
    }

    public boolean isLogPurgeByTimeEnabled() {
        return this.ivLog.ivPurgeByTimeEnabled;
    }

    public long getLogPurgeMinTime() {
        return this.ivLog.ivPurgeMinTime;
    }

    public String getLogOutOfSpaceAction() {
        return this.ivLog.ivOutOfSpaceAction;
    }

    public boolean isLogBufferingEnabled() {
        return this.ivLog.ivBufferingEnabled;
    }

    public boolean isLogFileSwitchEnabled() {
        return this.ivLog.ivFileSwitchEnabled;
    }

    public int getLogFileSwitchTime() {
        return this.ivLog.ivFileSwitchTime;
    }

    public void setLogDataDirectory(String logDataDirectory) {
        LogState state = this.ivLog.setDataDirectory(logDataDirectory);
        if (state != null) {
            this.updateLogConfiguration(state);
            state.copyTo(this.ivLog);
        }
    }

    public void setLogPurgeBySizeEnabled(boolean logPurgeBySizeEnabled) {
        LogState state = this.ivLog.setPurgeBySizeEnabled(logPurgeBySizeEnabled);
        if (state != null) {
            this.updateLogConfiguration(state);
            state.copyTo(this.ivLog);
        }
    }

    public void setLogPurgeMaxSize(long logPurgeMaxSize) {
        LogState state = this.ivLog.setPurgeMaxSize(logPurgeMaxSize);
        if (state != null) {
            this.updateLogConfiguration(state);
            state.copyTo(this.ivLog);
        }
    }

    public void setLogPurgeByTimeEnabled(boolean logPurgeByTimeEnabled) {
        LogState state = this.ivLog.setPurgeByTimeEnabled(logPurgeByTimeEnabled);
        if (state != null) {
            this.updateLogConfiguration(state);
            state.copyTo(this.ivLog);
        }
    }

    public void setLogPurgeMinTime(long logPurgeMinTime) {
        LogState state = this.ivLog.setPurgeMinTime(logPurgeMinTime);
        if (state != null) {
            this.updateLogConfiguration(state);
            state.copyTo(this.ivLog);
        }
    }

    public void setLogOutOfSpaceAction(String logOutOfSpaceAction) {
        LogState state = this.ivLog.setOutOfSpaceAction(logOutOfSpaceAction);
        if (state != null) {
            this.updateLogConfiguration(state);
            state.copyTo(this.ivLog);
        }
    }

    public void setLogBufferingEnabled(boolean logBufferingEnabled) {
        LogState state = this.ivLog.setBufferingEnabled(logBufferingEnabled);
        if (state != null) {
            this.updateLogConfiguration(state);
            state.copyTo(this.ivLog);
        }
    }

    public void setLogFileSwitchEnabled(boolean logFileSwitchEnabled) {
        LogState state = this.ivLog.setFileSwitchEnabled(logFileSwitchEnabled);
        if (state != null) {
            this.updateLogConfiguration(state);
            state.copyTo(this.ivLog);
        }
    }

    public void setLogFileSwitchTime(int logFileSwitchTime) {
        LogState state = this.ivLog.setFileSwitchTime(logFileSwitchTime);
        if (state != null) {
            this.updateLogConfiguration(state);
            state.copyTo(this.ivLog);
        }
    }

    private void updateTraceConfiguration(TraceState state) {
        if (DIRECTORY_TYPE.equals(state.ivStorageType)) {
            LogRepositoryComponent.setTraceDirectoryDestination(state.ivDataDirectory, state.ivPurgeBySizeEnabled, state.ivPurgeByTimeEnabled, state.ivFileSwitchEnabled, state.ivBufferingEnabled, state.ivPurgeMaxSize * 0x100000L, state.ivPurgeMinTime * 3600000L, state.ivFileSwitchTime, state.ivOutOfSpaceAction);
        } else if (MEMORYBUFFER_TYPE.equals(state.ivStorageType)) {
            LogRepositoryComponent.setTraceMemoryDestination(state.ivDataDirectory, state.ivMemoryBufferSize * 0x100000L);
        } else {
            throw new IllegalArgumentException("Unknown value for trace storage type: " + state.ivStorageType);
        }
    }

    public void setTrace(String dataDirectory, boolean enablePurgeBySize, boolean enablePurgeByTime, long maxSize, long minPurgeTime, String outOfSpaceAction, boolean enableBuffering, boolean fileSwitchEnabled, int fileSwitchTime) {
        TraceState state = (TraceState)this.ivTrace.clone();
        state.ivStorageType = DIRECTORY_TYPE;
        state.ivDataDirectory = dataDirectory;
        state.ivPurgeBySizeEnabled = enablePurgeBySize;
        state.ivPurgeByTimeEnabled = enablePurgeByTime;
        state.ivPurgeMaxSize = maxSize;
        state.ivPurgeMinTime = minPurgeTime;
        state.ivOutOfSpaceAction = outOfSpaceAction;
        state.ivBufferingEnabled = enableBuffering;
        state.ivFileSwitchEnabled = fileSwitchEnabled;
        state.ivFileSwitchTime = fileSwitchTime;
        this.updateTraceConfiguration(state);
        state.copyTo(this.ivTrace);
    }

    public void setTraceMemory(String dataDirectory, long memoryBufferSize) {
        TraceState state = (TraceState)this.ivTrace.clone();
        state.ivStorageType = MEMORYBUFFER_TYPE;
        state.ivDataDirectory = dataDirectory;
        state.ivMemoryBufferSize = memoryBufferSize;
        this.updateTraceConfiguration(state);
        state.copyTo(this.ivTrace);
    }

    public String getTraceStorageType() {
        return this.ivTrace.ivStorageType;
    }

    public String getTraceDataDirectory() {
        return this.ivTrace.ivDataDirectory;
    }

    public boolean isTracePurgeBySizeEnabled() {
        return this.ivTrace.ivPurgeBySizeEnabled;
    }

    public long getTracePurgeMaxSize() {
        return this.ivTrace.ivPurgeMaxSize;
    }

    public boolean isTracePurgeByTimeEnabled() {
        return this.ivTrace.ivPurgeByTimeEnabled;
    }

    public long getTracePurgeMinTime() {
        return this.ivTrace.ivPurgeMinTime;
    }

    public long getTraceMemoryBufferSize() {
        return this.ivTrace.ivMemoryBufferSize;
    }

    public String getTraceOutOfSpaceAction() {
        return this.ivTrace.ivOutOfSpaceAction;
    }

    public boolean isTraceBufferingEnabled() {
        return this.ivTrace.ivBufferingEnabled;
    }

    public boolean isTraceFileSwitchEnabled() {
        return this.ivTrace.ivFileSwitchEnabled;
    }

    public int getTraceFileSwitchTime() {
        return this.ivTrace.ivFileSwitchTime;
    }

    public void setTraceStorageType(String trcStorageType) {
        TraceState state = this.ivTrace.setStorageType(trcStorageType);
        if (state != null) {
            this.updateTraceConfiguration(state);
            state.copyTo(this.ivTrace);
        }
    }

    public void setTraceDataDirectory(String trcDataDirectory) {
        TraceState state = (TraceState)this.ivTrace.setDataDirectory(trcDataDirectory);
        if (state != null) {
            this.updateTraceConfiguration(state);
            state.copyTo(this.ivTrace);
        }
    }

    public void setTracePurgeBySizeEnabled(boolean trcPurgeBySizeEnabled) {
        TraceState state = (TraceState)this.ivTrace.setPurgeBySizeEnabled(trcPurgeBySizeEnabled);
        if (state != null) {
            this.updateTraceConfiguration(state);
            state.copyTo(this.ivTrace);
        }
    }

    public void setTracePurgeMaxSize(long trcPurgeMaxSize) {
        TraceState state = (TraceState)this.ivTrace.setPurgeMaxSize(trcPurgeMaxSize);
        if (state != null) {
            this.updateTraceConfiguration(state);
            state.copyTo(this.ivTrace);
        }
    }

    public void setTracePurgeByTimeEnabled(boolean trcPurgeByTimeEnabled) {
        TraceState state = (TraceState)this.ivTrace.setPurgeByTimeEnabled(trcPurgeByTimeEnabled);
        if (state != null) {
            this.updateTraceConfiguration(state);
            state.copyTo(this.ivTrace);
        }
    }

    public void setTracePurgeMinTime(long trcPurgeMinTime) {
        TraceState state = (TraceState)this.ivTrace.setPurgeMinTime(trcPurgeMinTime);
        if (state != null) {
            this.updateTraceConfiguration(state);
            state.copyTo(this.ivTrace);
        }
    }

    public void setTraceMemoryBufferSize(long trcMemoryBufferSize) {
        TraceState state = this.ivTrace.setMemoryBufferSize(trcMemoryBufferSize);
        if (state != null) {
            this.updateTraceConfiguration(state);
            state.copyTo(this.ivTrace);
        }
    }

    public void setTraceOutOfSpaceAction(String trcOutOfSpaceAction) {
        TraceState state = (TraceState)this.ivTrace.setOutOfSpaceAction(trcOutOfSpaceAction);
        if (state != null) {
            this.updateTraceConfiguration(state);
            state.copyTo(this.ivTrace);
        }
    }

    public void setTraceBufferingEnabled(boolean trcBufferingEnabled) {
        TraceState state = (TraceState)this.ivTrace.setBufferingEnabled(trcBufferingEnabled);
        if (state != null) {
            this.updateTraceConfiguration(state);
            state.copyTo(this.ivTrace);
        }
    }

    public void setTraceFileSwitchEnabled(boolean trcFileSwitchEnabled) {
        TraceState state = (TraceState)this.ivTrace.setFileSwitchEnabled(trcFileSwitchEnabled);
        if (state != null) {
            this.updateTraceConfiguration(state);
            state.copyTo(this.ivTrace);
        }
    }

    public void setTraceFileSwitchTime(int trcFileSwitchTime) {
        TraceState state = (TraceState)this.ivTrace.setFileSwitchTime(trcFileSwitchTime);
        if (state != null) {
            this.updateTraceConfiguration(state);
            state.copyTo(this.ivTrace);
        }
    }

    private void updateTextConfiguration(TextState state) {
        if (state.ivEnabled) {
            LogRepositoryComponent.setTextDestination(state.ivDataDirectory, state.ivPurgeBySizeEnabled, state.ivPurgeByTimeEnabled, state.ivFileSwitchEnabled, state.ivBufferingEnabled, state.ivPurgeMaxSize * 0x100000L, state.ivPurgeMinTime * 3600000L, state.ivFileSwitchTime, state.ivOutOfSpaceAction, state.ivOutputFormat, state.ivTraceIncluded);
        } else {
            LogRepositoryComponent.disableTextDestination();
        }
    }

    public void setTextLog(boolean enabled, String dataDirectory, boolean enablePurgeBySize, boolean enablePurgeByTime, long purgeMaxSize, long purgeMinTime, String outOfSpaceAction, String outputFormat, boolean traceIncluded, boolean enableBuffering, boolean fileSwitchEnabled, int fileSwitchTime) {
        TextState state = (TextState)this.ivText.clone();
        state.ivEnabled = enabled;
        state.ivDataDirectory = dataDirectory;
        state.ivPurgeBySizeEnabled = enablePurgeBySize;
        state.ivPurgeByTimeEnabled = enablePurgeByTime;
        state.ivPurgeMaxSize = purgeMaxSize;
        state.ivPurgeMinTime = purgeMinTime;
        state.ivOutOfSpaceAction = outOfSpaceAction;
        state.ivTraceIncluded = traceIncluded;
        state.ivOutputFormat = outputFormat;
        state.ivBufferingEnabled = enableBuffering;
        state.ivFileSwitchEnabled = fileSwitchEnabled;
        state.ivFileSwitchTime = fileSwitchTime;
        this.updateTextConfiguration(state);
        state.copyTo(this.ivText);
    }

    public boolean isTextEnabled() {
        return this.ivText.ivEnabled;
    }

    public String getTextDataDirectory() {
        return this.ivText.ivDataDirectory;
    }

    public boolean isTextPurgeBySizeEnabled() {
        return this.ivText.ivPurgeBySizeEnabled;
    }

    public boolean isTextPurgeByTimeEnabled() {
        return this.ivText.ivPurgeByTimeEnabled;
    }

    public long getTextPurgeMaxSize() {
        return this.ivText.ivPurgeMaxSize;
    }

    public long getTextPurgeMinTime() {
        return this.ivText.ivPurgeMinTime;
    }

    public String getTextOutOfSpaceAction() {
        return this.ivText.ivOutOfSpaceAction;
    }

    public boolean isTextTraceIncluded() {
        return this.ivText.ivTraceIncluded;
    }

    public String getTextOutputFormat() {
        return this.ivText.ivOutputFormat;
    }

    public boolean isTextBufferingEnabled() {
        return this.ivText.ivBufferingEnabled;
    }

    public boolean isTextFileSwitchEnabled() {
        return this.ivText.ivFileSwitchEnabled;
    }

    public int getTextFileSwitchTime() {
        return this.ivText.ivFileSwitchTime;
    }

    public void setTextEnabled(boolean txtEnabled) {
        TextState state = this.ivText.setEnabled(txtEnabled);
        if (state != null) {
            this.updateTextConfiguration(state);
            state.copyTo(this.ivText);
        }
    }

    public void setTextDataDirectory(String txtDataDirectory) {
        TextState state = (TextState)this.ivText.setDataDirectory(txtDataDirectory);
        if (state != null) {
            this.updateTextConfiguration(state);
            state.copyTo(this.ivText);
        }
    }

    public void setTextPurgeBySizeEnabled(boolean txtPurgeBySizeEnabled) {
        TextState state = (TextState)this.ivText.setPurgeBySizeEnabled(txtPurgeBySizeEnabled);
        if (state != null) {
            this.updateTextConfiguration(state);
            state.copyTo(this.ivText);
        }
    }

    public void setTextPurgeByTimeEnabled(boolean txtPurgeByTimeEnabled) {
        TextState state = (TextState)this.ivText.setPurgeByTimeEnabled(txtPurgeByTimeEnabled);
        if (state != null) {
            this.updateTextConfiguration(state);
            state.copyTo(this.ivText);
        }
    }

    public void setTextPurgeMaxSize(long txtPurgeMaxSize) {
        TextState state = (TextState)this.ivText.setPurgeMaxSize(txtPurgeMaxSize);
        if (state != null) {
            this.updateTextConfiguration(state);
            state.copyTo(this.ivText);
        }
    }

    public void setTextPurgeMinTime(long txtPurgeMinTime) {
        TextState state = (TextState)this.ivText.setPurgeMinTime(txtPurgeMinTime);
        if (state != null) {
            this.updateTextConfiguration(state);
            state.copyTo(this.ivText);
        }
    }

    public void setTextOutOfSpaceAction(String txtOutOfSpaceAction) {
        TextState state = (TextState)this.ivText.setOutOfSpaceAction(txtOutOfSpaceAction);
        if (state != null) {
            this.updateTextConfiguration(state);
            state.copyTo(this.ivText);
        }
    }

    public void setTextTraceIncluded(boolean txtTraceIncluded) {
        TextState state = this.ivText.setTraceIncluded(txtTraceIncluded);
        if (state != null) {
            this.updateTextConfiguration(state);
            state.copyTo(this.ivText);
        }
    }

    public void setTextOutputFormat(String txtOutputFormat) {
        TextState state = this.ivText.setOutputFormat(txtOutputFormat);
        if (state != null) {
            this.updateTextConfiguration(state);
            state.copyTo(this.ivText);
        }
    }

    public void setTextBufferingEnabled(boolean txtBufferingEnabled) {
        TextState state = (TextState)this.ivText.setBufferingEnabled(txtBufferingEnabled);
        if (state != null) {
            this.updateTextConfiguration(state);
            state.copyTo(this.ivText);
        }
    }

    public void setTextFileSwitchEnabled(boolean txtFileSwitchEnabled) {
        TextState state = (TextState)this.ivText.setFileSwitchEnabled(txtFileSwitchEnabled);
        if (state != null) {
            this.updateTextConfiguration(state);
            state.copyTo(this.ivText);
        }
    }

    public void setTextFileSwitchTime(int txtFileSwitchTime) {
        TextState state = (TextState)this.ivText.setFileSwitchTime(txtFileSwitchTime);
        if (state != null) {
            this.updateTextConfiguration(state);
            state.copyTo(this.ivText);
        }
    }

    public void restartHpel() {
        this.updateLogConfiguration(this.ivLog);
        this.updateTraceConfiguration(this.ivTrace);
        LogRepositoryComponent.start();
        if (this.ivText.ivEnabled) {
            this.updateTextConfiguration(this.ivText);
        }
    }

    private class TextState
    extends LogState {
        boolean ivEnabled;
        boolean ivTraceIncluded;
        String ivOutputFormat;

        private TextState() {
            this.ivEnabled = false;
            this.ivOutputFormat = "Basic";
        }

        @Override
        protected void copyTo(LogState other) {
            super.copyTo(other);
            if (other instanceof TextState) {
                ((TextState)other).ivEnabled = this.ivEnabled;
                ((TextState)other).ivTraceIncluded = this.ivTraceIncluded;
                ((TextState)other).ivOutputFormat = this.ivOutputFormat;
            }
        }

        @Override
        protected LogState newInstance() {
            return new TextState();
        }

        TextState setEnabled(boolean enabled) {
            if (enabled != this.ivEnabled) {
                TextState copy = (TextState)this.clone();
                copy.ivEnabled = enabled;
                return copy;
            }
            return null;
        }

        TextState setTraceIncluded(boolean traceIncluded) {
            if (traceIncluded != this.ivTraceIncluded) {
                TextState copy = (TextState)this.clone();
                copy.ivTraceIncluded = traceIncluded;
                return copy;
            }
            return null;
        }

        TextState setOutputFormat(String outputFormat) {
            if (outputFormat != null && !outputFormat.equals(this.ivOutputFormat)) {
                TextState copy = (TextState)this.clone();
                copy.ivOutputFormat = outputFormat;
                return copy;
            }
            return null;
        }
    }

    private class TraceState
    extends LogState {
        String ivStorageType;
        long ivMemoryBufferSize;

        private TraceState() {
            this.ivStorageType = LogRepositoryConfiguration.DIRECTORY_TYPE;
        }

        @Override
        protected void copyTo(LogState other) {
            super.copyTo(other);
            if (other instanceof TraceState) {
                ((TraceState)other).ivStorageType = this.ivStorageType;
                ((TraceState)other).ivMemoryBufferSize = this.ivMemoryBufferSize;
            }
        }

        @Override
        protected LogState newInstance() {
            return new TraceState();
        }

        TraceState setStorageType(String storageType) {
            if (storageType != null && !storageType.equals(this.ivStorageType)) {
                TraceState copy = (TraceState)this.clone();
                copy.ivStorageType = storageType;
                return copy;
            }
            return null;
        }

        TraceState setMemoryBufferSize(long memoryBufferSize) {
            if (memoryBufferSize != this.ivMemoryBufferSize) {
                TraceState copy = (TraceState)this.clone();
                copy.ivMemoryBufferSize = memoryBufferSize;
                return copy;
            }
            return null;
        }
    }

    private class LogState {
        String ivDataDirectory;
        boolean ivPurgeBySizeEnabled;
        long ivPurgeMaxSize;
        boolean ivPurgeByTimeEnabled;
        long ivPurgeMinTime;
        String ivOutOfSpaceAction = "StopLogging";
        boolean ivBufferingEnabled;
        boolean ivFileSwitchEnabled;
        int ivFileSwitchTime;

        private LogState() {
        }

        protected void copyTo(LogState other) {
            other.ivDataDirectory = this.ivDataDirectory;
            other.ivPurgeBySizeEnabled = this.ivPurgeBySizeEnabled;
            other.ivPurgeMaxSize = this.ivPurgeMaxSize;
            other.ivPurgeByTimeEnabled = this.ivPurgeByTimeEnabled;
            other.ivPurgeMinTime = this.ivPurgeMinTime;
            other.ivOutOfSpaceAction = this.ivOutOfSpaceAction;
            other.ivBufferingEnabled = this.ivBufferingEnabled;
            other.ivFileSwitchEnabled = this.ivFileSwitchEnabled;
            other.ivFileSwitchTime = this.ivFileSwitchTime;
        }

        protected LogState newInstance() {
            return new LogState();
        }

        protected LogState clone() {
            LogState copy = this.newInstance();
            this.copyTo(copy);
            return copy;
        }

        LogState setDataDirectory(String dataDirectory) {
            if (dataDirectory != null && !dataDirectory.equals(this.ivDataDirectory)) {
                LogState copy = this.clone();
                copy.ivDataDirectory = dataDirectory;
                return copy;
            }
            return null;
        }

        LogState setPurgeBySizeEnabled(boolean purgeBySizeEnabled) {
            if (purgeBySizeEnabled != this.ivPurgeBySizeEnabled) {
                LogState copy = this.clone();
                copy.ivPurgeBySizeEnabled = purgeBySizeEnabled;
                return copy;
            }
            return null;
        }

        LogState setPurgeMaxSize(long purgeMaxSize) {
            if (purgeMaxSize != this.ivPurgeMaxSize) {
                LogState copy = this.clone();
                copy.ivPurgeMaxSize = purgeMaxSize;
                return copy;
            }
            return null;
        }

        LogState setPurgeByTimeEnabled(boolean purgeByTimeEnabled) {
            if (purgeByTimeEnabled != this.ivPurgeByTimeEnabled) {
                LogState copy = this.clone();
                copy.ivPurgeByTimeEnabled = purgeByTimeEnabled;
                return copy;
            }
            return null;
        }

        LogState setPurgeMinTime(long purgeMinTime) {
            if (purgeMinTime != this.ivPurgeMinTime) {
                LogState copy = this.clone();
                copy.ivPurgeMinTime = purgeMinTime;
                return copy;
            }
            return null;
        }

        LogState setOutOfSpaceAction(String outOfSpaceAction) {
            if (outOfSpaceAction != null && !outOfSpaceAction.equals(this.ivOutOfSpaceAction)) {
                LogState copy = this.clone();
                copy.ivOutOfSpaceAction = outOfSpaceAction;
                return copy;
            }
            return null;
        }

        LogState setBufferingEnabled(boolean bufferingEnabled) {
            if (bufferingEnabled != this.ivBufferingEnabled) {
                LogState copy = this.clone();
                copy.ivBufferingEnabled = bufferingEnabled;
                return copy;
            }
            return null;
        }

        LogState setFileSwitchEnabled(boolean fileSwitchEnabled) {
            if (fileSwitchEnabled != this.ivFileSwitchEnabled) {
                LogState copy = this.clone();
                copy.ivFileSwitchEnabled = fileSwitchEnabled;
                return copy;
            }
            return null;
        }

        LogState setFileSwitchTime(int fileSwitchTime) {
            if (fileSwitchTime != this.ivFileSwitchTime) {
                LogState copy = this.clone();
                copy.ivFileSwitchTime = fileSwitchTime;
                return copy;
            }
            return null;
        }
    }
}

