/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.reader.tasks;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.security.audit.encryption.AuditEncryptionImpl;
import com.ibm.ws.security.audit.encryption.AuditSigningImpl;
import com.ibm.ws.security.audit.reader.utils.CommandUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.spec.SecretKeySpec;

public class AuditLogReader {
    private static Logger theLogger = Logger.getLogger(AuditLogReader.class.getName());
    private static TraceComponent tc = Tr.register(AuditLogReader.class, (String)"AUDIT", (String)"com.ibm.ws.security.audit.reader");
    private static FileWriter outputFile = null;
    private static final String begin = "<auditRecord>";
    private static final String end = "</auditRecord>";
    private static final String newline = "\n";
    private static final String signatureOpenTag = "<signature>";
    private static final String signatureCloseTag = "</signature>";
    private static String signingCertAlias = new String();
    private static String signingKeyStoreLocation = new String();
    private static String signingKeyStoreName = new String();
    private static String encryptedSignerSharedKey = new String();
    private static String encCertAlias = new String();
    private static String encKeyStoreLocation = new String();
    private static String encKeyStoreName = new String();
    private static String encSharedKey = new String();
    private static boolean debugEnabled = false;

    public static String getReport(String fileName, String outputLocation, String encrypted, String encKeyStoreLoc, String encKeyStorePassword, String encKeyStoreType, String signed, String signingKeyStoreLoc, String signingKeyStorePassword, String signingKeyStoreType, boolean isDebug) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getReport: fileName: " + fileName + " outputLocation: " + outputLocation), (Object[])new Object[0]);
        }
        if (isDebug) {
            debugEnabled = true;
            Handler[] handlers = Logger.getLogger("").getHandlers();
            for (int index = 0; index < handlers.length; ++index) {
                handlers[index].setLevel(Level.FINE);
            }
            theLogger.setLevel(Level.FINE);
            theLogger.fine("fileName: " + fileName + " outputLocation: " + outputLocation);
        }
        encKeyStoreLocation = encKeyStoreLoc;
        signingKeyStoreLocation = signingKeyStoreLoc;
        try {
            AuditLogReader.processLog(fileName, outputLocation, encrypted, encKeyStoreLocation, encKeyStorePassword, encKeyStoreType, signed, signingKeyStoreLocation, signingKeyStorePassword, signingKeyStoreType);
            outputFile.close();
            BufferedReader br = new BufferedReader(new FileReader(outputLocation));
            if (br.readLine() == null) {
                File f = new File(outputLocation);
                f.deleteOnExit();
            }
            br.close();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getReport");
            }
            return "done";
        }
        catch (Exception e) {
            outputFile.close();
            BufferedReader br = new BufferedReader(new FileReader(outputLocation));
            if (br.readLine() == null) {
                File f = new File(outputLocation);
                f.deleteOnExit();
            }
            br.close();
            throw e;
        }
    }

    public static void processLog(String filename, String outputLocation, String encrypted, String encKeyStoreLocation, String encKeyStorePassword, String encKeyStoreType, String signed, String signingKeyStoreLocation, String signingKeyStorePassword, String signingKeyStoreType) throws Exception {
        block71: {
            try {
                String z;
                byte[] decryptedSharedKey;
                String x;
                byte[] sk;
                byte[] yy;
                AuditSigningImpl as;
                FileReader file_reader = new FileReader(filename);
                BufferedReader buffered_reader = new BufferedReader(file_reader);
                if (debugEnabled) {
                    theLogger.fine("processLog: filename: " + filename + " outputLocation: " + outputLocation + " encrypted: " + encrypted + " encKeyStoreLocation: " + encKeyStoreLocation + " encKeyStoreType: " + encKeyStoreType + " signed: " + signed + " signingKeyStoreLocation: " + signingKeyStoreLocation + " signingKeyStoreType: " + signingKeyStoreType);
                }
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)("processLog: filename: " + filename + " outputLocation: " + outputLocation + " encrypted: " + encrypted + " encKeyStoreLocation: " + encKeyStoreLocation + " encKeyStoreType: " + encKeyStoreType + " signed: " + signed + " signingKeyStoreLocation: " + signingKeyStoreLocation + " signingKeyStoreType: " + signingKeyStoreType), (Object[])new Object[0]);
                }
                String s = null;
                outputFile = new FileWriter(outputLocation);
                boolean encryptedLog = false;
                boolean signedLog = false;
                while ((s = buffered_reader.readLine()) != null) {
                    String f;
                    int ends;
                    if (s.contains("<EncryptionInformation>")) {
                        encryptedLog = true;
                    }
                    if (s.contains("<SigningInformation>")) {
                        signedLog = true;
                    }
                    if (s.contains("<encryptionKeyStore>")) {
                        ends = s.indexOf("</encryptionKeyStore>");
                        f = s.substring(23, ends);
                        if (debugEnabled) {
                            theLogger.fine("encryption keystore location from audit log: " + f);
                        }
                        if (encKeyStoreLocation == null || encKeyStoreLocation.isEmpty() || encKeyStoreLocation.length() == 0) {
                            encKeyStoreLocation = f;
                        }
                        if (debugEnabled) {
                            theLogger.fine("using encKeyStoreLocation from audit log: " + encKeyStoreLocation);
                        }
                    }
                    if (!s.contains("<signingKeyStore>")) continue;
                    ends = s.indexOf("</signingKeyStore>");
                    f = s.substring(20, ends);
                    if (debugEnabled) {
                        theLogger.fine("signing keystore location from audit log: " + f);
                    }
                    if (signingKeyStoreLocation == null || signingKeyStoreLocation.isEmpty() || signingKeyStoreLocation.length() == 0) {
                        signingKeyStoreLocation = f;
                    }
                    if (!debugEnabled) continue;
                    theLogger.fine("using signingKeyStoreLocation from audit log: " + signingKeyStoreLocation);
                }
                if (encryptedLog && !signedLog && (encrypted == null || encrypted.equals("false"))) {
                    if (debugEnabled) {
                        theLogger.fine("The audit log, " + filename + ", is encrypted but the --encrypted argument was either not specified or was specified and set to false.");
                    }
                    String msg = CommandUtils.getMessage("audit.MismatchingEncrypt", filename);
                    throw new Exception(msg);
                }
                if (!encryptedLog && signedLog && (signed == null || signed.equals("false"))) {
                    if (debugEnabled) {
                        theLogger.fine("The audit log, " + filename + ", is signed but the --signed argument was either not specified or was specified and set to false.");
                    }
                    String msg = CommandUtils.getMessage("audit.MismatchingSign", filename);
                    throw new Exception(msg);
                }
                if (encryptedLog && signedLog && (encrypted == null || encrypted.equals("false") || signed == null || signed.equals("false"))) {
                    if (debugEnabled) {
                        theLogger.fine("The audit log, " + filename + ", is encrypted and signed, but either the --signed or -- encrypted argument was either not specfiied or was specified and set to false.");
                    }
                    String msg = CommandUtils.getMessage("audit.MismatchingEncryptSign", filename);
                    throw new Exception(msg);
                }
                buffered_reader.close();
                if (debugEnabled) {
                    theLogger.fine("signedLog: " + signedLog + " encryptedLog: " + encryptedLog);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("signedLog: " + signedLog + " encryptedLog: " + encryptedLog), (Object[])new Object[0]);
                }
                if (signedLog || encryptedLog) {
                    AuditLogReader.getEncryptionAndSigningData(filename, signedLog, encryptedLog);
                }
                if (signedLog && !encryptedLog) {
                    Key publicKey = null;
                    publicKey = AuditLogReader.getPublicKey(signingKeyStoreType, signingKeyStoreLocation, signingKeyStorePassword, signingCertAlias);
                    as = null;
                    try {
                        as = new AuditSigningImpl(signingKeyStoreName, signingKeyStoreLocation, signingKeyStoreType, null, signingKeyStorePassword, signingCertAlias);
                    }
                    catch (Exception ase) {
                        throw new Exception(ase);
                    }
                    yy = Base64Coder.base64Decode((byte[])encryptedSignerSharedKey.getBytes("UTF8"));
                    sk = encryptedSignerSharedKey.getBytes();
                    x = new String(sk);
                    decryptedSharedKey = as.decryptSharedKey(yy, publicKey);
                    z = new String(decryptedSharedKey);
                    file_reader = new FileReader(filename);
                    AuditLogReader.processRecord(file_reader, signedLog, encryptedLog, null, null);
                }
                if (encryptedLog && !signedLog) {
                    if (encKeyStorePassword == null || encKeyStorePassword.length() == 0) {
                        String msg = CommandUtils.getMessage("audit.NoKeyStorePasswordValue", encKeyStoreLocation);
                        throw new Exception(msg);
                    }
                    Key publicKey = null;
                    publicKey = AuditLogReader.getPublicKey(encKeyStoreType, encKeyStoreLocation, encKeyStorePassword, encCertAlias);
                    AuditEncryptionImpl ae = null;
                    try {
                        ae = new AuditEncryptionImpl(encKeyStoreName, encKeyStoreLocation, encKeyStoreType, null, encKeyStorePassword, encCertAlias);
                    }
                    catch (Exception aee) {
                        throw new Exception(aee);
                    }
                    yy = Base64Coder.base64Decode((byte[])encSharedKey.getBytes("UTF8"));
                    sk = encSharedKey.getBytes();
                    x = new String(sk);
                    decryptedSharedKey = ae.decryptSharedKey(yy, publicKey);
                    z = new String(decryptedSharedKey);
                    file_reader = new FileReader(filename);
                    AuditLogReader.processRecord(file_reader, signedLog, encryptedLog, decryptedSharedKey, ae);
                }
                if (encryptedLog && signedLog) {
                    if (encKeyStorePassword == null || encKeyStorePassword.length() == 0) {
                        String msg = CommandUtils.getMessage("audit.NoKeyStorePasswordValue", encKeyStoreLocation);
                        throw new Exception(msg);
                    }
                    if (signingKeyStorePassword == null || signingKeyStorePassword.length() == 0) {
                        String msg = CommandUtils.getMessage("audit.NoKeyStorePasswordValue", signingKeyStoreLocation);
                        throw new Exception(msg);
                    }
                    Key publicKey = null;
                    try {
                        publicKey = AuditLogReader.getPublicKey(signingKeyStoreType, signingKeyStoreLocation, signingKeyStorePassword, signingCertAlias);
                    }
                    catch (Exception e) {
                        if (debugEnabled) {
                            theLogger.fine("exception getting public key for our signed records" + e.getMessage());
                        }
                        throw e;
                    }
                    as = null;
                    try {
                        as = new AuditSigningImpl(signingKeyStoreName, signingKeyStoreLocation, signingKeyStoreType, null, signingKeyStorePassword, signingCertAlias);
                    }
                    catch (Exception ase) {
                        throw new Exception(ase);
                    }
                    yy = Base64Coder.base64Decode((byte[])encryptedSignerSharedKey.getBytes("UTF8"));
                    sk = encryptedSignerSharedKey.getBytes();
                    byte[] decryptedSignedSharedKey = as.decryptSharedKey(yy, publicKey);
                    try {
                        publicKey = AuditLogReader.getPublicKey(encKeyStoreType, encKeyStoreLocation, encKeyStorePassword, encCertAlias);
                    }
                    catch (Exception e) {
                        if (debugEnabled) {
                            theLogger.fine("exception getting public key for our encrypted records" + e.getMessage());
                        }
                        throw e;
                    }
                    AuditEncryptionImpl ae = null;
                    if (debugEnabled) {
                        theLogger.fine("encKeyStoreName: " + encKeyStoreName + " encKeyStoreLocation: " + encKeyStoreLocation + " encKeyStoreType: " + encKeyStoreType + "encCertAlias: " + encCertAlias);
                    }
                    try {
                        ae = new AuditEncryptionImpl(encKeyStoreName, encKeyStoreLocation, encKeyStoreType, null, encKeyStorePassword, encCertAlias);
                    }
                    catch (Exception aee) {
                        if (debugEnabled) {
                            theLogger.fine("exception getting newing up an AuditEncryptionImpl" + aee.getMessage());
                        }
                        throw new Exception(aee);
                    }
                    yy = Base64Coder.base64Decode((byte[])encSharedKey.getBytes("UTF8"));
                    if (debugEnabled) {
                        theLogger.fine("Was able to base64Decode the encrypted shared key");
                    }
                    byte[] decryptedSharedKey2 = ae.decryptSharedKey(yy, publicKey);
                    if (debugEnabled) {
                        theLogger.fine("Was able to decrypt shared key");
                    }
                    if (debugEnabled) {
                        theLogger.fine("filename: " + filename);
                    }
                    try {
                        file_reader = new FileReader(filename);
                    }
                    catch (FileNotFoundException fnf) {
                        if (debugEnabled) {
                            theLogger.fine("File " + filename + " not found." + fnf.getMessage());
                        }
                        throw fnf;
                    }
                    AuditLogReader.processRecord(file_reader, signedLog, encryptedLog, decryptedSharedKey2, ae);
                }
                if (encryptedLog || signedLog) break block71;
                file_reader = new FileReader(filename);
                buffered_reader = new BufferedReader(file_reader);
                while ((s = buffered_reader.readLine()) != null) {
                    AuditLogReader.parseRecord(s);
                }
                buffered_reader.close();
            }
            catch (UnknownHostException uhe) {
                String msg = CommandUtils.getMessage("security.audit.UnknownHost", null);
                msg = msg.concat(" ").concat(uhe.getMessage());
                throw new Exception(msg);
            }
            catch (KeyStoreException ke) {
                String msg = CommandUtils.getMessage("security.audit.KeyStoreException", null);
                msg = msg.concat(" ").concat(ke.getMessage());
                throw new Exception(msg);
            }
            catch (NoSuchProviderException nspe) {
                String msg = CommandUtils.getMessage("security.audit.NoSuchProviderException", null);
                msg = msg.concat(" ").concat(nspe.getMessage());
                throw new Exception(msg);
            }
            catch (MalformedURLException mue) {
                String msg = CommandUtils.getMessage("security.audit.MalformedURLException", null);
                msg = msg.concat(" ").concat(mue.getMessage());
                throw new Exception(msg);
            }
            catch (CertificateException ce) {
                String msg = CommandUtils.getMessage("security.audit.CertificateException", null);
                msg = msg.concat(" ").concat(ce.getMessage());
                throw new Exception(msg);
            }
            catch (NoSuchAlgorithmException nsae) {
                String msg = CommandUtils.getMessage("security.audit.NoSuchAlgorithmException", null);
                msg = msg.concat(" ").concat(nsae.getMessage());
                throw new Exception(msg);
            }
            catch (FileNotFoundException fnf) {
                throw fnf;
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                throw e;
            }
        }
    }

    public static void processRecord(FileReader file_reader, boolean signedLog, boolean encryptedLog, byte[] decryptedSharedKey, AuditEncryptionImpl ae) throws Exception {
        String auditRecord = new String();
        String capturedRecord = new String();
        boolean startOfRecord = false;
        int num_captured_records = 0;
        String rec = null;
        try {
            int inByte;
            do {
                if ((inByte = file_reader.read()) == -1) continue;
                auditRecord = auditRecord.concat(Character.toString((char)inByte));
                if (startOfRecord) {
                    capturedRecord = capturedRecord.concat(Character.toString((char)inByte));
                }
                if (!startOfRecord && auditRecord.contains(begin)) {
                    startOfRecord = true;
                    capturedRecord = "";
                }
                if (!auditRecord.contains(end)) continue;
                if (!startOfRecord) {
                    if (debugEnabled) {
                        theLogger.fine("WARNING: reached an end before a begin: " + auditRecord);
                    }
                    Tr.audit((TraceComponent)tc, (String)("WARNING: reached an end before a begin: " + auditRecord), (Object[])new Object[0]);
                    auditRecord = "";
                    capturedRecord = "";
                    continue;
                }
                startOfRecord = false;
                int lenRec = capturedRecord.length();
                if (capturedRecord.contains(begin)) {
                    if (debugEnabled) {
                        theLogger.fine("WARNING: reached a begin before the end: " + auditRecord);
                    }
                    Tr.audit((TraceComponent)tc, (String)("WARNING: reached a begin before the end: " + auditRecord), (Object[])new Object[0]);
                    auditRecord = "";
                    capturedRecord = "";
                    continue;
                }
                capturedRecord = capturedRecord.substring(0, lenRec - 14);
                capturedRecord = capturedRecord.trim();
                ++num_captured_records;
                auditRecord = "";
                byte[] bites = capturedRecord.getBytes("UTF8");
                if (bites.length % 4 != 0 && debugEnabled) {
                    theLogger.fine("capturedRecord length: " + bites.length + " capturedRecord: " + capturedRecord);
                }
                byte[] decodedRecord = Base64Coder.base64Decode((byte[])capturedRecord.getBytes("UTF8"));
                if (signedLog && !encryptedLog) {
                    rec = new String(decodedRecord);
                    int index3 = rec.indexOf(signatureOpenTag);
                    rec = rec.substring(0, index3);
                } else if (!signedLog && encryptedLog) {
                    SecretKeySpec recreatedSharedKey = new SecretKeySpec(decryptedSharedKey, "DESede");
                    byte[] decryptedRecord = ae.decrypt(decodedRecord, (Key)recreatedSharedKey);
                    if (decryptedRecord != null) {
                        rec = new String(decryptedRecord);
                    }
                } else if (signedLog && encryptedLog) {
                    String parsedSigRecord = new String();
                    byte[] strippedRecord = null;
                    for (int i = 0; i < decodedRecord.length; ++i) {
                        if (!(parsedSigRecord = parsedSigRecord.concat(Character.toString((char)decodedRecord[i]))).contains(signatureOpenTag)) continue;
                        strippedRecord = new byte[parsedSigRecord.length() - signatureOpenTag.length()];
                        System.arraycopy(decodedRecord, 0, strippedRecord, 0, parsedSigRecord.length() - signatureOpenTag.length());
                        break;
                    }
                    SecretKeySpec recreatedSharedKey = new SecretKeySpec(decryptedSharedKey, "DESede");
                    if (tc.isDebugEnabled()) {
                        byte[] byArray = recreatedSharedKey.getEncoded();
                    }
                    byte[] decryptedRecord = ae.decrypt(strippedRecord, (Key)recreatedSharedKey);
                    rec = new String(decryptedRecord);
                }
                AuditLogReader.parseRecord(rec);
            } while (inByte != -1);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public static Key getPublicKey(String keyStoreType, String keyStoreLocation, String keyStorePassword, String certAlias) throws KeyStoreException, NoSuchProviderException, MalformedURLException, IOException, CertificateException, NoSuchAlgorithmException, Exception {
        KeyStore ks = null;
        PublicKey publicKey = null;
        InputStream is = null;
        X509Certificate c = null;
        try {
            ks = KeyStore.getInstance(keyStoreType);
        }
        catch (KeyStoreException ke) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore.", (Object[])new Object[]{ke.getMessage()});
            }
            if (debugEnabled) {
                theLogger.fine("Exception opening keystore: " + ke.getMessage());
            }
            throw ke;
        }
        try {
            is = AuditLogReader.openKeyStore(keyStoreLocation);
        }
        catch (MalformedURLException me) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore: malformed URL.", (Object[])new Object[]{me.getMessage()});
            }
            if (debugEnabled) {
                theLogger.fine("Exception opening keystore: malformed URL: " + me.getMessage());
            }
            throw me;
        }
        catch (IOException ioe) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore.", (Object[])new Object[]{ioe.getMessage()});
            }
            if (debugEnabled) {
                theLogger.fine("Exception opening keystore: " + ioe.getMessage());
            }
            throw ioe;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Successfully opened the keystore at " + keyStoreLocation), (Object[])new Object[0]);
        }
        if (debugEnabled) {
            theLogger.fine("Successfully opened the keystore at: " + keyStoreLocation);
        }
        try {
            ks.load(is, keyStorePassword.toCharArray());
        }
        catch (CertificateException ce) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"CertificateException while loading keystore.", (Object[])new Object[]{ce.getMessage()});
            }
            if (debugEnabled) {
                theLogger.fine("CertificateException while loading keystore: " + ce.getMessage());
            }
            throw ce;
        }
        catch (IOException ioe) {
            String msg = CommandUtils.getMessage("security.audit.ErrorLoadingKeystore", keyStoreLocation);
            msg = msg.concat(" ").concat(ioe.getMessage());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"IOException while loading keystore.", (Object[])new Object[]{ioe.getMessage()});
            }
            if (debugEnabled) {
                theLogger.fine("IOException while loading keystore: " + msg);
            }
            throw new IOException(msg);
        }
        catch (NoSuchAlgorithmException ae) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"NoSuchAlgorithmException while loading keystore: no such algorithm", (Object[])new Object[]{ae.getMessage()});
            }
            if (debugEnabled) {
                theLogger.fine("NoSuchAlgorithmException while loading keystore:  no such algorithm: " + ae.getMessage());
            }
            throw ae;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Successfully loaded the keystore at " + keyStoreLocation), (Object[])new Object[0]);
        }
        if (debugEnabled) {
            theLogger.fine("Successfully loaded the keystore at: " + keyStoreLocation);
        }
        try {
            c = (X509Certificate)ks.getCertificate(certAlias);
        }
        catch (KeyStoreException ke) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting certficate from keystore.", (Object[])new Object[]{ke.getMessage()});
            }
            if (debugEnabled) {
                theLogger.fine("Exception getting certificate from keystore: " + ke.getMessage());
            }
            throw ke;
        }
        if (c == null) {
            if (debugEnabled) {
                theLogger.fine("Failed to get certificate " + certAlias + " from the keystore " + keyStoreLocation);
            }
            String msg = CommandUtils.getMessage("security.audit.CannotFindCertificate", certAlias, keyStoreLocation);
            throw new Exception(msg);
        }
        if (debugEnabled) {
            theLogger.fine("Succeeded getting the certificate " + certAlias + " from the keystore " + keyStoreLocation);
        }
        publicKey = c.getPublicKey();
        if (debugEnabled) {
            theLogger.fine("returning public key");
        }
        return publicKey;
    }

    public static void getEncryptionAndSigningData(String filename, boolean signedLog, boolean encryptedLog) throws Exception {
        boolean foundSignerCertAlias = false;
        boolean foundSignerKeyStore = false;
        boolean foundSignerKeyStoreName = false;
        boolean foundEncryptedSignerSharedKey = false;
        boolean foundEncryptionCertAlias = false;
        boolean foundEncryptionKeyStore = false;
        boolean foundEncryptedSharedKey = false;
        String s = null;
        try {
            FileReader file_reader = new FileReader(filename);
            BufferedReader buffered_reader = new BufferedReader(file_reader);
            while ((s = buffered_reader.readLine()) != null) {
                String string;
                int index2;
                int index1;
                if (s.contains("signingCertAlias")) {
                    foundSignerCertAlias = true;
                    index1 = s.indexOf(">");
                    index2 = s.indexOf("</signingCertAlias>");
                    signingCertAlias = s.substring(index1 + 1, index2);
                } else if (s.contains("signingKeyStore")) {
                    foundSignerKeyStore = true;
                    index1 = s.indexOf(">");
                    index2 = s.indexOf("</signingKeyStore>");
                    string = s.substring(index1 + 1, index2);
                } else if (s.contains("signingSharedKey")) {
                    foundEncryptedSignerSharedKey = true;
                    index1 = s.indexOf(">");
                    index2 = s.indexOf("</signingSharedKey");
                    encryptedSignerSharedKey = s.substring(index1 + 1, index2);
                }
                if (s.contains("encryptionCertAlias")) {
                    foundEncryptionCertAlias = true;
                    index1 = s.indexOf(">");
                    index2 = s.indexOf("</encryptionCertAlias>");
                    encCertAlias = s.substring(index1 + 1, index2);
                } else if (s.contains("encryptionKeyStore")) {
                    foundEncryptionKeyStore = true;
                    index1 = s.indexOf(">");
                    index2 = s.indexOf("</encryptionKeyStore>");
                    string = s.substring(index1 + 1, index2);
                } else if (s.contains("encryptedSharedKey")) {
                    foundEncryptedSharedKey = true;
                    index1 = s.indexOf(">");
                    index2 = s.indexOf("</encryptedSharedKey");
                    encSharedKey = s.substring(index1 + 1, index2);
                }
                if (signedLog && !encryptedLog) {
                    if (!foundSignerCertAlias || !foundSignerKeyStore || !foundEncryptedSignerSharedKey) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("signingKeyStoreLocation: " + signingKeyStoreLocation + " signingCertAlias: " + signingCertAlias), (Object[])new Object[0]);
                    }
                    if (!debugEnabled) break;
                    theLogger.fine("signingKeyStoreLocation: " + signingKeyStoreLocation + " signingCertAlias: " + signingCertAlias);
                    break;
                }
                if (!signedLog && encryptedLog) {
                    if (!foundEncryptionCertAlias || !foundEncryptionKeyStore || !foundEncryptedSharedKey) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("encCertAlias: " + encCertAlias + " encKeyStoreLocation: " + encKeyStoreLocation), (Object[])new Object[0]);
                    }
                    if (!debugEnabled) break;
                    theLogger.fine("encCertAlias: " + encCertAlias + " encKeyStoreLocation: " + encKeyStoreLocation);
                    break;
                }
                if (!signedLog || !encryptedLog || !foundEncryptionCertAlias || !foundEncryptionKeyStore || !foundEncryptedSharedKey || !foundSignerCertAlias || !foundSignerKeyStore || !foundEncryptedSignerSharedKey) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("encCertAlias: " + encCertAlias + " encKeyStoreLocation: " + encKeyStoreLocation), (Object[])new Object[0]);
                }
                if (debugEnabled) {
                    theLogger.fine("encCertAlias: " + encCertAlias + " encKeyStoreLocation: " + encKeyStoreLocation);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(" signingKeyStoreLocation: " + signingKeyStoreLocation + "signingCertAlias: " + signingCertAlias), (Object[])new Object[0]);
                }
                if (!debugEnabled) break;
                theLogger.fine("signingKeyStoreLocation: " + signingKeyStoreLocation + " signingCertAlias: " + signingCertAlias);
                break;
            }
            file_reader.close();
            buffered_reader.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
    }

    public static void parseRecord(String s) throws Exception {
        outputFile.write(s);
        outputFile.write(newline);
    }

    protected static InputStream openKeyStore(String fileName) throws MalformedURLException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("openKeyStore" + fileName), (Object[])new Object[0]);
        }
        try {
            OpenKeyStoreAction action = new OpenKeyStoreAction(fileName);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"openKeyStore");
            }
            return (InputStream)AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore.", (Object[])new Object[]{ex});
            }
            if (debugEnabled) {
                theLogger.fine("Exception opening keystore: " + ex.getMessage());
            }
            if (ex instanceof MalformedURLException) {
                throw (MalformedURLException)ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex.getMessage());
        }
    }

    static class OpenKeyStoreAction
    implements PrivilegedExceptionAction {
        private String file = null;

        public OpenKeyStoreAction(String fileName) {
            this.file = fileName;
        }

        public Object run() throws MalformedURLException, IOException {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"OpenKeyStoreAction.run", (Object[])new Object[0]);
            }
            InputStream fis = null;
            URL urlFile = null;
            File kfile = new File(this.file);
            if (kfile.exists() && kfile.length() == 0L) {
                if (debugEnabled) {
                    theLogger.fine("Keystore file exists, but is empty: " + this.file);
                }
                throw new IOException("Keystore file exists, but is empty: " + this.file);
            }
            urlFile = !kfile.exists() ? new URL(this.file) : new URL("file:" + kfile.getCanonicalPath());
            fis = urlFile.openStream();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"OpenKeyStoreAction.run");
            }
            return fis;
        }
    }
}

