/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.xml.internal.ConfigRefresher;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.filemonitor.FileMonitor;
import java.io.File;
import java.util.Collection;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ConfigFileMonitor
implements com.ibm.ws.kernel.filemonitor.FileMonitor {
    static final TraceComponent tc = Tr.register(ConfigFileMonitor.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private ServiceRegistration<FileMonitor> serviceRegistration;
    private Long monitorInterval;
    private Collection<String> monitoredFiles;
    private Collection<String> monitoredDirectories;
    private final boolean modified;
    private String monitorType;
    private final BundleContext bundleContext;
    private final ConfigRefresher configRefresher;
    static final long serialVersionUID = 1798270985904240469L;

    public ConfigFileMonitor(BundleContext bc, Collection<String> monitoredFiles, Collection<String> directoriesToMonitor, Long monitorInterval, boolean modified, String fileMonitorType, ConfigRefresher refresher) {
        this.bundleContext = bc;
        this.monitoredFiles = monitoredFiles;
        this.monitoredDirectories = directoriesToMonitor;
        this.monitorInterval = monitorInterval;
        this.modified = modified;
        this.monitorType = fileMonitorType;
        this.configRefresher = refresher;
    }

    void register() {
        Hashtable<String, Object> properties = this.getFileMonitorProperties();
        this.serviceRegistration = this.bundleContext.registerService(FileMonitor.class, (Object)this, properties);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Configuration monitoring is enabled. Monitoring interval is " + this.monitorInterval), (Object[])new Object[0]);
        }
    }

    void unregister() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Configuration monitoring is disabled.", (Object[])new Object[0]);
        }
    }

    private Hashtable<String, Object> getFileMonitorProperties() {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        properties.put("monitor.files", this.monitoredFiles);
        properties.put("monitor.directories", this.monitoredDirectories);
        properties.put("monitor.interval", this.monitorInterval);
        properties.put("monitor.type", this.monitorType);
        properties.put("monitor.recurse", false);
        properties.put("monitor.filter", ".*");
        properties.put("monitor.identification", "com.ibm.ws.kernel.monitor.config");
        return properties;
    }

    void updateFileMonitor(Long monitorInterval, String fileMonitorType) {
        if (this.monitorInterval.equals(monitorInterval) && this.monitorType.equals(fileMonitorType)) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Updating FileMonitor with a new monitoring interval: " + monitorInterval + " and type: " + fileMonitorType), (Object[])new Object[0]);
        }
        this.monitorInterval = monitorInterval;
        this.monitorType = fileMonitorType;
        Hashtable<String, Object> properties = this.getFileMonitorProperties();
        this.serviceRegistration.setProperties(properties);
    }

    void updateFileMonitor(Collection<String> filesToMonitor) {
        if (this.monitoredFiles.equals(filesToMonitor)) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Updating FileMonitor with a new set of files to monitor: " + filesToMonitor), (Object[])new Object[0]);
        }
        this.monitoredFiles = filesToMonitor;
        Hashtable<String, Object> properties = this.getFileMonitorProperties();
        this.serviceRegistration.setProperties(properties);
    }

    void updateDirectoryMonitor(Collection<String> directories) {
        if (this.monitoredDirectories.equals(directories)) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Updating FileMonitor with a new set of directories to monitor: " + directories), (Object[])new Object[0]);
        }
        this.monitoredDirectories = directories;
        Hashtable<String, Object> properties = this.getFileMonitorProperties();
        this.serviceRegistration.setProperties(properties);
    }

    public void onBaseline(Collection<File> baseline) {
        if (this.modified) {
            this.configRefresher.refreshConfiguration();
        }
    }

    public void onChange(Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles) {
        this.configRefresher.refreshConfiguration();
    }

    public void onChange(Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles, String filter) {
        this.configRefresher.refreshConfiguration();
    }
}

