/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.diagnostics.osgi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.container.BlueprintEvent;
import org.osgi.service.blueprint.container.BlueprintListener;
import org.osgi.service.blueprint.reflect.BeanArgument;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.MapEntry;
import org.osgi.service.blueprint.reflect.ReferenceListMetadata;
import org.osgi.service.blueprint.reflect.ReferenceMetadata;
import org.osgi.service.blueprint.reflect.ServiceMetadata;
import org.osgi.service.blueprint.reflect.ServiceReferenceMetadata;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BlueprintIntrospectorDetails
implements BlueprintListener {
    private final Map<Long, BlueprintState> states = new ConcurrentHashMap<Long, BlueprintState>();
    private final ServiceRegistration<BlueprintListener> reg;
    private final BundleContext bc;
    static final long serialVersionUID = -7907477295333995123L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    BlueprintIntrospectorDetails(BundleContext bc) {
        this.bc = bc;
        this.reg = bc.registerService(BlueprintListener.class, (Object)this, new Hashtable());
    }

    public void blueprintEvent(BlueprintEvent event) {
        this.states.put(event.getBundle().getBundleId(), BlueprintState.values()[event.getType()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @FFDCIgnore(value={InvalidSyntaxException.class, IllegalStateException.class})
    public void dump(PrintWriter b) {
        block33: {
            try {
                ServiceReference[] list = null;
                try {
                    list = this.bc.getAllServiceReferences("org.osgi.service.blueprint.container.BlueprintContainer", null);
                }
                catch (InvalidSyntaxException e) {
                    b.println("Unable to dump blueprint container details: bad service filter");
                    this.reg.unregister();
                    return;
                }
                catch (IllegalStateException ex) {
                    b.println("Unable to dump blueprint container details: bundle context is invalid (bundle has been stopped).");
                    this.reg.unregister();
                    return;
                }
                List<ServiceReference> containers = Arrays.asList(list);
                Collections.sort(containers, new Comparator<ServiceReference<BlueprintContainer>>(){
                    static final long serialVersionUID = -1563121176262520015L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public int compare(ServiceReference<BlueprintContainer> arg0, ServiceReference<BlueprintContainer> arg1) {
                        return Long.signum(arg0.getBundle().getBundleId() - arg1.getBundle().getBundleId());
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.diagnostics.osgi.BlueprintIntrospectorDetails$1", 1.class, null, null);
                    }
                });
                for (ServiceReference containerRef : containers) {
                    b.println();
                    b.append("Bundle: ").append(containerRef.getBundle().getSymbolicName()).append("(").append(Long.toString(containerRef.getBundle().getBundleId())).append(") Blueprint State: ").append(String.valueOf((Object)this.states.get(containerRef.getBundle().getBundleId()))).println();
                    BlueprintContainer container = (BlueprintContainer)this.bc.getService(containerRef);
                    if (container != null) {
                        for (String id : container.getComponentIds()) {
                            List deps;
                            ComponentMetadata md = container.getComponentMetadata(id);
                            if (md instanceof BeanMetadata) {
                                BeanMetadata bmd = (BeanMetadata)md;
                                b.append("  Bean: ").append(id).append(md.getActivation() == 1 ? " (Eager)" : " (Lazy)").append(" (").append(bmd.getScope() == null ? "singleton" : bmd.getScope()).append(")").append(" class: ").append(bmd.getClassName()).println();
                                if (bmd.getInitMethod() != null) {
                                    b.append("    Init method: ").append(bmd.getInitMethod()).println();
                                }
                                if (bmd.getDestroyMethod() != null) {
                                    b.append("    Destroy method: ").append(bmd.getDestroyMethod()).println();
                                }
                                if (bmd.getFactoryMethod() != null) {
                                    b.append("    Factory method: ").append(bmd.getFactoryMethod()).println();
                                }
                                if (bmd.getFactoryComponent() != null) {
                                    b.append("    Factory component: ").append(String.valueOf(bmd.getFactoryComponent())).println();
                                }
                                if (!bmd.getArguments().isEmpty()) {
                                    b.println("    Arguments:");
                                    for (BeanArgument m : bmd.getArguments()) {
                                        b.append("      ").append(String.valueOf(m)).println();
                                    }
                                }
                                if (!bmd.getProperties().isEmpty()) {
                                    b.println("    Properties:");
                                    for (BeanArgument m : bmd.getProperties()) {
                                        b.append("      ").append(String.valueOf(m)).println();
                                    }
                                }
                            } else if (md instanceof ReferenceListMetadata) {
                                ReferenceListMetadata rlmd = (ReferenceListMetadata)md;
                                b.append("  Reference List: ").append(id).append(", ").append(rlmd.getComponentName()).println();
                            } else if (md instanceof ReferenceMetadata) {
                                ReferenceMetadata rmd = (ReferenceMetadata)md;
                                b.append("  Reference: ").append(id).append(rmd.getComponentName()).println();
                            } else if (md instanceof ServiceMetadata) {
                                ServiceMetadata smd = (ServiceMetadata)md;
                                b.append("  Service: ").append(id).append(md.getActivation() == 1 ? " (Eager)" : " (Lazy)").append(" Ranking: ").append(Integer.toString(smd.getRanking())).append(" Auto-Export: ").append(String.valueOf((Object)AutoExport.values()[smd.getAutoExport()])).append(" Interfaces: ").append(String.valueOf(smd.getInterfaces())).println();
                                if (!smd.getServiceProperties().isEmpty()) {
                                    b.println("    Service Properties:");
                                    for (MapEntry entry : smd.getServiceProperties()) {
                                        b.append("      key=").append(String.valueOf(entry.getKey())).append(", value=").append(String.valueOf(entry.getValue())).println();
                                    }
                                }
                            } else {
                                b.append("  Component: ").append(id).println();
                            }
                            if (md instanceof ServiceReferenceMetadata) {
                                ServiceReferenceMetadata srmd = (ServiceReferenceMetadata)md;
                                b.append(srmd.getAvailability() == 2 ? " (Optional)" : " (Mandatory)").append(md.getActivation() == 1 ? " (Eager)" : " (Lazy)").println();
                                b.append("   Interface: ").append(srmd.getInterface()).println();
                                if (srmd.getComponentName() != null) {
                                    b.append("    Component Name: ").append(srmd.getComponentName()).println();
                                }
                                if (srmd.getFilter() != null) {
                                    b.append("    Filter: ").append(srmd.getFilter()).println();
                                }
                            }
                            if ((deps = md.getDependsOn()).isEmpty()) continue;
                            b.println("    Dependencies:");
                            for (String dep : deps) {
                                b.append("      ").append(dep).println();
                            }
                        }
                        continue;
                    }
                    b.println("  null container");
                }
                {
                    break block33;
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.reg.unregister();
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.diagnostics.osgi.BlueprintIntrospectorDetails", BlueprintIntrospectorDetails.class, null, null);
    }

    private static enum AutoExport {
        unknown,
        Disabled,
        Interfaces,
        ClassHierarchy,
        AllClasses;

    }

    private static enum BlueprintState {
        unknown,
        creating,
        created,
        destroying,
        destroyed,
        failure,
        gracePeriod,
        waiting;

    }
}

