/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.featureUtility.cli;

import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.InstallKernelFactory;
import com.ibm.ws.install.InstallKernelInteractive;
import com.ibm.ws.install.featureUtility.FeatureUtility;
import com.ibm.ws.install.featureUtility.FeatureUtilityExecutor;
import com.ibm.ws.install.featureUtility.cli.FeatureAction;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.ProgressBar;
import com.ibm.ws.install.internal.asset.ServerAsset;
import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.cmdline.ActionHandler;
import com.ibm.ws.kernel.boot.cmdline.Arguments;
import com.ibm.ws.kernel.boot.cmdline.ExitCode;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.feature.internal.cmdline.ArgumentsImpl;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.product.utility.CommandConsole;
import com.ibm.ws.product.utility.CommandTaskRegistry;
import com.ibm.ws.product.utility.ExecutionContext;
import com.ibm.ws.product.utility.extension.ValidateCommandTask;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InstallServerAction
implements ActionHandler {
    private FeatureUtility featureUtility;
    private InstallKernelInteractive installKernel;
    private Set<ServerAsset> servers;
    private Logger logger;
    private List<String> argList;
    private List<String> featureNames;
    private String fromDir;
    private String toDir;
    private String featuresBom;
    private List<String> additionalJsons;
    private Boolean noCache;
    private Boolean acceptLicense;
    private ProgressBar progressBar;
    private Map<String, String> featureToExt;

    public ExitCode handleTask(PrintStream stdout, PrintStream stderr, Arguments args) {
        if (args.getPositionalArguments().isEmpty()) {
            FeatureAction.help.handleTask((Arguments)new ArgumentsImpl(new String[]{"help", FeatureAction.getEnum(args.getAction()).toString()}));
            return ReturnCode.BAD_ARGUMENT;
        }
        ExitCode rc = this.initialize(args);
        if (!rc.equals(ReturnCode.OK)) {
            return rc;
        }
        rc = this.execute();
        return rc;
    }

    private ExitCode initialize(Arguments args) {
        ReturnCode rc = ReturnCode.OK;
        this.logger = InstallLogUtils.getInstallLogger();
        this.installKernel = InstallKernelFactory.getInteractiveInstance();
        this.featureNames = new ArrayList<String>();
        this.servers = new HashSet<ServerAsset>();
        this.argList = args.getPositionalArguments();
        this.fromDir = args.getOption("from");
        rc = this.validateFromDir(this.fromDir);
        if (rc != ReturnCode.OK) {
            return rc;
        }
        this.noCache = args.getOption("nocache") != null;
        this.acceptLicense = args.getOption("acceptlicense") != null;
        this.featuresBom = args.getOption("featuresbom");
        this.additionalJsons = new ArrayList<String>();
        try {
            if (this.featuresBom != null && this.checkValidCoord(this.featuresBom)) {
                this.additionalJsons.add(this.bomCoordToJsonCoord(this.featuresBom));
            }
        }
        catch (InstallException e1) {
            this.logger.log(Level.SEVERE, e1.getMessage(), e1);
            return FeatureUtilityExecutor.returnCode(e1.getRc());
        }
        this.toDir = args.getOption("to");
        this.progressBar = ProgressBar.getInstance();
        this.featureToExt = new HashMap<String, String>();
        HashMap<String, Double> methodMap = new HashMap<String, Double>();
        methodMap.put("initializeMap", 5.0);
        methodMap.put("fetchJsons", 10.0);
        methodMap.put("resolvedFeatures", 10.0);
        methodMap.put("fetchArtifacts", 10.0);
        methodMap.put("downloadArtifacts", 25.0);
        methodMap.put("installFeatures", 35.0);
        methodMap.put("cleanUp", 5.0);
        this.progressBar.setMethodMap(methodMap);
        String arg = this.argList.get(0);
        try {
            if (InstallServerAction.isServer(arg)) {
                return this.serverInit(arg);
            }
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("ERROR_SERVER_NOT_EXIST", new Object[]{arg}));
        }
        catch (InstallException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return FeatureUtilityExecutor.returnCode(e.getRc());
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return FeatureUtilityExecutor.returnCode(25);
        }
    }

    private String bomCoordToJsonCoord(String bomCoordinate) {
        String[] coordSplit = bomCoordinate.split(":");
        String groupId = coordSplit[0];
        String artifactId = "features";
        String version = coordSplit[2];
        return String.format("%s:%s:%s", groupId, artifactId, version);
    }

    private boolean checkValidCoord(String bomCoordinate) throws InstallException {
        boolean result = false;
        if (bomCoordinate.split(":").length != 3) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("ERROR_INVALID_FEATURE_BOM_COORDINATE", new Object[]{this.featuresBom}));
        }
        result = true;
        return result;
    }

    private ReturnCode serverInit(String fileName) throws InstallException, IOException {
        File serverXML;
        File file = serverXML = fileName.toLowerCase().endsWith("server.xml") ? new File(fileName) : new File(InstallUtils.getServersDir(), fileName + File.separator + "server.xml");
        if (!serverXML.isFile()) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_UNABLE_TO_FIND_SERVER_XML", new Object[]{serverXML.getParent()}));
        }
        this.servers.add(new ServerAsset(serverXML));
        return ReturnCode.OK;
    }

    private static boolean isServer(String fileName) {
        return new File(InstallUtils.getServersDir(), fileName).isDirectory() || fileName.toLowerCase().endsWith("server.xml");
    }

    private ReturnCode validateFromDir(String fromDir) {
        if (fromDir == null) {
            return ReturnCode.OK;
        }
        if (fromDir.isEmpty()) {
            this.logger.log(Level.SEVERE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_DIRECTORY_REQUIRED", new Object[]{"from"}));
            return ReturnCode.BAD_ARGUMENT;
        }
        if (!new File(fromDir).exists()) {
            this.logger.log(Level.SEVERE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_DIRECTORY_NOT_EXISTS", new Object[]{fromDir}));
            return ReturnCode.BAD_ARGUMENT;
        }
        return ReturnCode.OK;
    }

    private ExitCode installServerFeatures() {
        ReturnCode rc = ReturnCode.OK;
        HashSet<String> featuresToInstall = new HashSet<String>();
        try {
            featuresToInstall.addAll(this.installKernel.getServerFeaturesToInstall(this.servers, false));
            this.logger.fine("all server features: " + featuresToInstall);
        }
        catch (InstallException ie) {
            this.logger.log(Level.SEVERE, ie.getMessage(), ie);
            return FeatureUtilityExecutor.returnCode(ie.getRc());
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            rc = ReturnCode.RUNTIME_EXCEPTION;
        }
        if (featuresToInstall.isEmpty()) {
            this.logger.info(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("MSG_SERVER_NEW_FEATURES_NOT_REQUIRED", new Object[0]));
        } else {
            rc = this.assetInstallInit(featuresToInstall);
        }
        return rc;
    }

    private ExitCode assetInstallInit(Collection<String> assetIds) {
        ArrayList features = new ArrayList();
        ArrayList userFeatures = new ArrayList();
        for (String asset : assetIds) {
            if (asset.contains(":")) {
                String[] assetSplit = asset.split(":");
                this.featureToExt.put(assetSplit[1], assetSplit[0]);
                this.featureNames.add(assetSplit[1]);
                continue;
            }
            this.featureToExt.put(asset, "");
            this.featureNames.add(asset);
        }
        return ReturnCode.OK;
    }

    private ExitCode install() {
        try {
            this.featureUtility = new FeatureUtility.FeatureUtilityBuilder().setFromDir(this.fromDir).setFeaturesToInstall(this.featureNames).setNoCache(this.noCache).setlicenseAccepted(this.acceptLicense).setAdditionalJsons(this.additionalJsons).build();
            this.featureUtility.setFeatureToExt(this.featureToExt);
            this.featureUtility.setIsInstallServerFeature(true);
            this.featureUtility.installFeatures();
        }
        catch (InstallException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return FeatureUtilityExecutor.returnCode(e.getRc());
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return FeatureUtilityExecutor.returnCode(25);
        }
        return ReturnCode.OK;
    }

    private ExitCode execute() {
        ReturnCode rc = ReturnCode.OK;
        if (!this.servers.isEmpty()) {
            rc = this.installServerFeatures();
        }
        if (ReturnCode.OK.equals((Object)rc) && !this.featureNames.isEmpty()) {
            rc = this.install();
        }
        if (ReturnCode.OK.equals((Object)rc)) {
            this.progressBar.finish();
        } else {
            this.progressBar.finishWithError();
        }
        if (ReturnCode.OK.equals((Object)rc) && !this.validateProduct()) {
            rc = ReturnCode.INVALID;
        }
        return rc;
    }

    private boolean validateProduct() {
        BundleRepositoryRegistry.disposeAll();
        BundleRepositoryRegistry.initializeDefaults(null, (boolean)false);
        ValidateCommandTask vcTask = new ValidateCommandTask();
        vcTask.setPrintErrorOnly(true);
        vcTask.setPrintStartMessage(true);
        vcTask.doExecute(new ExecutionContext(){

            public CommandConsole getCommandConsole() {
                return new CommandConsole(){

                    public boolean isInputStreamAvailable() {
                        return false;
                    }

                    public String readMaskedText(String prompt) {
                        return null;
                    }

                    public String readText(String prompt) {
                        return null;
                    }

                    public void printInfoMessage(String message) {
                        InstallServerAction.this.logger.log(Level.INFO, message);
                    }

                    public void printlnInfoMessage(String message) {
                        InstallServerAction.this.logger.log(Level.INFO, message);
                    }

                    public void printErrorMessage(String errorMessage) {
                        InstallServerAction.this.logger.log(Level.SEVERE, errorMessage);
                    }

                    public void printlnErrorMessage(String errorMessage) {
                        InstallServerAction.this.logger.log(Level.SEVERE, errorMessage);
                    }
                };
            }

            public String[] getArguments() {
                return null;
            }

            public Set<String> getOptionNames() {
                return new HashSet<String>();
            }

            public String getOptionValue(String option) {
                return null;
            }

            public boolean optionExists(String option) {
                return false;
            }

            public CommandTaskRegistry getCommandTaskRegistry() {
                return null;
            }

            public <T> T getAttribute(String name, Class<T> cls) {
                if (name.equals("WLP_INSTALLATION_LOCATION")) {
                    return (T)Utils.getInstallDir();
                }
                return null;
            }

            public Object getAttribute(String name) {
                return null;
            }

            public void setAttribute(String name, Object value) {
            }

            public void setOverrideOutputStream(PrintStream outputStream) {
            }
        });
        return vcTask.isSuccessful();
    }
}

