/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.main;

import com.ibm.ws.ras.instrument.internal.main.StaticTraceInstrumentation;
import com.ibm.ws.ras.instrument.internal.model.PackageInfo;
import com.ibm.ws.ras.instrument.internal.model.TraceType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

class Transformer
extends StaticTraceInstrumentation
implements ClassFileTransformer {
    List<String> includesList = new ArrayList<String>();
    List<String> excludesList = new ArrayList<String>();

    Transformer(Properties props, boolean quiet) {
        if (!props.containsKey("packages.include") && !props.containsKey("packages.exclude")) {
            if (!quiet) {
                System.err.println("Dynamic trace transformation is enabled without args");
            }
            this.includesList.add("/");
            this.excludesList.add("java/");
        } else {
            int i;
            String[] packages;
            String packagesValue = props.getProperty("packages.include");
            if (packagesValue != null) {
                packages = packagesValue.split(",");
                for (i = 0; i < packages.length; ++i) {
                    this.includesList.add(packages[i].replaceAll("\\.", "/"));
                }
            }
            if ((packagesValue = props.getProperty("packages.exclude")) != null) {
                packages = packagesValue.split(",");
                for (i = 0; i < packages.length; ++i) {
                    this.excludesList.add(packages[i].replaceAll("\\.", "/"));
                }
            }
            String debug = props.getProperty("debug", "false");
            this.setDebug(Boolean.valueOf(debug));
            String instrumentWithFFDC = props.getProperty("ffdc", "true");
            this.setInstrumentWithFFDC(Boolean.valueOf(instrumentWithFFDC));
            String traceStyle = props.getProperty("style", "jsr47");
            if (traceStyle.equalsIgnoreCase("jsr47")) {
                this.setTraceType(TraceType.JAVA_LOGGING);
            } else if (traceStyle.equalsIgnoreCase("tr")) {
                this.setTraceType(TraceType.TR);
            } else if (traceStyle.equalsIgnoreCase("none")) {
                this.setTraceType(TraceType.NONE);
            }
            String computeFrames = props.getProperty("computeFrames", "false");
            this.setComputeFrames(Boolean.valueOf(computeFrames));
            if (!quiet) {
                System.err.println("Dynamic trace transformation is enabled");
                System.err.println("  includesList = " + this.includesList);
                System.err.println("  excludesList = " + this.excludesList);
                System.err.println("  debug = " + debug);
                System.err.println("  ffdc = " + instrumentWithFFDC);
                System.err.println("  style = " + traceStyle);
                System.err.println("  computeFrames = " + computeFrames);
            }
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (className.startsWith(Transformer.class.getPackage().getName().replaceAll("\\.", "/"))) {
            return null;
        }
        if (className.startsWith("java/util/logging/")) {
            return null;
        }
        boolean include = false;
        for (String s : this.includesList) {
            if (!className.startsWith(s) && !s.equals("/")) continue;
            include = true;
            break;
        }
        for (String s : this.excludesList) {
            if (!className.startsWith(s) && !s.equals("/")) continue;
            include = false;
            break;
        }
        if (!include) {
            return null;
        }
        String internalPackageName = className.replaceAll("/[^/]+$", "");
        PackageInfo packageInfo = this.getPackageInfo(internalPackageName);
        if (packageInfo == null && loader != null) {
            String packageInfoResourceName = internalPackageName + "/package-info.class";
            InputStream is = loader.getResourceAsStream(packageInfoResourceName);
            packageInfo = this.processPackageInfo(is);
            this.addPackageInfo(packageInfo);
        }
        try {
            return this.transform(new ByteArrayInputStream(classfileBuffer));
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }
}

