/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.restfulWS.internal.globalhandler;

import com.ibm.webservices.handler.impl.GlobalHandlerService;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.webservices.handler.GlobalHandlerMessageContext;
import com.ibm.wsspi.webservices.handler.Handler;
import io.openliberty.restfulWS.internal.globalhandler.RESTfulGlobalHandlerMessageContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Provider
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(immediate=true, service={RESTfulWSHandlerImpl.class}, property={"service.vendor=IBM"})
public class RESTfulWSHandlerImpl
implements ClientRequestFilter,
ClientResponseFilter,
ContainerRequestFilter,
ContainerResponseFilter {
    private static final TraceComponent tc = Tr.register(RESTfulWSHandlerImpl.class, (String)"RESTfulWS", null);
    private static Optional<GlobalHandlerService> globalHandlerService;
    @Context
    HttpServletRequest servletRequest;
    @Context
    HttpServletResponse servletResponse;
    static final long serialVersionUID = 5678503304038838608L;

    @Reference(name="GlobalHandlerService", service=GlobalHandlerService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setGlobalHandlerService(GlobalHandlerService service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setGlobalHandlerService " + service), (Object[])new Object[0]);
        }
        globalHandlerService = Optional.of(service);
    }

    protected void unsetGlobalHandlerService(GlobalHandlerService service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setGlobalHandlerService " + service), (Object[])new Object[0]);
        }
        globalHandlerService = Optional.empty();
    }

    public void filter(ClientRequestContext arg0) throws IOException {
        globalHandlerService.ifPresent(ghs -> {
            RESTfulGlobalHandlerMessageContext context = new RESTfulGlobalHandlerMessageContext(false, true, () -> ((ClientRequestContext)arg0).getPropertyNames(), arg_0 -> ((ClientRequestContext)arg0).getProperty(arg_0), (arg_0, arg_1) -> ((ClientRequestContext)arg0).setProperty(arg_0, arg_1), arg_0 -> ((ClientRequestContext)arg0).removeProperty(arg_0), this.servletRequest, this.servletResponse);
            this.execute(ghs.getJAXRSClientSideOutFlowGlobalHandlers(), context);
        });
    }

    public void filter(ClientRequestContext arg0, ClientResponseContext arg1) throws IOException {
        globalHandlerService.ifPresent(ghs -> {
            RESTfulGlobalHandlerMessageContext context = new RESTfulGlobalHandlerMessageContext(false, false, () -> ((ClientRequestContext)arg0).getPropertyNames(), arg_0 -> ((ClientRequestContext)arg0).getProperty(arg_0), (arg_0, arg_1) -> ((ClientRequestContext)arg0).setProperty(arg_0, arg_1), arg_0 -> ((ClientRequestContext)arg0).removeProperty(arg_0), this.servletRequest, this.servletResponse);
            this.execute(ghs.getJAXRSClientSideInFlowGlobalHandlers(), context);
        });
    }

    public void filter(ContainerRequestContext arg0) throws IOException {
        globalHandlerService.ifPresent(ghs -> {
            RESTfulGlobalHandlerMessageContext context = new RESTfulGlobalHandlerMessageContext(true, false, () -> ((ContainerRequestContext)arg0).getPropertyNames(), arg_0 -> ((ContainerRequestContext)arg0).getProperty(arg_0), (arg_0, arg_1) -> ((ContainerRequestContext)arg0).setProperty(arg_0, arg_1), arg_0 -> ((ContainerRequestContext)arg0).removeProperty(arg_0), this.servletRequest, this.servletResponse);
            this.execute(ghs.getJAXRSServerSideInFlowGlobalHandlers(), context);
        });
    }

    public void filter(ContainerRequestContext arg0, ContainerResponseContext arg1) throws IOException {
        globalHandlerService.ifPresent(ghs -> {
            RESTfulGlobalHandlerMessageContext context = new RESTfulGlobalHandlerMessageContext(true, true, () -> ((ContainerRequestContext)arg0).getPropertyNames(), arg_0 -> ((ContainerRequestContext)arg0).getProperty(arg_0), (arg_0, arg_1) -> ((ContainerRequestContext)arg0).setProperty(arg_0, arg_1), arg_0 -> ((ContainerRequestContext)arg0).removeProperty(arg_0), this.servletRequest, this.servletResponse);
            this.execute(ghs.getJAXRSServerSideOutFlowGlobalHandlers(), context);
        });
    }

    private void execute(List<Handler> handlers, GlobalHandlerMessageContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"execute", (Object[])new Object[]{handlers, context});
        }
        ArrayList<Handler> executedHandlers = new ArrayList<Handler>();
        try {
            for (Handler handler : handlers) {
                handler.handleMessage(context);
                executedHandlers.add(handler);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.restfulWS.internal.globalhandler.RESTfulWSHandlerImpl", (String)"148", (Object)this, (Object[])new Object[]{handlers, context});
            for (int i = executedHandlers.size() - 1; i >= 0; --i) {
                ((Handler)executedHandlers.get(i)).handleFault(context);
            }
        }
    }
}

