/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import jakarta.servlet.http.Part;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.disk.DiskFileItem;

public class SRTServletRequestPart
implements Part {
    protected DiskFileItem _part;
    private static final TraceNLS nls = TraceNLS.getTraceNLS(SRTServletRequestPart.class, (String)"com.ibm.ws.webcontainer.resources.Messages");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.srt.SRTServletRequestPart";
    protected static final Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.srt");

    public SRTServletRequestPart(DiskFileItem item) {
        this._part = item;
    }

    public void delete() throws IOException {
        if (System.getSecurityManager() != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "delete", "via security manager. Location from part [" + this._part.getStoreLocation() + "]");
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws IOException {
                        SRTServletRequestPart.this._part.delete();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception e1 = e.getException();
                if (e1 instanceof IOException) {
                    throw (IOException)e1;
                }
                if (e1 instanceof RuntimeException) {
                    throw (RuntimeException)e1;
                }
                throw new IOException(e1);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "delete", "via DiskFileItem.delete. Location from part [" + this._part.getStoreLocation() + "]");
            }
            this._part.delete();
        }
    }

    public String getContentType() {
        String returnValue = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return SRTServletRequestPart.this._part.getContentType();
            }
        }) : this._part.getContentType();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getContentType", " [" + returnValue + "]");
        }
        return returnValue;
    }

    public String getHeader(String headerName) {
        String returnValue;
        if (System.getSecurityManager() != null) {
            final String finalHeaderName = headerName;
            returnValue = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    FileItemHeaders headers = SRTServletRequestPart.this._part.getHeaders();
                    return headers.getHeader(finalHeaderName);
                }
            });
        } else {
            FileItemHeaders headers = this._part.getHeaders();
            returnValue = headers.getHeader(headerName);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getHeader", " headerName [" + headerName + "] , return value [" + returnValue + "]");
        }
        return returnValue;
    }

    public Collection<String> getHeaderNames() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getHeaderNames", "");
        }
        final ArrayList<String> headerNamesList = new ArrayList<String>();
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    FileItemHeaders headers = SRTServletRequestPart.this._part.getHeaders();
                    Iterator it = headers.getHeaderNames();
                    while (it.hasNext()) {
                        headerNamesList.add((String)it.next());
                    }
                    return null;
                }
            });
        } else {
            FileItemHeaders headers = this._part.getHeaders();
            Iterator it = headers.getHeaderNames();
            while (it.hasNext()) {
                headerNamesList.add((String)it.next());
            }
        }
        return headerNamesList;
    }

    public Collection<String> getHeaders(String headerName) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getHeaders", "");
        }
        final ArrayList<String> headersList = new ArrayList<String>();
        if (System.getSecurityManager() != null) {
            final String finalHeaderName = headerName;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    FileItemHeaders headers = SRTServletRequestPart.this._part.getHeaders();
                    Iterator it = headers.getHeaders(finalHeaderName);
                    while (it.hasNext()) {
                        headersList.add((String)it.next());
                    }
                    return null;
                }
            });
        } else {
            FileItemHeaders headers = this._part.getHeaders();
            Iterator it = headers.getHeaders(headerName);
            while (it.hasNext()) {
                headersList.add((String)it.next());
            }
        }
        return headersList;
    }

    public InputStream getInputStream() throws IOException {
        InputStream returnValue;
        if (System.getSecurityManager() != null) {
            try {
                returnValue = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                    @Override
                    public InputStream run() throws IOException {
                        return SRTServletRequestPart.this._part.getInputStream();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception e1 = e.getException();
                if (e1 instanceof IOException) {
                    throw (IOException)e1;
                }
                if (e1 instanceof RuntimeException) {
                    throw (RuntimeException)e1;
                }
                throw new IOException(e1);
            }
        } else {
            returnValue = this._part.getInputStream();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getInputStream", " [" + returnValue + "]");
        }
        return returnValue;
    }

    public String getName() {
        String returnValue = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return SRTServletRequestPart.this._part.getFieldName();
            }
        }) : this._part.getFieldName();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getName", " [" + returnValue + "]");
        }
        return returnValue;
    }

    public long getSize() {
        long returnValue;
        if (System.getSecurityManager() != null) {
            Long longObjectValue = AccessController.doPrivileged(new PrivilegedAction<Long>(){

                @Override
                public Long run() {
                    return new Long(SRTServletRequestPart.this._part.getSize());
                }
            });
            returnValue = longObjectValue;
        } else {
            returnValue = this._part.getSize();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getSize", " [" + returnValue + "]");
        }
        return returnValue;
    }

    public void write(String fileName) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "write", "fileName [" + fileName + "]");
        }
        if (System.getSecurityManager() != null) {
            try {
                final String finalFileName = fileName;
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        File f = new File(SRTServletRequestPart.this._part.getStoreLocation().getParentFile(), finalFileName);
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, SRTServletRequestPart.CLASS_NAME, "write", "location [" + f + "]");
                            logger.logp(Level.FINE, SRTServletRequestPart.CLASS_NAME, "write", "location from part.getStoreLocation [" + SRTServletRequestPart.this._part.getStoreLocation() + "]");
                        }
                        SRTServletRequestPart.this._part.write(f);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception e1 = e.getException();
                throw new IOException(e1);
            }
        }
        File f = new File(this._part.getStoreLocation().getParentFile(), fileName);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "write", "location [" + f + "]");
            logger.logp(Level.FINE, CLASS_NAME, "write", "location from part.getStoreLocation [" + this._part.getStoreLocation() + "]");
        }
        try {
            this._part.write(f);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public boolean isFormField() {
        boolean returnValue;
        if (System.getSecurityManager() != null) {
            Boolean booleanObjectValue = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return new Boolean(SRTServletRequestPart.this._part.isFormField());
                }
            });
            returnValue = booleanObjectValue;
        } else {
            returnValue = this._part.isFormField();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isFormField", " [" + returnValue + "]");
        }
        return returnValue;
    }
}

