/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.osgi.container.config;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.container.ErrorPage;
import com.ibm.ws.container.service.annotations.FragmentAnnotations;
import com.ibm.ws.container.service.annotations.SpecificAnnotations;
import com.ibm.ws.container.service.annotations.WebAnnotations;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.container.service.config.ServletConfigurator;
import com.ibm.ws.container.service.config.ServletConfiguratorHelper;
import com.ibm.ws.container.service.config.WebFragmentInfo;
import com.ibm.ws.container.service.config.extended.RefBndAndExtHelper;
import com.ibm.ws.injectionengine.osgi.util.OSGiJNDIEnvironmentRefBindingHelper;
import com.ibm.ws.javaee.dd.DeploymentDescriptor;
import com.ibm.ws.javaee.dd.common.AdministeredObject;
import com.ibm.ws.javaee.dd.common.ConnectionFactory;
import com.ibm.ws.javaee.dd.common.ContextService;
import com.ibm.ws.javaee.dd.common.DataSource;
import com.ibm.ws.javaee.dd.common.Description;
import com.ibm.ws.javaee.dd.common.DescriptionGroup;
import com.ibm.ws.javaee.dd.common.DisplayName;
import com.ibm.ws.javaee.dd.common.EJBRef;
import com.ibm.ws.javaee.dd.common.EnvEntry;
import com.ibm.ws.javaee.dd.common.Icon;
import com.ibm.ws.javaee.dd.common.JMSConnectionFactory;
import com.ibm.ws.javaee.dd.common.JMSDestination;
import com.ibm.ws.javaee.dd.common.JNDIEnvironmentRef;
import com.ibm.ws.javaee.dd.common.Listener;
import com.ibm.ws.javaee.dd.common.MailSession;
import com.ibm.ws.javaee.dd.common.ManagedExecutor;
import com.ibm.ws.javaee.dd.common.ManagedScheduledExecutor;
import com.ibm.ws.javaee.dd.common.ManagedThreadFactory;
import com.ibm.ws.javaee.dd.common.MessageDestinationRef;
import com.ibm.ws.javaee.dd.common.ParamValue;
import com.ibm.ws.javaee.dd.common.PersistenceContextRef;
import com.ibm.ws.javaee.dd.common.PersistenceUnitRef;
import com.ibm.ws.javaee.dd.common.ResourceBaseGroup;
import com.ibm.ws.javaee.dd.common.ResourceEnvRef;
import com.ibm.ws.javaee.dd.common.ResourceRef;
import com.ibm.ws.javaee.dd.common.RunAs;
import com.ibm.ws.javaee.dd.common.wsclient.ServiceRef;
import com.ibm.ws.javaee.dd.commonbnd.RefBindingsGroup;
import com.ibm.ws.javaee.dd.web.WebApp;
import com.ibm.ws.javaee.dd.web.WebFragment;
import com.ibm.ws.javaee.dd.web.common.CookieConfig;
import com.ibm.ws.javaee.dd.web.common.FilterMapping;
import com.ibm.ws.javaee.dd.web.common.LocaleEncodingMapping;
import com.ibm.ws.javaee.dd.web.common.LocaleEncodingMappingList;
import com.ibm.ws.javaee.dd.web.common.MimeMapping;
import com.ibm.ws.javaee.dd.web.common.Servlet;
import com.ibm.ws.javaee.dd.web.common.ServletMapping;
import com.ibm.ws.javaee.dd.web.common.SessionConfig;
import com.ibm.ws.javaee.dd.web.common.WelcomeFileList;
import com.ibm.ws.javaee.dd.webbnd.VirtualHost;
import com.ibm.ws.javaee.dd.webbnd.WebBnd;
import com.ibm.ws.javaee.dd.webext.WebExt;
import com.ibm.ws.resource.ResourceRefConfigFactory;
import com.ibm.ws.resource.ResourceRefConfigList;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.session.SessionCookieConfigImpl;
import com.ibm.ws.webcontainer.filter.FilterConfig;
import com.ibm.ws.webcontainer.metadata.EJBRefImpl;
import com.ibm.ws.webcontainer.metadata.EnvEntryImpl;
import com.ibm.ws.webcontainer.metadata.InjectionTargetsEditable;
import com.ibm.ws.webcontainer.metadata.MessageDestinationRefImpl;
import com.ibm.ws.webcontainer.metadata.PersistenceContextRefImpl;
import com.ibm.ws.webcontainer.metadata.PersistenceUnitRefImpl;
import com.ibm.ws.webcontainer.metadata.ResourceEnvRefImpl;
import com.ibm.ws.webcontainer.metadata.ResourceRefImpl;
import com.ibm.ws.webcontainer.metadata.ServiceRefImpl;
import com.ibm.ws.webcontainer.osgi.WebContainer;
import com.ibm.ws.webcontainer.osgi.container.config.merge.AdministeredObjectComparator;
import com.ibm.ws.webcontainer.osgi.container.config.merge.ConnectionFactoryComparator;
import com.ibm.ws.webcontainer.osgi.container.config.merge.ContextServiceComparator;
import com.ibm.ws.webcontainer.osgi.container.config.merge.DataSourceComparator;
import com.ibm.ws.webcontainer.osgi.container.config.merge.EJBRefComparator;
import com.ibm.ws.webcontainer.osgi.container.config.merge.EnvEntryComparator;
import com.ibm.ws.webcontainer.osgi.container.config.merge.JMSConnectionFactoryComparator;
import com.ibm.ws.webcontainer.osgi.container.config.merge.JMSDestinationComparator;
import com.ibm.ws.webcontainer.osgi.container.config.merge.MailSessionComparator;
import com.ibm.ws.webcontainer.osgi.container.config.merge.ManagedExecutorComparator;
import com.ibm.ws.webcontainer.osgi.container.config.merge.ManagedScheduledExecutorComparator;
import com.ibm.ws.webcontainer.osgi.container.config.merge.ManagedThreadFactoryComparator;
import com.ibm.ws.webcontainer.osgi.container.config.merge.MessageDestinationRefComparator;
import com.ibm.ws.webcontainer.osgi.container.config.merge.PersistenceContextRefComparator;
import com.ibm.ws.webcontainer.osgi.container.config.merge.PersistenceUnitRefComparator;
import com.ibm.ws.webcontainer.osgi.container.config.merge.ResourceEnvRefComparator;
import com.ibm.ws.webcontainer.osgi.container.config.merge.ResourceRefComparator;
import com.ibm.ws.webcontainer.osgi.container.config.merge.ServiceRefComparator;
import com.ibm.ws.webcontainer.osgi.metadata.WebComponentMetaDataImpl;
import com.ibm.ws.webcontainer.osgi.webapp.WebAppConfiguration;
import com.ibm.ws.webcontainer.servlet.ServletConfig;
import com.ibm.ws.webcontainer.servlet.TargetConfig;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.info.AnnotationInfo;
import com.ibm.wsspi.anno.info.AnnotationValue;
import com.ibm.wsspi.anno.info.ClassInfo;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.injectionengine.JNDIEnvironmentRefType;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.annotation.MultipartConfig;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.annotation.WebListener;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class WebAppConfiguratorHelper
implements ServletConfiguratorHelper {
    private static final String CLASS_NAME = WebAppConfiguratorHelper.class.getSimpleName();
    private static final TraceComponent tc = Tr.register(WebAppConfiguratorHelper.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.LShimMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS(WebAppConfiguratorHelper.class, (String)"com.ibm.ws.webcontainer.resources.LShimMessages");
    private static final String CDI_CONVERSATION_FILTER = "CDI Conversation Filter";
    private static final EnvEntryComparator ENV_ENTRY_COMPARATOR = new EnvEntryComparator();
    private static final ServiceRefComparator SERVICE_REF_COMPARATOR = new ServiceRefComparator();
    private static final ResourceRefComparator RESOURCE_REF_COMPARATOR = new ResourceRefComparator();
    private static final ResourceEnvRefComparator RESOURCE_ENV_REF_COMPARATOR = new ResourceEnvRefComparator();
    private static final MessageDestinationRefComparator MESSAGE_DESTINATION_REF_COMPARATOR = new MessageDestinationRefComparator();
    private static final PersistenceUnitRefComparator PERSISTENCE_UNIT_REF_COMPARATOR = new PersistenceUnitRefComparator();
    private static final PersistenceContextRefComparator PERSISTENCE_CONTEXT_REF_COMPARATOR = new PersistenceContextRefComparator();
    private static final DataSourceComparator DATA_SOURCE_COMPARATOR = new DataSourceComparator();
    private static final MailSessionComparator MAIL_SESSION_COMPARATOR = new MailSessionComparator();
    private static final EJBRefComparator EJB_REF_COMPARATOR = new EJBRefComparator();
    private static final ConnectionFactoryComparator CF_COMPARATOR = new ConnectionFactoryComparator();
    private static final AdministeredObjectComparator ADMINISTERED_OBJECT_COMPARATOR = new AdministeredObjectComparator();
    private static final ContextServiceComparator CONTEXT_SERVICE_COMPARATOR = new ContextServiceComparator();
    private static final JMSConnectionFactoryComparator JMS_CF_COMPARATOR = new JMSConnectionFactoryComparator();
    private static final JMSDestinationComparator JMS_DESTINATION_COMPARATOR = new JMSDestinationComparator();
    private static final ManagedExecutorComparator MANAGED_EXECUTOR_COMPARATOR = new ManagedExecutorComparator();
    private static final ManagedScheduledExecutorComparator MANAGED_SCHEDULED_EXECUTOR_COMPARATOR = new ManagedScheduledExecutorComparator();
    private static final ManagedThreadFactoryComparator MANAGED_THREAD_FACTORY_COMPARATOR = new ManagedThreadFactoryComparator();
    protected final ServletConfigurator configurator;
    private final List<Class<?>> listenerInterfaces;
    private static boolean allowDefaultErrorPageInServlet30 = WCCustomProperties.ALLOW_DEFAULT_ERROR_PAGE;
    private static boolean deferProcessingIncompleteFiltersInWebXML = WCCustomProperties.DEFER_PROCESSING_INCOMPLETE_FILTERS_IN_WEB_XML;
    protected final ConfigurationWriter webAppConfiguration;
    protected List<DeferredAction> allActions = new ArrayList<DeferredAction>();
    private Set<String> annotationScanningRequiredClasses = new HashSet<String>();
    private Map<String, String> urlToServletNameMap;
    private static final AtomicLong uniqueId = new AtomicLong(1L);
    ArrayList<MappingIndexPair<FilterMapping, Integer>> deferredFilterMappings = new ArrayList();
    int filterMappingIndex = 0;
    int filterMappingIndexOffset = 0;
    public static final String DEFAULT_ERROR_PAGE_KEY = "DEFAULT";

    public static boolean allowDefaultErrorPageInServlet30() {
        return allowDefaultErrorPageInServlet30;
    }

    public static int getVersionId(String version) throws IllegalStateException {
        int versionID = 0;
        if ("6.0".equals(version)) {
            versionID = 60;
        } else if ("5.0".equals(version)) {
            versionID = 50;
        } else if ("4.0".equals(version)) {
            versionID = 40;
        } else if ("3.1".equals(version)) {
            versionID = 31;
        } else if ("3.0".equals(version)) {
            versionID = 30;
        } else if ("2.5".equals(version)) {
            versionID = 25;
        } else if ("2.4".equals(version)) {
            versionID = 24;
        } else if ("2.3".equals(version)) {
            versionID = 23;
        } else if ("2.2".equals(version)) {
            versionID = 22;
        } else {
            throw new IllegalStateException("invalid web-app version");
        }
        return versionID;
    }

    public static int getServletSpecLevel() {
        int containerSpecLevel = WebContainer.getServletContainerSpecLevel();
        return containerSpecLevel;
    }

    public static boolean isServletSpecLevel31OrHigher() {
        return WebAppConfiguratorHelper.getServletSpecLevel() >= 31;
    }

    public static boolean isServletSpecLevel50orLower() {
        return WebAppConfiguratorHelper.getServletSpecLevel() <= 50;
    }

    public static int getDefaultVersionId() {
        return 30;
    }

    public static String generateId() {
        return "WebAppGeneratedId" + uniqueId.getAndIncrement();
    }

    public WebAppConfiguratorHelper(ServletConfigurator configurator, ResourceRefConfigFactory resourceRefConfigFactory, List<Class<?>> listenerInterfaces) {
        this.configurator = configurator;
        WebModuleInfo moduleInfo = (WebModuleInfo)configurator.getFromModuleCache(WebModuleInfo.class);
        ApplicationMetaData amd = ((ExtendedApplicationInfo)moduleInfo.getApplicationInfo()).getMetaData();
        this.webAppConfiguration = new ConfigurationWriter(new WebAppConfiguration(amd, WebAppConfiguratorHelper.generateId()), resourceRefConfigFactory);
        this.webAppConfiguration.setContextRoot(moduleInfo.getContextRoot());
        this.webAppConfiguration.setModuleName(moduleInfo.getName());
        this.webAppConfiguration.setJ2EEModuleName(moduleInfo.getURI());
        this.webAppConfiguration.setApplicationName(moduleInfo.getApplicationInfo().getDeploymentName());
        this.listenerInterfaces = listenerInterfaces;
        if (WebAppConfiguratorHelper.isServletSpecLevel31OrHigher()) {
            this.urlToServletNameMap = new HashMap<String, String>();
        }
    }

    private void removeFromRequiredClasses(Set<String> selectedClassNames, String reason) {
        String mcText;
        String methodName = "removeFromRequiredClasses";
        if (!this.configurator.getMetadataCompleted()) {
            this.annotationScanningRequiredClasses.removeAll(selectedClassNames);
            mcText = ": Metadata-incomplete: Remove: ";
        } else {
            mcText = ": Metadata-Complete: Ignore: ";
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + ": " + reason), (Object[])new Object[0]);
            for (String selectedClassName : selectedClassNames) {
                Tr.debug((TraceComponent)tc, (String)(methodName + mcText + " [ " + selectedClassName + " ]"), (Object[])new Object[0]);
            }
        }
    }

    private void addToRequiredClasses(String className, String reason) {
        String methodName = "addToRequiredClasses";
        if (!this.configurator.getMetadataCompleted()) {
            this.annotationScanningRequiredClasses.add(className);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Metadata-incomplete: Add [ " + className + " ]: " + reason), (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + ": Metadata-complete: Ignore [ " + className + " ]: " + reason), (Object[])new Object[0]);
        }
    }

    private Object getFromModuleCache(String path, Class<?> owner) throws UnableToAdaptException {
        Entry entry = this.configurator.getModuleContainer().getEntry(path);
        if (entry != null) {
            NonPersistentCache entryCache = (NonPersistentCache)entry.adapt(NonPersistentCache.class);
            return entryCache.getFromCache(owner);
        }
        return null;
    }

    public void configureInit() throws UnableToAdaptException {
        String methodName = "configureInit";
        String displayName = this.webAppConfiguration.getDisplayName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"WebAppConfiguration [ " + displayName + " ]"});
        }
        this.configureWebAppVersion();
        this.configureBundleHeaders();
        ArrayList<String> orderedLibPaths = new ArrayList<String>();
        for (WebFragmentInfo fragmentInfo : this.configurator.getWebAnnotations().getOrderedItems()) {
            String libraryURI = fragmentInfo.getLibraryURI();
            if (libraryURI.startsWith("WEB-INF/lib/")) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + ": Adding library fragment [ " + libraryURI + " ]"), (Object[])new Object[0]);
                }
                orderedLibPaths.add(libraryURI.substring("WEB-INF/lib/".length()));
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)(methodName + ": Skipping non-library fragment [ " + libraryURI + " ]"), (Object[])new Object[0]);
        }
        this.configureOrderedLibPaths(orderedLibPaths);
        this.configureContextRoot();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)("WebAppConfiguration [ " + displayName + " ]"));
        }
    }

    private void configureContextRoot() {
        String contextRoot = this.configurator.getContextRootFromServerConfig();
        if (contextRoot != null) {
            this.webAppConfiguration.config.setContextRoot(contextRoot);
        }
    }

    private void configureBundleHeaders() throws UnableToAdaptException {
        Object manifestHeaders = this.getFromModuleCache("/META-INF/MANIFEST.MF", Dictionary.class);
        if (manifestHeaders != null) {
            this.webAppConfiguration.setBundleHeaders((Dictionary)manifestHeaders);
        }
    }

    public void configureFromWebApp(WebApp webApp) throws UnableToAdaptException {
        this.configureDisplayName(webApp.getDisplayNames());
        this.configureDescription(webApp.getDescriptions());
        this.configureContextParam(webApp.getContextParams());
        this.configureErrorPages(webApp.getErrorPages());
        this.configureMimeMapping(webApp.getMimeMappings());
        this.configureWelcomeFileList(webApp.getWelcomeFileList());
        this.configureDistributableFromWebApp(webApp.isSetDistributable());
        if (WebAppConfiguratorHelper.isServletSpecLevel31OrHigher()) {
            this.configureDenyUncoveredHttpMethodsFromWebApp(webApp.isSetDenyUncoveredHttpMethods());
        }
        this.configureSessionConfig(webApp.getSessionConfig());
        this.configureServlets((DeploymentDescriptor)webApp, webApp.getServlets());
        this.configureServletMappings(webApp.getServletMappings());
        this.configureLocaleEncodingMap(webApp.getLocaleEncodingMappingList());
        this.configureListener(webApp.getListeners());
        this.configureEnvEntries(webApp.getEnvEntries());
        this.configureResourceRefs(webApp.getResourceRefs());
        this.configureResourceEnvRefs(webApp.getResourceEnvRefs());
        this.configureMessageDestinationRefs(webApp.getMessageDestinationRefs());
        this.configurePersistenceUnitRefs(webApp.getPersistenceUnitRefs());
        this.configurePersistenceContextRefs(webApp.getPersistenceContextRefs());
        this.configureDataSources(webApp.getDataSources());
        this.configureMailSessions(webApp.getMailSessions());
        this.configureServiceRefs(webApp.getServiceRefs());
        this.configureEJBRefs(webApp.getEJBRefs());
        this.configureEJBLocalRefs(webApp.getEJBLocalRefs());
        this.configureConnectionFactories(webApp.getConnectionFactories());
        this.configureContextServices(webApp.getContextServices());
        this.configureJMSConnectionFactories(webApp.getJMSConnectionFactories());
        this.configureJMSDestinations(webApp.getJMSDestinations());
        this.configureManagedExecutors(webApp.getManagedExecutors());
        this.configureManagedScheduledExecutors(webApp.getManagedScheduledExecutors());
        this.configureManagedThreadFactories(webApp.getManagedThreadFactories());
        this.configureAdministeredObjects(webApp.getAdministeredObjects());
        this.configureFilters((DeploymentDescriptor)webApp, webApp.getFilters());
        this.configureFilterMappings((DeploymentDescriptor)webApp, webApp.getFilterMappings());
    }

    public void configureFromWebFragment(WebFragmentInfo webFragmentItem) throws UnableToAdaptException {
        WebFragment webFragment = webFragmentItem.getWebFragment();
        this.configureContextParam(webFragment.getContextParams());
        this.configureErrorPages(webFragment.getErrorPages());
        this.configureMimeMapping(webFragment.getMimeMappings());
        this.configureWelcomeFileList(webFragment.getWelcomeFileList());
        this.configureDistributableFromFragment(webFragment.isSetDistributable());
        this.configureSessionConfig(webFragment.getSessionConfig());
        this.configureServlets((DeploymentDescriptor)webFragment, webFragment.getServlets());
        this.configureServletMappings(webFragment.getServletMappings());
        this.configureLocaleEncodingMap(webFragment.getLocaleEncodingMappingList());
        this.configureListener(webFragment.getListeners());
        this.configureEnvEntries(webFragment.getEnvEntries());
        this.configureResourceRefs(webFragment.getResourceRefs());
        this.configureResourceEnvRefs(webFragment.getResourceEnvRefs());
        this.configureMessageDestinationRefs(webFragment.getMessageDestinationRefs());
        this.configurePersistenceUnitRefs(webFragment.getPersistenceUnitRefs());
        this.configurePersistenceContextRefs(webFragment.getPersistenceContextRefs());
        this.configureContextServices(webFragment.getContextServices());
        this.configureDataSources(webFragment.getDataSources());
        this.configureManagedExecutors(webFragment.getManagedExecutors());
        this.configureManagedScheduledExecutors(webFragment.getManagedScheduledExecutors());
        this.configureManagedThreadFactories(webFragment.getManagedThreadFactories());
        this.configureServiceRefs(webFragment.getServiceRefs());
        this.configureEJBRefs(webFragment.getEJBRefs());
        this.configureEJBLocalRefs(webFragment.getEJBLocalRefs());
        this.configureFilters((DeploymentDescriptor)webFragment, webFragment.getFilters());
        this.configureFilterMappings((DeploymentDescriptor)webFragment, webFragment.getFilterMappings());
    }

    private void logAnnotations(String methodName, String title, WebFragmentInfo webFragmentItem, Set<String> annotationClassNames) {
        if (annotationClassNames.isEmpty()) {
            return;
        }
        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) {
            return;
        }
        String prefix = CLASS_NAME + "." + methodName + ": ";
        Tr.debug((TraceComponent)tc, (String)(prefix + "[ " + webFragmentItem + " ]: " + title + ": [ " + annotationClassNames.size() + " ]"), (Object[])new Object[0]);
        for (String className : annotationClassNames) {
            Tr.debug((TraceComponent)tc, (String)(prefix + "  [ " + className + " ]"), (Object[])new Object[0]);
        }
    }

    public void configureFromAnnotations(WebFragmentInfo webFragmentItem) throws UnableToAdaptException {
        FragmentAnnotations fragmentAnnotations = this.configurator.getWebAnnotations().getFragmentAnnotations(webFragmentItem);
        Set webServletClassNames = fragmentAnnotations.selectAnnotatedClasses(WebServlet.class);
        this.configureServletAnnotation(webServletClassNames);
        this.configureListenerAnnotation(fragmentAnnotations.selectAnnotatedClasses(WebListener.class));
        this.configureMultipartConfigAnnotation(fragmentAnnotations.selectAnnotatedClasses(MultipartConfig.class));
        this.configureRunAsAnnotation(fragmentAnnotations.selectAnnotatedClasses(jakarta.annotation.security.RunAs.class));
        Set webFilterClassNames = fragmentAnnotations.selectAnnotatedClasses(WebFilter.class);
        this.configureFilterAnnotation(webFilterClassNames);
    }

    public void configureDefaults() throws UnableToAdaptException {
        this.configureSpecifiedClasses();
        for (DeferredAction action : this.allActions) {
            if (action.isAllServletAction()) {
                Map servletMap = this.configurator.getConfigItemMap("servlet");
                for (ServletConfigurator.ConfigItem configItem : servletMap.values()) {
                    ServletConfig servletConfig = (ServletConfig)configItem.getValue();
                    action.doAction(servletConfig);
                }
                continue;
            }
            action.doAction(null);
        }
        this.configureDefaultConfigurations();
    }

    protected void configureSpecificClass(String className) throws UnableToAdaptException {
        Set webFilterClassNames;
        Set multipartClassNames;
        Set webListenerClassNames;
        Set<String> specifiedClasses;
        SpecificAnnotations specificAnnotations;
        Set webServletClassNames;
        boolean isExcluded;
        boolean isSetIsExcluded;
        String skipReason;
        boolean isIncluded;
        String methodName = "configureSpecificClass";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Specific class name [ " + className + " ]"});
        }
        if (this.configurator.isMetadataComplete()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, (Object)"Ignore: Metadata-complete");
            }
            return;
        }
        if (!this.annotationScanningRequiredClasses.contains(className) && TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)"Ignore: Not an annotation scanning required class");
        }
        WebAnnotations webAnnotations = this.configurator.getWebAnnotations();
        boolean skipClass = isIncluded = webAnnotations.isIncludedClass(className);
        if (isIncluded) {
            skipReason = "Seed";
            isSetIsExcluded = false;
            isExcluded = false;
        } else {
            isSetIsExcluded = true;
            skipClass = isExcluded = webAnnotations.isExcludedClass(className);
            skipReason = isExcluded ? "Excluded" : null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            boolean isPartial = webAnnotations.isPartialClass(className);
            if (!isSetIsExcluded) {
                isExcluded = webAnnotations.isExcludedClass(className);
            }
            boolean isExternal = webAnnotations.isExternalClass(className);
            Tr.debug((TraceComponent)tc, (String)(methodName + ": Class [ " + className + " ] Seed     [ " + Boolean.valueOf(isIncluded) + " ]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)(methodName + ": Class [ " + className + " ] Partial  [ " + Boolean.valueOf(isPartial) + " ]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)(methodName + ": Class [ " + className + " ] Excluded [ " + Boolean.valueOf(isExcluded) + " ]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)(methodName + ": Class [ " + className + " ] External [ " + Boolean.valueOf(isExternal) + " ]"), (Object[])new Object[0]);
        }
        if (skipClass) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, (Object)("Reject: " + skipReason + " class"));
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Select: Non-seed, non-excluded, class"});
        }
        if (!(webServletClassNames = (specificAnnotations = webAnnotations.getSpecificAnnotations(specifiedClasses = Collections.singleton(className))).selectAnnotatedClasses(WebServlet.class)).isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Detected @WebServlet on [ " + className + " ]"), (Object[])new Object[0]);
            }
            this.configureServletAnnotation(webServletClassNames);
        }
        if (!(webListenerClassNames = specificAnnotations.selectAnnotatedClasses(WebListener.class)).isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Detected @WebListener on [ " + className + " ]"), (Object[])new Object[0]);
            }
            this.configureListenerAnnotation(webListenerClassNames, true);
        }
        if (!(multipartClassNames = specificAnnotations.selectAnnotatedClasses(MultipartConfig.class)).isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Detected @MultipartConfig on [ " + className + " ]"), (Object[])new Object[0]);
            }
            this.configureMultipartConfigAnnotation(multipartClassNames);
        }
        if (!(webFilterClassNames = specificAnnotations.selectAnnotatedClasses(WebFilter.class)).isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Detected @WebFilter on [ " + className + " ]"), (Object[])new Object[0]);
            }
            this.configureFilterAnnotation(webFilterClassNames, true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    protected void configureSpecifiedClasses() throws UnableToAdaptException {
        String methodName = "configureSpecifiedClasses";
        String displayName = this.webAppConfiguration.getDisplayName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"WebAppConfiguration [ " + displayName + " ]"});
        }
        if (this.configurator.isMetadataComplete()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, (Object)("WebAppConfiguration [ " + displayName + " ]: Metadata-complete"));
            }
            return;
        }
        if (this.annotationScanningRequiredClasses.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, (Object)("WebAppConfiguration [ " + displayName + " ]: No annotation required classes"));
            }
            return;
        }
        WebAnnotations webAnnotations = this.configurator.getWebAnnotations();
        HashSet<String> specifiedClasses = new HashSet<String>();
        for (String specifiedClassName : this.annotationScanningRequiredClasses) {
            boolean isExcluded;
            boolean isSetIsExcluded;
            String skipReason;
            boolean isIncluded;
            boolean skipClass = isIncluded = webAnnotations.isIncludedClass(specifiedClassName);
            if (isIncluded) {
                skipReason = "Seed";
                isSetIsExcluded = false;
                isExcluded = false;
            } else {
                isSetIsExcluded = true;
                skipClass = isExcluded = webAnnotations.isExcludedClass(specifiedClassName);
                skipReason = isExcluded ? "Excluded" : null;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                boolean isPartial = webAnnotations.isPartialClass(specifiedClassName);
                if (!isSetIsExcluded) {
                    isExcluded = webAnnotations.isExcludedClass(specifiedClassName);
                }
                boolean isExternal = webAnnotations.isExternalClass(specifiedClassName);
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Class [ " + specifiedClassName + " ] Seed     [ " + Boolean.valueOf(isIncluded) + " ]"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Class [ " + specifiedClassName + " ] Partial  [ " + Boolean.valueOf(isPartial) + " ]"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Class [ " + specifiedClassName + " ] Excluded [ " + Boolean.valueOf(isExcluded) + " ]"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Class [ " + specifiedClassName + " ] External [ " + Boolean.valueOf(isExternal) + " ]"), (Object[])new Object[0]);
            }
            if (skipClass) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Reject: " + skipReason + " class [ " + specifiedClassName + " ]"), (Object[])new Object[0]);
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Select: Non-seed, non-excluded, class [ " + specifiedClassName + " ]"), (Object[])new Object[0]);
            }
            specifiedClasses.add(specifiedClassName);
        }
        if (specifiedClasses.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, (Object)("WebAppConfiguration [ " + displayName + " ]: No selected classes"));
            }
            return;
        }
        SpecificAnnotations specificAnnotations = webAnnotations.getSpecificAnnotations(specifiedClasses);
        Set webServletClassNames = specificAnnotations.selectAnnotatedClasses(WebServlet.class);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            for (String webServletClassName : webServletClassNames) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Selected @WebServlet class [ " + webServletClassName + " ]"), (Object[])new Object[0]);
            }
        }
        this.configureServletAnnotation(webServletClassNames);
        Set multipartClassNames = specificAnnotations.selectAnnotatedClasses(MultipartConfig.class);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            for (String multipartClassName : multipartClassNames) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Selected @MultipartConfig class [ " + multipartClassName + " ]"), (Object[])new Object[0]);
            }
        }
        this.configureMultipartConfigAnnotation(multipartClassNames);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)("WebAppConfiguration [ " + displayName + " ]"));
        }
    }

    public void configureWebBnd(WebBnd webBnd) {
        OSGiJNDIEnvironmentRefBindingHelper.processBndAndExt(this.webAppConfiguration.getAllRefBindings(), this.webAppConfiguration.getEnvEntryValues(), (ResourceRefConfigList)this.webAppConfiguration.getResourceRefConfigList(), (RefBindingsGroup)webBnd, null);
        VirtualHost vhost = webBnd.getVirtualHost();
        if (vhost != null) {
            this.webAppConfiguration.setVirtualHostName(vhost);
        }
    }

    public void configureWebExt(WebExt webExt) {
        this.configureResourceRefExtensions(webExt.getResourceRefs());
    }

    public void finish() {
        this.webAppConfiguration.cacheResults(this.configurator);
        this.webAppConfiguration.setGlobalAndPrivateConfig();
    }

    private void configureOrderedLibPaths(List<String> allLocations) {
        this.webAppConfiguration.setOrderedLibPaths(new ArrayList<String>(allLocations));
    }

    private void configureEnvEntries(List<EnvEntry> envEntries) {
        Map envEntryConfigItemMap = this.configurator.getConfigItemMap("env-entry");
        Set additiveEnvEntryNames = this.configurator.getContextSet("env-entry-name");
        for (EnvEntry envEntry : envEntries) {
            String name = envEntry.getName();
            if (name == null) continue;
            ServletConfigurator.ConfigItem existedEnvEntry = (ServletConfigurator.ConfigItem)envEntryConfigItemMap.get(name);
            if (existedEnvEntry == null) {
                EnvEntryImpl envEntryImpl = new EnvEntryImpl(envEntry);
                this.webAppConfiguration.addRef(JNDIEnvironmentRefType.EnvEntry, (JNDIEnvironmentRef)envEntryImpl);
                envEntryConfigItemMap.put(name, this.createConfigItem(envEntryImpl, ENV_ENTRY_COMPARATOR));
                if (this.configurator.getConfigSource() != ServletConfigurator.ConfigSource.WEB_XML || envEntry.getInjectionTargets().size() != 0) continue;
                additiveEnvEntryNames.add(name);
                continue;
            }
            this.processDuplicateJndiReferenceConfig("env-entry", "env-entry-name", name, existedEnvEntry, envEntry, additiveEnvEntryNames);
        }
    }

    private void configureServiceRefs(List<ServiceRef> serviceRefs) {
        Map serviceRefConfigItemMap = this.configurator.getConfigItemMap("service-ref");
        Set additiveServiceRefNames = this.configurator.getContextSet("service-ref-name");
        for (ServiceRef serviceRef : serviceRefs) {
            String name = serviceRef.getName();
            if (name == null) continue;
            ServletConfigurator.ConfigItem existedServiceRef = (ServletConfigurator.ConfigItem)serviceRefConfigItemMap.get(name);
            if (existedServiceRef == null) {
                ServiceRefImpl serviceRefImpl = new ServiceRefImpl(serviceRef);
                this.webAppConfiguration.addRef(JNDIEnvironmentRefType.ServiceRef, (JNDIEnvironmentRef)serviceRefImpl);
                serviceRefConfigItemMap.put(name, this.createConfigItem(serviceRefImpl, SERVICE_REF_COMPARATOR));
                if (this.configurator.getConfigSource() != ServletConfigurator.ConfigSource.WEB_XML || serviceRef.getInjectionTargets().size() != 0) continue;
                additiveServiceRefNames.add(name);
                continue;
            }
            this.processDuplicateJndiReferenceConfig("service-ref", "service-ref-name", name, existedServiceRef, serviceRef, additiveServiceRefNames);
        }
    }

    private void configureResourceRefs(List<ResourceRef> resourceRefs) {
        Map resourceRefConfigItemMap = this.configurator.getConfigItemMap("resource-ref");
        Set additiveResourceRefNames = this.configurator.getContextSet("res-ref-name");
        for (ResourceRef resourceRef : resourceRefs) {
            String name = resourceRef.getName();
            if (name == null) continue;
            ServletConfigurator.ConfigItem existedResourceRef = (ServletConfigurator.ConfigItem)resourceRefConfigItemMap.get(name);
            if (existedResourceRef == null) {
                ResourceRefImpl resourceRefImpl = new ResourceRefImpl(resourceRef);
                this.webAppConfiguration.addRef(JNDIEnvironmentRefType.ResourceRef, (JNDIEnvironmentRef)resourceRefImpl);
                resourceRefConfigItemMap.put(name, this.createConfigItem(resourceRefImpl, RESOURCE_REF_COMPARATOR));
                if (this.configurator.getConfigSource() != ServletConfigurator.ConfigSource.WEB_XML || resourceRef.getInjectionTargets().size() != 0) continue;
                additiveResourceRefNames.add(name);
                continue;
            }
            this.processDuplicateJndiReferenceConfig("resource-ref", "res-ref-name", name, existedResourceRef, resourceRef, additiveResourceRefNames);
        }
    }

    private void configureResourceEnvRefs(List<ResourceEnvRef> resourceEnvRefs) {
        Map resourceEnvRefConfigItemMap = this.configurator.getConfigItemMap("resource-env-ref");
        Set additiveResourceEnvRefNames = this.configurator.getContextSet("resource-env-ref-name");
        for (ResourceEnvRef resourceEnvRef : resourceEnvRefs) {
            String name = resourceEnvRef.getName();
            if (name == null) continue;
            ServletConfigurator.ConfigItem existedResourceEnvRef = (ServletConfigurator.ConfigItem)resourceEnvRefConfigItemMap.get(name);
            if (existedResourceEnvRef == null) {
                ResourceEnvRefImpl resourceEnvRefImpl = new ResourceEnvRefImpl(resourceEnvRef);
                this.webAppConfiguration.addRef(JNDIEnvironmentRefType.ResourceEnvRef, (JNDIEnvironmentRef)resourceEnvRefImpl);
                resourceEnvRefConfigItemMap.put(name, this.createConfigItem(resourceEnvRefImpl, RESOURCE_ENV_REF_COMPARATOR));
                if (this.configurator.getConfigSource() != ServletConfigurator.ConfigSource.WEB_XML || resourceEnvRef.getInjectionTargets().size() != 0) continue;
                additiveResourceEnvRefNames.add(name);
                continue;
            }
            this.processDuplicateJndiReferenceConfig("resource-env-ref", "resource-env-ref-name", name, existedResourceEnvRef, resourceEnvRef, additiveResourceEnvRefNames);
        }
    }

    private void configureMessageDestinationRefs(List<MessageDestinationRef> messageDestRefs) {
        Map messageDestRefConfigItemMap = this.configurator.getConfigItemMap("message-destination-ref");
        Set additiveMessageDestRefNames = this.configurator.getContextSet("message-destination-ref-name");
        for (MessageDestinationRef messageDestRef : messageDestRefs) {
            String name = messageDestRef.getName();
            if (name == null) continue;
            ServletConfigurator.ConfigItem existedMessageDestRef = (ServletConfigurator.ConfigItem)messageDestRefConfigItemMap.get(name);
            if (existedMessageDestRef == null) {
                MessageDestinationRefImpl messageDestRefImpl = new MessageDestinationRefImpl(messageDestRef);
                this.webAppConfiguration.addRef(JNDIEnvironmentRefType.MessageDestinationRef, (JNDIEnvironmentRef)messageDestRefImpl);
                messageDestRefConfigItemMap.put(name, this.createConfigItem(messageDestRefImpl, MESSAGE_DESTINATION_REF_COMPARATOR));
                if (this.configurator.getConfigSource() != ServletConfigurator.ConfigSource.WEB_XML || messageDestRef.getInjectionTargets().size() != 0) continue;
                additiveMessageDestRefNames.add(name);
                continue;
            }
            this.processDuplicateJndiReferenceConfig("message-destination-ref", "message-destination-ref-name", name, existedMessageDestRef, messageDestRef, additiveMessageDestRefNames);
        }
    }

    private void configurePersistenceUnitRefs(List<PersistenceUnitRef> persistenceUnitRefs) {
        Map persistenceUnitRefConfigItemMap = this.configurator.getConfigItemMap("persistence-unit-ref");
        Set additivePersistenceUnitRefNames = this.configurator.getContextSet("persistence-unit-ref-name");
        for (PersistenceUnitRef persistenceUnitRef : persistenceUnitRefs) {
            String name = persistenceUnitRef.getName();
            if (name == null) continue;
            ServletConfigurator.ConfigItem existedPersistenceUnitRef = (ServletConfigurator.ConfigItem)persistenceUnitRefConfigItemMap.get(name);
            if (existedPersistenceUnitRef == null) {
                PersistenceUnitRefImpl persistenceUnitRefImpl = new PersistenceUnitRefImpl(persistenceUnitRef);
                this.webAppConfiguration.addRef(JNDIEnvironmentRefType.PersistenceUnitRef, (JNDIEnvironmentRef)persistenceUnitRefImpl);
                persistenceUnitRefConfigItemMap.put(name, this.createConfigItem(persistenceUnitRefImpl, PERSISTENCE_UNIT_REF_COMPARATOR));
                if (this.configurator.getConfigSource() != ServletConfigurator.ConfigSource.WEB_XML || persistenceUnitRef.getInjectionTargets().size() != 0) continue;
                additivePersistenceUnitRefNames.add(name);
                continue;
            }
            this.processDuplicateJndiReferenceConfig("persistence-unit-ref", "persistence-unit-ref-name", name, existedPersistenceUnitRef, persistenceUnitRef, additivePersistenceUnitRefNames);
        }
    }

    private void configurePersistenceContextRefs(List<PersistenceContextRef> persistenceContextRefs) {
        Map persistenceContextRefConfigItemMap = this.configurator.getConfigItemMap("persistence-context-ref");
        Set additivePersistenceContextRefNames = this.configurator.getContextSet("persistence-context-ref-name");
        for (PersistenceContextRef persistenceContextRef : persistenceContextRefs) {
            String name = persistenceContextRef.getName();
            if (name == null) continue;
            ServletConfigurator.ConfigItem existedPersistenceContextRef = (ServletConfigurator.ConfigItem)persistenceContextRefConfigItemMap.get(name);
            if (existedPersistenceContextRef == null) {
                PersistenceContextRefImpl persistenceContextRefImpl = new PersistenceContextRefImpl(persistenceContextRef);
                this.webAppConfiguration.addRef(JNDIEnvironmentRefType.PersistenceContextRef, (JNDIEnvironmentRef)persistenceContextRefImpl);
                persistenceContextRefConfigItemMap.put(name, this.createConfigItem(persistenceContextRefImpl, PERSISTENCE_CONTEXT_REF_COMPARATOR));
                if (this.configurator.getConfigSource() != ServletConfigurator.ConfigSource.WEB_XML || persistenceContextRef.getInjectionTargets().size() != 0) continue;
                additivePersistenceContextRefNames.add(name);
                continue;
            }
            this.processDuplicateJndiReferenceConfig("persistence-context-ref", "persistence-context-ref-name", name, existedPersistenceContextRef, persistenceContextRef, additivePersistenceContextRefNames);
        }
    }

    private void configureDataSources(List<DataSource> dataSources) {
        Map dataSourceConfigItemMap = this.configurator.getConfigItemMap("data-source");
        for (DataSource dataSource : dataSources) {
            String name = dataSource.getName();
            if (name == null) continue;
            ServletConfigurator.ConfigItem existedDataSource = (ServletConfigurator.ConfigItem)dataSourceConfigItemMap.get(name);
            if (existedDataSource == null) {
                dataSourceConfigItemMap.put(name, this.createConfigItem(dataSource, DATA_SOURCE_COMPARATOR));
                this.webAppConfiguration.addRef(JNDIEnvironmentRefType.DataSource, (JNDIEnvironmentRef)dataSource);
                continue;
            }
            if (existedDataSource.getSource() == ServletConfigurator.ConfigSource.WEB_XML && this.configurator.getConfigSource() == ServletConfigurator.ConfigSource.WEB_FRAGMENT) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"{0}.{1} with value {2}  is configured in web.xml, the value {3} from web-fragment.xml in {4} is ignored", (Object[])new Object[]{"data-source", "name", existedDataSource.getValue(), name, this.configurator.getLibraryURI()});
                continue;
            }
            if (existedDataSource.getSource() != ServletConfigurator.ConfigSource.WEB_FRAGMENT || this.configurator.getConfigSource() != ServletConfigurator.ConfigSource.WEB_FRAGMENT || existedDataSource.compareValue((Object)dataSource)) continue;
            this.configurator.addErrorMessage(nls.getFormattedMessage("CONFLICT_DATASOURCE_REFERENCE_BETWEEN_WEB_FRAGMENT_XML", new Object[]{name, existedDataSource.getLibraryURI(), this.configurator.getLibraryURI()}, "Two data-source configurations with the same name {0} found in the web-fragment.xml of {1} and {2}."));
        }
    }

    private void configureMailSessions(List<MailSession> mailSessions) {
        String displayName = this.webAppConfiguration.getDisplayName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Begin processing mail-session annotations for WebAppConfiguration {0} ", (Object[])new Object[]{displayName});
        }
        Map mailSessionConfigItemMap = this.configurator.getConfigItemMap("mail-session");
        for (MailSession mailSession : mailSessions) {
            ServletConfigurator.ConfigItem existedMailSession;
            String name = mailSession.getName();
            if (name == null) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Mail-session annotation skipped due to null name value", (Object[])new Object[0]);
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing mail-session " + name), (Object[])new Object[0]);
            }
            if ((existedMailSession = (ServletConfigurator.ConfigItem)mailSessionConfigItemMap.get(name)) == null) {
                mailSessionConfigItemMap.put(name, this.createConfigItem(mailSession, MAIL_SESSION_COMPARATOR));
                this.webAppConfiguration.addRef(JNDIEnvironmentRefType.MailSession, (JNDIEnvironmentRef)mailSession);
                continue;
            }
            if (existedMailSession.getSource() == ServletConfigurator.ConfigSource.WEB_XML && this.configurator.getConfigSource() == ServletConfigurator.ConfigSource.WEB_FRAGMENT) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"{0}.{1} with value {2}  is configured in web.xml, the value {3} from web-fragment.xml in {4} is ignored", (Object[])new Object[]{"data-source", "name", existedMailSession.getValue(), name, this.configurator.getLibraryURI()});
                continue;
            }
            if (existedMailSession.getSource() != ServletConfigurator.ConfigSource.WEB_FRAGMENT || this.configurator.getConfigSource() != ServletConfigurator.ConfigSource.WEB_FRAGMENT || existedMailSession.compareValue((Object)mailSession)) continue;
            this.configurator.addErrorMessage(nls.getFormattedMessage("CONFLICT_MAILSESSION_REFERENCE_BETWEEN_WEB_FRAGMENT_XML", new Object[]{name, existedMailSession.getLibraryURI(), this.configurator.getLibraryURI()}, "Two mail-session configurations with the same name {0} found in the web-fragment.xml of {1} and {2}."));
        }
    }

    private void configureConnectionFactories(List<ConnectionFactory> connFactories) {
        Map cfConfigItemMap = this.configurator.getConfigItemMap("connection-factory");
        for (ConnectionFactory connFactory : connFactories) {
            String name = connFactory.getName();
            if (name == null) continue;
            ServletConfigurator.ConfigItem existedCF = (ServletConfigurator.ConfigItem)cfConfigItemMap.get(name);
            if (existedCF == null) {
                cfConfigItemMap.put(name, this.createConfigItem(connFactory, CF_COMPARATOR));
                this.webAppConfiguration.addRef(JNDIEnvironmentRefType.ConnectionFactory, (JNDIEnvironmentRef)connFactory);
                continue;
            }
            if (existedCF.getSource() == ServletConfigurator.ConfigSource.WEB_XML && this.configurator.getConfigSource() == ServletConfigurator.ConfigSource.WEB_FRAGMENT) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"{0}.{1} with value {2}  is configured in web.xml, the value {3} from web-fragment.xml in {4} is ignored", (Object[])new Object[]{"connection-factory", "name", existedCF.getValue(), name, this.configurator.getLibraryURI()});
                continue;
            }
            if (existedCF.getSource() != ServletConfigurator.ConfigSource.WEB_FRAGMENT || this.configurator.getConfigSource() != ServletConfigurator.ConfigSource.WEB_FRAGMENT || existedCF.compareValue((Object)connFactory)) continue;
            this.configurator.addErrorMessage(nls.getFormattedMessage("CONFLICT_CONNECTION_FACTORY_REFERENCE_BETWEEN_WEB_FRAGMENT_XML", new Object[]{name, existedCF.getLibraryURI(), this.configurator.getLibraryURI()}, "Two connection-factory configurations with the same name {0} found in the web-fragment.xml of {1} and {2}."));
        }
    }

    private void configureAdministeredObjects(List<AdministeredObject> adminObjects) {
        Map cfConfigItemMap = this.configurator.getConfigItemMap("administered-object");
        for (AdministeredObject adminObject : adminObjects) {
            String name = adminObject.getName();
            if (name == null) continue;
            ServletConfigurator.ConfigItem existedAdminObject = (ServletConfigurator.ConfigItem)cfConfigItemMap.get(name);
            if (existedAdminObject == null) {
                cfConfigItemMap.put(name, this.createConfigItem(adminObject, ADMINISTERED_OBJECT_COMPARATOR));
                this.webAppConfiguration.addRef(JNDIEnvironmentRefType.AdministeredObject, (JNDIEnvironmentRef)adminObject);
                continue;
            }
            if (existedAdminObject.getSource() == ServletConfigurator.ConfigSource.WEB_XML && this.configurator.getConfigSource() == ServletConfigurator.ConfigSource.WEB_FRAGMENT) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"{0}.{1} with value {2}  is configured in web.xml, the value {3} from web-fragment.xml in {4} is ignored", (Object[])new Object[]{"administered-object", "name", existedAdminObject.getValue(), name, this.configurator.getLibraryURI()});
                continue;
            }
            if (existedAdminObject.getSource() != ServletConfigurator.ConfigSource.WEB_FRAGMENT || this.configurator.getConfigSource() != ServletConfigurator.ConfigSource.WEB_FRAGMENT || existedAdminObject.compareValue((Object)adminObject)) continue;
            this.configurator.addErrorMessage(nls.getFormattedMessage("CONFLICT_ADMINISTERED_OBJECT_REFERENCE_BETWEEN_WEB_FRAGMENT_XML", new Object[]{name, existedAdminObject.getLibraryURI(), this.configurator.getLibraryURI()}, "Two administered-object configurations with the same name {0} found in the web-fragment.xml of {1} and {2}."));
        }
    }

    private void configureContextServices(List<ContextService> contextServices) {
        Map configItemMap = this.configurator.getConfigItemMap("context-service");
        for (ContextService contextService : contextServices) {
            String name = contextService.getName();
            if (name == null) continue;
            ServletConfigurator.ConfigItem existed = (ServletConfigurator.ConfigItem)configItemMap.get(name);
            if (existed == null) {
                configItemMap.put(name, this.createConfigItem(contextService, CONTEXT_SERVICE_COMPARATOR));
                this.webAppConfiguration.addRef(JNDIEnvironmentRefType.ContextService, (JNDIEnvironmentRef)contextService);
                continue;
            }
            if (existed.getSource() == ServletConfigurator.ConfigSource.WEB_XML && this.configurator.getConfigSource() == ServletConfigurator.ConfigSource.WEB_FRAGMENT) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("context-service.name with value " + existed.getValue() + " is configured in web.xml, the value " + name + " from web-fragment.xml in " + this.configurator.getLibraryURI() + " is ignored"), (Object[])new Object[0]);
                continue;
            }
            if (existed.getSource() != ServletConfigurator.ConfigSource.WEB_FRAGMENT || this.configurator.getConfigSource() != ServletConfigurator.ConfigSource.WEB_FRAGMENT || existed.compareValue((Object)contextService)) continue;
            this.configurator.addErrorMessage(Tr.formatMessage((TraceComponent)tc, (String)"WEB_FRAGMENT_XML_RESOURCE_CONFLICT", (Object[])new Object[]{"context-service", name, existed.getLibraryURI(), this.configurator.getLibraryURI()}));
        }
    }

    private void configureJMSConnectionFactories(List<JMSConnectionFactory> jmsConnFactories) {
        Map jmsCfConfigItemMap = this.configurator.getConfigItemMap(JNDIEnvironmentRefType.JMSConnectionFactory.getXMLElementName());
        for (JMSConnectionFactory jmsConnFactory : jmsConnFactories) {
            String name = jmsConnFactory.getName();
            if (name == null) continue;
            ServletConfigurator.ConfigItem existedCF = (ServletConfigurator.ConfigItem)jmsCfConfigItemMap.get(name);
            if (existedCF == null) {
                jmsCfConfigItemMap.put(name, this.createConfigItem(jmsConnFactory, JMS_CF_COMPARATOR));
                this.webAppConfiguration.addRef(JNDIEnvironmentRefType.JMSConnectionFactory, (JNDIEnvironmentRef)jmsConnFactory);
                continue;
            }
            if (existedCF.getSource() == ServletConfigurator.ConfigSource.WEB_XML && this.configurator.getConfigSource() == ServletConfigurator.ConfigSource.WEB_FRAGMENT) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"{0}.{1} with value {2}  is configured in web.xml, the value {3} from web-fragment.xml in {4} is ignored", (Object[])new Object[]{JNDIEnvironmentRefType.JMSConnectionFactory.getXMLElementName(), "name", existedCF.getValue(), name, this.configurator.getLibraryURI()});
                continue;
            }
            if (existedCF.getSource() != ServletConfigurator.ConfigSource.WEB_FRAGMENT || this.configurator.getConfigSource() != ServletConfigurator.ConfigSource.WEB_FRAGMENT || existedCF.compareValue((Object)jmsConnFactory)) continue;
            this.configurator.addErrorMessage(nls.getFormattedMessage("CONFLICT_JMS_CONNECTION_FACTORY_REFERENCE_BETWEEN_WEB_FRAGMENT_XML", new Object[]{name, existedCF.getLibraryURI(), this.configurator.getLibraryURI()}, "Two " + JNDIEnvironmentRefType.JMSConnectionFactory.getXMLElementName() + " configurations with the same name {0} found in the web-fragment.xml of {1} and {2}."));
        }
    }

    private void configureJMSDestinations(List<JMSDestination> jmsDestinations) {
        Map jmsDestinationConfigItemMap = this.configurator.getConfigItemMap(JNDIEnvironmentRefType.JMSConnectionFactory.getXMLElementName());
        for (JMSDestination jmsDestination : jmsDestinations) {
            String name = jmsDestination.getName();
            if (name == null) continue;
            ServletConfigurator.ConfigItem existedCF = (ServletConfigurator.ConfigItem)jmsDestinationConfigItemMap.get(name);
            if (existedCF == null) {
                jmsDestinationConfigItemMap.put(name, this.createConfigItem(jmsDestination, JMS_DESTINATION_COMPARATOR));
                this.webAppConfiguration.addRef(JNDIEnvironmentRefType.JMSDestination, (JNDIEnvironmentRef)jmsDestination);
                continue;
            }
            if (existedCF.getSource() == ServletConfigurator.ConfigSource.WEB_XML && this.configurator.getConfigSource() == ServletConfigurator.ConfigSource.WEB_FRAGMENT) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"{0}.{1} with value {2}  is configured in web.xml, the value {3} from web-fragment.xml in {4} is ignored", (Object[])new Object[]{JNDIEnvironmentRefType.JMSConnectionFactory.getXMLElementName(), "name", existedCF.getValue(), name, this.configurator.getLibraryURI()});
                continue;
            }
            if (existedCF.getSource() != ServletConfigurator.ConfigSource.WEB_FRAGMENT || this.configurator.getConfigSource() != ServletConfigurator.ConfigSource.WEB_FRAGMENT || existedCF.compareValue((Object)jmsDestination)) continue;
            this.configurator.addErrorMessage(nls.getFormattedMessage("CONFLICT_JMS_DESTINATION_REFERENCE_BETWEEN_WEB_FRAGMENT_XML", new Object[]{name, existedCF.getLibraryURI(), this.configurator.getLibraryURI()}, "Two " + JNDIEnvironmentRefType.JMSConnectionFactory.getXMLElementName() + " configurations with the same name {0} found in the web-fragment.xml of {1} and {2}."));
        }
    }

    private void configureManagedExecutors(List<ManagedExecutor> executors) {
        Map configItemMap = this.configurator.getConfigItemMap("managed-executor");
        for (ManagedExecutor executor : executors) {
            String name = executor.getName();
            if (name == null) continue;
            ServletConfigurator.ConfigItem existed = (ServletConfigurator.ConfigItem)configItemMap.get(name);
            if (existed == null) {
                configItemMap.put(name, this.createConfigItem(executor, MANAGED_EXECUTOR_COMPARATOR));
                this.webAppConfiguration.addRef(JNDIEnvironmentRefType.ManagedExecutor, (JNDIEnvironmentRef)executor);
                continue;
            }
            if (existed.getSource() == ServletConfigurator.ConfigSource.WEB_XML && this.configurator.getConfigSource() == ServletConfigurator.ConfigSource.WEB_FRAGMENT) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("managed-executor.name with value " + existed.getValue() + " is configured in web.xml, the value " + name + " from web-fragment.xml in " + this.configurator.getLibraryURI() + " is ignored"), (Object[])new Object[0]);
                continue;
            }
            if (existed.getSource() != ServletConfigurator.ConfigSource.WEB_FRAGMENT || this.configurator.getConfigSource() != ServletConfigurator.ConfigSource.WEB_FRAGMENT || existed.compareValue((Object)executor)) continue;
            this.configurator.addErrorMessage(Tr.formatMessage((TraceComponent)tc, (String)"WEB_FRAGMENT_XML_RESOURCE_CONFLICT", (Object[])new Object[]{"managed-executor", name, existed.getLibraryURI(), this.configurator.getLibraryURI()}));
        }
    }

    private void configureManagedScheduledExecutors(List<ManagedScheduledExecutor> executors) {
        Map configItemMap = this.configurator.getConfigItemMap("managed-scheduled-executor");
        for (ManagedScheduledExecutor executor : executors) {
            String name = executor.getName();
            if (name == null) continue;
            ServletConfigurator.ConfigItem existed = (ServletConfigurator.ConfigItem)configItemMap.get(name);
            if (existed == null) {
                configItemMap.put(name, this.createConfigItem(executor, MANAGED_SCHEDULED_EXECUTOR_COMPARATOR));
                this.webAppConfiguration.addRef(JNDIEnvironmentRefType.ManagedScheduledExecutor, (JNDIEnvironmentRef)executor);
                continue;
            }
            if (existed.getSource() == ServletConfigurator.ConfigSource.WEB_XML && this.configurator.getConfigSource() == ServletConfigurator.ConfigSource.WEB_FRAGMENT) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("managed-scheduled-executor.name with value " + existed.getValue() + " is configured in web.xml, the value " + name + " from web-fragment.xml in " + this.configurator.getLibraryURI() + " is ignored"), (Object[])new Object[0]);
                continue;
            }
            if (existed.getSource() != ServletConfigurator.ConfigSource.WEB_FRAGMENT || this.configurator.getConfigSource() != ServletConfigurator.ConfigSource.WEB_FRAGMENT || existed.compareValue((Object)executor)) continue;
            this.configurator.addErrorMessage(Tr.formatMessage((TraceComponent)tc, (String)"WEB_FRAGMENT_XML_RESOURCE_CONFLICT", (Object[])new Object[]{"managed-scheduled-executor", name, existed.getLibraryURI(), this.configurator.getLibraryURI()}));
        }
    }

    private void configureManagedThreadFactories(List<ManagedThreadFactory> threadFactories) {
        Map configItemMap = this.configurator.getConfigItemMap("managed-thread-factory");
        for (ManagedThreadFactory threadFactory : threadFactories) {
            String name = threadFactory.getName();
            if (name == null) continue;
            ServletConfigurator.ConfigItem existed = (ServletConfigurator.ConfigItem)configItemMap.get(name);
            if (existed == null) {
                configItemMap.put(name, this.createConfigItem(threadFactory, MANAGED_THREAD_FACTORY_COMPARATOR));
                this.webAppConfiguration.addRef(JNDIEnvironmentRefType.ManagedThreadFactory, (JNDIEnvironmentRef)threadFactory);
                continue;
            }
            if (existed.getSource() == ServletConfigurator.ConfigSource.WEB_XML && this.configurator.getConfigSource() == ServletConfigurator.ConfigSource.WEB_FRAGMENT) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("managed-thread-factory.name with value " + existed.getValue() + " is configured in web.xml, the value " + name + " from web-fragment.xml in " + this.configurator.getLibraryURI() + " is ignored"), (Object[])new Object[0]);
                continue;
            }
            if (existed.getSource() != ServletConfigurator.ConfigSource.WEB_FRAGMENT || this.configurator.getConfigSource() != ServletConfigurator.ConfigSource.WEB_FRAGMENT || existed.compareValue((Object)threadFactory)) continue;
            this.configurator.addErrorMessage(Tr.formatMessage((TraceComponent)tc, (String)"WEB_FRAGMENT_XML_RESOURCE_CONFLICT", (Object[])new Object[]{"managed-thread-factory", name, existed.getLibraryURI(), this.configurator.getLibraryURI()}));
        }
    }

    private void configureEJBRefs(List<EJBRef> ejbRefs) {
        Map ejbRefConfigItemMap = this.configurator.getConfigItemMap("ejb-ref");
        Set additiveEJBRefNames = this.configurator.getContextSet("ejb-ref-name");
        for (EJBRef ejbRef : ejbRefs) {
            String name = ejbRef.getName();
            if (name == null) continue;
            ServletConfigurator.ConfigItem existedEJBRef = (ServletConfigurator.ConfigItem)ejbRefConfigItemMap.get(name);
            if (existedEJBRef == null) {
                EJBRefImpl ejbRefImpl = new EJBRefImpl(ejbRef);
                this.webAppConfiguration.addRef(JNDIEnvironmentRefType.EJBRef, (JNDIEnvironmentRef)ejbRefImpl);
                ejbRefConfigItemMap.put(name, this.createConfigItem(ejbRefImpl, EJB_REF_COMPARATOR));
                if (this.configurator.getConfigSource() != ServletConfigurator.ConfigSource.WEB_XML || ejbRef.getInjectionTargets().size() != 0) continue;
                additiveEJBRefNames.add(name);
                continue;
            }
            this.processDuplicateJndiReferenceConfig("ejb-ref", "ejb-ref-name", name, existedEJBRef, ejbRef, additiveEJBRefNames);
        }
    }

    private void configureEJBLocalRefs(List<EJBRef> ejbRefs) {
        Map ejbRefConfigItemMap = this.configurator.getConfigItemMap("ejb-local-ref");
        Set additiveEJBRefNames = this.configurator.getContextSet("ejb-ref-name");
        for (EJBRef ejbRef : ejbRefs) {
            String name = ejbRef.getName();
            if (name == null) continue;
            ServletConfigurator.ConfigItem existedEJBRef = (ServletConfigurator.ConfigItem)ejbRefConfigItemMap.get(name);
            if (existedEJBRef == null) {
                EJBRefImpl ejbRefImpl = new EJBRefImpl(ejbRef);
                this.webAppConfiguration.addRef(JNDIEnvironmentRefType.EJBRef, (JNDIEnvironmentRef)ejbRefImpl);
                ejbRefConfigItemMap.put(name, this.createConfigItem(ejbRefImpl, EJB_REF_COMPARATOR));
                if (this.configurator.getConfigSource() != ServletConfigurator.ConfigSource.WEB_XML || ejbRef.getInjectionTargets().size() != 0) continue;
                additiveEJBRefNames.add(name);
                continue;
            }
            this.processDuplicateJndiReferenceConfig("ejb-local-ref", "ejb-ref-name", name, existedEJBRef, ejbRef, additiveEJBRefNames);
        }
    }

    private void addFilterMapping(FilterConfig filterConfig, String urlPattern, String servletName, DispatcherType[] dispatcherTypes, boolean processMappingsNow) {
        this.addFilterMapping(filterConfig, urlPattern, servletName, dispatcherTypes, processMappingsNow, -1);
    }

    private void addFilterMapping(final FilterConfig filterConfig, final String urlPattern, final String servletName, DispatcherType[] dispatcherTypes, boolean processMappingsNow, final int index) {
        EnumSet<DispatcherType> dispatcherTypeEnumSet;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addFilterMapping", (Object[])new Object[]{"servletName [ " + servletName + " ] urlPattern [ " + urlPattern + " ] processMappingsNow [ " + processMappingsNow + "] index [ " + index + " ]"});
        }
        if (dispatcherTypes != null && dispatcherTypes.length > 0) {
            dispatcherTypeEnumSet = EnumSet.noneOf(DispatcherType.class);
            for (DispatcherType dispatcherType : dispatcherTypes) {
                dispatcherTypeEnumSet.add(dispatcherType);
            }
        } else {
            dispatcherTypeEnumSet = null;
        }
        final WebAppConfiguratorHelper configHelper = this;
        if (urlPattern != null) {
            if (processMappingsNow) {
                filterConfig.addMappingForUrlPatterns(dispatcherTypeEnumSet, true, index, urlPattern);
            } else {
                this.allActions.add(new DeferredAction(){

                    @Override
                    public boolean isAllServletAction() {
                        return false;
                    }

                    @Override
                    public void doAction(ServletConfig servletConfig) throws UnableToAdaptException {
                        filterConfig.addMappingForUrlPatterns((EnumSet<DispatcherType>)dispatcherTypeEnumSet, true, index, urlPattern);
                        configHelper.configureSpecificClass(filterConfig.getClassName());
                    }
                });
            }
        } else if (servletName.equals("*")) {
            if (processMappingsNow) {
                Map servletMap = this.configurator.getConfigItemMap("servlet");
                for (ServletConfigurator.ConfigItem configItem : servletMap.values()) {
                    ServletConfig servletConfig = (ServletConfig)configItem.getValue();
                    if (servletConfig.getServletName() == null) continue;
                    filterConfig.addMappingForServletNames(dispatcherTypeEnumSet, true, servletConfig.getServletName());
                }
            } else {
                this.allActions.add(new DeferredAction(){

                    @Override
                    public boolean isAllServletAction() {
                        return true;
                    }

                    @Override
                    public void doAction(ServletConfig servletConfig) throws UnableToAdaptException {
                        String configName = servletConfig.getServletName();
                        if (configName != null) {
                            filterConfig.addMappingForServletNames(dispatcherTypeEnumSet, true, configName);
                            configHelper.configureSpecificClass(filterConfig.getClassName());
                        }
                    }
                });
            }
        } else if (processMappingsNow) {
            filterConfig.addMappingForServletNames(dispatcherTypeEnumSet, true, servletName);
        } else {
            this.allActions.add(new DeferredAction(){

                @Override
                public boolean isAllServletAction() {
                    return false;
                }

                @Override
                public void doAction(ServletConfig servletConfig) throws UnableToAdaptException {
                    filterConfig.addMappingForServletNames(dispatcherTypeEnumSet, true, servletName);
                    configHelper.configureSpecificClass(filterConfig.getClassName());
                }
            });
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addFilterMapping", (Object)("servletName [ " + servletName + " ] urlPattern [ " + urlPattern + " ] processMappingsNow [ " + processMappingsNow + "] index [ " + index + " ]"));
        }
    }

    private void configureTargetConfig(TargetConfig targetConfig, String className, String reason, DescriptionGroup descGroup) {
        if (className != null) {
            targetConfig.setClassName(className);
            this.addToRequiredClasses(className, reason);
        }
        this.configureDisplayName(targetConfig, this.getDisplayName(descGroup.getDisplayNames()));
        this.configureDescription(targetConfig, this.getDescription(descGroup.getDescriptions()));
        this.configureIcons(targetConfig, descGroup.getIcons());
    }

    private void configureInitParams(TargetConfig targetConfig, List<ParamValue> initParams, String targetConfigType) {
        Map initParamMap = this.configurator.getConfigItemMap(targetConfigType + ".init-param");
        for (ParamValue initParam : initParams) {
            String initParamName = initParam.getName();
            String initParamValue = initParam.getValue();
            this.configureInitParam(targetConfig, initParamMap, initParamName, initParamValue, targetConfigType);
        }
    }

    private void configureAsyncSupported(TargetConfig targetConfig, boolean isAsyncSupported, String targetConfigType) {
        String targetName = targetConfig.getName();
        Map asyncSupportedMap = this.configurator.getConfigItemMap(targetConfigType + ".async-supported");
        ServletConfigurator.ConfigItem existedAsyncSupported = (ServletConfigurator.ConfigItem)asyncSupportedMap.get(targetName);
        if (existedAsyncSupported == null) {
            targetConfig.setAsyncSupported(isAsyncSupported);
            asyncSupportedMap.put(targetName, this.createConfigItem(isAsyncSupported));
        } else {
            this.validateDuplicateConfiguration(targetConfigType, "async-supported", isAsyncSupported, existedAsyncSupported);
        }
    }

    private void configureDisplayName(TargetConfig targetConfig, String displayName) {
        if (displayName != null && !displayName.isEmpty() && targetConfig.getDisplayName() == null) {
            targetConfig.setDisplayName(displayName);
        }
    }

    private void configureDescription(TargetConfig targetConfig, String description) {
        if (description != null && !description.isEmpty() && targetConfig.getDescription() == null) {
            targetConfig.setDescription(description);
        }
    }

    private void configureIcons(TargetConfig targetConfig, List<Icon> icons) {
        for (Icon icon : icons) {
            this.configureSmallIcon(targetConfig, icon.getSmallIcon());
            this.configureLargeIcon(targetConfig, icon.getLargeIcon());
        }
    }

    private void configureSmallIcon(TargetConfig targetConfig, String smallIcon) {
        if (smallIcon != null && !smallIcon.isEmpty() && targetConfig.getSmallIcon() == null) {
            targetConfig.setSmallIcon(smallIcon);
        }
    }

    private void configureLargeIcon(TargetConfig targetConfig, String largeIcon) {
        if (largeIcon != null && !largeIcon.isEmpty() && targetConfig.getLargeIcon() == null) {
            targetConfig.setLargeIcon(largeIcon);
        }
    }

    private void configureInitParam(TargetConfig targetConfig, Map<String, ServletConfigurator.ConfigItem<String>> initParamMap, String initParamName, String initParamValue, String targetConfigType) {
        String targetName = targetConfig.getName();
        ServletConfigurator.ConfigItem<String> existedInitParam = initParamMap.get(targetName + "." + initParamName);
        if (existedInitParam == null) {
            targetConfig.addInitParameter(initParamName, initParamValue);
            initParamMap.put(targetName + "." + initParamName, this.createConfigItem(initParamValue));
        } else {
            this.validateDuplicateKeyValueConfiguration(targetConfigType, "init-param.param-name", initParamName, "param-value", initParamValue, existedInitParam);
        }
    }

    private void configureCommonWebAnnotation(TargetConfig targetConfig, AnnotationInfo webAnnotation, String targetConfigType) {
        Map initParamMap;
        List initParamList;
        AnnotationValue asyncSupportedValue = webAnnotation.getValue("asyncSupported");
        boolean asyncSupported = null == asyncSupportedValue ? false : asyncSupportedValue.getBooleanValue();
        this.configureAsyncSupported(targetConfig, asyncSupported, targetConfigType);
        AnnotationValue displayNameValue = webAnnotation.getValue("displayName");
        this.configureDisplayName(targetConfig, displayNameValue != null ? displayNameValue.getStringValue() : null);
        AnnotationValue descriptionValue = webAnnotation.getValue("description");
        this.configureDescription(targetConfig, descriptionValue != null ? descriptionValue.getStringValue() : null);
        AnnotationValue smallIconValue = webAnnotation.getValue("smallIcon");
        this.configureSmallIcon(targetConfig, smallIconValue != null ? smallIconValue.getStringValue() : null);
        AnnotationValue largeIconValue = webAnnotation.getValue("largeIcon");
        this.configureLargeIcon(targetConfig, largeIconValue != null ? largeIconValue.getStringValue() : null);
        AnnotationValue initParamsValue = webAnnotation.getValue("initParams");
        if (initParamsValue != null) {
            initParamList = initParamsValue.getArrayValue();
            initParamMap = this.configurator.getConfigItemMap(targetConfigType + ".init-param");
        } else {
            initParamList = Collections.emptyList();
            initParamMap = null;
        }
        for (AnnotationValue initParam : initParamList) {
            AnnotationInfo initParamAnnotation = initParam.getAnnotationValue();
            String initParamName = initParamAnnotation.getValue("name").getStringValue();
            String initParamValue = initParamAnnotation.getValue("value").getStringValue();
            this.configureInitParam(targetConfig, initParamMap, initParamName, initParamValue, targetConfigType);
        }
    }

    private void configureContextParam(List<ParamValue> paramValues) {
        Map contextParamValueConfigItemMap = this.configurator.getConfigItemMap("context-param");
        for (ParamValue paramValue : paramValues) {
            String contextParamName = paramValue.getName();
            String contextParamValue = paramValue.getValue();
            ServletConfigurator.ConfigItem existedParamValueConfigItem = (ServletConfigurator.ConfigItem)contextParamValueConfigItemMap.get(contextParamName);
            if (existedParamValueConfigItem == null) {
                this.webAppConfiguration.addContextParam(contextParamName, contextParamValue);
                contextParamValueConfigItemMap.put(contextParamName, this.createConfigItem(contextParamValue));
                continue;
            }
            this.validateDuplicateKeyValueConfiguration("context-param", "param-name", contextParamName, "param-value", contextParamValue, existedParamValueConfigItem);
        }
    }

    private void configureWebAppVersion() {
        this.webAppConfiguration.setVersion(this.configurator.getServletVersion());
        this.webAppConfiguration.setMetadataComplete(this.configurator.isMetadataComplete());
    }

    private void configureDefaultConfigurations() {
        this.webAppConfiguration.addDefaultWelcomeFiles();
        this.webAppConfiguration.setDefaultDisplayName();
    }

    private void configureDescription(List<Description> descriptions) {
        String description = this.getDescription(descriptions);
        if (description != null) {
            this.webAppConfiguration.setDescription(description);
        }
    }

    private void configureDisplayName(List<DisplayName> displayNames) {
        String displayName = this.getDisplayName(displayNames);
        if (displayName != null) {
            this.webAppConfiguration.setDisplayName(displayName);
        }
    }

    private void configureDistributableFromWebApp(boolean distributableSet) {
        if (!WCCustomProperties.IGNORE_DISTRIBUTABLE) {
            this.webAppConfiguration.setDistributable(distributableSet);
        }
    }

    private void configureDenyUncoveredHttpMethodsFromWebApp(boolean denyUncoveredHttpMethods) {
        this.webAppConfiguration.setDenyUncoveredHttpMethods(denyUncoveredHttpMethods);
    }

    private void configureDistributableFromFragment(boolean distributableSet) {
        if (!WCCustomProperties.IGNORE_DISTRIBUTABLE && this.webAppConfiguration.isDistributable() && !distributableSet) {
            this.webAppConfiguration.setDistributable(distributableSet);
            if (TraceComponent.isAnyTracingEnabled() && tc.isInfoEnabled()) {
                Tr.info((TraceComponent)tc, (String)"DISTRIBUTABLE_SET_TO_FALSE_IN_FRAGMENT", (Object[])new Object[]{this.configurator.getLibraryURI()});
            }
        }
    }

    private void configureErrorPages(List<com.ibm.ws.javaee.dd.web.common.ErrorPage> errorPages) {
        Map errorCodeConfigItemMap = this.configurator.getConfigItemMap("error-page.error-code");
        Map exceptionTypeConfigItemMap = this.configurator.getConfigItemMap("error-page.exception-type");
        Map defaultConfigItemMap = WebAppConfiguratorHelper.allowDefaultErrorPageInServlet30() || WebAppConfiguratorHelper.isServletSpecLevel31OrHigher() ? this.configurator.getConfigItemMap("error-page.default") : null;
        for (com.ibm.ws.javaee.dd.web.common.ErrorPage errorPage : errorPages) {
            ServletConfigurator.ConfigItem existingDefaultErrorPage;
            String location;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Processing error page {0} with error-code {1} and exception-type {2}.", (Object[])new Object[]{errorPage.getLocation(), errorPage.getErrorCode(), errorPage.getExceptionType()});
            }
            if (this.isNullOrEmptyString(location = errorPage.getLocation())) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"No location; ignoring", (Object[])new Object[0]);
                continue;
            }
            ErrorPage configErrorPage = new ErrorPage(location);
            if (errorPage.isSetErrorCode()) {
                int errorCode = errorPage.getErrorCode();
                String errorCodeString = String.valueOf(errorCode);
                ServletConfigurator.ConfigItem existedErrorPage = (ServletConfigurator.ConfigItem)errorCodeConfigItemMap.get(errorCodeString);
                if (existedErrorPage == null) {
                    configErrorPage.setErrorParam(errorCodeString);
                    this.webAppConfiguration.addCodeErrorPage(errorCode, configErrorPage);
                    errorCodeConfigItemMap.put(errorCodeString, this.createConfigItem(location));
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"New error-code error page {0} {1}", (Object[])new Object[]{errorCodeString, location});
                    continue;
                }
                this.validateDuplicateKeyValueConfiguration("error-page", "error-code", errorCodeString, "location", location, existedErrorPage);
                continue;
            }
            if (!this.isNullOrEmptyString(errorPage.getExceptionType())) {
                String exceptionType = errorPage.getExceptionType();
                ServletConfigurator.ConfigItem existedErrorPage = (ServletConfigurator.ConfigItem)exceptionTypeConfigItemMap.get(exceptionType);
                if (existedErrorPage == null) {
                    configErrorPage.setErrorParam(exceptionType);
                    this.webAppConfiguration.addExceptionErrorPage(exceptionType, configErrorPage);
                    exceptionTypeConfigItemMap.put(exceptionType, this.createConfigItem(location));
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"New exception-type error page {0} {1}", (Object[])new Object[]{exceptionType, location});
                    continue;
                }
                this.validateDuplicateKeyValueConfiguration("error-page", "exception-type", exceptionType, "location", location, existedErrorPage);
                continue;
            }
            if (!WebAppConfiguratorHelper.allowDefaultErrorPageInServlet30() && !WebAppConfiguratorHelper.isServletSpecLevel31OrHigher()) {
                if (this.configurator.getConfigSource() == ServletConfigurator.ConfigSource.WEB_XML) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"Ignoring default error page with location {0} in web.xml for feature level {1}", (Object[])new Object[]{location, Integer.toString(WebAppConfiguratorHelper.getServletSpecLevel())});
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Ignoring default error page with location {0} in web-fragment.xml in {1} for feature level {2}", (Object[])new Object[]{location, this.configurator.getLibraryURI(), Integer.toString(WebAppConfiguratorHelper.getServletSpecLevel())});
                continue;
            }
            int schemaLevel = this.configurator.getServletVersion();
            if (schemaLevel < 30) {
                if (this.configurator.getConfigSource() == ServletConfigurator.ConfigSource.WEB_XML) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Ignoring default error page with location {0} in web.xml for schema level {1}", (Object[])new Object[]{location, Integer.toString(schemaLevel)});
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Ignoring default error page with location {0} in web-fragment.xml in {1} for specification level {2}", (Object[])new Object[]{location, this.configurator.getLibraryURI(), Integer.toString(schemaLevel)});
                }
            }
            if ((existingDefaultErrorPage = (ServletConfigurator.ConfigItem)defaultConfigItemMap.get(DEFAULT_ERROR_PAGE_KEY)) == null) {
                this.webAppConfiguration.setDefaultErrorPage(configErrorPage);
                defaultConfigItemMap.put(DEFAULT_ERROR_PAGE_KEY, this.createConfigItem(location));
                continue;
            }
            this.validateDuplicateDefaultErrorPageConfiguration(location, (ServletConfigurator.ConfigItem<String>)existingDefaultErrorPage);
        }
    }

    private void configureFilters(DeploymentDescriptor webDD, List<com.ibm.ws.javaee.dd.web.common.Filter> filters) {
        for (com.ibm.ws.javaee.dd.web.common.Filter filter : filters) {
            this.processFilterConfig(webDD, filter);
        }
    }

    private void configureFilterMappings(DeploymentDescriptor webDD, List<FilterMapping> filterMappings) {
        for (FilterMapping filterMapping : filterMappings) {
            this.processFilterMappingConfig(webDD, filterMapping);
        }
    }

    private void configureFilterAnnotation(Set<String> webFilterClassNames) throws UnableToAdaptException {
        this.configureFilterAnnotation(webFilterClassNames, false);
    }

    private void configureFilterAnnotation(Set<String> webFilterClassNames, boolean processMappings) throws UnableToAdaptException {
        String methodName = "configureFilterAnnotation";
        String displayName = this.webAppConfiguration.getDisplayName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"WebAppConfiguration [ " + displayName + " ]"});
        }
        WebAnnotations webAnnotations = this.configurator.getWebAnnotations();
        this.removeFromRequiredClasses(webFilterClassNames, "WebFilter");
        AnnotationTargets_Targets targets = webAnnotations.getAnnotationTargets();
        Map filterMap = this.configurator.getConfigItemMap("filter");
        for (String className : webFilterClassNames) {
            FilterConfig filterConfig;
            ServletConfigurator.ConfigItem existedFilter;
            String filterName;
            boolean servletNameAttributeConfigured;
            boolean urlPatternsAttributeConfigured;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": @WebFilter target class [ " + className + " ]"), (Object[])new Object[0]);
            }
            if (!targets.isInstanceOf(className, Filter.class)) {
                Tr.error((TraceComponent)tc, (String)"ERROR_WEBFILTER_MUST_IMPLEMENT_FILTER", (Object[])new Object[]{className});
                continue;
            }
            ClassInfo targetClass = webAnnotations.getClassInfo(className);
            AnnotationInfo webFilterAnnotation = targetClass.getAnnotation(WebFilter.class);
            AnnotationValue valueAttribute = webFilterAnnotation.getValue("value");
            boolean valueAttributeConfigured = null == valueAttribute ? false : !valueAttribute.getArrayValue().isEmpty();
            AnnotationValue urlPatternsAnnotation = webFilterAnnotation.getValue("urlPatterns");
            boolean bl = null == urlPatternsAnnotation ? false : (urlPatternsAttributeConfigured = !urlPatternsAnnotation.getArrayValue().isEmpty());
            if (valueAttributeConfigured && urlPatternsAttributeConfigured) {
                Tr.error((TraceComponent)tc, (String)"ERROR_WEBFILTER_HAS_VALUE_AND_PATTERNS", (Object[])new Object[]{className});
                continue;
            }
            AnnotationValue servletNameAttribute = webFilterAnnotation.getValue("servletNames");
            boolean bl2 = null == servletNameAttribute ? false : (servletNameAttributeConfigured = !servletNameAttribute.getArrayValue().isEmpty());
            if (!(valueAttributeConfigured || urlPatternsAttributeConfigured || servletNameAttributeConfigured)) {
                Tr.error((TraceComponent)tc, (String)"ERROR_WEBFILTER_MISSING_VAL_PATT_SERVLET", (Object[])new Object[]{className});
                continue;
            }
            AnnotationValue nameValue = webFilterAnnotation.getValue("filterName");
            String string = filterName = null == nameValue ? null : nameValue.getStringValue();
            if (null == filterName || filterName.isEmpty()) {
                filterName = className;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"@WebFilter filter name == {0}", (Object[])new Object[]{filterName});
            }
            if ((existedFilter = (ServletConfigurator.ConfigItem)filterMap.get(filterName)) == null) {
                filterConfig = this.webAppConfiguration.createFilterConfig("FilterGeneratedId" + this.configurator.generateUniqueId(), filterName);
                filterConfig.setFilterClassName(className);
                this.webAppConfiguration.addFilterInfo(filterConfig);
                filterMap.put(filterName, this.createConfigItem(filterConfig));
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Add new filter from WebFilter annotation filter class name = {0}", (Object[])new Object[]{className});
                }
            } else {
                filterConfig = (FilterConfig)existedFilter.getValue();
            }
            this.configureCommonWebAnnotation(filterConfig, webFilterAnnotation, "filter");
            this.configureWebFilterAnnotation(filterConfig, webFilterAnnotation, processMappings);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)("WebAppConfiguration [ " + displayName + " ]"));
        }
    }

    private void configureListener(List<Listener> listeners) {
        this.addListener(listeners, false);
    }

    private void addListener(List<Listener> listeners, boolean processListenerNow) {
        Set listenerClassNames = this.configurator.getContextSet("listener");
        for (Listener listener : listeners) {
            String listenerClassName = listener.getListenerClassName();
            if (listenerClassNames.contains(listenerClassName)) continue;
            listenerClassNames.add(listenerClassName);
            this.addToRequiredClasses(listenerClassName, "Listener");
            if (processListenerNow) {
                this.webAppConfiguration.addListener(listenerClassName);
                continue;
            }
            this.addDeferredListener(listenerClassName);
        }
    }

    private void configureListenerAnnotation(Set<String> selectedTargets) throws UnableToAdaptException {
        this.configureListenerAnnotation(selectedTargets, false);
    }

    private void configureListenerAnnotation(Set<String> selectedTargets, boolean processListenerNow) throws UnableToAdaptException {
        String methodName = "configureListenerAnnotation";
        String displayName = this.webAppConfiguration.getDisplayName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"WebAppConfiguration [ " + displayName + " ]"});
        }
        WebAnnotations webAnnotations = this.configurator.getWebAnnotations();
        Set listenerClassNames = this.configurator.getContextSet("listener");
        this.removeFromRequiredClasses(selectedTargets, "Listener");
        for (String listenerClassName : selectedTargets) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": @WebListener target class [ " + listenerClassName + " ]"), (Object[])new Object[0]);
            }
            ClassInfo listenerClassInfo = webAnnotations.getClassInfo(listenerClassName);
            if (listenerClassNames.contains(listenerClassName)) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"The same listener class {0} has already been added, the @WebListener is ignored", (Object[])new Object[]{listenerClassName});
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"In processWebListenerAnnotations - processing WebListener {0}", (Object[])new Object[]{listenerClassName});
            }
            boolean implementSupportedListenerInterfaceName = false;
            for (Class<?> iface : this.listenerInterfaces) {
                if (!listenerClassInfo.isInstanceOf(iface)) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WebListener {0} implements required interface {1}", (Object[])new Object[]{listenerClassName, iface.getName()});
                }
                implementSupportedListenerInterfaceName = true;
                break;
            }
            if (!implementSupportedListenerInterfaceName) {
                Tr.error((TraceComponent)tc, (String)"ERROR_WEBLISTENER_MUST_IMPLEMENT_IFACE", (Object[])new Object[]{listenerClassName});
            }
            if (processListenerNow) {
                this.webAppConfiguration.addListener(listenerClassName);
            } else {
                this.addDeferredListener(listenerClassName);
            }
            listenerClassNames.add(listenerClassName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)("WebAppConfiguration [ " + displayName + " ]"));
        }
    }

    private void addDeferredListener(String listenerClassName) {
        final String finalListenerClassName = listenerClassName;
        final WebAppConfiguratorHelper configHelper = this;
        this.allActions.add(new DeferredAction(){

            @Override
            public boolean isAllServletAction() {
                return false;
            }

            @Override
            public void doAction(ServletConfig servletConfig) throws UnableToAdaptException {
                WebAppConfiguratorHelper.this.webAppConfiguration.addListener(finalListenerClassName);
                configHelper.configureSpecificClass(finalListenerClassName);
            }
        });
    }

    private void configureMimeMapping(List<MimeMapping> mimeMappings) {
        Map mimeMappingConfigItemMap = this.configurator.getConfigItemMap("mime-mapping");
        for (MimeMapping mimeMapping : mimeMappings) {
            String extension = mimeMapping.getExtension();
            String mimeType = mimeMapping.getMimeType();
            if (this.isNullOrEmptyString(extension) || this.isNullOrEmptyString(mimeType)) continue;
            ServletConfigurator.ConfigItem existedMimeMapping = (ServletConfigurator.ConfigItem)mimeMappingConfigItemMap.get(extension);
            if (existedMimeMapping == null) {
                this.webAppConfiguration.addMimeMapping(extension, mimeType);
                mimeMappingConfigItemMap.put(extension, this.createConfigItem(mimeType));
                continue;
            }
            this.validateDuplicateKeyValueConfiguration("mime-mapping", "extension", extension, "mime-type", mimeType, existedMimeMapping);
        }
    }

    private void configureMultipartConfigAnnotation(Set<String> selectedTargets) throws UnableToAdaptException {
        String methodName = "configureMultipartConfigAnnotation";
        String displayName = this.webAppConfiguration.getDisplayName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"WebAppConfiguration [ " + displayName + " ]"});
        }
        WebAnnotations webAnnotations = this.configurator.getWebAnnotations();
        for (String targetClassName : selectedTargets) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"@MultipartConfig found on class {0}", (Object[])new Object[]{targetClassName});
            }
            ClassInfo classInfo = webAnnotations.getClassInfo(targetClassName);
            final String fullyQualifiedClassName = targetClassName;
            AnnotationInfo mpCfgAnnotation = classInfo.getAnnotation(MultipartConfig.class);
            AnnotationValue locationValue = mpCfgAnnotation.getValue("location");
            final String location = locationValue.getStringValue();
            AnnotationValue maxFileSizeValue = mpCfgAnnotation.getValue("maxFileSize");
            final long maxFileSize = maxFileSizeValue.getLongValue();
            AnnotationValue maxRequestSizeValue = mpCfgAnnotation.getValue("maxRequestSize");
            final long maxReqSize = maxRequestSizeValue.getLongValue();
            AnnotationValue fileSizeThresholdValue = mpCfgAnnotation.getValue("fileSizeThreshold");
            final int fileSizeThreshold = fileSizeThresholdValue.getIntValue();
            this.allActions.add(new DeferredAction(){

                @Override
                public boolean isAllServletAction() {
                    return true;
                }

                @Override
                public void doAction(ServletConfig servletConfig) {
                    if (fullyQualifiedClassName.equals(servletConfig.getClassName()) && servletConfig.getServletName() != null && servletConfig.getMultipartConfig() == null) {
                        servletConfig.setMultipartConfig(new MultipartConfigElement(location, maxFileSize, maxReqSize, fileSizeThreshold));
                    }
                }
            });
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)("WebAppConfiguration [ " + displayName + " ]"));
        }
    }

    private void configureRunAsAnnotation(Set<String> selectedTargets) throws UnableToAdaptException {
        String methodName = "configureRunAsAnnotation";
        String displayName = this.webAppConfiguration.getDisplayName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"WebAppConfiguration [ " + displayName + " ]"});
        }
        WebAnnotations webAnnotations = this.configurator.getWebAnnotations();
        for (String targetClassName : selectedTargets) {
            ClassInfo classInfo = webAnnotations.getClassInfo(targetClassName);
            final String fullyQualifiedClassName = targetClassName;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"@RunAs found on class {0}", (Object[])new Object[]{fullyQualifiedClassName});
            }
            AnnotationInfo runAsAnnotation = classInfo.getAnnotation(jakarta.annotation.security.RunAs.class);
            AnnotationValue value = runAsAnnotation.getValue("value");
            final String role = value.getStringValue();
            this.allActions.add(new DeferredAction(){

                @Override
                public boolean isAllServletAction() {
                    return true;
                }

                @Override
                public void doAction(ServletConfig servletConfig) {
                    if (fullyQualifiedClassName.equals(servletConfig.getClassName()) && servletConfig.getServletName() != null && servletConfig.getRunAsRole() == null) {
                        servletConfig.setRunAsRole(role);
                    }
                }
            });
            Map servletMap = this.configurator.getConfigItemMap("servlet");
            for (ServletConfigurator.ConfigItem configItem : servletMap.values()) {
                ServletConfig servletConfig = (ServletConfig)configItem.getValue();
                if (!fullyQualifiedClassName.equals(servletConfig.getClassName()) || servletConfig.getServletName() == null) continue;
                if (servletConfig.getRunAsRole() == null) {
                    servletConfig.setRunAsRole(role);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("@RunAs for servlet name " + servletConfig.getServletName() + " has value == " + role), (Object[])new Object[0]);
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("@RunAs for servlet name " + servletConfig.getServletName() + " is configured in the web.xml or web-fragment.xml, @RunAs is ignored"), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)("WebAppConfiguration [ " + displayName + " ]"));
        }
    }

    private void configureServlets(DeploymentDescriptor webDD, List<Servlet> servlets) {
        for (Servlet servlet : servlets) {
            this.processServletConfig(webDD, servlet);
        }
    }

    private void configureServletMappings(List<ServletMapping> servletMappings) throws UnableToAdaptException {
        for (ServletMapping servletMapping : servletMappings) {
            this.processServletMappingConfig(servletMapping);
        }
    }

    private void configureLocaleEncodingMap(LocaleEncodingMappingList mapList) {
        List mappingList;
        if (mapList != null && (mappingList = mapList.getLocaleEncodingMappings()) != null) {
            for (LocaleEncodingMapping oneMapping : mappingList) {
                this.webAppConfiguration.addLocaleEncodingMap(oneMapping.getLocale(), oneMapping.getEncoding());
            }
        }
    }

    private void configureServletAnnotation(Set<String> webServletClassNames) throws UnableToAdaptException {
        String methodName = "configureServletAnnotation";
        String displayName = this.webAppConfiguration.getDisplayName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"WebAppConfiguration [ " + displayName + " ]"});
        }
        WebAnnotations webAnnotations = this.configurator.getWebAnnotations();
        this.removeFromRequiredClasses(webServletClassNames, "Servlet");
        AnnotationTargets_Targets targets = webAnnotations.getAnnotationTargets();
        Map servletMap = this.configurator.getConfigItemMap("servlet");
        for (String className : webServletClassNames) {
            String servletName;
            boolean urlPatternsAttributeConfigured;
            boolean valueAttributeConfigured;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": @WebServlet target class [ " + className + " ]"), (Object[])new Object[0]);
            }
            if (!targets.isInstanceOf(className, HttpServlet.class)) {
                Tr.error((TraceComponent)tc, (String)"ERROR_WEBSERVLET_MUST_IMPLEMENT_HTTPSERVLET", (Object[])new Object[]{className});
                continue;
            }
            ClassInfo targetClass = webAnnotations.getClassInfo(className);
            AnnotationInfo webServletAnnotation = targetClass.getAnnotation(WebServlet.class);
            AnnotationValue valueAttribute = webServletAnnotation.getValue("value");
            AnnotationValue urlPatternsAttribute = webServletAnnotation.getValue("urlPatterns");
            boolean bl = null == valueAttribute ? false : (valueAttributeConfigured = !webServletAnnotation.getValue("value").getArrayValue().isEmpty());
            boolean bl2 = null == urlPatternsAttribute ? false : (urlPatternsAttributeConfigured = !webServletAnnotation.getValue("urlPatterns").getArrayValue().isEmpty());
            if (valueAttributeConfigured && urlPatternsAttributeConfigured) {
                Tr.error((TraceComponent)tc, (String)"ERROR_WEBSERVLET_HAS_VALUE_AND_PATTERNS", (Object[])new Object[]{className});
                continue;
            }
            if (!valueAttributeConfigured && !urlPatternsAttributeConfigured) {
                Tr.error((TraceComponent)tc, (String)"ERROR_WEBSERVLET_MISSING_PATTERNS", (Object[])new Object[]{className});
                continue;
            }
            AnnotationValue nameValue = webServletAnnotation.getValue("name");
            String string = servletName = null == nameValue ? null : nameValue.getStringValue();
            if (null == servletName || servletName.isEmpty()) {
                servletName = className;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("@WebServlet servlet name == " + servletName), (Object[])new Object[0]);
            }
            ServletConfigurator.ConfigItem existedServlet = (ServletConfigurator.ConfigItem)servletMap.get(servletName);
            ServletConfig servletConfig = null;
            if (existedServlet == null) {
                servletConfig = this.webAppConfiguration.createServletConfig("ServletGeneratedId" + this.configurator.generateUniqueId(), servletName);
                servletConfig.setClassName(className);
                this.webAppConfiguration.addServletInfo(servletName, servletConfig);
                servletMap.put(servletName, this.createConfigItem(servletConfig));
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Add new servlet from WebServlet annotation servlet class name = {0}", (Object[])new Object[]{className});
                }
            } else {
                servletConfig = (ServletConfig)existedServlet.getValue();
            }
            this.configureCommonWebAnnotation(servletConfig, webServletAnnotation, "servlet");
            this.configureWebServletAnnotation(servletConfig, webServletAnnotation);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)("WebAppConfiguration [ " + displayName + " ]"));
        }
    }

    protected void configureSessionConfig(SessionConfig sessionConfig) {
        List trackingModeValues;
        CookieConfig cookieConfig;
        if (sessionConfig == null) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"configureSessionConfig ", (Object[])new Object[0]);
        }
        Map sessionConfigItemMap = this.configurator.getConfigItemMap("session-config");
        if (sessionConfig.isSetSessionTimeout()) {
            int sessionTimeout = sessionConfig.getSessionTimeout();
            ServletConfigurator.ConfigItem existedTimeout = (ServletConfigurator.ConfigItem)sessionConfigItemMap.get("session-timeout");
            if (existedTimeout == null) {
                this.webAppConfiguration.setSessionTimeout(sessionTimeout);
                sessionConfigItemMap.put("session-timeout", this.createConfigItem(String.valueOf(sessionTimeout)));
            } else {
                this.validateDuplicateConfiguration("session-config", "session-timeout", String.valueOf(sessionTimeout), existedTimeout);
            }
        }
        if ((cookieConfig = sessionConfig.getCookieConfig()) != null) {
            ServletConfigurator.ConfigItem existedHttpOnly;
            String cookiePath;
            String cookieName;
            String cookieDomain;
            SessionCookieConfigImpl sessionCookieConfigImpl = (SessionCookieConfigImpl)this.webAppConfiguration.getSessionCookieConfig();
            String cookieComment = cookieConfig.getComment();
            if (cookieComment != null) {
                ServletConfigurator.ConfigItem existedComment = (ServletConfigurator.ConfigItem)sessionConfigItemMap.get("comment");
                if (existedComment == null) {
                    sessionCookieConfigImpl.setComment(cookieComment, false);
                    sessionConfigItemMap.put("comment", this.createConfigItem(cookieComment));
                } else {
                    this.validateDuplicateConfiguration("cookie-config", "comment", cookieComment, existedComment);
                }
            }
            if ((cookieDomain = cookieConfig.getDomain()) != null) {
                ServletConfigurator.ConfigItem existedDomain = (ServletConfigurator.ConfigItem)sessionConfigItemMap.get("domain");
                if (existedDomain == null) {
                    sessionCookieConfigImpl.setDomain(cookieDomain, false);
                    sessionConfigItemMap.put("domain", this.createConfigItem(cookieDomain));
                } else {
                    this.validateDuplicateConfiguration("cookie-config", "domain", cookieDomain, existedDomain);
                }
            }
            if (cookieConfig.isSetMaxAge()) {
                int maxAge = cookieConfig.getMaxAge();
                ServletConfigurator.ConfigItem existedMaxAge = (ServletConfigurator.ConfigItem)sessionConfigItemMap.get("max-age");
                if (existedMaxAge == null) {
                    sessionCookieConfigImpl.setMaxAge(maxAge, false);
                    sessionConfigItemMap.put("max-age", this.createConfigItem(String.valueOf(maxAge)));
                } else {
                    this.validateDuplicateConfiguration("cookie-config", "max-age", String.valueOf(maxAge), existedMaxAge);
                }
            }
            if ((cookieName = cookieConfig.getName()) != null) {
                ServletConfigurator.ConfigItem existedName = (ServletConfigurator.ConfigItem)sessionConfigItemMap.get("name");
                if (existedName == null) {
                    sessionCookieConfigImpl.setName(cookieName, false);
                    sessionConfigItemMap.put("name", this.createConfigItem(cookieName));
                } else {
                    this.validateDuplicateConfiguration("cookie-config", "name", cookieDomain, existedName);
                }
            }
            if ((cookiePath = cookieConfig.getPath()) != null) {
                ServletConfigurator.ConfigItem existedPath = (ServletConfigurator.ConfigItem)sessionConfigItemMap.get("path");
                if (existedPath == null) {
                    sessionCookieConfigImpl.setPath(cookiePath, false);
                    sessionConfigItemMap.put("path", this.createConfigItem(cookiePath));
                } else {
                    this.validateDuplicateConfiguration("cookie-config", "path", cookiePath, existedPath);
                }
            }
            if (cookieConfig.isSetHTTPOnly()) {
                boolean httpOnly = cookieConfig.isHTTPOnly();
                existedHttpOnly = (ServletConfigurator.ConfigItem)sessionConfigItemMap.get("http-only");
                if (existedHttpOnly == null) {
                    sessionCookieConfigImpl.setHttpOnly(httpOnly, false);
                    sessionConfigItemMap.put("http-only", this.createConfigItem(String.valueOf(httpOnly)));
                } else {
                    this.validateDuplicateConfiguration("cookie-config", "http-only", String.valueOf(httpOnly), existedHttpOnly);
                }
            }
            if (cookieConfig.isSetSecure()) {
                boolean cookieSecured = cookieConfig.isSecure();
                existedHttpOnly = (ServletConfigurator.ConfigItem)sessionConfigItemMap.get("secure");
                if (existedHttpOnly == null) {
                    sessionCookieConfigImpl.setSecure(cookieSecured, false);
                    sessionConfigItemMap.put("secure", this.createConfigItem(String.valueOf(cookieSecured)));
                } else {
                    this.validateDuplicateConfiguration("cookie-config", "secure", String.valueOf(cookieSecured), existedHttpOnly);
                }
            }
        }
        if ((trackingModeValues = sessionConfig.getTrackingModeValues()) != null && !trackingModeValues.isEmpty()) {
            for (SessionConfig.TrackingModeEnum trackingModeValue : trackingModeValues) {
                SessionTrackingMode mode = null;
                switch (trackingModeValue) {
                    case COOKIE: {
                        mode = SessionTrackingMode.COOKIE;
                        break;
                    }
                    case SSL: {
                        mode = SessionTrackingMode.SSL;
                        break;
                    }
                    case URL: {
                        mode = SessionTrackingMode.URL;
                    }
                }
                this.webAppConfiguration.addSessionTrackingMode(mode);
            }
        }
    }

    private void configureWebFilterAnnotation(FilterConfig filterConfig, AnnotationInfo webFilterAnnotation, boolean processMappingsNow) {
        String methodName = "configureWebFilterAnnotation";
        String displayName = this.webAppConfiguration.getDisplayName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"WebAppConfiguration [ " + displayName + " ]"});
        }
        String filterName = filterConfig.getFilterName();
        Map filterMappingMap = this.configurator.getConfigItemMap("filter-mapping");
        if (!filterMappingMap.containsKey(filterName)) {
            AnnotationValue servletNamesValue;
            AnnotationValue dispatcherTypesValue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Add [ " + filterName + " ]"), (Object[])new Object[0]);
            }
            List dispatcherTypeList = null == (dispatcherTypesValue = webFilterAnnotation.getValue("dispatcherTypes")) ? new ArrayList() : dispatcherTypesValue.getArrayValue();
            DispatcherType[] dispatcherTypes = new DispatcherType[dispatcherTypeList.size()];
            int index = 0;
            for (Object dispatcherType : dispatcherTypeList) {
                String dispatcherTypeValue = dispatcherType.getStringValue();
                dispatcherTypes[index++] = DispatcherType.valueOf((String)dispatcherTypeValue);
            }
            AnnotationValue urlPatternsValue = webFilterAnnotation.getValue("value");
            if (null == urlPatternsValue || urlPatternsValue.getArrayValue().isEmpty()) {
                urlPatternsValue = webFilterAnnotation.getValue("urlPatterns");
            }
            if (null != urlPatternsValue) {
                for (AnnotationValue urlPatternValue : urlPatternsValue.getArrayValue()) {
                    this.addFilterMapping(filterConfig, urlPatternValue.getStringValue(), null, dispatcherTypes, processMappingsNow);
                }
            }
            if (null != (servletNamesValue = webFilterAnnotation.getValue("servletNames"))) {
                for (AnnotationValue servletNameValue : servletNamesValue.getArrayValue()) {
                    this.addFilterMapping(filterConfig, null, servletNameValue.getStringValue(), dispatcherTypes, false);
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + ": Ignore [ " + filterName + " ]: Duplicate"), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)("WebAppConfiguration [ " + displayName + " ]"));
        }
    }

    private void configureWebServletAnnotation(ServletConfig servletConfig, AnnotationInfo webServletAnnotation) throws UnableToAdaptException {
        Map servletMappingMap;
        AnnotationValue loadOnStartupValue;
        String methodName = "configureWebServletAnnotation";
        String displayName = this.webAppConfiguration.getDisplayName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"WebAppConfiguration [ " + displayName + " ]"});
        }
        int loadOnStartup = null == (loadOnStartupValue = webServletAnnotation.getValue("loadOnStartup")) ? -1 : loadOnStartupValue.getIntValue();
        String servletName = servletConfig.getServletName();
        Map loadOnStartupMap = this.configurator.getConfigItemMap("servlet.load-on-startup");
        if (!loadOnStartupMap.containsKey(servletName)) {
            servletConfig.setLoadOnStartup(loadOnStartup);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"@WebServlet servlet == {0} class == {1} loadOnStartup == {2}", (Object[])new Object[]{servletName, servletConfig.getClassName(), loadOnStartup});
            }
        }
        if (!(servletMappingMap = this.configurator.getConfigItemMap("servlet-mapping")).containsKey(servletName)) {
            List urlPatternList;
            AnnotationValue urlPatternListValue = webServletAnnotation.getValue("value");
            List list = urlPatternList = null == urlPatternListValue ? null : urlPatternListValue.getArrayValue();
            if (null == urlPatternList || urlPatternList.isEmpty()) {
                urlPatternList = webServletAnnotation.getValue("urlPatterns").getArrayValue();
            }
            for (AnnotationValue urlPatternValue : urlPatternList) {
                String existingName;
                String urlText = urlPatternValue.getStringValue();
                if (WebAppConfiguratorHelper.isServletSpecLevel31OrHigher() && (existingName = this.urlToServletNameMap.put(urlText, servletName)) != null && !existingName.equals(servletName)) {
                    Tr.error((TraceComponent)tc, (String)"duplicate.url.pattern.for.servlet.mapping", (Object[])new Object[]{urlText, servletName, existingName});
                    throw new UnableToAdaptException(nls.getFormattedMessage("duplicate.url.pattern.for.servlet.mapping", new Object[]{urlText, servletName, existingName}, "servlet-mapping value matches multiple servlets: " + urlText));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + ": Map servlet [ " + servletName + " ] to URL [ " + urlText + " ]"), (Object[])new Object[0]);
                }
                this.webAppConfiguration.addServletMapping(servletName, urlText);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)("WebAppConfiguration [ " + displayName + " ]"));
        }
    }

    private void configureWelcomeFileList(WelcomeFileList welcomeFileList) {
        if (welcomeFileList == null) {
            return;
        }
        Set welcomeFileSet = this.configurator.getContextSet("welcome-file-list");
        for (String welcomeFile : welcomeFileList.getWelcomeFiles()) {
            if (welcomeFileSet.contains(welcomeFile)) continue;
            welcomeFileSet.add(welcomeFile);
            this.webAppConfiguration.addWelcomeFile(welcomeFile);
        }
    }

    private void configureResourceRefExtensions(List<com.ibm.ws.javaee.dd.commonext.ResourceRef> resRefExts) {
        RefBndAndExtHelper.configureResourceRefExtensions(resRefExts, (ResourceRefConfigList)this.webAppConfiguration.getResourceRefConfigList());
    }

    private MultipartConfigElement createMultipartConfigElement(com.ibm.ws.javaee.dd.web.common.MultipartConfig multipartConfig) {
        return new MultipartConfigElement(multipartConfig.getLocation(), multipartConfig.isSetMaxFileSize() ? multipartConfig.getMaxFileSize() : -1L, multipartConfig.isSetMaxRequestSize() ? multipartConfig.getMaxRequestSize() : -1L, multipartConfig.isSetFileSizeThreshold() ? multipartConfig.getFileSizeThreshold() : 0);
    }

    private String getDescription(List<Description> descriptions) {
        for (Description description : descriptions) {
            String value = description.getValue();
            if (value == null || value.isEmpty()) continue;
            return value;
        }
        return null;
    }

    private String getDisplayName(List<DisplayName> displayNames) {
        for (DisplayName displayName : displayNames) {
            String value = displayName.getValue();
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private boolean isSameMultipartConfigs(com.ibm.ws.javaee.dd.web.common.MultipartConfig configA, com.ibm.ws.javaee.dd.web.common.MultipartConfig configB) {
        if (configA.getLocation() == null ? configB.getLocation() != null : !configA.getLocation().equals(configB.getLocation())) {
            return false;
        }
        if (!(!configA.isSetFileSizeThreshold() && !configB.isSetFileSizeThreshold() || configA.isSetFileSizeThreshold() && configB.isSetFileSizeThreshold() && configA.getFileSizeThreshold() == configB.getFileSizeThreshold())) {
            return false;
        }
        if (!(!configA.isSetMaxFileSize() && !configB.isSetMaxFileSize() || configA.isSetMaxFileSize() && configB.isSetMaxFileSize() && configA.getMaxFileSize() == configB.getMaxFileSize())) {
            return false;
        }
        return !configA.isSetMaxRequestSize() && !configB.isSetMaxRequestSize() || configA.isSetMaxRequestSize() && configB.isSetMaxRequestSize() && configA.getMaxRequestSize() == configB.getMaxRequestSize();
    }

    private final boolean isNullOrEmptyString(String value) {
        return value == null || value.isEmpty();
    }

    private FilterConfig createCdiConversationFilter(DeploymentDescriptor webDD) {
        return this.processFilterConfig(webDD, new com.ibm.ws.javaee.dd.web.common.Filter(){

            public List<Description> getDescriptions() {
                return Collections.emptyList();
            }

            public List<Icon> getIcons() {
                return Collections.emptyList();
            }

            public List<DisplayName> getDisplayNames() {
                return Collections.emptyList();
            }

            public boolean isSetAsyncSupported() {
                return true;
            }

            public boolean isAsyncSupported() {
                return true;
            }

            public List<ParamValue> getInitParams() {
                return Collections.emptyList();
            }

            public String getFilterName() {
                return WebAppConfiguratorHelper.CDI_CONVERSATION_FILTER;
            }

            public String getFilterClass() {
                return null;
            }
        });
    }

    private FilterConfig processFilterConfig(DeploymentDescriptor webDD, com.ibm.ws.javaee.dd.web.common.Filter filter) {
        String filterName = filter.getFilterName();
        Map filterMap = this.configurator.getConfigItemMap("filter");
        ServletConfigurator.ConfigItem existedFilter = (ServletConfigurator.ConfigItem)filterMap.get(filterName);
        FilterConfig filterConfig = null;
        if (existedFilter == null) {
            String id = webDD.getIdForComponent((Object)filter);
            if (id == null) {
                id = "FilterGeneratedId" + this.configurator.generateUniqueId();
            }
            filterConfig = this.webAppConfiguration.createFilterConfig(id, filterName);
            this.configureTargetConfig(filterConfig, filter.getFilterClass(), "Filter", (DescriptionGroup)filter);
            this.webAppConfiguration.addFilterInfo(filterConfig);
            filterMap.put(filterName, this.createConfigItem(filterConfig));
        } else {
            filterConfig = (FilterConfig)existedFilter.getValue();
        }
        this.configureInitParams(filterConfig, filter.getInitParams(), "filter");
        if (filter.isSetAsyncSupported()) {
            this.configureAsyncSupported(filterConfig, filter.isAsyncSupported(), "filter");
        }
        return filterConfig;
    }

    private void processFilterMappingConfig(DeploymentDescriptor webDD, FilterMapping filterMapping) {
        this.processFilterMappingConfig(webDD, filterMapping, false, this.filterMappingIndex);
    }

    private void processFilterMappingConfig(DeploymentDescriptor webDD, FilterMapping filterMapping, boolean defer, int index) {
        Map filterMappingMap;
        ServletConfigurator.ConfigItem existedFilterMapping;
        Map filterMap;
        ServletConfigurator.ConfigItem filterItem;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processFilterMappingConfig", (Object[])new Object[]{"webDD [ " + webDD + " ] defer [ " + defer + " ] index [ " + index + " ]"});
        }
        String filterName = filterMapping.getFilterName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processFilterMappingConfig: filterName [ " + filterName + " ]"), (Object[])new Object[0]);
        }
        if ((filterItem = (ServletConfigurator.ConfigItem)(filterMap = this.configurator.getConfigItemMap("filter")).get(filterName)) == null) {
            if (defer) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)" No filter configuration found for {0}, the filter-mapping configuration in {1} is ignored", (Object[])new Object[]{filterName, this.configurator.getLibraryURI()});
                }
                ++this.filterMappingIndexOffset;
            } else if (deferProcessingIncompleteFiltersInWebXML) {
                this.deferredFilterMappings.add(new MappingIndexPair<FilterMapping, Integer>(filterMapping, this.filterMappingIndex));
            }
            ++this.filterMappingIndex;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"processFilterMappingConfig", (Object)("webDD [ " + webDD + " ] defer [ " + defer + " ] index [ " + index + " ]"));
            }
            return;
        }
        ++this.filterMappingIndex;
        FilterConfig filterConfig = (FilterConfig)filterItem.getValue();
        if (filterConfig == null && CDI_CONVERSATION_FILTER.equals(filterName)) {
            filterMap.remove(filterName);
            filterConfig = this.createCdiConversationFilter(webDD);
        }
        if ((existedFilterMapping = (ServletConfigurator.ConfigItem)(filterMappingMap = this.configurator.getConfigItemMap("filter-mapping")).get(filterName)) == null) {
            DispatcherType[] dispatcherTypes = this.getDispatcherTypes(filterMapping);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"processFilterMappingConfig: existing filter mapping not found", (Object[])new Object[0]);
            }
            if (defer) {
                this.addFilterMapping(filterConfig, filterMapping.getURLPattern(), filterMapping.getServletName(), dispatcherTypes, false, index);
            } else {
                this.addFilterMapping(filterConfig, filterMapping.getURLPattern(), filterMapping.getServletName(), dispatcherTypes, false);
            }
            filterMappingMap.put(filterName, this.createConfigItem(filterMapping));
        } else if (existedFilterMapping.getSource() == ServletConfigurator.ConfigSource.WEB_XML && this.configurator.getConfigSource() == ServletConfigurator.ConfigSource.WEB_XML || existedFilterMapping.getSource() == ServletConfigurator.ConfigSource.WEB_FRAGMENT && this.configurator.getConfigSource() == ServletConfigurator.ConfigSource.WEB_FRAGMENT) {
            DispatcherType[] dispatcherTypes = this.getDispatcherTypes(filterMapping);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"processFilterMappingConfig: existing filter mapping found", (Object[])new Object[0]);
            }
            this.addFilterMapping(filterConfig, filterMapping.getURLPattern(), filterMapping.getServletName(), dispatcherTypes, false);
        } else if (existedFilterMapping.getSource() == ServletConfigurator.ConfigSource.WEB_XML && this.configurator.getConfigSource() == ServletConfigurator.ConfigSource.WEB_FRAGMENT) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"filter-mapping for filter {0} is configured in web.xml, the value from web-fragment.xml in {1} is ignored", (Object[])new Object[]{filterName, this.configurator.getLibraryURI()});
            }
        } else if (existedFilterMapping.getSource() == ServletConfigurator.ConfigSource.WEB_FRAGMENT && this.configurator.getConfigSource() == ServletConfigurator.ConfigSource.ANNOTATION && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"filter-mapping for filter {0} is configured in web-fragment.xml from {1}, the value from annotation is ignored", (Object[])new Object[]{filterName, existedFilterMapping.getLibraryURI()});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processFilterMappingConfig", (Object)("webDD [ " + webDD + " ] defer [ " + defer + " ] index [ " + index + " ]"));
        }
    }

    private DispatcherType[] getDispatcherTypes(FilterMapping filterMapping) {
        List dispatcherValues = filterMapping.getDispatcherValues();
        if (dispatcherValues == null) {
            return null;
        }
        DispatcherType[] dispatcherTypes = new DispatcherType[dispatcherValues.size()];
        int index = 0;
        for (FilterMapping.DispatcherEnum dispatcherValue : dispatcherValues) {
            DispatcherType dispatcherType = null;
            switch (dispatcherValue) {
                case ASYNC: {
                    dispatcherType = DispatcherType.ASYNC;
                    break;
                }
                case ERROR: {
                    dispatcherType = DispatcherType.ERROR;
                    break;
                }
                case FORWARD: {
                    dispatcherType = DispatcherType.FORWARD;
                    break;
                }
                case INCLUDE: {
                    dispatcherType = DispatcherType.INCLUDE;
                    break;
                }
                case REQUEST: {
                    dispatcherType = DispatcherType.REQUEST;
                }
            }
            dispatcherTypes[index++] = dispatcherType;
        }
        return dispatcherTypes;
    }

    private void processServletConfig(DeploymentDescriptor webDD, Servlet servlet) {
        RunAs runAs;
        String servletName = servlet.getServletName();
        Map servletMap = this.configurator.getConfigItemMap("servlet");
        ServletConfigurator.ConfigItem existedServlet = (ServletConfigurator.ConfigItem)servletMap.get(servletName);
        ServletConfig servletConfig = null;
        if (existedServlet == null) {
            String servletId = webDD.getIdForComponent((Object)servlet);
            if (servletId == null) {
                servletId = "ServletGeneratedId" + this.configurator.generateUniqueId();
            }
            servletConfig = this.webAppConfiguration.createServletConfig(servletId, servletName);
            this.configureTargetConfig(servletConfig, servlet.getServletClass(), "Servlet", (DescriptionGroup)servlet);
            String jspFile = servlet.getJSPFile();
            if (jspFile != null) {
                servletConfig.setIsJsp(true);
                servletConfig.setFileName(jspFile);
            }
            if (servlet.isSetEnabled()) {
                servletConfig.setEnabled(servlet.isEnabled());
            }
            this.webAppConfiguration.addServletInfo(servletName, servletConfig);
            servletMap.put(servletName, this.createConfigItem(servletConfig));
        } else {
            servletConfig = (ServletConfig)existedServlet.getValue();
        }
        this.configureInitParams(servletConfig, servlet.getInitParams(), "servlet");
        if (servlet.isSetLoadOnStartup()) {
            Map servletLoadOnStartupMap = this.configurator.getConfigItemMap("servlet.load-on-startup");
            ServletConfigurator.ConfigItem existedLoadOnStartup = (ServletConfigurator.ConfigItem)servletLoadOnStartupMap.get(servletName);
            if (existedLoadOnStartup == null) {
                servletConfig.setStartUpWeight(servlet.isNullLoadOnStartup() ? null : Integer.valueOf(servlet.getLoadOnStartup()));
                servletLoadOnStartupMap.put(servletName, this.createConfigItem(servlet.getLoadOnStartup()));
            } else {
                this.validateDuplicateConfiguration("servlet", "load-on-startup", servlet.isNullLoadOnStartup() ? null : Integer.valueOf(servlet.getLoadOnStartup()), existedLoadOnStartup);
            }
        }
        if (servlet.getMultipartConfig() != null) {
            Map servletMultipartConfigMap = this.configurator.getConfigItemMap("servlet.multipart-config");
            if (existedServlet == null || !servletMultipartConfigMap.containsKey(servletName)) {
                servletConfig.setMultipartConfig(this.createMultipartConfigElement(servlet.getMultipartConfig()));
                servletMultipartConfigMap.put(servletName, this.createConfigItem(servlet.getMultipartConfig()));
            } else {
                ServletConfigurator.ConfigItem existedMultipartConfig = (ServletConfigurator.ConfigItem)servletMultipartConfigMap.get(servletName);
                if (existedMultipartConfig.getSource() == ServletConfigurator.ConfigSource.WEB_FRAGMENT && this.configurator.getConfigSource() == ServletConfigurator.ConfigSource.WEB_FRAGMENT) {
                    if (!this.isSameMultipartConfigs((com.ibm.ws.javaee.dd.web.common.MultipartConfig)existedMultipartConfig.getValue(), servlet.getMultipartConfig())) {
                        // empty if block
                    }
                } else if (existedMultipartConfig.getSource() == ServletConfigurator.ConfigSource.WEB_XML && this.configurator.getConfigSource() == ServletConfigurator.ConfigSource.WEB_FRAGMENT && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"multipart-config for servlet {0} is configured in web.xml, the value from web-fragment.xml in {1}  is ignored", (Object[])new Object[]{servletName, this.configurator.getLibraryURI()});
                }
            }
        }
        if (servlet.isSetAsyncSupported()) {
            this.configureAsyncSupported(servletConfig, servlet.isAsyncSupported(), "servlet");
        }
        if ((runAs = servlet.getRunAs()) != null) {
            servletConfig.setRunAsRole(runAs.getRoleName());
        }
    }

    private void processServletMappingConfig(ServletMapping servletMapping) throws UnableToAdaptException {
        String servletName = servletMapping.getServletName();
        Map servletMappingMap = this.configurator.getConfigItemMap("servlet-mapping");
        ServletConfigurator.ConfigItem existedServletMapping = (ServletConfigurator.ConfigItem)servletMappingMap.get(servletName);
        if (existedServletMapping == null) {
            List urlPatterns = servletMapping.getURLPatterns();
            for (String urlPattern : urlPatterns) {
                String existingName;
                if (WebAppConfiguratorHelper.isServletSpecLevel31OrHigher() && (existingName = this.urlToServletNameMap.put(urlPattern, servletName)) != null && !existingName.equals(servletName)) {
                    Tr.error((TraceComponent)tc, (String)"duplicate.url.pattern.for.servlet.mapping", (Object[])new Object[]{urlPattern, servletName, existingName});
                    throw new UnableToAdaptException(nls.getFormattedMessage("duplicate.url.pattern.for.servlet.mapping", new Object[]{urlPattern, servletName, existingName}, "servlet-mapping value matches multiple servlets: " + urlPattern));
                }
                this.webAppConfiguration.addServletMapping(servletName, urlPattern);
            }
            if (urlPatterns.size() > 0) {
                servletMappingMap.put(servletName, this.createConfigItem(urlPatterns));
            }
        } else if (existedServletMapping.getSource() == ServletConfigurator.ConfigSource.WEB_XML && this.configurator.getConfigSource() == ServletConfigurator.ConfigSource.WEB_XML || existedServletMapping.getSource() == ServletConfigurator.ConfigSource.WEB_FRAGMENT && this.configurator.getConfigSource() == ServletConfigurator.ConfigSource.WEB_FRAGMENT) {
            for (String urlPattern : servletMapping.getURLPatterns()) {
                String existingName;
                if (WebAppConfiguratorHelper.isServletSpecLevel31OrHigher() && (existingName = this.urlToServletNameMap.put(urlPattern, servletName)) != null && !existingName.equals(servletName)) {
                    Tr.error((TraceComponent)tc, (String)"duplicate.url.pattern.for.servlet.mapping", (Object[])new Object[]{urlPattern, servletName, existingName});
                    throw new UnableToAdaptException(nls.getFormattedMessage("duplicate.url.pattern.for.servlet.mapping", new Object[]{urlPattern, servletName, existingName}, "servlet-mapping value matches multiple servlets: " + urlPattern));
                }
                this.webAppConfiguration.addServletMapping(servletName, urlPattern);
            }
        } else if (existedServletMapping.getSource() == ServletConfigurator.ConfigSource.WEB_XML && this.configurator.getConfigSource() == ServletConfigurator.ConfigSource.WEB_FRAGMENT) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("servlet-mapping for servlet " + servletName + " is configured in web.xml, the value from web-fragment.xml in " + this.configurator.getLibraryURI() + " is ignored"), (Object[])new Object[0]);
            }
        } else if (existedServletMapping.getSource() == ServletConfigurator.ConfigSource.WEB_FRAGMENT && this.configurator.getConfigSource() == ServletConfigurator.ConfigSource.ANNOTATION && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("servlet-mapping for servlet " + servletName + " is configured in web-fragment.xml from " + existedServletMapping.getLibraryURI() + " , the value from annotation is ignored"), (Object[])new Object[0]);
        }
    }

    private <T extends ResourceBaseGroup> void processDuplicateJndiReferenceConfig(String referenceElementName, String jndiElementName, String jndiElementValue, ServletConfigurator.ConfigItem<T> existedConfigItem, T currentValue, Set<String> additiveJNDIReferenceNames) {
        if (existedConfigItem.getSource() == ServletConfigurator.ConfigSource.WEB_XML && this.configurator.getConfigSource() == ServletConfigurator.ConfigSource.WEB_FRAGMENT) {
            if (WebAppConfiguratorHelper.isServletSpecLevel31OrHigher() || additiveJNDIReferenceNames.contains(jndiElementValue)) {
                ((InjectionTargetsEditable)existedConfigItem.getValue(InjectionTargetsEditable.class)).addInjectionTargets(currentValue.getInjectionTargets());
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"{0}.{1} with value {2}  is configured in web.xml with injection-target, the configurations from web-fragment.xml in {3} is ignored", (Object[])new Object[]{referenceElementName, jndiElementName, jndiElementValue, this.configurator.getLibraryURI()});
            }
        } else if (existedConfigItem.getSource() == ServletConfigurator.ConfigSource.WEB_FRAGMENT && this.configurator.getConfigSource() == ServletConfigurator.ConfigSource.WEB_FRAGMENT) {
            if (existedConfigItem.compareValue(currentValue)) {
                ((InjectionTargetsEditable)existedConfigItem.getValue(InjectionTargetsEditable.class)).addInjectionTargets(currentValue.getInjectionTargets());
            } else {
                this.configurator.addErrorMessage(nls.getFormattedMessage("CONFLICT_JNDI_REFERENCE_BETWEEN_WEB_FRAGMENT_XML", new Object[]{referenceElementName, jndiElementValue, jndiElementName, existedConfigItem.getLibraryURI(), this.configurator.getLibraryURI()}, "Conflict JNDI configurations are found in the web-fragment.xml files"));
            }
        }
    }

    protected <T> ServletConfigurator.ConfigItem<T> createConfigItem(T value) {
        return this.configurator.createConfigItem(value);
    }

    private <T> ServletConfigurator.ConfigItem<T> createConfigItem(T value, ServletConfigurator.MergeComparator<T> comparator) {
        return this.configurator.createConfigItem(value, comparator);
    }

    protected <T> void validateDuplicateConfiguration(String parentElementName, String elementName, T currentValue, ServletConfigurator.ConfigItem<T> existedConfigItem) {
        this.configurator.validateDuplicateConfiguration(parentElementName, elementName, currentValue, existedConfigItem);
    }

    private <T> void validateDuplicateKeyValueConfiguration(String parentElementName, String keyElementName, String keyElementValue, String valueElementName, T currentValue, ServletConfigurator.ConfigItem<T> existedConfigItem) {
        this.configurator.validateDuplicateKeyValueConfiguration(parentElementName, keyElementName, keyElementValue, valueElementName, currentValue, existedConfigItem);
    }

    private void validateDuplicateDefaultErrorPageConfiguration(String newLocationValue, ServletConfigurator.ConfigItem<String> currentLocationItem) {
        this.configurator.validateDuplicateDefaultErrorPageConfiguration(newLocationValue, currentLocationItem);
    }

    public void processIgnoredMappings(DeploymentDescriptor webDD) throws UnableToAdaptException {
        if (!this.deferredFilterMappings.isEmpty()) {
            for (MappingIndexPair<FilterMapping, Integer> filterPair : this.deferredFilterMappings) {
                this.processFilterMappingConfig(webDD, filterPair.getMapping(), true, filterPair.getIndex() - this.filterMappingIndexOffset);
            }
        }
    }

    protected static interface DeferredAction {
        public boolean isAllServletAction();

        public void doAction(ServletConfig var1) throws UnableToAdaptException;
    }

    private static final class MappingIndexPair<T, N> {
        private T t;
        private N n;

        public MappingIndexPair(T t, N n) {
            this.t = t;
            this.n = n;
        }

        public T getMapping() {
            return this.t;
        }

        public N getIndex() {
            return this.n;
        }
    }

    protected static final class ConfigurationWriter {
        private final WebAppConfiguration config;
        private final ResourceRefConfigFactory resourceRefConfigFactory;

        public ConfigurationWriter(WebAppConfiguration config, ResourceRefConfigFactory resourceRefConfigFactory) {
            this.config = config;
            this.resourceRefConfigFactory = resourceRefConfigFactory;
        }

        public void setContextRoot(String contextRoot) {
            this.config.setContextRoot(contextRoot);
        }

        public void setDistributable(boolean distributable) {
            this.config.setDistributable(distributable);
        }

        public boolean isDistributable() {
            return this.config.isDistributable();
        }

        public void setModuleName(String moduleName) {
            this.config.setModuleName(moduleName);
        }

        public void setJ2EEModuleName(String j2eeModuleName) {
            this.config.setJ2EEModuleName(j2eeModuleName);
        }

        public void setApplicationName(String appName) {
            this.config.setApplicationName(appName);
        }

        public void setBundleHeaders(Dictionary<String, String> bundleHeaders) {
            this.config.setBundleHeaders(bundleHeaders);
        }

        public void setOrderedLibPaths(ArrayList<String> orderedLibPaths) {
            this.config.setOrderedLibPaths(orderedLibPaths);
        }

        public void addRef(JNDIEnvironmentRefType refType, JNDIEnvironmentRef ref) {
            refType.addRef(this.config.getAllRefs(), ref);
        }

        public void setVersion(int servletVersion) {
            this.config.setVersion(servletVersion);
        }

        public void setMetadataComplete(boolean metadataComplete) {
            this.config.setMetadataComplete(metadataComplete);
        }

        public void setDescription(String description) {
            this.config.setDescription(description);
        }

        public void setDisplayName(String displayName) {
            this.config.setDisplayName(displayName);
        }

        public void addListener(String listenerClass) {
            this.config.addListener(listenerClass);
            Set<String> setOfWebXmlDefinedListeners = this.config.getWebXmlDefinedListeners();
            setOfWebXmlDefinedListeners.add(listenerClass);
        }

        public void addLocaleEncodingMap(String locale, String encoding) {
            this.config.addLocaleEncodingMap(locale, encoding);
        }

        public void setSessionTimeout(int sessionTimeout) {
            this.config.setSessionTimeout(sessionTimeout);
            this.config.setModuleSessionTimeoutSet(true);
        }

        public void addServletMapping(String servletName, String urlPattern) {
            this.config.addServletMapping(servletName, urlPattern);
        }

        public Map<JNDIEnvironmentRefType, Map<String, String>> getAllRefBindings() {
            return this.config.getAllRefBindings();
        }

        public Map<String, String> getEnvEntryValues() {
            return this.config.getEnvEntryValues();
        }

        public void addFilterInfo(FilterConfig filterConfig) {
            this.config.addFilterInfo(filterConfig);
        }

        public void addServletInfo(String servletName, ServletConfig servletConfig) {
            this.config.addServletInfo(servletName, servletConfig);
        }

        public ResourceRefConfigList getResourceRefConfigList() {
            return this.config.getResourceRefConfigList(this.resourceRefConfigFactory);
        }

        public ServletConfig createServletConfig(String servletId, String servletName) {
            ServletConfig servletConfig = new ServletConfig(servletId, this.config);
            servletConfig.setMetaData(new WebComponentMetaDataImpl(this.config.getMetaData()));
            servletConfig.setServletName(servletName);
            return servletConfig;
        }

        public FilterConfig createFilterConfig(String filterId, String filterName) {
            FilterConfig filterConfig = new FilterConfig(filterId, this.config);
            filterConfig.setName(filterName);
            return filterConfig;
        }

        public void addContextParam(String contextParamName, String contextParamValue) {
            HashMap webAppContextParamMap = this.config.getContextParams();
            webAppContextParamMap.put(contextParamName, contextParamValue);
        }

        public void addDefaultWelcomeFiles() {
            List<String> welcomeFiles = this.config.getWelcomeFileList();
            if (welcomeFiles.isEmpty()) {
                welcomeFiles.addAll(Arrays.asList("index.html", "index.htm", "index.jsp"));
            }
        }

        public void setDefaultDisplayName() {
            if (this.config.getDisplayName() == null) {
                this.config.setDisplayName(this.config.getModuleName());
            }
        }

        public void addWelcomeFile(String welcomeFile) {
            List<String> welcomeFiles = this.config.getWelcomeFileList();
            welcomeFiles.add(welcomeFile);
        }

        public void addSessionTrackingMode(SessionTrackingMode mode) {
            EnumSet<SessionTrackingMode> stm = this.config.getInternalDefaultSessionTrackingMode();
            if (stm == null) {
                stm = EnumSet.noneOf(SessionTrackingMode.class);
                this.config.setDefaultSessionTrackingMode(stm);
                this.config.setModuleSessionTrackingModeSet(true);
            }
            stm.add(mode);
        }

        public void addCodeErrorPage(int errorCode, ErrorPage configErrorPage) {
            HashMap webAppCodeErrorPages = this.config.getCodeErrorPages();
            webAppCodeErrorPages.put(errorCode, configErrorPage);
        }

        public void addExceptionErrorPage(String exceptionType, ErrorPage configErrorPage) {
            HashMap webAppExceptionErrorPages = this.config.getExceptionErrorPages();
            webAppExceptionErrorPages.put(exceptionType, configErrorPage);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setDefaultErrorPage(ErrorPage newDefaultErrorPage) {
            String newLocation;
            block8: {
                block7: {
                    String currentLocation = this.config.getDefaultErrorPage();
                    newLocation = newDefaultErrorPage.getLocation();
                    if (newLocation.equals(currentLocation)) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Default error page {0} same as prior default error page; ignoring.", (Object[])new Object[]{newLocation});
                        }
                        return;
                    }
                    if (currentLocation == null || currentLocation.isEmpty()) break block7;
                    if (WebAppConfiguratorHelper.isServletSpecLevel31OrHigher()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Descriptor default error page {0} overwrites extension default error page {1}.", (Object[])new Object[]{newLocation, currentLocation});
                        }
                        break block8;
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Descriptor default error page {0} masked by extension default error page {1}.", (Object[])new Object[]{newLocation, currentLocation});
                        }
                        return;
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Assigning descriptor default error page {0}.", (Object[])new Object[]{newLocation});
                }
            }
            this.config.setDefaultErrorPage(newLocation);
        }

        public SessionCookieConfig getSessionCookieConfig() {
            SessionCookieConfig sessionCookieConfigImpl = this.config.getSessionCookieConfig();
            if (sessionCookieConfigImpl == null && WebAppConfiguratorHelper.isServletSpecLevel50orLower()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getSessionCookieConfig was null; created new scc for <= servlet 5.0", (Object[])new Object[0]);
                }
                sessionCookieConfigImpl = new SessionCookieConfigImpl();
                this.setSessionCookieConfig(sessionCookieConfigImpl);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getSessionCookieConfig return [{0}]", (Object[])new Object[]{sessionCookieConfigImpl});
            }
            return sessionCookieConfigImpl;
        }

        public void setSessionCookieConfig(SessionCookieConfig scc) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setSessionCookieConfig [{0}]", (Object[])new Object[]{scc});
            }
            this.config.setSessionCookieConfig(scc);
        }

        public void cacheResults(ServletConfigurator configurator) {
            configurator.addToModuleCache(WebAppConfig.class, (Object)this.config);
            configurator.addToModuleCache(WebModuleMetaData.class, (Object)this.config.getMetaData());
        }

        public String getDisplayName() {
            String displayName = this.config.getDisplayName();
            if (displayName != null) {
                return displayName;
            }
            return this.config.getModuleName();
        }

        public void addMimeMapping(String extension, String mimeType) {
            Map webAppMimeMappings = this.config.getMimeMappings();
            webAppMimeMappings.put(extension, mimeType);
            this.config.getServletInfos();
        }

        public void setGlobalAndPrivateConfig() {
            this.config.setDisableStaticMappingCache();
            this.config.setSTSHeaderValue();
            this.config.setEncodeDispatchedRequestURI();
            this.config.setMultiReadOfPostDataValue();
        }

        public void setVirtualHostName(VirtualHost virtualHost) {
            this.config.setVirtualHostName(virtualHost.getName());
        }

        public void setDenyUncoveredHttpMethods(boolean denyUncoveredHttpMethods) {
            this.config.setDenyUncoveredHttpMethods(denyUncoveredHttpMethods);
        }

        public void setDefaultContextRootUsed(boolean isDefaultContextRootUsed) {
            this.config.setDefaultContextRootUsed(isDefaultContextRootUsed);
        }

        public void setDefaultContextPath(String defaultContextPath) {
            String methodName = "setDefaultContextPath";
            boolean isDefaultContextRootUsed = this.config.isDefaultContextRootUsed();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": defaultContextPath --> " + defaultContextPath + "; isDefaultContextRootUsed --> " + isDefaultContextRootUsed), (Object[])new Object[0]);
            }
            if (isDefaultContextRootUsed) {
                this.config.setContextRoot(defaultContextPath);
            }
        }

        public void setRequestEncoding(String encoding) {
            this.config.setModuleRequestEncoding(encoding);
        }

        public void setResponseEncoding(String encoding) {
            this.config.setModuleResponseEncoding(encoding);
        }
    }
}

