/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.java2sec;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.classloading.java2sec.FilePathUtil;
import com.ibm.ws.classloading.java2sec.GrantEntry;
import com.ibm.ws.classloading.java2sec.Parser;
import com.ibm.ws.classloading.java2sec.ParserException;
import com.ibm.ws.classloading.java2sec.PermissionEntry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ParseJavaPolicy {
    private static final TraceComponent tc = Tr.register(ParseJavaPolicy.class, (String)"Java2SecurityUtil", (String)"com.ibm.ws.classloading.internal.resources.Java2SecurityUtilMessages");
    String file;
    FileReader fr;
    Parser parser;
    boolean expandProp;
    String keyStoreUrlString;
    String keyStoreType;
    static List<GrantEntry> grants = new ArrayList<GrantEntry>();
    String javaHome;
    String javaVersion;
    String javaSecurityPolicy;
    String javaVendor;
    static final long serialVersionUID = -5751147301966922559L;

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ParseJavaPolicy(boolean expandProp) throws FileNotFoundException, IOException, ParserException {
        block31: {
            block30: {
                this.file = null;
                this.fr = null;
                this.parser = null;
                this.expandProp = false;
                this.javaHome = AccessController.doPrivileged(new PrivilegedAction<String>(){
                    static final long serialVersionUID = -6174352101157031598L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public String run() {
                        return System.getProperty("java.home");
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.java2sec.ParseJavaPolicy$1", 1.class, (String)"Java2SecurityUtil", (String)"com.ibm.ws.classloading.internal.resources.Java2SecurityUtilMessages");
                    }
                });
                this.javaVersion = AccessController.doPrivileged(new PrivilegedAction<String>(){
                    static final long serialVersionUID = -5138235994640244119L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public String run() {
                        return System.getProperty("java.version");
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.java2sec.ParseJavaPolicy$2", 2.class, (String)"Java2SecurityUtil", (String)"com.ibm.ws.classloading.internal.resources.Java2SecurityUtilMessages");
                    }
                });
                this.javaSecurityPolicy = AccessController.doPrivileged(new PrivilegedAction<String>(){
                    static final long serialVersionUID = -892143882147055683L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public String run() {
                        return System.getProperty("java.security.policy");
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.java2sec.ParseJavaPolicy$3", 3.class, (String)"Java2SecurityUtil", (String)"com.ibm.ws.classloading.internal.resources.Java2SecurityUtilMessages");
                    }
                });
                this.javaVendor = AccessController.doPrivileged(new PrivilegedAction<String>(){
                    static final long serialVersionUID = 2748995056692216586L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public String run() {
                        return System.getProperty("java.vendor");
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.java2sec.ParseJavaPolicy$4", 4.class, (String)"Java2SecurityUtil", (String)"com.ibm.ws.classloading.internal.resources.Java2SecurityUtilMessages");
                    }
                });
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("java.home: " + this.javaHome + " javaVendor: " + this.javaVendor + " javaSecurityPolicy: " + this.javaSecurityPolicy + " javaVersion: " + this.javaVersion), (Object[])new Object[0]);
                }
                this.file = this.javaSecurityPolicy;
                if (this.file == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Did not find java.policy under the location specified by java.security.policy", (Object[])new Object[0]);
                    }
                    if (this.javaHome != null) {
                        Integer version = 0;
                        String[] versionElements = this.javaVersion.split("\\D");
                        int i = Integer.valueOf(versionElements[0]) == 1 ? 1 : 0;
                        Integer MAJOR = Integer.valueOf(versionElements[i++]);
                        if (i < versionElements.length) {
                            Integer MINOR = Integer.valueOf(versionElements[i++]);
                        } else {
                            Integer MINOR = 0;
                        }
                        if (i < versionElements.length) {
                            Integer MICRO = Integer.valueOf(versionElements[i]);
                        } else {
                            Integer MICRO = 0;
                        }
                        if (9 <= MAJOR) {
                            this.file = this.javaHome.concat("/conf/security/java.policy");
                            File fileToCheck = new File(this.file);
                            if (!fileToCheck.exists()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("JDK version installed: " + version + " but did not find java.home/conf/security/java.policy"), (Object[])new Object[0]);
                                }
                                this.file = this.wheresJavaPolicy();
                            }
                        } else {
                            this.file = this.wheresJavaPolicy();
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("File location of java.policy file: " + this.file), (Object[])new Object[0]);
                }
                if (this.file != null && this.file.charAt(0) == '=') {
                    this.file = this.file.substring(1);
                }
                if (this.file != null) break block30;
                try {
                    if (this.fr == null) return;
                    this.fr.close();
                    return;
                }
                catch (IOException version) {
                    void e;
                    FFDCFilter.processException((Throwable)version, (String)"com.ibm.ws.classloading.java2sec.ParseJavaPolicy", (String)"183", (Object)this, (Object[])new Object[]{expandProp});
                    throw e;
                }
            }
            File fileToCheck = new File(this.file);
            if (fileToCheck.exists()) break block31;
            try {
                if (this.fr == null) return;
                this.fr.close();
                return;
            }
            catch (IOException versionElements) {
                void e;
                FFDCFilter.processException((Throwable)versionElements, (String)"com.ibm.ws.classloading.java2sec.ParseJavaPolicy", (String)"183", (Object)this, (Object[])new Object[]{expandProp});
                throw e;
            }
        }
        this.fr = new FileReader(this.file);
        this.init(this.fr, expandProp);
        this.parse();
        try {
            if (this.fr == null) return;
            this.fr.close();
            return;
        }
        catch (IOException fileToCheck) {
            void e;
            FFDCFilter.processException((Throwable)fileToCheck, (String)"com.ibm.ws.classloading.java2sec.ParseJavaPolicy", (String)"183", (Object)this, (Object[])new Object[]{expandProp});
            throw e;
        }
        catch (ParserException e) {
            try {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.classloading.java2sec.ParseJavaPolicy", (String)"171", (Object)this, (Object[])new Object[]{expandProp});
                throw e;
                catch (FileNotFoundException e533332) {
                    FFDCFilter.processException((Throwable)e533332, (String)"com.ibm.ws.classloading.java2sec.ParseJavaPolicy", (String)"173", (Object)this, (Object[])new Object[]{expandProp});
                    throw e533332;
                }
                catch (IOException e3) {
                    FFDCFilter.processException((Throwable)e3, (String)"com.ibm.ws.classloading.java2sec.ParseJavaPolicy", (String)"175", (Object)this, (Object[])new Object[]{expandProp});
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (this.fr == null) throw throwable;
                    this.fr.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    void e4;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.classloading.java2sec.ParseJavaPolicy", (String)"183", (Object)this, (Object[])new Object[]{expandProp});
                    throw e4;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String wheresJavaPolicy() {
        String policyLocation = null;
        if (this.javaHome.endsWith("jre")) {
            policyLocation = this.javaHome.concat("/lib/security/java.policy");
            File fileToCheck = new File(policyLocation);
            if (fileToCheck.exists()) return policyLocation;
            String javaHomeWithoutJre = this.javaHome.substring(0, this.javaHome.length() - 3);
            policyLocation = javaHomeWithoutJre.concat("/lib/security/java.policy");
            if (fileToCheck.exists()) return policyLocation;
            if (!tc.isDebugEnabled()) return policyLocation;
            Tr.debug((TraceComponent)tc, (String)("javaHome: " + this.javaHome + "Could not find java.policy file under either java.home/jre/lib/security or java.home/lib/security"), (Object[])new Object[0]);
            return policyLocation;
        } else {
            policyLocation = this.javaHome.concat("/lib/security.java.policy");
            File fileToCheck = new File(policyLocation);
            if (fileToCheck.exists()) return policyLocation;
            policyLocation = this.javaHome.concat("/jre/lib/security/java.policy");
            fileToCheck = new File(policyLocation);
            if (fileToCheck.exists()) return policyLocation;
            if (!tc.isDebugEnabled()) return policyLocation;
            Tr.debug((TraceComponent)tc, (String)("javaHome: " + this.javaHome + "Could not find java.policy file under either java.home/jre/lib/security or java.home/lib/security"), (Object[])new Object[0]);
        }
        return policyLocation;
    }

    public static List getJavaPolicyGrants() {
        return grants;
    }

    private void init(Reader rdr, boolean expandProp) {
        this.parser = new Parser(rdr);
        this.expandProp = expandProp;
    }

    public String toString() {
        return this.getClass().getName();
    }

    Iterator grantEntries() {
        return grants.iterator();
    }

    void parse() throws IOException, ParserException {
        this.parser.nextToken();
        while (!this.parser.eof()) {
            if (this.parser.peek("grant")) {
                GrantEntry g = this.parseGrantEntry();
                if (g != null) {
                    grants.add(g);
                }
            } else if (this.parser.peek("keystore")) {
                if (this.keyStoreUrlString == null) {
                    this.parseKeystoreEntry();
                    if (this.keyStoreType == null) {
                        this.keyStoreType = "JKS";
                    }
                }
            } else {
                throw new ParserException(this.parser.getLineNumber(), "Unexpected keyword \"" + this.parser.getStringValue() + "\"");
            }
            this.parser.match(";");
        }
    }

    void parseKeystoreEntry() throws IOException, ParserException {
        this.parser.match("keystore");
        this.keyStoreUrlString = this.parser.match("quoted string");
        if (!this.parser.peek(",")) {
            return;
        }
        this.parser.match(",");
        if (!this.parser.peek("\"")) {
            throw new ParserException(this.parser.getLineNumber(), "expected keystore type");
        }
        this.keyStoreType = this.parser.match("quoted string");
    }

    GrantEntry parseGrantEntry() throws IOException, ParserException {
        String filePrefix = "file:";
        GrantEntry g = new GrantEntry();
        this.parser.match("grant");
        while (!this.parser.peek("{")) {
            if (this.parser.peek("codeBase")) {
                this.parser.match("codeBase");
                g.codeBase = this.parser.match("quoted string");
                if (g.codeBase.startsWith(filePrefix)) {
                    g.codeBase = g.codeBase.substring(filePrefix.length());
                }
                if (!this.parser.peek(",")) continue;
                this.parser.match(",");
                continue;
            }
            if (this.parser.peek("signedBy")) {
                this.parser.match("signedBy");
                g.signedBy = this.parser.match("quoted string");
                if (!this.parser.peek(",")) continue;
                this.parser.match(",");
                continue;
            }
            throw new ParserException(this.parser.getLineNumber(), "expected codeBase or signedBy");
        }
        this.parser.match("{");
        while (!this.parser.peek("}")) {
            if (this.parser.peek("permission")) {
                try {
                    PermissionEntry p = this.parsePermissionEntry();
                    g.add(p);
                }
                catch (ParserException p) {
                    FFDCFilter.processException((Throwable)p, (String)"com.ibm.ws.classloading.java2sec.ParseJavaPolicy", (String)"377", (Object)this, (Object[])new Object[0]);
                    this.parser.skipEntry();
                }
                this.parser.match(";");
                continue;
            }
            throw new ParserException(this.parser.getLineNumber(), "expected permission entry");
        }
        this.parser.match("}");
        try {
            if (g.codeBase != null) {
                g.codeBase = this.expand(g.codeBase, false);
            }
            g.signedBy = this.expand(g.signedBy);
        }
        catch (ParserException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.classloading.java2sec.ParseJavaPolicy", (String)"391", (Object)this, (Object[])new Object[0]);
            return null;
        }
        return g;
    }

    PermissionEntry parsePermissionEntry() throws IOException, ParserException {
        PermissionEntry p = new PermissionEntry();
        this.parser.match("permission");
        p.permissionType = this.parser.match("permission type");
        if (this.parser.peek("\"")) {
            p.name = this.expand(this.parser.match_p("quoted string")).trim();
        }
        if (!this.parser.peek(",")) {
            return p;
        }
        this.parser.match(",");
        if (this.parser.peek("\"")) {
            p.action = this.expand(this.parser.match("quoted string"));
            if (!this.parser.peek(",")) {
                return p;
            }
            this.parser.match(",");
        }
        try {
            if (this.parser.peek("signedBy")) {
                this.parser.match("signedBy");
                p.signedBy = this.expand(this.parser.match("quoted string"));
            }
        }
        catch (ParserException parserException) {
            FFDCFilter.processException((Throwable)parserException, (String)"com.ibm.ws.classloading.java2sec.ParseJavaPolicy", (String)"430", (Object)this, (Object[])new Object[0]);
            return null;
        }
        return p;
    }

    String expand(String str) throws ParserException {
        return this.expand(str, false);
    }

    String expand(String str, boolean encodeValue) throws ParserException {
        if (this.expandProp) {
            int strLen = 0;
            if (str == null || (strLen = str.length()) == 0) {
                return str;
            }
            StringBuffer buf = new StringBuffer(strLen + 25);
            int index = 0;
            for (int last = 0; last < strLen; ++last) {
                String value;
                String key;
                index = str.indexOf("${{", last);
                if (index == -1) {
                    index = str.indexOf("${", last);
                    if (index == -1) {
                        buf.append(str.substring(last));
                        break;
                    }
                    buf.append(str.substring(last, index));
                    last = str.indexOf("}", index);
                    if (last == -1) {
                        buf.append(str.substring(index));
                        break;
                    }
                    key = str.substring(index + 2, last);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("key: " + key), (Object[])new Object[0]);
                    }
                    if (key.equals("/")) {
                        buf.append(File.separator);
                        continue;
                    }
                    value = System.getProperty(key);
                    if (value != null) {
                        if (encodeValue) {
                            value = FilePathUtil.encodeFilePath(value);
                        }
                        buf.append(value);
                        continue;
                    }
                    StringBuffer errBuf = new StringBuffer(32);
                    errBuf.append("line ").append(this.parser.getLineNumber()).append(": ");
                    errBuf.append("unable to expand \"").append(key).append("\"");
                    String errStr = errBuf.toString();
                    throw new ParserException(errStr);
                }
                buf.append(str.substring(last, index));
                last = str.indexOf("}", index);
                if (last == -1) {
                    buf.append(str.substring(index));
                    break;
                }
                key = str.substring(index + 3, last);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("key: " + key), (Object[])new Object[0]);
                }
                if (key.equals("/")) {
                    buf.append(File.separator);
                    continue;
                }
                value = System.getProperty(key);
                if (value != null) {
                    if (encodeValue) {
                        value = FilePathUtil.encodeFilePath(value);
                    }
                    buf.append(value);
                    continue;
                }
                StringBuffer errBuf = new StringBuffer(32);
                errBuf.append("line ").append(this.parser.getLineNumber()).append(": ");
                errBuf.append("unable to expand \"").append(key).append("\"");
                String errStr = errBuf.toString();
                throw new ParserException(errStr);
            }
            return buf.toString();
        }
        return str;
    }
}

