/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import jakarta.json.bind.serializer.SerializationContext;
import jakarta.json.stream.JsonGenerator;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.serializer.AbstractContainerSerializer;
import org.eclipse.yasson.internal.serializer.EmbeddedItem;
import org.eclipse.yasson.internal.serializer.MapToEntriesArraySerializer;
import org.eclipse.yasson.internal.serializer.MapToObjectSerializer;
import org.eclipse.yasson.internal.serializer.SerializerBuilder;

public class MapSerializer<K, V>
extends AbstractContainerSerializer<Map<K, V>>
implements EmbeddedItem {
    private final boolean nullable;
    private final boolean forceMapArraySerializerForNullKeys;
    private Delegate<K, V> serializer;
    private int actualTypeArgument = 0;

    protected MapSerializer(SerializerBuilder builder) {
        super(builder);
        this.nullable = builder.getJsonbContext().getConfigProperties().getConfigNullable();
        this.forceMapArraySerializerForNullKeys = builder.getJsonbContext().getConfigProperties().isForceMapArraySerializerForNullKeys();
        this.serializer = null;
    }

    @Override
    protected void beforeSerialize(Map<K, V> obj) {
        if (this.serializer == null) {
            boolean allStrings = true;
            boolean first = !this.forceMapArraySerializerForNullKeys;
            Class<?> cls = null;
            Iterator<K> i = obj.keySet().iterator();
            while (allStrings && i.hasNext()) {
                K key = i.next();
                if (cls != null) {
                    if (key == null) {
                        allStrings = false;
                        continue;
                    }
                    allStrings = cls.equals(key.getClass());
                    continue;
                }
                if (key instanceof String || key instanceof Number || key instanceof Enum) {
                    cls = key.getClass();
                    first = false;
                    continue;
                }
                if (key == null && first) {
                    first = false;
                    continue;
                }
                allStrings = false;
            }
            this.serializer = allStrings ? new MapToObjectSerializer(this) : new MapToEntriesArraySerializer(this);
        }
    }

    @Override
    protected void serializeInternal(Map<K, V> obj, JsonGenerator generator, SerializationContext ctx) {
        this.serializer.serializeContainer(obj, generator, ctx);
    }

    @Override
    protected void writeStart(JsonGenerator generator) {
        this.serializer.writeStart(generator);
    }

    @Override
    protected void writeStart(String key, JsonGenerator generator) {
        this.serializer.writeStart(key, generator);
    }

    @Override
    protected void writeEnd(JsonGenerator generator) {
        this.serializer.writeEnd(generator);
    }

    protected boolean isNullable() {
        return this.nullable;
    }

    protected void serializeKey() {
        this.actualTypeArgument = 0;
    }

    protected void serializeValue() {
        this.actualTypeArgument = 1;
    }

    @Override
    protected Type getValueType(Type valueType) {
        if (valueType instanceof ParameterizedType && ((ParameterizedType)valueType).getActualTypeArguments().length > this.actualTypeArgument) {
            Optional<Type> runtimeTypeOptional = ReflectionUtils.resolveOptionalType(this, ((ParameterizedType)valueType).getActualTypeArguments()[this.actualTypeArgument]);
            return (Type)((Object)runtimeTypeOptional.orElse((Type)((Object)Object.class)));
        }
        return Object.class;
    }

    static interface Delegate<K, V> {
        default public void beforeSerialize(Map<K, V> obj) {
        }

        public void writeStart(JsonGenerator var1);

        public void writeStart(String var1, JsonGenerator var2);

        default public void writeEnd(JsonGenerator generator) {
            generator.writeEnd();
        }

        public void serializeContainer(Map<K, V> var1, JsonGenerator var2, SerializationContext var3);
    }
}

