/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.transaction.impl;

import com.ibm.jbatch.container.exception.TransactionManagementException;
import com.ibm.jbatch.spi.services.TransactionManagerAdapter;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class DefaultNonTransactionalManager
implements TransactionManagerAdapter {
    private static final String CLASSNAME = DefaultNonTransactionalManager.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private int status;
    static final long serialVersionUID = 8472555997927538310L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public DefaultNonTransactionalManager() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.transaction.impl.DefaultNonTransactionalManager", "<init>", new Object[0]);
        }
        this.status = 6;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.transaction.impl.DefaultNonTransactionalManager", "<init>", this);
        }
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void begin() throws TransactionManagementException {
        logger.entering(CLASSNAME, "begin");
        this.status = 0;
        logger.log(Level.FINE, "jakarta.transaction.Status.ACTIVE: {0}", this.status);
        logger.exiting(CLASSNAME, "begin");
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void commit() throws TransactionManagementException {
        logger.entering(CLASSNAME, "commit");
        this.status = 3;
        logger.log(Level.FINE, "jakarta.transaction.Status.STATUS_COMMITTED: {0}", this.status);
        logger.exiting(CLASSNAME, "commit");
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void rollback() throws TransactionManagementException {
        logger.entering(CLASSNAME, "rollback");
        this.status = 4;
        logger.log(Level.FINE, "jakarta.transaction.Status.STATUS_ROLLEDBACK: {0}", this.status);
        logger.exiting(CLASSNAME, "rollback");
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getStatus() throws TransactionManagementException {
        logger.entering(CLASSNAME, "getStatus");
        logger.exiting(CLASSNAME, "getStatus", this.status);
        return this.status;
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setRollbackOnly() throws TransactionManagementException {
        logger.entering(CLASSNAME, "setRollbackOnly");
        this.status = 9;
        logger.log(Level.FINE, "jakarta.transaction.Status.STATUS_ROLLING_BACK: {0}", this.status);
        logger.exiting(CLASSNAME, "setRollbackOnly");
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setTransactionTimeout(int seconds) throws TransactionManagementException {
        logger.entering(CLASSNAME, "setTransactionTimeout", seconds);
        logger.fine("do nothing");
        logger.exiting(CLASSNAME, "setTransactionTimeout");
    }
}

