/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.persistence.jpa;

import com.ibm.jbatch.container.context.impl.MetricImpl;
import com.ibm.jbatch.container.persistence.jpa.EntityConstants;
import com.ibm.jbatch.container.persistence.jpa.JobExecutionEntity;
import com.ibm.jbatch.container.persistence.jpa.RemotablePartitionEntity;
import com.ibm.jbatch.container.persistence.jpa.TopLevelStepExecutionEntity;
import com.ibm.jbatch.container.ws.WSPartitionStepThreadExecution;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.serialization.DeserializationObjectInputStream;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.Metric;
import jakarta.batch.runtime.StepExecution;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.UniqueConstraint;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;

@DiscriminatorColumn(name="THREADTYPE", discriminatorType=DiscriminatorType.CHAR)
@DiscriminatorValue(value="P")
@NamedQuery(name="StepThreadExecutionEntity.getStepThreadExecutionsByJobExecIdAndStatusesQuery", query="SELECT e FROM StepThreadExecutionEntity e WHERE e.jobExec.jobExecId=:jobExecutionId AND e.batchStatus IN :status ORDER BY e.stepExecutionId ASC")
@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"FK_JOBEXECID", "STEPNAME", "PARTNUM"})})
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class StepThreadExecutionEntity
implements WSPartitionStepThreadExecution,
StepExecution,
EntityConstants {
    public static final String GET_STEP_THREAD_EXECUTIONIDS_BY_JOB_EXEC_AND_STATUSES_QUERY = "StepThreadExecutionEntity.getStepThreadExecutionsByJobExecIdAndStatusesQuery";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="STEPEXECID", nullable=false)
    private long stepExecutionId;
    @Column(name="STEPNAME", nullable=false, length=128)
    private String stepName;
    @Column(name="BATCHSTATUS", nullable=false)
    private BatchStatus batchStatus;
    @Column(name="EXITSTATUS", length=512)
    private String exitStatus;
    @Column(name="M_READ", nullable=false)
    private long readCount = 0L;
    @Column(name="M_WRITE", nullable=false)
    private long writeCount = 0L;
    @Column(name="M_COMMIT", nullable=false)
    private long commitCount = 0L;
    @Column(name="M_ROLLBACK", nullable=false)
    private long rollbackCount = 0L;
    @Column(name="M_READSKIP", nullable=false)
    private long readSkipCount = 0L;
    @Column(name="M_PROCESSSKIP", nullable=false)
    private long processSkipCount = 0L;
    @Column(name="M_WRITESKIP", nullable=false)
    private long writeSkipCount = 0L;
    @Column(name="M_FILTER", nullable=false)
    private long filterCount = 0L;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="STARTTIME")
    private Date startTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="ENDTIME")
    private Date endTime;
    @Lob
    @Column(name="USERDATA")
    private byte[] persistentUserDataBytes;
    @Column(name="PARTNUM", nullable=false)
    private int partitionNumber = -1;
    @Column(name="INTERNALSTATUS", nullable=false)
    private int internalStatus;
    @ManyToOne
    @JoinColumn(name="FK_JOBEXECID", nullable=false)
    private JobExecutionEntity jobExec;
    @ManyToOne
    @JoinColumn(name="FK_TOPLVL_STEPEXECID")
    private TopLevelStepExecutionEntity topLevelStepExecution;
    static final long serialVersionUID = -4164584981400728003L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Trivial
    public StepThreadExecutionEntity() {
    }

    public StepThreadExecutionEntity(JobExecutionEntity jobExecution, String stepName, int partitionNumber) {
        this.jobExec = jobExecution;
        this.stepName = stepName;
        this.partitionNumber = partitionNumber;
        this.batchStatus = BatchStatus.STARTING;
        this.internalStatus = 0;
    }

    public StepThreadExecutionEntity(long stepExecutionId, JobExecutionEntity jobExecution, String stepName, int partitionNumber) {
        this(jobExecution, stepName, partitionNumber);
        this.setStepExecutionId(stepExecutionId);
    }

    public long getStepExecutionId() {
        return this.stepExecutionId;
    }

    public void setStepExecutionId(long stepExecutionId) {
        this.stepExecutionId = stepExecutionId;
    }

    public String getStepName() {
        return this.stepName;
    }

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }

    public BatchStatus getBatchStatus() {
        return this.batchStatus;
    }

    public void setBatchStatus(BatchStatus batchStatus) {
        this.batchStatus = batchStatus;
    }

    public String getExitStatus() {
        return this.exitStatus;
    }

    public void setExitStatus(String exitStatus) {
        this.exitStatus = exitStatus;
    }

    public long getReadCount() {
        return this.readCount;
    }

    public void setReadCount(long readCount) {
        this.readCount = readCount;
    }

    public RemotablePartitionEntity getRemotablePartition() {
        return null;
    }

    public void setRemotablePartition(RemotablePartitionEntity remotablePartition) {
    }

    public long getWriteCount() {
        return this.writeCount;
    }

    public void setWriteCount(long writeCount) {
        this.writeCount = writeCount;
    }

    public long getCommitCount() {
        return this.commitCount;
    }

    public void setCommitCount(long commitCount) {
        this.commitCount = commitCount;
    }

    public long getRollbackCount() {
        return this.rollbackCount;
    }

    public void setRollbackCount(long rollbackCount) {
        this.rollbackCount = rollbackCount;
    }

    public long getReadSkipCount() {
        return this.readSkipCount;
    }

    public void setReadSkipCount(long readSkipCount) {
        this.readSkipCount = readSkipCount;
    }

    public long getProcessSkipCount() {
        return this.processSkipCount;
    }

    public void setProcessSkipCount(long processSkipCount) {
        this.processSkipCount = processSkipCount;
    }

    public long getFilterCount() {
        return this.filterCount;
    }

    public void setFilterCount(long filterCount) {
        this.filterCount = filterCount;
    }

    public long getWriteSkipCount() {
        return this.writeSkipCount;
    }

    public void setWriteSkipCount(long writeSkipCount) {
        this.writeSkipCount = writeSkipCount;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public byte[] getPersistentUserDataBytes() {
        return this.persistentUserDataBytes;
    }

    public void setPersistentUserDataBytes(byte[] persistentUserData) {
        this.persistentUserDataBytes = persistentUserData;
    }

    private Serializable getPersistentUserDataObject() {
        Serializable retVal = null;
        try {
            retVal = this.deserializeObject(this.persistentUserDataBytes);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.jbatch.container.persistence.jpa.StepThreadExecutionEntity", (String)"310", (Object)this, (Object[])new Object[0]);
            throw new IllegalStateException("Problem while trying to deserialize persistent user data");
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.persistence.jpa.StepThreadExecutionEntity", (String)"312", (Object)this, (Object[])new Object[0]);
            throw new IllegalStateException("Problem while trying to deserialize persistent user data");
        }
        return retVal;
    }

    public Serializable getPersistentUserData() {
        return this.getPersistentUserDataObject();
    }

    @Override
    public int getPartitionNumber() {
        return this.partitionNumber;
    }

    public void setPartitionNumber(int partitionNumber) {
        this.partitionNumber = partitionNumber;
    }

    public JobExecutionEntity getJobExecution() {
        return this.jobExec;
    }

    public void setJobExecution(JobExecutionEntity jobExecution) {
        this.jobExec = jobExecution;
    }

    public TopLevelStepExecutionEntity getTopLevelStepExecution() {
        return this.topLevelStepExecution;
    }

    public void setTopLevelStepExecution(TopLevelStepExecutionEntity topLevelStepExecution) {
        this.topLevelStepExecution = topLevelStepExecution;
    }

    public void addMetrics(StepThreadExecutionEntity step) {
        this.readCount += step.getReadCount();
        this.writeCount += step.getWriteCount();
        this.processSkipCount += step.getProcessSkipCount();
        this.commitCount += step.getCommitCount();
        this.rollbackCount += step.getRollbackCount();
        this.readSkipCount += step.getReadSkipCount();
        this.filterCount += step.getFilterCount();
        this.writeSkipCount += step.getWriteSkipCount();
    }

    private Serializable deserializeObject(byte[] buffer) throws IOException, ClassNotFoundException {
        Serializable theObject = null;
        DeserializationObjectInputStream objectIn = null;
        if (buffer != null) {
            objectIn = new DeserializationObjectInputStream((InputStream)new ByteArrayInputStream(buffer), Thread.currentThread().getContextClassLoader());
            theObject = (Serializable)objectIn.readObject();
            objectIn.close();
        }
        return theObject;
    }

    public int getInternalStatus() {
        return this.internalStatus;
    }

    public void setInternalStatus(int internalStatus) {
        this.internalStatus = internalStatus;
    }

    public Metric[] getMetrics() {
        Metric[] metrics = new MetricImpl[]{new MetricImpl(Metric.MetricType.READ_COUNT, this.readCount), new MetricImpl(Metric.MetricType.WRITE_COUNT, this.writeCount), new MetricImpl(Metric.MetricType.COMMIT_COUNT, this.commitCount), new MetricImpl(Metric.MetricType.ROLLBACK_COUNT, this.rollbackCount), new MetricImpl(Metric.MetricType.READ_SKIP_COUNT, this.readSkipCount), new MetricImpl(Metric.MetricType.PROCESS_SKIP_COUNT, this.processSkipCount), new MetricImpl(Metric.MetricType.FILTER_COUNT, this.filterCount), new MetricImpl(Metric.MetricType.WRITE_SKIP_COUNT, this.writeSkipCount)};
        return metrics;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("For StepThreadExecutionEntity:");
        buf.append(" step Name = " + this.stepName);
        buf.append(", partition Number = " + this.partitionNumber);
        buf.append(", step exec id = " + this.stepExecutionId);
        return buf.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.persistence.jpa.StepThreadExecutionEntity", StepThreadExecutionEntity.class, (String)"wsbatch", null);
    }
}

